/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90.blocktree;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gnit.lucenekmp.codecs.lucene90.blocktree.CompressionAlgorithm;
import org.gnit.lucenekmp.codecs.lucene90.blocktree.SegmentTermsEnumFrame;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0010\u0016\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001QB\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KJ\u000e\u0010L\u001a\u00020G2\u0006\u0010H\u001a\u00020IJ\u000e\u0010M\u001a\u00020G2\u0006\u0010M\u001a\u00020NJ\u0006\u0010O\u001a\u00020GJ\b\u0010P\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u001a\u0010\u001f\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0019\"\u0004\b!\u0010\u001bR\u001a\u0010\"\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0019\"\u0004\b$\u0010\u001bR\u001a\u0010%\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0019\"\u0004\b'\u0010\u001bR\u001a\u0010(\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0019\"\u0004\b*\u0010\u001bR\u001a\u0010+\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0019\"\u0004\b-\u0010\u001bR\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u000e\u00104\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00106\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\r\"\u0004\b8\u0010\u000fR\u0011\u00109\u001a\u00020:\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u001a\u0010=\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\r\"\u0004\b?\u0010\u000fR\u001a\u0010@\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\r\"\u0004\bB\u0010\u000fR\u001a\u0010C\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\r\"\u0004\bE\u0010\u000f\u00a8\u0006R"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Stats;", "", "segment", "", "field", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getSegment", "()Ljava/lang/String;", "getField", "indexNumBytes", "", "getIndexNumBytes", "()J", "setIndexNumBytes", "(J)V", "totalTermCount", "getTotalTermCount", "setTotalTermCount", "totalTermBytes", "getTotalTermBytes", "setTotalTermBytes", "nonFloorBlockCount", "", "getNonFloorBlockCount", "()I", "setNonFloorBlockCount", "(I)V", "floorBlockCount", "getFloorBlockCount", "setFloorBlockCount", "floorSubBlockCount", "getFloorSubBlockCount", "setFloorSubBlockCount", "mixedBlockCount", "getMixedBlockCount", "setMixedBlockCount", "termsOnlyBlockCount", "getTermsOnlyBlockCount", "setTermsOnlyBlockCount", "subBlocksOnlyBlockCount", "getSubBlocksOnlyBlockCount", "setSubBlocksOnlyBlockCount", "totalBlockCount", "getTotalBlockCount", "setTotalBlockCount", "blockCountByPrefixLen", "", "getBlockCountByPrefixLen", "()[I", "setBlockCountByPrefixLen", "([I)V", "startBlockCount", "endBlockCount", "totalBlockSuffixBytes", "getTotalBlockSuffixBytes", "setTotalBlockSuffixBytes", "compressionAlgorithms", "", "getCompressionAlgorithms", "()[J", "totalUncompressedBlockSuffixBytes", "getTotalUncompressedBlockSuffixBytes", "setTotalUncompressedBlockSuffixBytes", "totalBlockStatsBytes", "getTotalBlockStatsBytes", "setTotalBlockStatsBytes", "totalBlockOtherBytes", "getTotalBlockOtherBytes", "setTotalBlockOtherBytes", "startBlock", "", "frame", "Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/SegmentTermsEnumFrame;", "isFloor", "", "endBlock", "term", "Lorg/gnit/lucenekmp/util/BytesRef;", "finish", "toString", "PrintStream", "core"})
public final class Stats {
    @NotNull
    private final String segment;
    @NotNull
    private final String field;
    private long indexNumBytes;
    private long totalTermCount;
    private long totalTermBytes;
    private int nonFloorBlockCount;
    private int floorBlockCount;
    private int floorSubBlockCount;
    private int mixedBlockCount;
    private int termsOnlyBlockCount;
    private int subBlocksOnlyBlockCount;
    private int totalBlockCount;
    @NotNull
    private int[] blockCountByPrefixLen;
    private int startBlockCount;
    private int endBlockCount;
    private long totalBlockSuffixBytes;
    @NotNull
    private final long[] compressionAlgorithms;
    private long totalUncompressedBlockSuffixBytes;
    private long totalBlockStatsBytes;
    private long totalBlockOtherBytes;

    public Stats(@NotNull String segment, @NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.segment = segment;
        this.field = field;
        this.blockCountByPrefixLen = new int[10];
        this.compressionAlgorithms = new long[3];
    }

    @NotNull
    public final String getSegment() {
        return this.segment;
    }

    @NotNull
    public final String getField() {
        return this.field;
    }

    public final long getIndexNumBytes() {
        return this.indexNumBytes;
    }

    public final void setIndexNumBytes(long l) {
        this.indexNumBytes = l;
    }

    public final long getTotalTermCount() {
        return this.totalTermCount;
    }

    public final void setTotalTermCount(long l) {
        this.totalTermCount = l;
    }

    public final long getTotalTermBytes() {
        return this.totalTermBytes;
    }

    public final void setTotalTermBytes(long l) {
        this.totalTermBytes = l;
    }

    public final int getNonFloorBlockCount() {
        return this.nonFloorBlockCount;
    }

    public final void setNonFloorBlockCount(int n) {
        this.nonFloorBlockCount = n;
    }

    public final int getFloorBlockCount() {
        return this.floorBlockCount;
    }

    public final void setFloorBlockCount(int n) {
        this.floorBlockCount = n;
    }

    public final int getFloorSubBlockCount() {
        return this.floorSubBlockCount;
    }

    public final void setFloorSubBlockCount(int n) {
        this.floorSubBlockCount = n;
    }

    public final int getMixedBlockCount() {
        return this.mixedBlockCount;
    }

    public final void setMixedBlockCount(int n) {
        this.mixedBlockCount = n;
    }

    public final int getTermsOnlyBlockCount() {
        return this.termsOnlyBlockCount;
    }

    public final void setTermsOnlyBlockCount(int n) {
        this.termsOnlyBlockCount = n;
    }

    public final int getSubBlocksOnlyBlockCount() {
        return this.subBlocksOnlyBlockCount;
    }

    public final void setSubBlocksOnlyBlockCount(int n) {
        this.subBlocksOnlyBlockCount = n;
    }

    public final int getTotalBlockCount() {
        return this.totalBlockCount;
    }

    public final void setTotalBlockCount(int n) {
        this.totalBlockCount = n;
    }

    @NotNull
    public final int[] getBlockCountByPrefixLen() {
        return this.blockCountByPrefixLen;
    }

    public final void setBlockCountByPrefixLen(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.blockCountByPrefixLen = nArray;
    }

    public final long getTotalBlockSuffixBytes() {
        return this.totalBlockSuffixBytes;
    }

    public final void setTotalBlockSuffixBytes(long l) {
        this.totalBlockSuffixBytes = l;
    }

    @NotNull
    public final long[] getCompressionAlgorithms() {
        return this.compressionAlgorithms;
    }

    public final long getTotalUncompressedBlockSuffixBytes() {
        return this.totalUncompressedBlockSuffixBytes;
    }

    public final void setTotalUncompressedBlockSuffixBytes(long l) {
        this.totalUncompressedBlockSuffixBytes = l;
    }

    public final long getTotalBlockStatsBytes() {
        return this.totalBlockStatsBytes;
    }

    public final void setTotalBlockStatsBytes(long l) {
        this.totalBlockStatsBytes = l;
    }

    public final long getTotalBlockOtherBytes() {
        return this.totalBlockOtherBytes;
    }

    public final void setTotalBlockOtherBytes(long l) {
        this.totalBlockOtherBytes = l;
    }

    public final void startBlock(@NotNull SegmentTermsEnumFrame frame, boolean isFloor) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        int n = this.totalBlockCount;
        this.totalBlockCount = n + 1;
        if (isFloor) {
            if (frame.getFp() == frame.getFpOrig()) {
                n = this.floorBlockCount;
                this.floorBlockCount = n + 1;
            }
            n = this.floorSubBlockCount;
            this.floorSubBlockCount = n + 1;
        } else {
            n = this.nonFloorBlockCount;
            this.nonFloorBlockCount = n + 1;
        }
        if (this.blockCountByPrefixLen.length <= frame.getPrefixLength()) {
            this.blockCountByPrefixLen = ArrayUtil.Companion.grow(this.blockCountByPrefixLen, 1 + frame.getPrefixLength());
        }
        int[] nArray = this.blockCountByPrefixLen;
        int n2 = frame.getPrefixLength();
        int n3 = nArray[n2];
        nArray[n2] = n3 + 1;
        int n4 = this.startBlockCount;
        this.startBlockCount = n4 + 1;
        this.totalBlockSuffixBytes += frame.getTotalSuffixBytes();
        this.totalUncompressedBlockSuffixBytes += (long)frame.getSuffixesReader().length();
        if (frame.getSuffixesReader() != frame.getSuffixLengthsReader()) {
            this.totalUncompressedBlockSuffixBytes += (long)frame.getSuffixLengthsReader().length();
        }
        this.totalBlockStatsBytes += (long)frame.getStatsReader().length();
        long[] lArray = this.compressionAlgorithms;
        int n5 = frame.getCompressionAlg().getCode();
        long l = lArray[n5];
        lArray[n5] = l + 1L;
    }

    public final void endBlock(@NotNull SegmentTermsEnumFrame frame) {
        int n;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        int termCount = frame.isLeafBlock() ? frame.getEntCount() : frame.getState().getTermBlockOrd();
        int subBlockCount = frame.getEntCount() - termCount;
        this.totalTermCount += (long)termCount;
        if (termCount != 0 && subBlockCount != 0) {
            n = this.mixedBlockCount;
            this.mixedBlockCount = n + 1;
        } else if (termCount != 0) {
            n = this.termsOnlyBlockCount;
            this.termsOnlyBlockCount = n + 1;
        } else if (subBlockCount != 0) {
            n = this.subBlocksOnlyBlockCount;
            this.subBlocksOnlyBlockCount = n + 1;
        } else {
            throw new IllegalStateException();
        }
        n = this.endBlockCount;
        this.endBlockCount = n + 1;
        long otherBytes = frame.getFpEnd() - frame.getFp() - frame.getTotalSuffixBytes() - (long)frame.getStatsReader().length();
        if (!(otherBytes > 0L)) {
            boolean bl = false;
            String string = "otherBytes=" + otherBytes + " frame.fp=" + frame.getFp() + " frame.fpEnd=" + frame.getFpEnd();
            throw new IllegalArgumentException(string.toString());
        }
        this.totalBlockOtherBytes += otherBytes;
    }

    public final void term(@NotNull BytesRef term) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        this.totalTermBytes += (long)term.getLength();
    }

    public final void finish() {
        if (!(this.startBlockCount == this.endBlockCount)) {
            boolean $i$a$-require-Stats$finish$42 = false;
            String $i$a$-require-Stats$finish$42 = "startBlockCount=" + this.startBlockCount + " endBlockCount=" + this.endBlockCount;
            throw new IllegalArgumentException($i$a$-require-Stats$finish$42.toString());
        }
        if (!(this.totalBlockCount == this.floorSubBlockCount + this.nonFloorBlockCount)) {
            boolean $i$a$-require-Stats$finish$52 = false;
            String $i$a$-require-Stats$finish$52 = "floorSubBlockCount=" + this.floorSubBlockCount + " nonFloorBlockCount=" + this.nonFloorBlockCount + " totalBlockCount=" + this.totalBlockCount;
            throw new IllegalArgumentException($i$a$-require-Stats$finish$52.toString());
        }
        if (!(this.totalBlockCount == this.mixedBlockCount + this.termsOnlyBlockCount + this.subBlocksOnlyBlockCount)) {
            boolean bl = false;
            String string = "totalBlockCount=" + this.totalBlockCount + " mixedBlockCount=" + this.mixedBlockCount + " subBlocksOnlyBlockCount=" + this.subBlocksOnlyBlockCount + " termsOnlyBlockCount=" + this.termsOnlyBlockCount;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public String toString() {
        PrintStream out = new PrintStream(0, 1, null);
        out.println("  index FST:");
        out.println("    " + this.indexNumBytes + " bytes");
        out.println("  terms:");
        out.println("    " + this.totalTermCount + " terms");
        out.println("    " + this.totalTermBytes + " bytes" + (String)(this.totalTermCount != 0L ? " (" + Math.floor((double)this.totalTermBytes / (double)this.totalTermCount * (double)10) / (double)10 + " bytes/term)" : ""));
        out.println("  blocks:");
        out.println("    " + this.totalBlockCount + " blocks");
        out.println("    " + this.termsOnlyBlockCount + " terms-only blocks");
        out.println("    " + this.subBlocksOnlyBlockCount + " sub-block-only blocks");
        out.println("    " + this.mixedBlockCount + " mixed blocks");
        out.println("    " + this.floorBlockCount + " floor blocks");
        out.println("    " + (this.totalBlockCount - this.floorSubBlockCount) + " non-floor blocks");
        out.println("    " + this.floorSubBlockCount + " floor sub-blocks");
        out.println("    " + this.totalUncompressedBlockSuffixBytes + " term suffix bytes before compression" + (String)(this.totalBlockCount != 0 ? " (" + Math.rint((double)this.totalBlockSuffixBytes / (double)this.totalBlockCount * (double)10) / (double)10 + " suffix-bytes/block)" : ""));
        StringBuilder compressionCounts = new StringBuilder();
        int n = this.compressionAlgorithms.length;
        for (int code = 0; code < n; ++code) {
            if (this.compressionAlgorithms[code] == 0L) continue;
            if (((CharSequence)compressionCounts).length() > 0) {
                compressionCounts.append(", ");
            }
            compressionCounts.append((Object)CompressionAlgorithm.Companion.byCode(code));
            compressionCounts.append(": ");
            compressionCounts.append(this.compressionAlgorithms[code]);
        }
        out.println("    " + this.totalBlockSuffixBytes + " compressed term suffix bytes" + (String)(this.totalBlockCount != 0 ? " (" + Math.rint((double)this.totalBlockSuffixBytes / (double)this.totalUncompressedBlockSuffixBytes * (double)100) / (double)100 + " compression ratio - compression count by algorithm: " + compressionCounts : "") + ")");
        out.println("    " + this.totalBlockStatsBytes + " term stats bytes " + (String)(this.totalBlockCount != 0 ? " (" + Math.rint((double)this.totalBlockStatsBytes / (double)this.totalBlockCount * (double)10) / (double)10 + " stats-bytes/block)" : ""));
        out.println("    " + this.totalBlockOtherBytes + " other bytes" + (String)(this.totalBlockCount != 0 ? " (" + Math.rint((double)this.totalBlockOtherBytes / (double)this.totalBlockCount * (double)10) / (double)10 + " other-bytes/block)" : ""));
        if (this.totalBlockCount != 0) {
            out.println("    by prefix length:");
            int total = 0;
            int n2 = this.blockCountByPrefixLen.length;
            for (int prefix = 0; prefix < n2; ++prefix) {
                int blockCount = this.blockCountByPrefixLen[prefix];
                total += blockCount;
                if (blockCount == 0) continue;
                out.println("      " + StringsKt.padStart$default((String)String.valueOf(prefix), (int)2, (char)'\u0000', (int)2, null) + ": " + blockCount);
            }
            if (!(this.totalBlockCount == total)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }
        return out.toString();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0001J\b\u0010\f\u001a\u00020\rH\u0016R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Stats$PrintStream;", "", "initialCap", "", "<init>", "(I)V", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "println", "", "obj", "toString", "", "core"})
    private static final class PrintStream {
        @NotNull
        private final StringBuilder sb;

        public PrintStream(int initialCap) {
            this.sb = new StringBuilder(initialCap);
        }

        public /* synthetic */ PrintStream(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 1024;
            }
            this(n);
        }

        public final void println(@Nullable Object obj) {
            StringBuilder stringBuilder = this.sb.append(obj);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            stringBuilder.append('\n');
        }

        public static /* synthetic */ void println$default(PrintStream printStream, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = "";
            }
            printStream.println(object);
        }

        @NotNull
        public String toString() {
            String string = this.sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public PrintStream() {
            this(0, 1, null);
        }
    }
}

