/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90.compressing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.store.ChecksumIndexInput;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.packed.DirectMonotonicWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 !2\u00060\u0001j\u0002`\u0002:\u0001!BI\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0018J\u001e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0013J\b\u0010 \u001a\u00020\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/FieldsIndexWriter;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "dir", "Lorg/gnit/lucenekmp/store/Directory;", "name", "", "suffix", "extension", "codecName", "id", "", "blockShift", "", "ioContext", "Lorg/gnit/lucenekmp/store/IOContext;", "<init>", "(Lorg/gnit/lucenekmp/store/Directory;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[BILorg/gnit/lucenekmp/store/IOContext;)V", "docsOut", "Lorg/gnit/lucenekmp/store/IndexOutput;", "filePointersOut", "totalDocs", "totalChunks", "previousFP", "", "writeIndex", "", "numDocs", "startPointer", "finish", "maxPointer", "metaOut", "close", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nFieldsIndexWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldsIndexWriter.kt\norg/gnit/lucenekmp/codecs/lucene90/compressing/FieldsIndexWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1#2:166\n*E\n"})
public final class FieldsIndexWriter
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Directory dir;
    @NotNull
    private final String name;
    @NotNull
    private final String suffix;
    @NotNull
    private final String extension;
    @NotNull
    private final String codecName;
    @NotNull
    private final byte[] id;
    private final int blockShift;
    @NotNull
    private final IOContext ioContext;
    @Nullable
    private IndexOutput docsOut;
    @Nullable
    private IndexOutput filePointersOut;
    private int totalDocs;
    private int totalChunks;
    private long previousFP;
    public static final int VERSION_START = 0;
    public static final int VERSION_CURRENT = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsIndexWriter(@NotNull Directory dir, @NotNull String name, @NotNull String suffix, @NotNull String extension, @NotNull String codecName, @NotNull byte[] id, int blockShift, @NotNull IOContext ioContext) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)codecName, (String)"codecName");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)ioContext, (String)"ioContext");
        this.dir = dir;
        this.name = name;
        this.suffix = suffix;
        this.extension = extension;
        this.codecName = codecName;
        this.id = id;
        this.blockShift = blockShift;
        this.ioContext = ioContext;
        this.docsOut = this.dir.createTempOutput(this.name, this.codecName + "-doc_ids", this.ioContext);
        boolean success = false;
        try {
            IndexOutput indexOutput = this.docsOut;
            Intrinsics.checkNotNull((Object)indexOutput);
            CodecUtil.INSTANCE.writeHeader(indexOutput, this.codecName + "Docs", 0);
            IndexOutput indexOutput2 = this.filePointersOut = this.dir.createTempOutput(this.name, this.codecName + "file_pointers", this.ioContext);
            Intrinsics.checkNotNull((Object)indexOutput2);
            CodecUtil.INSTANCE.writeHeader(indexOutput2, this.codecName + "FilePointers", 0);
            success = true;
        }
        catch (Throwable throwable) {
            this.close();
            throw throwable;
        }
    }

    public final void writeIndex(int numDocs, long startPointer) throws IOException {
        if (!(startPointer >= this.previousFP)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        IndexOutput indexOutput = this.docsOut;
        Intrinsics.checkNotNull((Object)indexOutput);
        indexOutput.writeVInt(numDocs);
        IndexOutput indexOutput2 = this.filePointersOut;
        Intrinsics.checkNotNull((Object)indexOutput2);
        indexOutput2.writeVLong(startPointer - this.previousFP);
        this.previousFP = startPointer;
        this.totalDocs += numDocs;
        int n = this.totalChunks;
        this.totalChunks = n + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finish(int numDocs, long maxPointer, @NotNull IndexOutput metaOut) throws IOException {
        Intrinsics.checkNotNullParameter((Object)metaOut, (String)"metaOut");
        if (!(numDocs == this.totalDocs)) {
            boolean bl = false;
            String string = "Expected " + numDocs + " docs, but got " + this.totalDocs;
            throw new IllegalStateException(string.toString());
        }
        IndexOutput indexOutput = this.docsOut;
        Intrinsics.checkNotNull((Object)indexOutput);
        CodecUtil.INSTANCE.writeFooter(indexOutput);
        IndexOutput indexOutput2 = this.filePointersOut;
        Intrinsics.checkNotNull((Object)indexOutput2);
        CodecUtil.INSTANCE.writeFooter(indexOutput2);
        Object object = new AutoCloseable[2];
        Intrinsics.checkNotNull((Object)this.docsOut);
        Intrinsics.checkNotNull((Object)this.filePointersOut);
        IOUtils.INSTANCE.close((AutoCloseable)object);
        object = this.dir.createOutput(IndexFileNames.INSTANCE.segmentFileName(this.name, this.suffix, this.extension), this.ioContext);
        Throwable throwable = null;
        try {
            int i;
            int n;
            Throwable priorE;
            IndexOutput dataOut = (IndexOutput)object;
            boolean bl = false;
            CodecUtil.INSTANCE.writeIndexHeader(dataOut, this.codecName + "Idx", 0, this.id, this.suffix);
            metaOut.writeInt(numDocs);
            metaOut.writeInt(this.blockShift);
            metaOut.writeInt(this.totalChunks + 1);
            metaOut.writeLong(dataOut.getFilePointer());
            IndexOutput indexOutput3 = this.docsOut;
            Intrinsics.checkNotNull((Object)indexOutput3);
            AutoCloseable autoCloseable = this.dir.openChecksumInput(indexOutput3.getName());
            Throwable throwable2 = null;
            try {
                ChecksumIndexInput docsIn = (ChecksumIndexInput)autoCloseable;
                boolean bl2 = false;
                CodecUtil.INSTANCE.checkHeader(docsIn, this.codecName + "Docs", 0, 0);
                priorE = null;
                try {
                    DirectMonotonicWriter docs = DirectMonotonicWriter.Companion.getInstance(metaOut, dataOut, (long)this.totalChunks + 1L, this.blockShift);
                    long doc = 0L;
                    docs.add(doc);
                    n = this.totalChunks;
                    for (i = 0; i < n; ++i) {
                        docs.add(doc += (long)docsIn.readVInt());
                    }
                    docs.finish();
                    if (doc != (long)this.totalDocs) {
                        throw new CorruptIndexException("Docs don't add up", docsIn);
                    }
                }
                catch (Throwable e) {
                    priorE = e;
                }
                finally {
                    CodecUtil.INSTANCE.checkFooter(docsIn, priorE);
                }
                docsIn = Unit.INSTANCE;
            }
            catch (Throwable bl2) {
                throwable2 = bl2;
                throw bl2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
            }
            IndexOutput indexOutput4 = this.docsOut;
            Intrinsics.checkNotNull((Object)indexOutput4);
            this.dir.deleteFile(indexOutput4.getName());
            this.docsOut = null;
            metaOut.writeLong(dataOut.getFilePointer());
            IndexOutput indexOutput5 = this.filePointersOut;
            Intrinsics.checkNotNull((Object)indexOutput5);
            autoCloseable = this.dir.openChecksumInput(indexOutput5.getName());
            throwable2 = null;
            try {
                ChecksumIndexInput filePointersIn = (ChecksumIndexInput)autoCloseable;
                boolean bl3 = false;
                CodecUtil.INSTANCE.checkHeader(filePointersIn, this.codecName + "FilePointers", 0, 0);
                priorE = null;
                try {
                    DirectMonotonicWriter filePointers = DirectMonotonicWriter.Companion.getInstance(metaOut, dataOut, (long)this.totalChunks + 1L, this.blockShift);
                    long fp = 0L;
                    n = this.totalChunks;
                    for (i = 0; i < n; ++i) {
                        filePointers.add(fp += filePointersIn.readVLong());
                    }
                    if (maxPointer < fp) {
                        throw new CorruptIndexException("File pointers don't add up", filePointersIn);
                    }
                    filePointers.add(maxPointer);
                    filePointers.finish();
                }
                catch (Throwable e) {
                    priorE = e;
                }
                finally {
                    CodecUtil.INSTANCE.checkFooter(filePointersIn, priorE);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
            }
            IndexOutput indexOutput6 = this.filePointersOut;
            Intrinsics.checkNotNull((Object)indexOutput6);
            this.dir.deleteFile(indexOutput6.getName());
            this.filePointersOut = null;
            metaOut.writeLong(dataOut.getFilePointer());
            metaOut.writeLong(maxPointer);
            CodecUtil.INSTANCE.writeFooter(dataOut);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.docsOut, this.filePointersOut};
            IOUtils.INSTANCE.closeNullable(autoCloseableArray);
        }
        finally {
            List fileNames = new ArrayList();
            if (this.docsOut != null) {
                IndexOutput indexOutput = this.docsOut;
                Intrinsics.checkNotNull((Object)indexOutput);
                fileNames.add(indexOutput.getName());
            }
            if (this.filePointersOut != null) {
                IndexOutput indexOutput = this.filePointersOut;
                Intrinsics.checkNotNull((Object)indexOutput);
                fileNames.add(indexOutput.getName());
            }
            try {
                IOUtils.INSTANCE.deleteFiles(this.dir, fileNames);
            }
            finally {
                this.docsOut = this.filePointersOut = null;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/FieldsIndexWriter$Companion;", "", "<init>", "()V", "VERSION_START", "", "VERSION_CURRENT", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

