/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90.compressing;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.StoredFieldsFormat;
import org.gnit.lucenekmp.codecs.StoredFieldsReader;
import org.gnit.lucenekmp.codecs.StoredFieldsWriter;
import org.gnit.lucenekmp.codecs.compressing.CompressionMode;
import org.gnit.lucenekmp.codecs.lucene90.compressing.Lucene90CompressingStoredFieldsReader;
import org.gnit.lucenekmp.codecs.lucene90.compressing.Lucene90CompressingStoredFieldsWriter;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.SegmentInfo;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\rJ*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsFormat;", "Lorg/gnit/lucenekmp/codecs/StoredFieldsFormat;", "formatName", "", "segmentSuffix", "compressionMode", "Lorg/gnit/lucenekmp/codecs/compressing/CompressionMode;", "chunkSize", "", "maxDocsPerChunk", "blockShift", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/gnit/lucenekmp/codecs/compressing/CompressionMode;III)V", "(Ljava/lang/String;Lorg/gnit/lucenekmp/codecs/compressing/CompressionMode;III)V", "fieldsReader", "Lorg/gnit/lucenekmp/codecs/StoredFieldsReader;", "directory", "Lorg/gnit/lucenekmp/store/Directory;", "si", "Lorg/gnit/lucenekmp/index/SegmentInfo;", "fn", "Lorg/gnit/lucenekmp/index/FieldInfos;", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "fieldsWriter", "Lorg/gnit/lucenekmp/codecs/StoredFieldsWriter;", "toString", "core"})
@SourceDebugExtension(value={"SMAP\nLucene90CompressingStoredFieldsFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene90CompressingStoredFieldsFormat.kt\norg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsFormat\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1#2:149\n*E\n"})
public final class Lucene90CompressingStoredFieldsFormat
extends StoredFieldsFormat {
    @NotNull
    private final String formatName;
    @NotNull
    private final String segmentSuffix;
    @NotNull
    private final CompressionMode compressionMode;
    private final int chunkSize;
    private final int maxDocsPerChunk;
    private final int blockShift;

    public Lucene90CompressingStoredFieldsFormat(@NotNull String formatName, @NotNull String segmentSuffix, @NotNull CompressionMode compressionMode, int chunkSize, int maxDocsPerChunk, int blockShift) {
        Intrinsics.checkNotNullParameter((Object)formatName, (String)"formatName");
        Intrinsics.checkNotNullParameter((Object)segmentSuffix, (String)"segmentSuffix");
        Intrinsics.checkNotNullParameter((Object)compressionMode, (String)"compressionMode");
        this.formatName = formatName;
        this.segmentSuffix = segmentSuffix;
        this.compressionMode = compressionMode;
        if (!(chunkSize >= 1)) {
            boolean $i$a$-require-Lucene90CompressingStoredFieldsFormat$42 = false;
            String $i$a$-require-Lucene90CompressingStoredFieldsFormat$42 = "chunkSize must be >= 1";
            throw new IllegalArgumentException($i$a$-require-Lucene90CompressingStoredFieldsFormat$42.toString());
        }
        this.chunkSize = chunkSize;
        if (!(maxDocsPerChunk >= 1)) {
            boolean $i$a$-require-Lucene90CompressingStoredFieldsFormat$52 = false;
            String $i$a$-require-Lucene90CompressingStoredFieldsFormat$52 = "maxDocsPerChunk must be >= 1";
            throw new IllegalArgumentException($i$a$-require-Lucene90CompressingStoredFieldsFormat$52.toString());
        }
        this.maxDocsPerChunk = maxDocsPerChunk;
        if (!(blockShift >= 2 && blockShift <= 22)) {
            boolean bl = false;
            String string = "blockSize must be in 2-22, got " + blockShift;
            throw new IllegalArgumentException(string.toString());
        }
        this.blockShift = blockShift;
    }

    public Lucene90CompressingStoredFieldsFormat(@NotNull String formatName, @NotNull CompressionMode compressionMode, int chunkSize, int maxDocsPerChunk, int blockShift) {
        Intrinsics.checkNotNullParameter((Object)formatName, (String)"formatName");
        Intrinsics.checkNotNullParameter((Object)compressionMode, (String)"compressionMode");
        this(formatName, "", compressionMode, chunkSize, maxDocsPerChunk, blockShift);
    }

    @Override
    @NotNull
    public StoredFieldsReader fieldsReader(@NotNull Directory directory, @NotNull SegmentInfo si, @Nullable FieldInfos fn, @NotNull IOContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new Lucene90CompressingStoredFieldsReader(directory, si, this.segmentSuffix, fn, context, this.formatName, this.compressionMode);
    }

    @Override
    @NotNull
    public StoredFieldsWriter fieldsWriter(@NotNull Directory directory, @NotNull SegmentInfo si, @NotNull IOContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new Lucene90CompressingStoredFieldsWriter(directory, si, this.segmentSuffix, context, this.formatName, this.compressionMode, this.chunkSize, this.maxDocsPerChunk, this.blockShift);
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "(compressionMode=" + this.compressionMode + ", chunkSize=" + this.chunkSize + ", maxDocsPerChunk=" + this.maxDocsPerChunk + ", blockShift=" + this.blockShift + ")";
    }
}

