/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90.compressing;

import java.io.EOFException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.StoredFieldsReader;
import org.gnit.lucenekmp.codecs.compressing.CompressionMode;
import org.gnit.lucenekmp.codecs.compressing.Decompressor;
import org.gnit.lucenekmp.codecs.lucene90.compressing.FieldsIndex;
import org.gnit.lucenekmp.codecs.lucene90.compressing.FieldsIndexReader;
import org.gnit.lucenekmp.codecs.lucene90.compressing.Lucene90CompressingStoredFieldsWriter;
import org.gnit.lucenekmp.codecs.lucene90.compressing.StoredFieldsInts;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.SegmentInfo;
import org.gnit.lucenekmp.index.StoredFieldDataInput;
import org.gnit.lucenekmp.index.StoredFieldVisitor;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.DoubleExtKt;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.store.AlreadyClosedException;
import org.gnit.lucenekmp.store.ByteArrayDataInput;
import org.gnit.lucenekmp.store.ChecksumIndexInput;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.ReadAdvice;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BitUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.LongsRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 J2\u00020\u0001:\u0003HIJB\u0019\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006BC\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\f\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0005\u0010\u0014J\b\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u000202H\u0016J\u0010\u00104\u001a\u0002022\u0006\u00105\u001a\u00020\u0016H\u0016J\u000e\u00106\u001a\u0002072\u0006\u00105\u001a\u00020\u0016J\u000e\u00108\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0016J\u0018\u00109\u001a\u0002022\u0006\u00105\u001a\u00020\u00162\u0006\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020\u0001H\u0016J\u0006\u0010@\u001a\u00020\u0013J\u0006\u0010A\u001a\u00020\u001bJ\u0006\u0010B\u001a\u00020!J\u0006\u0010C\u001a\u00020\u001dJ\u0006\u0010D\u001a\u00020\u001dJ\u0006\u0010E\u001a\u00020\u001dJ\b\u0010F\u001a\u000202H\u0016J\b\u0010G\u001a\u00020\fH\u0016R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0018R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010(\u001a\u00060)R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010=\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?\u00a8\u0006K"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsReader;", "Lorg/gnit/lucenekmp/codecs/StoredFieldsReader;", "reader", "merging", "", "<init>", "(Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsReader;Z)V", "d", "Lorg/gnit/lucenekmp/store/Directory;", "si", "Lorg/gnit/lucenekmp/index/SegmentInfo;", "segmentSuffix", "", "fn", "Lorg/gnit/lucenekmp/index/FieldInfos;", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "formatName", "compressionMode", "Lorg/gnit/lucenekmp/codecs/compressing/CompressionMode;", "(Lorg/gnit/lucenekmp/store/Directory;Lorg/gnit/lucenekmp/index/SegmentInfo;Ljava/lang/String;Lorg/gnit/lucenekmp/index/FieldInfos;Lorg/gnit/lucenekmp/store/IOContext;Ljava/lang/String;Lorg/gnit/lucenekmp/codecs/compressing/CompressionMode;)V", "version", "", "getVersion", "()I", "fieldInfos", "indexReader", "Lorg/gnit/lucenekmp/codecs/lucene90/compressing/FieldsIndex;", "maxPointer", "", "getMaxPointer", "()J", "fieldsStream", "Lorg/gnit/lucenekmp/store/IndexInput;", "chunkSize", "getChunkSize", "decompressor", "Lorg/gnit/lucenekmp/codecs/compressing/Decompressor;", "numDocs", "getNumDocs", "state", "Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsReader$BlockState;", "numChunks", "numDirtyChunks", "numDirtyDocs", "prefetchedBlockIDCache", "", "prefetchedBlockIDCacheIndex", "closed", "ensureOpen", "", "close", "prefetch", "docID", "serializedDocument", "Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsReader$SerializedDocument;", "isLoaded", "document", "visitor", "Lorg/gnit/lucenekmp/index/StoredFieldVisitor;", "clone", "mergeInstance", "getMergeInstance", "()Lorg/gnit/lucenekmp/codecs/StoredFieldsReader;", "getCompressionMode", "getIndexReader", "getFieldsStream", "getNumDirtyDocs", "getNumDirtyChunks", "getNumChunks", "checkIntegrity", "toString", "SerializedDocument", "BlockState", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLucene90CompressingStoredFieldsReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene90CompressingStoredFieldsReader.kt\norg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,717:1\n1#2:718\n*E\n"})
public final class Lucene90CompressingStoredFieldsReader
extends StoredFieldsReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int version;
    @Nullable
    private final FieldInfos fieldInfos;
    @NotNull
    private final FieldsIndex indexReader;
    private final long maxPointer;
    @NotNull
    private final IndexInput fieldsStream;
    private final int chunkSize;
    @NotNull
    private final CompressionMode compressionMode;
    @NotNull
    private final Decompressor decompressor;
    private final int numDocs;
    private final boolean merging;
    @NotNull
    private final BlockState state;
    private final long numChunks;
    private final long numDirtyChunks;
    private final long numDirtyDocs;
    @NotNull
    private final long[] prefetchedBlockIDCache;
    private int prefetchedBlockIDCacheIndex;
    private boolean closed;
    private static final int PREFETCH_CACHE_SIZE = 16;
    private static final int PREFETCH_CACHE_MASK = 15;

    public final int getVersion() {
        return this.version;
    }

    public final long getMaxPointer() {
        return this.maxPointer;
    }

    public final int getChunkSize() {
        return this.chunkSize;
    }

    public final int getNumDocs() {
        return this.numDocs;
    }

    private Lucene90CompressingStoredFieldsReader(Lucene90CompressingStoredFieldsReader reader2, boolean merging) {
        this.version = reader2.version;
        this.fieldInfos = reader2.fieldInfos;
        this.fieldsStream = reader2.fieldsStream.clone();
        this.indexReader = reader2.indexReader.clone();
        this.maxPointer = reader2.maxPointer;
        this.chunkSize = reader2.chunkSize;
        this.compressionMode = reader2.compressionMode;
        this.decompressor = reader2.decompressor.clone();
        this.numDocs = reader2.numDocs;
        this.numChunks = reader2.numChunks;
        this.numDirtyChunks = reader2.numDirtyChunks;
        this.numDirtyDocs = reader2.numDirtyDocs;
        this.prefetchedBlockIDCache = new long[16];
        Arrays.INSTANCE.fill(this.prefetchedBlockIDCache, -1L);
        this.merging = merging;
        this.state = new BlockState();
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lucene90CompressingStoredFieldsReader(@NotNull Directory d, @NotNull SegmentInfo si, @NotNull String segmentSuffix, @Nullable FieldInfos fn, @NotNull IOContext context, @NotNull String formatName, @NotNull CompressionMode compressionMode) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        Intrinsics.checkNotNullParameter((Object)segmentSuffix, (String)"segmentSuffix");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)formatName, (String)"formatName");
        Intrinsics.checkNotNullParameter((Object)compressionMode, (String)"compressionMode");
        this.compressionMode = compressionMode;
        String segment = si.getName();
        boolean success = false;
        this.fieldInfos = fn;
        this.numDocs = si.maxDoc();
        String fieldsStreamFN = IndexFileNames.INSTANCE.segmentFileName(segment, segmentSuffix, "fdt");
        ChecksumIndexInput metaIn = null;
        try {
            this.fieldsStream = d.openInput(fieldsStreamFN, context.withReadAdvice(ReadAdvice.RANDOM));
            this.version = CodecUtil.INSTANCE.checkIndexHeader(this.fieldsStream, formatName, 1, 1, si.getId(), segmentSuffix);
            if (!((long)CodecUtil.INSTANCE.indexHeaderLength(formatName, segmentSuffix) == this.fieldsStream.getFilePointer())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            String metaStreamFN = IndexFileNames.INSTANCE.segmentFileName(segment, segmentSuffix, "fdm");
            metaIn = d.openChecksumInput(metaStreamFN);
            CodecUtil.INSTANCE.checkIndexHeader(metaIn, "Lucene90FieldsIndexMeta", 0, this.version, si.getId(), segmentSuffix);
            this.chunkSize = metaIn.readVInt();
            this.decompressor = compressionMode.newDecompressor();
            this.prefetchedBlockIDCache = new long[16];
            Arrays.INSTANCE.fill(this.prefetchedBlockIDCache, -1L);
            this.merging = false;
            this.state = new BlockState();
            CodecUtil.INSTANCE.retrieveChecksum(this.fieldsStream);
            long maxPointer = -1L;
            FieldsIndex indexReader = null;
            FieldsIndexReader fieldsIndexReader = new FieldsIndexReader(d, si.getName(), segmentSuffix, "fdx", "Lucene90FieldsIndex", si.getId(), metaIn, context);
            indexReader = fieldsIndexReader;
            this.maxPointer = maxPointer = fieldsIndexReader.getMaxPointer();
            this.indexReader = indexReader;
            this.numChunks = metaIn.readVLong();
            this.numDirtyChunks = metaIn.readVLong();
            this.numDirtyDocs = metaIn.readVLong();
            if (this.numChunks < this.numDirtyChunks) {
                throw new CorruptIndexException("Cannot have more dirty chunks than chunks: numChunks=" + this.numChunks + ", numDirtyChunks=" + this.numDirtyChunks, metaIn);
            }
            if (this.numDirtyChunks == 0L != (this.numDirtyDocs == 0L)) {
                throw new CorruptIndexException("Cannot have dirty chunks without dirty docs or vice-versa: numDirtyChunks=" + this.numDirtyChunks + ", numDirtyDocs=" + this.numDirtyDocs, metaIn);
            }
            if (this.numDirtyDocs < this.numDirtyChunks) {
                throw new CorruptIndexException("Cannot have more dirty chunks than documents within dirty chunks: numDirtyChunks=" + this.numDirtyChunks + ", numDirtyDocs=" + this.numDirtyDocs, metaIn);
            }
            CodecUtil.INSTANCE.checkFooter(metaIn, null);
            metaIn.close();
            success = true;
        }
        catch (Throwable t) {
            try {
                if (metaIn != null) {
                    CodecUtil.INSTANCE.checkFooter(metaIn, t);
                    throw new AssertionError((Object)"unreachable");
                }
                throw t;
            }
            catch (Throwable throwable) {
                AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
                autoCloseableArray[0] = this;
                Intrinsics.checkNotNull(metaIn);
                IOUtils.INSTANCE.closeWhileHandlingException(autoCloseableArray);
                throw throwable;
            }
        }
    }

    private final void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException("this FieldsReader is closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.indexReader, this.fieldsStream};
            IOUtils.INSTANCE.close(autoCloseableArray);
            this.closed = true;
        }
    }

    @Override
    public void prefetch(int docID) throws IOException {
        long blockID = this.indexReader.getBlockID(docID);
        for (long prefetchedBlockID : this.prefetchedBlockIDCache) {
            if (prefetchedBlockID != blockID) continue;
            return;
        }
        long blockStartPointer = this.indexReader.getBlockStartPointer(blockID);
        long blockLength = this.indexReader.getBlockLength(blockID);
        this.fieldsStream.prefetch(blockStartPointer, blockLength);
        int n = this.prefetchedBlockIDCacheIndex;
        this.prefetchedBlockIDCacheIndex = n + 1;
        this.prefetchedBlockIDCache[n & 0xF] = blockID;
    }

    @NotNull
    public final SerializedDocument serializedDocument(int docID) throws IOException {
        if (!this.state.contains(docID)) {
            this.fieldsStream.seek(this.indexReader.getStartPointer(docID));
            this.state.reset(docID);
        }
        if (!this.state.contains(docID)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.state.document(docID);
    }

    public final boolean isLoaded(int docID) {
        if (!this.merging) {
            boolean $i$a$-check-Lucene90CompressingStoredFieldsReader$isLoaded$32 = false;
            String $i$a$-check-Lucene90CompressingStoredFieldsReader$isLoaded$32 = "isLoaded should only ever get called on a merge instance";
            throw new IllegalStateException($i$a$-check-Lucene90CompressingStoredFieldsReader$isLoaded$32.toString());
        }
        if (!(this.version == 1)) {
            boolean bl = false;
            String string = "isLoaded should only ever get called when the reader is on the current version";
            throw new IllegalStateException(string.toString());
        }
        return this.state.contains(docID);
    }

    @Override
    public void document(int docID, @NotNull StoredFieldVisitor visitor2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        SerializedDocument doc = this.serializedDocument(docID);
        int n = doc.getNumStoredFields();
        block6: for (int fieldIDX = 0; fieldIDX < n; ++fieldIDX) {
            FieldInfo fieldInfo;
            long infoAndBits = doc.getIn().readVLong();
            int fieldNumber = (int)(infoAndBits >>> Lucene90CompressingStoredFieldsWriter.Companion.getTYPE_BITS());
            FieldInfos fieldInfos = this.fieldInfos;
            Intrinsics.checkNotNull((Object)fieldInfos);
            Intrinsics.checkNotNull((Object)fieldInfos.fieldInfo(fieldNumber));
            int bits = (int)(infoAndBits & (long)Lucene90CompressingStoredFieldsWriter.Companion.getTYPE_MASK());
            if (!(bits <= 5)) {
                boolean bl = false;
                String string = "bits=" + IntExtKt.toHexString(IntCompanionObject.INSTANCE, bits);
                throw new IllegalArgumentException(string.toString());
            }
            StoredFieldVisitor.Status status = visitor2.needsField(fieldInfo);
            switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 1: {
                    Lucene90CompressingStoredFieldsReader.Companion.readField(doc.getIn(), visitor2, fieldInfo, bits);
                    UnsupportedOperationException unsupportedOperationException = Unit.INSTANCE;
                    continue block6;
                }
                case 2: {
                    if (fieldIDX == doc.getNumStoredFields() - 1) {
                        return;
                    }
                    Lucene90CompressingStoredFieldsReader.Companion.skipField(doc.getIn(), bits);
                    UnsupportedOperationException unsupportedOperationException = Unit.INSTANCE;
                    continue block6;
                }
                case 3: {
                    return;
                }
                case -1: {
                    UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("StoredFieldVisitor returned null for field: " + fieldInfo.getName());
                    continue block6;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    @Override
    @NotNull
    public StoredFieldsReader clone() {
        this.ensureOpen();
        return new Lucene90CompressingStoredFieldsReader(this, false);
    }

    @Override
    @NotNull
    public StoredFieldsReader getMergeInstance() {
        this.ensureOpen();
        return new Lucene90CompressingStoredFieldsReader(this, true);
    }

    @NotNull
    public final CompressionMode getCompressionMode() {
        return this.compressionMode;
    }

    @NotNull
    public final FieldsIndex getIndexReader() {
        return this.indexReader;
    }

    @NotNull
    public final IndexInput getFieldsStream() {
        return this.fieldsStream;
    }

    public final long getNumDirtyDocs() {
        if (!(this.version == 1)) {
            boolean bl = false;
            String string = "getNumDirtyDocs should only ever get called when the reader is on the current version";
            throw new IllegalStateException(string.toString());
        }
        if (!(this.numDirtyDocs >= 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.numDirtyDocs;
    }

    public final long getNumDirtyChunks() {
        if (!(this.version == 1)) {
            boolean bl = false;
            String string = "getNumDirtyChunks should only ever get called when the reader is on the current version";
            throw new IllegalStateException(string.toString());
        }
        if (!(this.numDirtyChunks >= 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.numDirtyChunks;
    }

    public final long getNumChunks() {
        if (!(this.version == 1)) {
            boolean bl = false;
            String string = "getNumChunks should only ever get called when the reader is on the current version";
            throw new IllegalStateException(string.toString());
        }
        if (!(this.numChunks >= 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.numChunks;
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.indexReader.checkIntegrity();
        CodecUtil.INSTANCE.checksumEntireFile(this.fieldsStream);
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "(mode=" + this.compressionMode + ",chunksize=" + this.chunkSize + ")";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsReader$BlockState;", "", "<init>", "(Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsReader;)V", "docBase", "", "chunkDocs", "sliced", "", "offsets", "", "numStoredFields", "startPointer", "", "spare", "Lorg/gnit/lucenekmp/util/BytesRef;", "bytes", "contains", "docID", "reset", "", "doReset", "document", "Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsReader$SerializedDocument;", "core"})
    private final class BlockState {
        private int docBase;
        private int chunkDocs;
        private boolean sliced;
        @NotNull
        private long[] offsets = LongsRef.Companion.getEMPTY_LONGS();
        @NotNull
        private long[] numStoredFields = LongsRef.Companion.getEMPTY_LONGS();
        private long startPointer;
        @Nullable
        private final BytesRef spare;
        @Nullable
        private final BytesRef bytes;

        public BlockState() {
            if (Lucene90CompressingStoredFieldsReader.this.merging) {
                this.spare = new BytesRef();
                this.bytes = new BytesRef();
            } else {
                this.spare = this.bytes = null;
            }
        }

        public final boolean contains(int docID) {
            return docID >= this.docBase && docID < this.docBase + this.chunkDocs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void reset(int docID) throws IOException {
            boolean success = false;
            try {
                this.doReset(docID);
                success = true;
            }
            catch (Throwable throwable) {
                this.chunkDocs = 0;
                throw throwable;
            }
        }

        public final void doReset(int docID) throws IOException {
            this.docBase = Lucene90CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            int token = Lucene90CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            this.chunkDocs = token >>> 2;
            if (!this.contains(docID) || this.docBase + this.chunkDocs > Lucene90CompressingStoredFieldsReader.this.getNumDocs()) {
                throw new CorruptIndexException("Corrupted: docID=" + docID + ", docBase=" + this.docBase + ", chunkDocs=" + this.chunkDocs + ", numDocs=" + Lucene90CompressingStoredFieldsReader.this.getNumDocs(), Lucene90CompressingStoredFieldsReader.this.fieldsStream);
            }
            this.sliced = (token & 1) != 0;
            this.offsets = ArrayUtil.Companion.growNoCopy(this.offsets, this.chunkDocs + 1);
            this.numStoredFields = ArrayUtil.Companion.growNoCopy(this.numStoredFields, this.chunkDocs);
            if (this.chunkDocs == 1) {
                this.numStoredFields[0] = Lucene90CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                this.offsets[1] = Lucene90CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            } else {
                int i;
                StoredFieldsInts.INSTANCE.readInts(Lucene90CompressingStoredFieldsReader.this.fieldsStream, this.chunkDocs, this.numStoredFields, 0);
                StoredFieldsInts.INSTANCE.readInts(Lucene90CompressingStoredFieldsReader.this.fieldsStream, this.chunkDocs, this.offsets, 1);
                int n = this.chunkDocs;
                for (i = 0; i < n; ++i) {
                    long[] lArray = this.offsets;
                    int n2 = i + 1;
                    lArray[n2] = lArray[n2] + this.offsets[i];
                }
                n = this.chunkDocs;
                for (i = 0; i < n; ++i) {
                    long storedFields2;
                    long len = this.offsets[i + 1] - this.offsets[i];
                    if (len == 0L == ((storedFields2 = this.numStoredFields[i]) == 0L)) continue;
                    throw new CorruptIndexException("length=" + len + ", numStoredFields=" + storedFields2, Lucene90CompressingStoredFieldsReader.this.fieldsStream);
                }
            }
            this.startPointer = Lucene90CompressingStoredFieldsReader.this.fieldsStream.getFilePointer();
            if (Lucene90CompressingStoredFieldsReader.this.merging) {
                int totalLength = Math.INSTANCE.toIntExact(this.offsets[this.chunkDocs]);
                if (this.sliced) {
                    int toDecompress;
                    BytesRef bytesRef = this.bytes;
                    Intrinsics.checkNotNull((Object)bytesRef);
                    bytesRef.setLength(0);
                    this.bytes.setOffset(this.bytes.getLength());
                    for (int decompressed = 0; decompressed < totalLength; decompressed += toDecompress) {
                        toDecompress = java.lang.Math.min(totalLength - decompressed, Lucene90CompressingStoredFieldsReader.this.getChunkSize());
                        Decompressor decompressor = Lucene90CompressingStoredFieldsReader.this.decompressor;
                        DataInput dataInput = Lucene90CompressingStoredFieldsReader.this.fieldsStream;
                        BytesRef bytesRef2 = this.spare;
                        Intrinsics.checkNotNull((Object)bytesRef2);
                        decompressor.decompress(dataInput, toDecompress, 0, toDecompress, bytesRef2);
                        this.bytes.setBytes(ArrayUtil.Companion.grow(this.bytes.getBytes(), this.bytes.getLength() + this.spare.getLength()));
                        System.INSTANCE.arraycopy(this.spare.getBytes(), this.spare.getOffset(), this.bytes.getBytes(), this.bytes.getLength(), this.spare.getLength());
                        BytesRef bytesRef3 = this.bytes;
                        bytesRef3.setLength(bytesRef3.getLength() + this.spare.getLength());
                    }
                } else {
                    Decompressor decompressor = Lucene90CompressingStoredFieldsReader.this.decompressor;
                    DataInput dataInput = Lucene90CompressingStoredFieldsReader.this.fieldsStream;
                    BytesRef bytesRef = this.bytes;
                    Intrinsics.checkNotNull((Object)bytesRef);
                    decompressor.decompress(dataInput, totalLength, 0, totalLength, bytesRef);
                }
                if (this.bytes.getLength() != totalLength) {
                    throw new CorruptIndexException("Corrupted: expected chunk size = " + totalLength + ", got " + this.bytes.getLength(), Lucene90CompressingStoredFieldsReader.this.fieldsStream);
                }
            }
        }

        @NotNull
        public final SerializedDocument document(int docID) throws IOException {
            BytesRef bytesRef;
            if (!this.contains(docID)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int index = docID - this.docBase;
            int offset = Math.INSTANCE.toIntExact(this.offsets[index]);
            int length = Math.INSTANCE.toIntExact(this.offsets[index + 1]) - offset;
            int totalLength = Math.INSTANCE.toIntExact(this.offsets[this.chunkDocs]);
            int numStoredFields = Math.INSTANCE.toIntExact(this.numStoredFields[index]);
            if (Lucene90CompressingStoredFieldsReader.this.merging) {
                BytesRef bytesRef2 = this.bytes;
                bytesRef = bytesRef2;
                Intrinsics.checkNotNull((Object)bytesRef2);
            } else {
                bytesRef = new BytesRef();
            }
            BytesRef bytes = bytesRef;
            DataInput documentInput = null;
            if (length == 0) {
                documentInput = new ByteArrayDataInput();
            } else if (Lucene90CompressingStoredFieldsReader.this.merging) {
                documentInput = new ByteArrayDataInput(bytes.getBytes(), bytes.getOffset() + offset, length);
            } else if (this.sliced) {
                Lucene90CompressingStoredFieldsReader.this.fieldsStream.seek(this.startPointer);
                Lucene90CompressingStoredFieldsReader.this.decompressor.decompress(Lucene90CompressingStoredFieldsReader.this.fieldsStream, Lucene90CompressingStoredFieldsReader.this.getChunkSize(), offset, java.lang.Math.min(length, Lucene90CompressingStoredFieldsReader.this.getChunkSize() - offset), bytes);
                documentInput = new DataInput(bytes, length, Lucene90CompressingStoredFieldsReader.this){
                    private int decompressed;
                    final /* synthetic */ BytesRef $bytes;
                    final /* synthetic */ int $length;
                    final /* synthetic */ Lucene90CompressingStoredFieldsReader this$0;
                    {
                        this.$bytes = $bytes;
                        this.$length = $length;
                        this.this$0 = $receiver;
                        this.decompressed = $bytes.getLength();
                    }

                    public final int getDecompressed() {
                        return this.decompressed;
                    }

                    public final void setDecompressed(int n) {
                        this.decompressed = n;
                    }

                    public final void fillBuffer() throws IOException {
                        if (!(this.decompressed <= this.$length)) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        if (this.decompressed == this.$length) {
                            throw new EOFException();
                        }
                        int toDecompress = java.lang.Math.min(this.$length - this.decompressed, this.this$0.getChunkSize());
                        Lucene90CompressingStoredFieldsReader.access$getDecompressor$p(this.this$0).decompress(Lucene90CompressingStoredFieldsReader.access$getFieldsStream$p(this.this$0), toDecompress, 0, toDecompress, this.$bytes);
                        this.decompressed += toDecompress;
                    }

                    public byte readByte() throws IOException {
                        if (this.$bytes.getLength() == 0) {
                            this.fillBuffer();
                        }
                        BytesRef bytesRef = this.$bytes;
                        bytesRef.setLength(bytesRef.getLength() + -1);
                        bytesRef.getLength();
                        byte[] byArray = this.$bytes.getBytes();
                        bytesRef = this.$bytes;
                        int n = bytesRef.getOffset();
                        bytesRef.setOffset(n + 1);
                        return byArray[n];
                    }

                    public void readBytes(byte[] b, int offset, int len) throws IOException {
                        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                        int offset2 = offset;
                        int len2 = len;
                        while (len2 > this.$bytes.getLength()) {
                            System.INSTANCE.arraycopy(this.$bytes.getBytes(), this.$bytes.getOffset(), b, offset2, this.$bytes.getLength());
                            len2 -= this.$bytes.getLength();
                            offset2 += this.$bytes.getLength();
                            this.fillBuffer();
                        }
                        System.INSTANCE.arraycopy(this.$bytes.getBytes(), this.$bytes.getOffset(), b, offset2, len2);
                        BytesRef bytesRef = this.$bytes;
                        bytesRef.setOffset(bytesRef.getOffset() + len2);
                        bytesRef = this.$bytes;
                        bytesRef.setLength(bytesRef.getLength() - len2);
                    }

                    public void skipBytes(long numBytes) throws IOException {
                        long numBytes2 = 0L;
                        numBytes2 = numBytes;
                        if (!(numBytes2 >= 0L)) {
                            boolean bl = false;
                            String string = "numBytes must be >= 0, got " + numBytes2;
                            throw new IllegalArgumentException(string.toString());
                        }
                        while (numBytes2 > (long)this.$bytes.getLength()) {
                            numBytes2 -= (long)this.$bytes.getLength();
                            this.fillBuffer();
                        }
                        BytesRef bytesRef = this.$bytes;
                        bytesRef.setOffset(bytesRef.getOffset() + (int)numBytes2);
                        bytesRef = this.$bytes;
                        bytesRef.setLength(bytesRef.getLength() - (int)numBytes2);
                    }
                };
            } else {
                Lucene90CompressingStoredFieldsReader.this.fieldsStream.seek(this.startPointer);
                Lucene90CompressingStoredFieldsReader.this.decompressor.decompress(Lucene90CompressingStoredFieldsReader.this.fieldsStream, totalLength, offset, length, bytes);
                if (!(bytes.getLength() == length)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                documentInput = new ByteArrayDataInput(bytes.getBytes(), bytes.getOffset(), bytes.getLength());
            }
            return new SerializedDocument(documentInput, length, numStoredFields);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsReader$Companion;", "", "<init>", "()V", "PREFETCH_CACHE_SIZE", "", "PREFETCH_CACHE_MASK", "readField", "", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "visitor", "Lorg/gnit/lucenekmp/index/StoredFieldVisitor;", "info", "Lorg/gnit/lucenekmp/index/FieldInfo;", "bits", "skipField", "readZFloat", "", "readZDouble", "", "readTLong", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final void readField(DataInput in, StoredFieldVisitor visitor2, FieldInfo info, int bits) throws IOException {
            switch (bits & Lucene90CompressingStoredFieldsWriter.Companion.getTYPE_MASK()) {
                case 1: {
                    int length = in.readVInt();
                    visitor2.binaryField(info, new StoredFieldDataInput(in, length));
                    break;
                }
                case 0: {
                    visitor2.stringField(info, in.readString());
                    break;
                }
                case 2: {
                    visitor2.intField(info, in.readZInt());
                    break;
                }
                case 3: {
                    visitor2.floatField(info, this.readZFloat(in));
                    break;
                }
                case 4: {
                    visitor2.longField(info, this.readTLong(in));
                    break;
                }
                case 5: {
                    visitor2.doubleField(info, this.readZDouble(in));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown type flag: " + IntExtKt.toHexString(IntCompanionObject.INSTANCE, bits)));
                }
            }
        }

        private final void skipField(DataInput in, int bits) throws IOException {
            switch (bits & Lucene90CompressingStoredFieldsWriter.Companion.getTYPE_MASK()) {
                case 0: 
                case 1: {
                    int length = in.readVInt();
                    in.skipBytes(length);
                    break;
                }
                case 2: {
                    in.readZInt();
                    break;
                }
                case 3: {
                    this.readZFloat(in);
                    break;
                }
                case 4: {
                    this.readTLong(in);
                    break;
                }
                case 5: {
                    this.readZDouble(in);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown type flag: " + IntExtKt.toHexString(IntCompanionObject.INSTANCE, bits)));
                }
            }
        }

        public final float readZFloat(@NotNull DataInput in) throws IOException {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            byte b = (byte)(in.readByte() & 0xFFFFFFFF);
            if (b == 255) {
                return FloatExtKt.intBitsToFloat(FloatCompanionObject.INSTANCE, in.readInt());
            }
            if ((b & 0x80) != 0) {
                return (b & 0x7F) - 1;
            }
            int bits = b << 24 | (short)(in.readShort() & 0xFFFFFFFF) << 8 | (byte)(in.readByte() & 0xFFFFFFFF);
            return FloatExtKt.intBitsToFloat(FloatCompanionObject.INSTANCE, bits);
        }

        public final double readZDouble(@NotNull DataInput in) throws IOException {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            byte b = (byte)(in.readByte() & 0xFFFFFFFF);
            if (b == 255) {
                return DoubleExtKt.longBitsToDouble(DoubleCompanionObject.INSTANCE, in.readLong());
            }
            if (b == 254) {
                return FloatExtKt.intBitsToFloat(FloatCompanionObject.INSTANCE, in.readInt());
            }
            if ((b & 0x80) != 0) {
                return (b & 0x7F) - 1;
            }
            long bits = (long)b << 56 | (long)((in.readInt() & 0xFFFFFFFF) << 24) | (long)((short)(in.readShort() & 0xFFFFFFFF) << 8) | (long)((byte)(in.readByte() & 0xFFFFFFFF));
            return DoubleExtKt.longBitsToDouble(DoubleCompanionObject.INSTANCE, bits);
        }

        public final long readTLong(@NotNull DataInput in) throws IOException {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            byte header = (byte)(in.readByte() & 0xFFFFFFFF);
            long bits = header & 0x1F;
            if ((header & 0x20) != 0) {
                bits |= in.readVLong() << 5;
            }
            long l = BitUtil.INSTANCE.zigZagDecode(bits);
            switch (header & 0xC0) {
                case 64: {
                    l *= 1000L;
                    break;
                }
                case 128: {
                    l *= 3600000L;
                    break;
                }
                case 192: {
                    l *= 86400000L;
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return l;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsReader$SerializedDocument;", "", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "length", "", "numStoredFields", "<init>", "(Lorg/gnit/lucenekmp/store/DataInput;II)V", "getIn", "()Lorg/gnit/lucenekmp/store/DataInput;", "getLength", "()I", "getNumStoredFields", "core"})
    public static final class SerializedDocument {
        @NotNull
        private final DataInput in;
        private final int length;
        private final int numStoredFields;

        public SerializedDocument(@NotNull DataInput in, int length, int numStoredFields) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
            this.length = length;
            this.numStoredFields = numStoredFields;
        }

        @NotNull
        public final DataInput getIn() {
            return this.in;
        }

        public final int getLength() {
            return this.length;
        }

        public final int getNumStoredFields() {
            return this.numStoredFields;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StoredFieldVisitor.Status.values().length];
            try {
                nArray[StoredFieldVisitor.Status.YES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StoredFieldVisitor.Status.NO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StoredFieldVisitor.Status.STOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

