/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90.compressing;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.TermVectorsReader;
import org.gnit.lucenekmp.codecs.compressing.CompressionMode;
import org.gnit.lucenekmp.codecs.compressing.Decompressor;
import org.gnit.lucenekmp.codecs.lucene90.compressing.FieldsIndex;
import org.gnit.lucenekmp.codecs.lucene90.compressing.FieldsIndexReader;
import org.gnit.lucenekmp.codecs.lucene90.compressing.Lucene90CompressingTermVectorsWriter;
import org.gnit.lucenekmp.index.BaseTermsEnum;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.Fields;
import org.gnit.lucenekmp.index.ImpactsEnum;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.SegmentInfo;
import org.gnit.lucenekmp.index.SlowImpactsEnum;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.store.AlreadyClosedException;
import org.gnit.lucenekmp.store.ByteArrayDataInput;
import org.gnit.lucenekmp.store.ByteBuffersDataInput;
import org.gnit.lucenekmp.store.ByteBuffersDataOutput;
import org.gnit.lucenekmp.store.ChecksumIndexInput;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.RandomAccessInput;
import org.gnit.lucenekmp.store.ReadAdvice;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.LongValues;
import org.gnit.lucenekmp.util.LongsRef;
import org.gnit.lucenekmp.util.packed.BlockPackedReaderIterator;
import org.gnit.lucenekmp.util.packed.DirectReader;
import org.gnit.lucenekmp.util.packed.DirectWriter;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 ^2\u00020\u0001:\u0006YZ[\\]^B\u0011\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004BC\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\n\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0003\u0010\u0012J\u0006\u00109\u001a\u00020.J\u0006\u0010:\u001a\u00020.J\u0006\u0010;\u001a\u00020.J\b\u0010<\u001a\u00020=H\u0002J\b\u0010>\u001a\u00020=H\u0016J\b\u0010?\u001a\u00020\u0001H\u0016J\u000e\u0010C\u001a\u00020+2\u0006\u0010D\u001a\u00020\u001dJ\u0010\u0010E\u001a\u00020=2\u0006\u0010D\u001a\u00020\u001dH\u0016J\u0012\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010H\u001a\u00020\u001dH\u0016J3\u0010I\u001a\b\u0012\u0004\u0012\u00020K0J2\u0006\u0010L\u001a\u00020\u001d2\u0006\u0010M\u001a\u00020\u001d2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020KH\u0002\u00a2\u0006\u0002\u0010QJY\u0010R\u001a\b\u0012\u0004\u0012\u00020K0J2\u0006\u0010L\u001a\u00020\u001d2\u0006\u0010M\u001a\u00020\u001d2\u0006\u0010S\u001a\u00020O2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020K2\u0006\u0010T\u001a\u00020\u001d2\u0006\u0010U\u001a\u00020\u001d2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020K0JH\u0002\u00a2\u0006\u0002\u0010VJ\b\u0010W\u001a\u00020=H\u0016J\b\u0010X\u001a\u00020\nH\u0016R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001fR\u0011\u0010(\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001fR\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00101\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u000e\u00104\u001a\u000205X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010@\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010B\u00a8\u0006_"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsReader;", "Lorg/gnit/lucenekmp/codecs/TermVectorsReader;", "reader", "<init>", "(Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsReader;)V", "d", "Lorg/gnit/lucenekmp/store/Directory;", "si", "Lorg/gnit/lucenekmp/index/SegmentInfo;", "segmentSuffix", "", "fn", "Lorg/gnit/lucenekmp/index/FieldInfos;", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "formatName", "compressionMode", "Lorg/gnit/lucenekmp/codecs/compressing/CompressionMode;", "(Lorg/gnit/lucenekmp/store/Directory;Lorg/gnit/lucenekmp/index/SegmentInfo;Ljava/lang/String;Lorg/gnit/lucenekmp/index/FieldInfos;Lorg/gnit/lucenekmp/store/IOContext;Ljava/lang/String;Lorg/gnit/lucenekmp/codecs/compressing/CompressionMode;)V", "fieldInfos", "indexReader", "Lorg/gnit/lucenekmp/codecs/lucene90/compressing/FieldsIndex;", "getIndexReader", "()Lorg/gnit/lucenekmp/codecs/lucene90/compressing/FieldsIndex;", "vectorsStream", "Lorg/gnit/lucenekmp/store/IndexInput;", "getVectorsStream", "()Lorg/gnit/lucenekmp/store/IndexInput;", "version", "", "getVersion", "()I", "packedIntsVersion", "getPackedIntsVersion", "getCompressionMode", "()Lorg/gnit/lucenekmp/codecs/compressing/CompressionMode;", "decompressor", "Lorg/gnit/lucenekmp/codecs/compressing/Decompressor;", "chunkSize", "getChunkSize", "numDocs", "getNumDocs", "closed", "", "Lorg/gnit/lucenekmp/util/packed/BlockPackedReaderIterator;", "numChunks", "", "numDirtyChunks", "numDirtyDocs", "maxPointer", "getMaxPointer", "()J", "blockState", "Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsReader$BlockState;", "prefetchedBlockIDCache", "", "prefetchedBlockIDCacheIndex", "getNumDirtyDocs", "getNumDirtyChunks", "getNumChunks", "ensureOpen", "", "close", "clone", "mergeInstance", "getMergeInstance", "()Lorg/gnit/lucenekmp/codecs/TermVectorsReader;", "isLoaded", "docID", "prefetch", "get", "Lorg/gnit/lucenekmp/index/Fields;", "doc", "positionIndex", "", "", "skip", "numFields", "numTerms", "Lorg/gnit/lucenekmp/util/LongValues;", "termFreqs", "(IILorg/gnit/lucenekmp/util/LongValues;[I)[[I", "readPositions", "flags", "flag", "totalPositions", "(IILorg/gnit/lucenekmp/util/LongValues;Lorg/gnit/lucenekmp/util/LongValues;[III[[I)[[I", "checkIntegrity", "toString", "BlockState", "TVFields", "TVTerms", "TVTermsEnum", "TVPostingsEnum", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLucene90CompressingTermVectorsReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene90CompressingTermVectorsReader.kt\norg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1283:1\n1#2:1284\n*E\n"})
public final class Lucene90CompressingTermVectorsReader
extends TermVectorsReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final FieldInfos fieldInfos;
    @NotNull
    private final FieldsIndex indexReader;
    @NotNull
    private final IndexInput vectorsStream;
    private final int version;
    private final int packedIntsVersion;
    @NotNull
    private final CompressionMode compressionMode;
    @NotNull
    private final Decompressor decompressor;
    private final int chunkSize;
    private final int numDocs;
    private boolean closed;
    @NotNull
    private final BlockPackedReaderIterator reader;
    private final long numChunks;
    private final long numDirtyChunks;
    private final long numDirtyDocs;
    private final long maxPointer;
    @NotNull
    private BlockState blockState;
    @NotNull
    private final long[] prefetchedBlockIDCache;
    private int prefetchedBlockIDCacheIndex;
    private static final int PREFETCH_CACHE_SIZE = 16;
    private static final int PREFETCH_CACHE_MASK = PREFETCH_CACHE_SIZE - 1;

    @NotNull
    public final FieldsIndex getIndexReader() {
        return this.indexReader;
    }

    @NotNull
    public final IndexInput getVectorsStream() {
        return this.vectorsStream;
    }

    public final int getVersion() {
        return this.version;
    }

    public final int getPackedIntsVersion() {
        return this.packedIntsVersion;
    }

    @NotNull
    public final CompressionMode getCompressionMode() {
        return this.compressionMode;
    }

    public final int getChunkSize() {
        return this.chunkSize;
    }

    public final int getNumDocs() {
        return this.numDocs;
    }

    public final long getMaxPointer() {
        return this.maxPointer;
    }

    private Lucene90CompressingTermVectorsReader(Lucene90CompressingTermVectorsReader reader2) {
        this.blockState = new BlockState(-1L, -1, 0);
        this.fieldInfos = reader2.fieldInfos;
        this.vectorsStream = reader2.vectorsStream.clone();
        this.indexReader = reader2.indexReader.clone();
        this.packedIntsVersion = reader2.packedIntsVersion;
        this.compressionMode = reader2.compressionMode;
        this.decompressor = reader2.decompressor.clone();
        this.chunkSize = reader2.chunkSize;
        this.numDocs = reader2.numDocs;
        this.reader = new BlockPackedReaderIterator(this.vectorsStream, this.packedIntsVersion, 64, 0L);
        this.version = reader2.version;
        this.numChunks = reader2.numChunks;
        this.numDirtyChunks = reader2.numDirtyChunks;
        this.numDirtyDocs = reader2.numDirtyDocs;
        this.maxPointer = reader2.maxPointer;
        this.prefetchedBlockIDCache = new long[PREFETCH_CACHE_SIZE];
        Arrays.INSTANCE.fill(this.prefetchedBlockIDCache, -1L);
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lucene90CompressingTermVectorsReader(@NotNull Directory d, @NotNull SegmentInfo si, @NotNull String segmentSuffix, @Nullable FieldInfos fn, @NotNull IOContext context, @NotNull String formatName, @NotNull CompressionMode compressionMode) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        Intrinsics.checkNotNullParameter((Object)segmentSuffix, (String)"segmentSuffix");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)formatName, (String)"formatName");
        Intrinsics.checkNotNullParameter((Object)compressionMode, (String)"compressionMode");
        this.blockState = new BlockState(-1L, -1, 0);
        this.compressionMode = compressionMode;
        String segment = si.getName();
        boolean success = false;
        this.fieldInfos = fn;
        this.numDocs = si.maxDoc();
        ChecksumIndexInput metaIn = null;
        try {
            String vectorsStreamFN = IndexFileNames.INSTANCE.segmentFileName(segment, segmentSuffix, "tvd");
            this.vectorsStream = d.openInput(vectorsStreamFN, context.withReadAdvice(ReadAdvice.RANDOM));
            this.version = CodecUtil.INSTANCE.checkIndexHeader(this.vectorsStream, formatName, 0, 0, si.getId(), segmentSuffix);
            if (!((long)CodecUtil.INSTANCE.indexHeaderLength(formatName, segmentSuffix) == this.vectorsStream.getFilePointer())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            String metaStreamFN = IndexFileNames.INSTANCE.segmentFileName(segment, segmentSuffix, "tvm");
            metaIn = d.openChecksumInput(metaStreamFN);
            CodecUtil.INSTANCE.checkIndexHeader(metaIn, "Lucene90TermVectorsIndexMeta", 0, this.version, si.getId(), segmentSuffix);
            this.packedIntsVersion = metaIn.readVInt();
            this.chunkSize = metaIn.readVInt();
            CodecUtil.INSTANCE.retrieveChecksum(this.vectorsStream);
            FieldsIndexReader fieldsIndexReader = new FieldsIndexReader(d, si.getName(), segmentSuffix, "tvx", "Lucene90TermVectorsIndex", si.getId(), metaIn, context);
            this.indexReader = fieldsIndexReader;
            this.maxPointer = fieldsIndexReader.getMaxPointer();
            this.numChunks = metaIn.readVLong();
            this.numDirtyChunks = metaIn.readVLong();
            this.numDirtyDocs = metaIn.readVLong();
            if (this.numChunks < this.numDirtyChunks) {
                throw new CorruptIndexException("Cannot have more dirty chunks than chunks: numChunks=" + this.numChunks + ", numDirtyChunks=" + this.numDirtyChunks, metaIn);
            }
            if (this.numDirtyChunks == 0L != (this.numDirtyDocs == 0L)) {
                throw new CorruptIndexException("Cannot have dirty chunks without dirty docs or vice-versa: numDirtyChunks=" + this.numDirtyChunks + ", numDirtyDocs=" + this.numDirtyDocs, metaIn);
            }
            if (this.numDirtyDocs < this.numDirtyChunks) {
                throw new CorruptIndexException("Cannot have more dirty chunks than documents within dirty chunks: numDirtyChunks=" + this.numDirtyChunks + ", numDirtyDocs=" + this.numDirtyDocs, metaIn);
            }
            this.decompressor = compressionMode.newDecompressor();
            this.reader = new BlockPackedReaderIterator(this.vectorsStream, this.packedIntsVersion, 64, 0L);
            CodecUtil.INSTANCE.checkFooter(metaIn, null);
            metaIn.close();
            this.prefetchedBlockIDCache = new long[PREFETCH_CACHE_SIZE];
            Arrays.INSTANCE.fill(this.prefetchedBlockIDCache, -1L);
            success = true;
        }
        catch (Throwable t) {
            try {
                if (metaIn != null) {
                    CodecUtil.INSTANCE.checkFooter(metaIn, t);
                    throw new AssertionError((Object)"unreachable");
                }
                throw t;
            }
            catch (Throwable throwable) {
                AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
                autoCloseableArray[0] = this;
                Intrinsics.checkNotNull(metaIn);
                IOUtils.INSTANCE.closeWhileHandlingException(autoCloseableArray);
                throw throwable;
            }
        }
    }

    public final long getNumDirtyDocs() {
        if (!(this.version == 0)) {
            boolean bl = false;
            String string = "getNumDirtyDocs should only ever get called when the reader is on the current version";
            throw new IllegalStateException(string.toString());
        }
        if (!(this.numDirtyDocs >= 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.numDirtyDocs;
    }

    public final long getNumDirtyChunks() {
        if (!(this.version == 0)) {
            boolean bl = false;
            String string = "getNumDirtyChunks should only ever get called when the reader is on the current version";
            throw new IllegalStateException(string.toString());
        }
        if (!(this.numDirtyChunks >= 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.numDirtyChunks;
    }

    public final long getNumChunks() {
        if (!(this.version == 0)) {
            boolean bl = false;
            String string = "getNumChunks should only ever get called when the reader is on the current version";
            throw new IllegalStateException(string.toString());
        }
        if (!(this.numChunks >= 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.numChunks;
    }

    private final void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException("this FieldsReader is closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.indexReader, this.vectorsStream};
            IOUtils.INSTANCE.close(autoCloseableArray);
            this.closed = true;
        }
    }

    @Override
    @NotNull
    public TermVectorsReader clone() {
        return new Lucene90CompressingTermVectorsReader(this);
    }

    @Override
    @NotNull
    public TermVectorsReader getMergeInstance() {
        return new Lucene90CompressingTermVectorsReader(this);
    }

    public final boolean isLoaded(int docID) {
        return this.blockState.getDocBase() <= docID && docID < this.blockState.getDocBase() + this.blockState.getChunkDocs();
    }

    @Override
    public void prefetch(int docID) throws IOException {
        long blockID = this.indexReader.getBlockID(docID);
        for (long prefetchedBlockID : this.prefetchedBlockIDCache) {
            if (prefetchedBlockID != blockID) continue;
            return;
        }
        long blockStartPointer = this.indexReader.getBlockStartPointer(blockID);
        long blockLength = this.indexReader.getBlockLength(blockID);
        this.vectorsStream.prefetch(blockStartPointer, blockLength);
        int n = this.prefetchedBlockIDCacheIndex;
        this.prefetchedBlockIDCacheIndex = n + 1;
        this.prefetchedBlockIDCache[n & Lucene90CompressingTermVectorsReader.PREFETCH_CACHE_MASK] = blockID;
    }

    @Override
    @Nullable
    public Fields get(int doc) throws IOException {
        int termCount;
        int n;
        int j;
        int end;
        int i;
        long j2;
        long l;
        int k;
        int n2;
        LongsRef next;
        int j3;
        int termCount2;
        long i2;
        long i3;
        this.ensureOpen();
        long startPointer = 0L;
        startPointer = this.isLoaded(doc) ? this.blockState.getStartPointer() : this.indexReader.getStartPointer(doc);
        this.vectorsStream.seek(startPointer);
        int docBase = this.vectorsStream.readVInt();
        int chunkDocs = this.vectorsStream.readVInt() >>> 1;
        if (doc < docBase || doc >= docBase + chunkDocs || docBase + chunkDocs > this.numDocs) {
            throw new CorruptIndexException("docBase=" + docBase + ",chunkDocs=" + chunkDocs + ",doc=" + doc, this.vectorsStream);
        }
        this.blockState = new BlockState(startPointer, docBase, chunkDocs);
        long skip = 0L;
        long numFields = 0L;
        long totalFields = 0L;
        if (chunkDocs == 1) {
            skip = 0L;
            numFields = totalFields = (long)this.vectorsStream.readVInt();
        } else {
            int i4;
            this.reader.reset(this.vectorsStream, chunkDocs);
            long sum = 0L;
            for (i4 = docBase; i4 < doc; ++i4) {
                sum += this.reader.next();
            }
            skip = sum;
            numFields = this.reader.next();
            sum += numFields;
            int n3 = docBase + chunkDocs;
            for (i4 = doc + 1; i4 < n3; ++i4) {
                sum += this.reader.next();
            }
            totalFields = sum;
        }
        if (numFields == 0L) {
            return null;
        }
        int[] fieldNums = null;
        Lucene90CompressingTermVectorsReader $this$get_u24lambda_u243 = this;
        boolean bl = false;
        byte token = (byte)($this$get_u24lambda_u243.vectorsStream.readByte() & 0xFFFFFFFF);
        if (!(token != 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int bitsPerFieldNum = token & 0x1F;
        int totalDistinctFields = token >>> 5;
        if (totalDistinctFields == 7) {
            totalDistinctFields += $this$get_u24lambda_u243.vectorsStream.readVInt();
        }
        PackedInts.ReaderIterator it = PackedInts.INSTANCE.getReaderIteratorNoHeader($this$get_u24lambda_u243.vectorsStream, PackedInts.Format.PACKED, $this$get_u24lambda_u243.packedIntsVersion, ++totalDistinctFields, bitsPerFieldNum, 1);
        fieldNums = new int[totalDistinctFields];
        int n4 = totalDistinctFields;
        for (int i5 = 0; i5 < n4; ++i5) {
            fieldNums[i5] = (int)it.next();
        }
        long[] fieldNumOffs = new long[(int)numFields];
        LongValues flags = null;
        Lucene90CompressingTermVectorsReader $this$get_u24lambda_u244 = this;
        boolean bl2 = false;
        int bitsPerOff = DirectWriter.Companion.bitsRequired(fieldNums.length - 1);
        LongValues allFieldNumOffs = DirectReader.INSTANCE.getInstance(Lucene90CompressingTermVectorsReader.Companion.slice($this$get_u24lambda_u244.vectorsStream), bitsPerOff);
        switch ($this$get_u24lambda_u244.vectorsStream.readVInt()) {
            case 0: {
                LongValues fieldFlags = DirectReader.INSTANCE.getInstance(Lucene90CompressingTermVectorsReader.Companion.slice($this$get_u24lambda_u244.vectorsStream), Lucene90CompressingTermVectorsWriter.Companion.getFLAGS_BITS());
                ByteBuffersDataOutput out = new ByteBuffersDataOutput(0, 0, null, null, 15, null);
                DirectWriter writer = DirectWriter.Companion.getInstance(out, totalFields, Lucene90CompressingTermVectorsWriter.Companion.getFLAGS_BITS());
                for (i3 = 0L; i3 < totalFields; ++i3) {
                    long fieldNumOff = allFieldNumOffs.get(i3);
                    if (!(fieldNumOff >= 0L && fieldNumOff < (long)fieldNums.length)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    writer.add(fieldFlags.get(fieldNumOff));
                }
                writer.finish();
                flags = DirectReader.INSTANCE.getInstance(out.toDataInput(), Lucene90CompressingTermVectorsWriter.Companion.getFLAGS_BITS());
                Unit unit = Unit.INSTANCE;
                break;
            }
            case 1: {
                flags = DirectReader.INSTANCE.getInstance(Lucene90CompressingTermVectorsReader.Companion.slice($this$get_u24lambda_u244.vectorsStream), Lucene90CompressingTermVectorsWriter.Companion.getFLAGS_BITS());
                Unit unit = Unit.INSTANCE;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        for (i2 = 0L; i2 < numFields; ++i2) {
            fieldNumOffs[(int)i2] = allFieldNumOffs.get(skip + i2);
        }
        LongValues numTerms = null;
        long totalTerms = 0L;
        Lucene90CompressingTermVectorsReader $this$get_u24lambda_u245 = this;
        boolean bl3 = false;
        int bitsRequired = $this$get_u24lambda_u245.vectorsStream.readVInt();
        numTerms = DirectReader.INSTANCE.getInstance(Lucene90CompressingTermVectorsReader.Companion.slice($this$get_u24lambda_u245.vectorsStream), bitsRequired);
        long sum = 0L;
        for (i3 = 0L; i3 < totalFields; ++i3) {
            sum += numTerms.get(i3);
        }
        totalTerms = sum;
        long docOff = 0L;
        long docLen = 0L;
        long totalLen = 0L;
        int[] fieldLengths = new int[(int)numFields];
        int[][] prefixLengths = new int[(int)numFields][];
        int[][] suffixLengths = new int[(int)numFields][];
        Lucene90CompressingTermVectorsReader $this$get_u24lambda_u246 = this;
        boolean bl4 = false;
        $this$get_u24lambda_u246.reader.reset($this$get_u24lambda_u246.vectorsStream, totalTerms);
        long toSkip = 0L;
        for (i2 = 0L; i2 < skip; ++i2) {
            toSkip += numTerms.get(i2);
        }
        $this$get_u24lambda_u246.reader.skip(toSkip);
        for (i2 = 0L; i2 < numFields; ++i2) {
            termCount2 = (int)numTerms.get(skip + i2);
            int[] fieldPrefixLengths = new int[termCount2];
            prefixLengths[(int)i2] = fieldPrefixLengths;
            j3 = 0;
            while (j3 < termCount2) {
                next = $this$get_u24lambda_u246.reader.next(termCount2 - j3);
                n2 = next.getLength();
                for (k = 0; k < n2; ++k) {
                    fieldPrefixLengths[j3++] = (int)next.getLongs()[next.getOffset() + k];
                }
            }
        }
        $this$get_u24lambda_u246.reader.skip(totalTerms - $this$get_u24lambda_u246.reader.ord());
        $this$get_u24lambda_u246.reader.reset($this$get_u24lambda_u246.vectorsStream, totalTerms);
        toSkip = 0L;
        for (i2 = 0L; i2 < skip; ++i2) {
            l = numTerms.get(i2);
            for (j2 = 0L; j2 < l; ++j2) {
                docOff += $this$get_u24lambda_u246.reader.next();
            }
        }
        for (i2 = 0L; i2 < numFields; ++i2) {
            termCount2 = (int)numTerms.get(skip + i2);
            int[] fieldSuffixLengths = new int[termCount2];
            suffixLengths[(int)i2] = fieldSuffixLengths;
            j3 = 0;
            while (j3 < termCount2) {
                next = $this$get_u24lambda_u246.reader.next(termCount2 - j3);
                n2 = next.getLength();
                for (k = 0; k < n2; ++k) {
                    fieldSuffixLengths[j3++] = (int)next.getLongs()[next.getOffset() + k];
                }
            }
            int n5 = (int)i2;
            int[] nArray = suffixLengths[(int)i2];
            Intrinsics.checkNotNull((Object)nArray);
            fieldLengths[n5] = Lucene90CompressingTermVectorsReader.Companion.sum(nArray);
            docLen += (long)fieldLengths[(int)i2];
        }
        totalLen = docOff + docLen;
        for (i2 = skip + numFields; i2 < totalFields; ++i2) {
            l = numTerms.get(i2);
            for (j2 = 0L; j2 < l; ++j2) {
                totalLen += $this$get_u24lambda_u246.reader.next();
            }
        }
        int[] termFreqs = new int[(int)totalTerms];
        Lucene90CompressingTermVectorsReader $this$get_u24lambda_u247 = this;
        boolean bl5 = false;
        $this$get_u24lambda_u247.reader.reset($this$get_u24lambda_u247.vectorsStream, totalTerms);
        int i6 = 0;
        while ((long)i6 < totalTerms) {
            LongsRef next2 = $this$get_u24lambda_u247.reader.next((int)(totalTerms - (long)i6));
            termCount2 = next2.getLength();
            for (int k2 = 0; k2 < termCount2; ++k2) {
                termFreqs[i6++] = 1 + (int)next2.getLongs()[next2.getOffset() + k2];
            }
        }
        int totalPositions = 0;
        int totalOffsets = 0;
        long totalPayloads = 0L;
        Lucene90CompressingTermVectorsReader $this$get_u24lambda_u249 = this;
        boolean bl6 = false;
        long termIndex = 0L;
        for (long i7 = 0L; i7 < totalFields; ++i7) {
            int f = (int)flags.get(i7);
            int termCount3 = (int)numTerms.get(i7);
            for (int j4 = 0; j4 < termCount3; ++j4) {
                j2 = termIndex;
                termIndex = j2 + 1L;
                int freq = termFreqs[(int)j2];
                if ((f & 1) != 0) {
                    totalPositions += freq;
                }
                if ((f & 2) != 0) {
                    totalOffsets += freq;
                }
                if ((f & 4) == 0) continue;
                totalPayloads += (long)freq;
            }
            if (i7 != totalFields - 1L || termIndex == totalTerms) continue;
            boolean $i$a$-require-Lucene90CompressingTermVectorsReader$get$6$22 = false;
            String $i$a$-require-Lucene90CompressingTermVectorsReader$get$6$22 = termIndex + " " + totalTerms;
            throw new IllegalArgumentException($i$a$-require-Lucene90CompressingTermVectorsReader$get$6$22.toString());
        }
        int[][] positionIndex = this.positionIndex((int)skip, (int)numFields, numTerms, termFreqs);
        Object positions = null;
        Object startOffsets = null;
        Object lengths = null;
        positions = totalPositions > 0 ? (Object)this.readPositions((int)skip, (int)numFields, flags, numTerms, termFreqs, 1, totalPositions, positionIndex) : new int[(int)numFields][];
        if (totalOffsets > 0) {
            float[] charsPerTerm = new float[fieldNums.length];
            int f = charsPerTerm.length;
            for (i = 0; i < f; ++i) {
                charsPerTerm[i] = FloatExtKt.intBitsToFloat(FloatCompanionObject.INSTANCE, this.vectorsStream.readInt());
            }
            startOffsets = this.readPositions((int)skip, (int)numFields, flags, numTerms, termFreqs, 2, totalOffsets, positionIndex);
            lengths = this.readPositions((int)skip, (int)numFields, flags, numTerms, termFreqs, 2, totalOffsets, positionIndex);
            f = (int)numFields;
            for (i = 0; i < f; ++i) {
                int[] fStartOffsets = startOffsets[i];
                int[] fPositions = positions[i];
                if (fStartOffsets != null && fPositions != null) {
                    float fieldCharsPerTerm = charsPerTerm[(int)fieldNumOffs[i]];
                    int $i$a$-require-Lucene90CompressingTermVectorsReader$get$6$22 = startOffsets[i].length;
                    for (int j5 = 0; j5 < $i$a$-require-Lucene90CompressingTermVectorsReader$get$6$22; ++j5) {
                        int n6 = j5;
                        fStartOffsets[n6] = fStartOffsets[n6] + (int)(fieldCharsPerTerm * (float)fPositions[j5]);
                    }
                }
                if (fStartOffsets == null) continue;
                int[] fPrefixLengths = prefixLengths[i];
                int[] fSuffixLengths = suffixLengths[i];
                int[] fLengths = lengths[i];
                end = (int)numTerms.get(skip + (long)i);
                for (j = 0; j < end; ++j) {
                    int[] nArray;
                    Intrinsics.checkNotNull((Object)fPrefixLengths);
                    int n7 = fPrefixLengths[j];
                    Intrinsics.checkNotNull((Object)fSuffixLengths);
                    int termLength = n7 + fSuffixLengths[j];
                    Intrinsics.checkNotNull((Object)lengths[i]);
                    n = positionIndex[i][j];
                    nArray[n] = nArray[n] + termLength;
                    int k3 = positionIndex[i][j] + 1;
                    n = positionIndex[i][j + 1];
                    while (k3 < n) {
                        int n8 = k3;
                        fStartOffsets[n8] = fStartOffsets[n8] + fStartOffsets[k3 - 1];
                        Intrinsics.checkNotNull((Object)fLengths);
                        int[] nArray2 = fLengths;
                        int n9 = k3++;
                        nArray2[n9] = nArray2[n9] + termLength;
                    }
                }
            }
        } else {
            startOffsets = lengths = new int[(int)numFields][];
        }
        if (totalPositions > 0) {
            i = (int)numFields;
            for (int i8 = 0; i8 < i; ++i8) {
                int[] fPositions = positions[i8];
                int[] fpositionIndex = positionIndex[i8];
                if (fPositions == null) continue;
                int end2 = (int)numTerms.get(skip + (long)i8);
                for (int j6 = 0; j6 < end2; ++j6) {
                    int fLengths = fpositionIndex[j6 + 1];
                    for (int k4 = fpositionIndex[j6] + 1; k4 < fLengths; ++k4) {
                        j = k4;
                        fPositions[j] = fPositions[j] + fPositions[k4 - 1];
                    }
                }
            }
        }
        int[][] payloadIndex = new int[(int)numFields][];
        long totalPayloadLength = 0L;
        long payloadOff = 0L;
        long payloadLen = 0L;
        if (totalPayloads > 0L) {
            int k5;
            int j7;
            int f;
            this.reader.reset(this.vectorsStream, totalPayloads);
            int termIndex2 = 0;
            for (long i9 = 0L; i9 < skip; ++i9) {
                f = (int)flags.get(i9);
                termCount = (int)numTerms.get(i9);
                if ((f & 4) != 0) {
                    for (j7 = 0; j7 < termCount; ++j7) {
                        int freq = termFreqs[termIndex2 + j7];
                        for (k5 = 0; k5 < freq; ++k5) {
                            int l2 = (int)this.reader.next();
                            payloadOff += (long)l2;
                        }
                    }
                }
                termIndex2 += termCount;
            }
            totalPayloadLength = payloadOff;
            end = (int)numFields;
            for (int i10 = 0; i10 < end; ++i10) {
                f = (int)flags.get(skip + (long)i10);
                termCount = (int)numTerms.get(skip + (long)i10);
                if ((f & 4) != 0) {
                    int totalFreq = positionIndex[i10][termCount];
                    payloadIndex[i10] = new int[totalFreq + 1];
                    int posIdx = 0;
                    int[] nArray = payloadIndex[i10];
                    Intrinsics.checkNotNull((Object)nArray);
                    nArray[posIdx] = (int)payloadLen;
                    for (int j8 = 0; j8 < termCount; ++j8) {
                        int freq = termFreqs[termIndex2 + j8];
                        for (int k6 = 0; k6 < freq; ++k6) {
                            int payloadLength = (int)this.reader.next();
                            int[] nArray3 = payloadIndex[i10];
                            Intrinsics.checkNotNull((Object)nArray3);
                            nArray3[posIdx + 1] = (int)(payloadLen += (long)payloadLength);
                            ++posIdx;
                        }
                    }
                    if (!(posIdx == totalFreq)) {
                        String freq = "Failed requirement.";
                        throw new IllegalArgumentException(freq.toString());
                    }
                }
                termIndex2 += termCount;
            }
            totalPayloadLength += payloadLen;
            for (long i11 = skip + numFields; i11 < totalFields; ++i11) {
                f = (int)flags.get(i11);
                termCount = (int)numTerms.get(i11);
                if ((f & 4) != 0) {
                    for (j7 = 0; j7 < termCount; ++j7) {
                        int freq = termFreqs[termIndex2 + j7];
                        for (k5 = 0; k5 < freq; ++k5) {
                            totalPayloadLength += this.reader.next();
                        }
                    }
                }
                termIndex2 += termCount;
            }
            if (!((long)termIndex2 == totalTerms)) {
                boolean $i$a$-require-Lucene90CompressingTermVectorsReader$get$82 = false;
                String $i$a$-require-Lucene90CompressingTermVectorsReader$get$82 = termIndex2 + " " + totalTerms;
                throw new IllegalArgumentException($i$a$-require-Lucene90CompressingTermVectorsReader$get$82.toString());
            }
        }
        BytesRef suffixBytes = new BytesRef();
        this.decompressor.decompress(this.vectorsStream, (int)(totalLen + totalPayloadLength), (int)(docOff + payloadOff), (int)(docLen + payloadLen), suffixBytes);
        suffixBytes.setLength((int)docLen);
        BytesRef payloadBytes = new BytesRef(suffixBytes.getBytes(), (int)((long)suffixBytes.getOffset() + docLen), (int)payloadLen);
        int[] fieldFlags = new int[(int)numFields];
        termCount = (int)numFields;
        for (int i12 = 0; i12 < termCount; ++i12) {
            fieldFlags[i12] = (int)flags.get(skip + (long)i12);
        }
        int[] fieldNumTerms = new int[(int)numFields];
        n = (int)numFields;
        for (int i13 = 0; i13 < n; ++i13) {
            fieldNumTerms[i13] = (int)numTerms.get(skip + (long)i13);
        }
        int[][] fieldTermFreqs = new int[(int)numFields][];
        Lucene90CompressingTermVectorsReader $this$get_u24lambda_u2411 = this;
        boolean bl7 = false;
        long termIdx = 0L;
        for (long i14 = 0L; i14 < skip; ++i14) {
            termIdx += numTerms.get(i14);
        }
        int n10 = (int)numFields;
        for (int i15 = 0; i15 < n10; ++i15) {
            long termCount4 = numTerms.get(skip + (long)i15);
            fieldTermFreqs[i15] = new int[(int)termCount4];
            int n11 = (int)termCount4;
            for (int j9 = 0; j9 < n11; ++j9) {
                int[] nArray = fieldTermFreqs[i15];
                Intrinsics.checkNotNull((Object)nArray);
                long l3 = termIdx;
                termIdx = l3 + 1L;
                nArray[j9] = termFreqs[(int)l3];
            }
        }
        if (!((long)Lucene90CompressingTermVectorsReader.Companion.sum(fieldLengths) == docLen)) {
            boolean bl8 = false;
            String string = Lucene90CompressingTermVectorsReader.Companion.sum(fieldLengths) + " != " + docLen;
            throw new IllegalArgumentException(string.toString());
        }
        return new TVFields(fieldNums, fieldFlags, fieldNumOffs, fieldNumTerms, fieldLengths, prefixLengths, suffixLengths, fieldTermFreqs, positionIndex, (int[][])positions, (int[][])startOffsets, (int[][])lengths, payloadBytes, payloadIndex, suffixBytes);
    }

    private final int[][] positionIndex(int skip, int numFields, LongValues numTerms, int[] termFreqs) {
        int[][] positionIndex = new int[numFields][];
        int termIndex = 0;
        long l = skip;
        for (long i = 0L; i < l; ++i) {
            int termCount = (int)numTerms.get(i);
            termIndex += termCount;
        }
        for (int i = 0; i < numFields; ++i) {
            int termCount = (int)numTerms.get((long)skip + (long)i);
            positionIndex[i] = new int[termCount + 1];
            for (int j = 0; j < termCount; ++j) {
                int freq = termFreqs[termIndex + j];
                int[] nArray = positionIndex[i];
                Intrinsics.checkNotNull((Object)nArray);
                int[] nArray2 = positionIndex[i];
                Intrinsics.checkNotNull((Object)nArray2);
                nArray[j + 1] = nArray2[j] + freq;
            }
            termIndex += termCount;
        }
        return positionIndex;
    }

    private final int[][] readPositions(int skip, int numFields, LongValues flags, LongValues numTerms, int[] termFreqs, int flag, int totalPositions, int[][] positionIndex) throws IOException {
        int[][] positions = new int[numFields][];
        this.reader.reset(this.vectorsStream, totalPositions);
        long toSkip = 0L;
        int termIndex = 0;
        long l = skip;
        for (long i = 0L; i < l; ++i) {
            int f = (int)flags.get(i);
            int termCount = (int)numTerms.get(i);
            if ((f & flag) != 0) {
                for (int j = 0; j < termCount; ++j) {
                    int freq = termFreqs[termIndex + j];
                    toSkip += (long)freq;
                }
            }
            termIndex += termCount;
        }
        this.reader.skip(toSkip);
        for (int i = 0; i < numFields; ++i) {
            int f = (int)flags.get((long)skip + (long)i);
            int termCount = (int)numTerms.get((long)skip + (long)i);
            if ((f & flag) != 0) {
                int totalFreq = positionIndex[i][termCount];
                int[] fieldPositions = new int[totalFreq];
                positions[i] = fieldPositions;
                int j = 0;
                while (j < totalFreq) {
                    LongsRef nextPositions = this.reader.next(totalFreq - j);
                    int n = nextPositions.getLength();
                    for (int k = 0; k < n; ++k) {
                        fieldPositions[j++] = (int)nextPositions.getLongs()[nextPositions.getOffset() + k];
                    }
                }
            }
            termIndex += termCount;
        }
        this.reader.skip((long)totalPositions - this.reader.ord());
        return positions;
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.indexReader.checkIntegrity();
        CodecUtil.INSTANCE.checksumEntireFile(this.vectorsStream);
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "(mode=" + this.compressionMode + ",chunksize=" + this.chunkSize + ")";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsReader$BlockState;", "", "startPointer", "", "docBase", "", "chunkDocs", "<init>", "(JII)V", "getStartPointer", "()J", "getDocBase", "()I", "getChunkDocs", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "core"})
    private static final class BlockState {
        private final long startPointer;
        private final int docBase;
        private final int chunkDocs;

        public BlockState(long startPointer, int docBase, int chunkDocs) {
            this.startPointer = startPointer;
            this.docBase = docBase;
            this.chunkDocs = chunkDocs;
        }

        public final long getStartPointer() {
            return this.startPointer;
        }

        public final int getDocBase() {
            return this.docBase;
        }

        public final int getChunkDocs() {
            return this.chunkDocs;
        }

        public final long component1() {
            return this.startPointer;
        }

        public final int component2() {
            return this.docBase;
        }

        public final int component3() {
            return this.chunkDocs;
        }

        @NotNull
        public final BlockState copy(long startPointer, int docBase, int chunkDocs) {
            return new BlockState(startPointer, docBase, chunkDocs);
        }

        public static /* synthetic */ BlockState copy$default(BlockState blockState, long l, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                l = blockState.startPointer;
            }
            if ((n3 & 2) != 0) {
                n = blockState.docBase;
            }
            if ((n3 & 4) != 0) {
                n2 = blockState.chunkDocs;
            }
            return blockState.copy(l, n, n2);
        }

        @NotNull
        public String toString() {
            return "BlockState(startPointer=" + this.startPointer + ", docBase=" + this.docBase + ", chunkDocs=" + this.chunkDocs + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.startPointer);
            result = result * 31 + Integer.hashCode(this.docBase);
            result = result * 31 + Integer.hashCode(this.chunkDocs);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BlockState)) {
                return false;
            }
            BlockState blockState = (BlockState)other;
            if (this.startPointer != blockState.startPointer) {
                return false;
            }
            if (this.docBase != blockState.docBase) {
                return false;
            }
            return this.chunkDocs == blockState.chunkDocs;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsReader$Companion;", "", "<init>", "()V", "PREFETCH_CACHE_SIZE", "", "PREFETCH_CACHE_MASK", "slice", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "in", "Lorg/gnit/lucenekmp/store/IndexInput;", "sum", "arr", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final RandomAccessInput slice(IndexInput in) throws IOException {
            int length = in.readVInt();
            byte[] bytes = new byte[length];
            in.readBytes(bytes, 0, length);
            Object[] objectArray = new ByteBuffer[]{ByteBuffer.Companion.wrap$default(ByteBuffer.Companion, bytes, 0, 0, 6, null)};
            return new ByteBuffersDataInput(CollectionsKt.mutableListOf((Object[])objectArray));
        }

        private final int sum(int[] arr) {
            int sum = 0;
            for (int el : arr) {
                sum += el;
            }
            return sum;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010)\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u00af\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\u0006\u0010\u0014\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0096\u0002J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsReader$TVFields;", "Lorg/gnit/lucenekmp/index/Fields;", "fieldNums", "", "fieldFlags", "fieldNumOffs", "", "numTerms", "fieldLengths", "prefixLengths", "", "suffixLengths", "termFreqs", "positionIndex", "positions", "startOffsets", "lengths", "payloadBytes", "Lorg/gnit/lucenekmp/util/BytesRef;", "payloadIndex", "suffixBytes", "<init>", "(Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsReader;[I[I[J[I[I[[I[[I[[I[[I[[I[[I[[ILorg/gnit/lucenekmp/util/BytesRef;[[ILorg/gnit/lucenekmp/util/BytesRef;)V", "[[I", "iterator", "", "", "terms", "Lorg/gnit/lucenekmp/index/Terms;", "field", "size", "", "core"})
    private final class TVFields
    extends Fields {
        @NotNull
        private final int[] fieldNums;
        @NotNull
        private final int[] fieldFlags;
        @NotNull
        private final long[] fieldNumOffs;
        @NotNull
        private final int[] numTerms;
        @NotNull
        private final int[] fieldLengths;
        @NotNull
        private final int[][] prefixLengths;
        @NotNull
        private final int[][] suffixLengths;
        @NotNull
        private final int[][] termFreqs;
        @NotNull
        private final int[][] positionIndex;
        @NotNull
        private final int[][] positions;
        @NotNull
        private final int[][] startOffsets;
        @NotNull
        private final int[][] lengths;
        @NotNull
        private final int[][] payloadIndex;
        @NotNull
        private final BytesRef suffixBytes;
        @NotNull
        private final BytesRef payloadBytes;

        public TVFields(@NotNull int[] fieldNums, @NotNull int[] fieldFlags, @NotNull long[] fieldNumOffs, @NotNull int[] numTerms, @NotNull int[] fieldLengths, @NotNull int[][] prefixLengths, @NotNull int[][] suffixLengths, @NotNull int[][] termFreqs, @NotNull int[][] positionIndex, @NotNull int[][] positions, @NotNull int[][] startOffsets, @NotNull int[][] lengths, @NotNull BytesRef payloadBytes, @NotNull int[][] payloadIndex, BytesRef suffixBytes) {
            Intrinsics.checkNotNullParameter((Object)fieldNums, (String)"fieldNums");
            Intrinsics.checkNotNullParameter((Object)fieldFlags, (String)"fieldFlags");
            Intrinsics.checkNotNullParameter((Object)fieldNumOffs, (String)"fieldNumOffs");
            Intrinsics.checkNotNullParameter((Object)numTerms, (String)"numTerms");
            Intrinsics.checkNotNullParameter((Object)fieldLengths, (String)"fieldLengths");
            Intrinsics.checkNotNullParameter((Object)prefixLengths, (String)"prefixLengths");
            Intrinsics.checkNotNullParameter((Object)suffixLengths, (String)"suffixLengths");
            Intrinsics.checkNotNullParameter((Object)termFreqs, (String)"termFreqs");
            Intrinsics.checkNotNullParameter((Object)positionIndex, (String)"positionIndex");
            Intrinsics.checkNotNullParameter((Object)positions, (String)"positions");
            Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
            Intrinsics.checkNotNullParameter((Object)lengths, (String)"lengths");
            Intrinsics.checkNotNullParameter((Object)payloadBytes, (String)"payloadBytes");
            Intrinsics.checkNotNullParameter((Object)payloadIndex, (String)"payloadIndex");
            Intrinsics.checkNotNullParameter((Object)suffixBytes, (String)"suffixBytes");
            this.fieldNums = fieldNums;
            this.fieldFlags = fieldFlags;
            this.fieldNumOffs = fieldNumOffs;
            this.numTerms = numTerms;
            this.fieldLengths = fieldLengths;
            this.prefixLengths = prefixLengths;
            this.suffixLengths = suffixLengths;
            this.termFreqs = termFreqs;
            this.positionIndex = positionIndex;
            this.positions = positions;
            this.startOffsets = startOffsets;
            this.lengths = lengths;
            this.payloadBytes = payloadBytes;
            this.payloadIndex = payloadIndex;
            this.suffixBytes = suffixBytes;
        }

        @Override
        @NotNull
        public Iterator<String> iterator() {
            return new Iterator<String>(this, Lucene90CompressingTermVectorsReader.this){
                private int i;
                final /* synthetic */ TVFields this$0;
                final /* synthetic */ Lucene90CompressingTermVectorsReader this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public final int getI() {
                    return this.i;
                }

                public final void setI(int n) {
                    this.i = n;
                }

                public boolean hasNext() {
                    return this.i < TVFields.access$getFieldNumOffs$p(this.this$0).length;
                }

                public String next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    int n = this.i;
                    this.i = n + 1;
                    int fieldNum = TVFields.access$getFieldNums$p(this.this$0)[(int)TVFields.access$getFieldNumOffs$p(this.this$0)[n]];
                    FieldInfos fieldInfos = Lucene90CompressingTermVectorsReader.access$getFieldInfos$p(this.this$1);
                    Intrinsics.checkNotNull((Object)fieldInfos);
                    FieldInfo fieldInfo = fieldInfos.fieldInfo(fieldNum);
                    Intrinsics.checkNotNull((Object)fieldInfo);
                    return fieldInfo.getName();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        @Nullable
        public Terms terms(@Nullable String field) throws IOException {
            FieldInfos fieldInfos = Lucene90CompressingTermVectorsReader.this.fieldInfos;
            Intrinsics.checkNotNull((Object)fieldInfos);
            String string = field;
            Intrinsics.checkNotNull((Object)string);
            FieldInfo fieldInfo = fieldInfos.fieldInfo(string);
            if (fieldInfo == null) {
                return null;
            }
            int idx = -1;
            int n = this.fieldNumOffs.length;
            for (int i = 0; i < n; ++i) {
                if (this.fieldNums[(int)this.fieldNumOffs[i]] != fieldInfo.getNumber()) continue;
                idx = i;
                break;
            }
            if (idx == -1 || this.numTerms[idx] == 0) {
                return null;
            }
            int fieldOff = 0;
            int fieldLen = -1;
            int n2 = this.fieldNumOffs.length;
            for (int i = 0; i < n2; ++i) {
                if (i < idx) {
                    fieldOff += this.fieldLengths[i];
                    continue;
                }
                fieldLen = this.fieldLengths[i];
                break;
            }
            if (!(fieldLen >= 0)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            return new TVTerms(this.numTerms[idx], this.fieldFlags[idx], this.prefixLengths[idx], this.suffixLengths[idx], this.termFreqs[idx], this.positionIndex[idx], this.positions[idx], this.startOffsets[idx], this.lengths[idx], this.payloadIndex[idx], this.payloadBytes, new BytesRef(this.suffixBytes.getBytes(), this.suffixBytes.getOffset() + fieldOff, fieldLen));
        }

        @Override
        public int size() {
            return this.fieldNumOffs.length;
        }

        public static final /* synthetic */ long[] access$getFieldNumOffs$p(TVFields $this) {
            return $this.fieldNumOffs;
        }

        public static final /* synthetic */ int[] access$getFieldNums$p(TVFields $this) {
            return $this.fieldNums;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\tJ\u0006\u0010\u0017\u001a\u00020\u0014J\u0006\u0010\u0018\u001a\u00020\u0014J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016J\b\u0010\u001b\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\u001c\u001a\u00020\u0005H\u0016J\b\u0010\u001d\u001a\u00020\u0005H\u0016J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0016J\b\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsReader$TVPostingsEnum;", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "<init>", "()V", "doc", "", "termFreq", "positionIndex", "positions", "", "startOffsets", "lengths", "payload", "Lorg/gnit/lucenekmp/util/BytesRef;", "getPayload", "()Lorg/gnit/lucenekmp/util/BytesRef;", "payloadIndex", "basePayloadOffset", "i", "reset", "", "freq", "payloads", "checkDoc", "checkPosition", "nextPosition", "startOffset", "endOffset", "docID", "nextDoc", "advance", "target", "cost", "", "core"})
    @SourceDebugExtension(value={"SMAP\nLucene90CompressingTermVectorsReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene90CompressingTermVectorsReader.kt\norg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsReader$TVPostingsEnum\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1283:1\n1#2:1284\n*E\n"})
    private static final class TVPostingsEnum
    extends PostingsEnum {
        private int doc = -1;
        private int termFreq;
        private int positionIndex;
        private int[] positions;
        private int[] startOffsets;
        private int[] lengths;
        private int[] payloadIndex;
        private int basePayloadOffset;
        private int i;

        @Override
        @Nullable
        public BytesRef getPayload() {
            this.checkPosition();
            BytesRef bytesRef = this.getPayload();
            Intrinsics.checkNotNull((Object)bytesRef);
            return bytesRef.getLength() == 0 ? null : this.getPayload();
        }

        public final void reset(int freq, int positionIndex, @NotNull int[] positions, @NotNull int[] startOffsets, @NotNull int[] lengths, @NotNull BytesRef payloads, @NotNull int[] payloadIndex) {
            Intrinsics.checkNotNullParameter((Object)positions, (String)"positions");
            Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
            Intrinsics.checkNotNullParameter((Object)lengths, (String)"lengths");
            Intrinsics.checkNotNullParameter((Object)payloads, (String)"payloads");
            Intrinsics.checkNotNullParameter((Object)payloadIndex, (String)"payloadIndex");
            this.termFreq = freq;
            this.positionIndex = positionIndex;
            this.positions = positions;
            this.startOffsets = startOffsets;
            this.lengths = lengths;
            this.basePayloadOffset = payloads.getOffset();
            BytesRef bytesRef = this.getPayload();
            Intrinsics.checkNotNull((Object)bytesRef);
            bytesRef.setBytes(payloads.getBytes());
            BytesRef bytesRef2 = this.getPayload();
            Intrinsics.checkNotNull((Object)bytesRef2);
            bytesRef2.setLength(0);
            BytesRef bytesRef3 = this.getPayload();
            Intrinsics.checkNotNull((Object)bytesRef3);
            BytesRef bytesRef4 = this.getPayload();
            Intrinsics.checkNotNull((Object)bytesRef4);
            bytesRef3.setOffset(bytesRef4.getLength());
            this.payloadIndex = payloadIndex;
            this.doc = this.i = -1;
        }

        public final void checkDoc() {
            if (!(this.doc != Integer.MAX_VALUE)) {
                boolean $i$a$-check-Lucene90CompressingTermVectorsReader$TVPostingsEnum$checkDoc$32 = false;
                String $i$a$-check-Lucene90CompressingTermVectorsReader$TVPostingsEnum$checkDoc$32 = "DocsEnum exhausted";
                throw new IllegalStateException($i$a$-check-Lucene90CompressingTermVectorsReader$TVPostingsEnum$checkDoc$32.toString());
            }
            if (!(this.doc != -1)) {
                boolean bl = false;
                String string = "DocsEnum not started";
                throw new IllegalStateException(string.toString());
            }
        }

        public final void checkPosition() {
            this.checkDoc();
            if (!(this.i >= 0)) {
                boolean $i$a$-check-Lucene90CompressingTermVectorsReader$TVPostingsEnum$checkPosition$32 = false;
                String $i$a$-check-Lucene90CompressingTermVectorsReader$TVPostingsEnum$checkPosition$32 = "Position enum not started";
                throw new IllegalStateException($i$a$-check-Lucene90CompressingTermVectorsReader$TVPostingsEnum$checkPosition$32.toString());
            }
            if (!(this.i < this.termFreq)) {
                boolean bl = false;
                String string = "Read past last position";
                throw new IllegalStateException(string.toString());
            }
        }

        @Override
        public int nextPosition() throws IOException {
            if (!(this.doc == 0)) {
                throw new IllegalStateException("Check failed.");
            }
            if (!(this.i < this.termFreq - 1)) {
                boolean bl = false;
                String string = "Read past last position";
                throw new IllegalStateException(string.toString());
            }
            ++this.i;
            int[] nArray = this.payloadIndex;
            if (this.payloadIndex == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"payloadIndex");
                nArray = null;
            }
            BytesRef bytesRef = this.getPayload();
            Intrinsics.checkNotNull((Object)bytesRef);
            int[] nArray2 = this.payloadIndex;
            if (this.payloadIndex == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"payloadIndex");
                nArray2 = null;
            }
            bytesRef.setOffset(this.basePayloadOffset + nArray2[this.positionIndex + this.i]);
            BytesRef bytesRef2 = this.getPayload();
            Intrinsics.checkNotNull((Object)bytesRef2);
            int[] nArray3 = this.payloadIndex;
            if (this.payloadIndex == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"payloadIndex");
                nArray3 = null;
            }
            int n = nArray3[this.positionIndex + this.i + 1];
            int[] nArray4 = this.payloadIndex;
            if (this.payloadIndex == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"payloadIndex");
                nArray4 = null;
            }
            bytesRef2.setLength(n - nArray4[this.positionIndex + this.i]);
            int[] nArray5 = this.positions;
            if (this.positions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"positions");
                nArray5 = null;
            }
            int[] nArray6 = this.positions;
            if (this.positions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"positions");
                nArray6 = null;
            }
            return nArray6[this.positionIndex + this.i];
        }

        @Override
        public int startOffset() throws IOException {
            this.checkPosition();
            int[] nArray = this.startOffsets;
            if (this.startOffsets == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"startOffsets");
                nArray = null;
            }
            int[] nArray2 = this.startOffsets;
            if (this.startOffsets == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"startOffsets");
                nArray2 = null;
            }
            return nArray2[this.positionIndex + this.i];
        }

        @Override
        public int endOffset() throws IOException {
            this.checkPosition();
            int[] nArray = this.startOffsets;
            if (this.startOffsets == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"startOffsets");
                nArray = null;
            }
            int[] nArray2 = this.startOffsets;
            if (this.startOffsets == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"startOffsets");
                nArray2 = null;
            }
            int n = nArray2[this.positionIndex + this.i];
            int[] nArray3 = this.lengths;
            if (this.lengths == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lengths");
                nArray3 = null;
            }
            return n + nArray3[this.positionIndex + this.i];
        }

        @Override
        public int freq() throws IOException {
            this.checkDoc();
            return this.termFreq;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            int n;
            if (this.doc == -1) {
                int n2;
                int it = n2 = 0;
                boolean bl = false;
                this.doc = it;
                return n2;
            }
            int it = n = Integer.MAX_VALUE;
            boolean bl = false;
            this.doc = it;
            return n;
        }

        @Override
        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        @Override
        public long cost() {
            return 1L;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u0006\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020 H\u0016J\b\u0010#\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R\u0014\u0010\u001c\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006$"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsReader$TVTerms;", "Lorg/gnit/lucenekmp/index/Terms;", "numTerms", "", "flags", "prefixLengths", "", "suffixLengths", "termFreqs", "positionIndex", "positions", "startOffsets", "lengths", "payloadIndex", "payloadBytes", "Lorg/gnit/lucenekmp/util/BytesRef;", "termBytes", "<init>", "(II[I[I[I[I[I[I[I[ILorg/gnit/lucenekmp/util/BytesRef;Lorg/gnit/lucenekmp/util/BytesRef;)V", "sumTotalTermFreq", "", "getSumTotalTermFreq", "()J", "iterator", "Lorg/gnit/lucenekmp/index/TermsEnum;", "size", "sumDocFreq", "getSumDocFreq", "docCount", "getDocCount", "()I", "hasFreqs", "", "hasOffsets", "hasPositions", "hasPayloads", "core"})
    private static final class TVTerms
    extends Terms {
        private final int numTerms;
        private final int flags;
        @NotNull
        private final int[] prefixLengths;
        @NotNull
        private final int[] suffixLengths;
        @NotNull
        private final int[] termFreqs;
        @NotNull
        private final int[] positionIndex;
        @NotNull
        private final int[] positions;
        @NotNull
        private final int[] startOffsets;
        @NotNull
        private final int[] lengths;
        @NotNull
        private final int[] payloadIndex;
        private final long sumTotalTermFreq;
        @NotNull
        private final BytesRef termBytes;
        @NotNull
        private final BytesRef payloadBytes;
        private final long sumDocFreq;
        private final int docCount;

        public TVTerms(int numTerms, int flags, @NotNull int[] prefixLengths, @NotNull int[] suffixLengths, @NotNull int[] termFreqs, @NotNull int[] positionIndex, @NotNull int[] positions, @NotNull int[] startOffsets, @NotNull int[] lengths, @NotNull int[] payloadIndex, @NotNull BytesRef payloadBytes, @NotNull BytesRef termBytes) {
            Intrinsics.checkNotNullParameter((Object)prefixLengths, (String)"prefixLengths");
            Intrinsics.checkNotNullParameter((Object)suffixLengths, (String)"suffixLengths");
            Intrinsics.checkNotNullParameter((Object)termFreqs, (String)"termFreqs");
            Intrinsics.checkNotNullParameter((Object)positionIndex, (String)"positionIndex");
            Intrinsics.checkNotNullParameter((Object)positions, (String)"positions");
            Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
            Intrinsics.checkNotNullParameter((Object)lengths, (String)"lengths");
            Intrinsics.checkNotNullParameter((Object)payloadIndex, (String)"payloadIndex");
            Intrinsics.checkNotNullParameter((Object)payloadBytes, (String)"payloadBytes");
            Intrinsics.checkNotNullParameter((Object)termBytes, (String)"termBytes");
            this.numTerms = numTerms;
            this.flags = flags;
            this.prefixLengths = prefixLengths;
            this.suffixLengths = suffixLengths;
            this.termFreqs = termFreqs;
            this.positionIndex = positionIndex;
            this.positions = positions;
            this.startOffsets = startOffsets;
            this.lengths = lengths;
            this.payloadIndex = payloadIndex;
            this.payloadBytes = payloadBytes;
            this.termBytes = termBytes;
            long ttf = 0L;
            for (int tf : this.termFreqs) {
                ttf += (long)tf;
            }
            this.sumTotalTermFreq = ttf;
            this.sumDocFreq = this.numTerms;
            this.docCount = 1;
        }

        @Override
        public long getSumTotalTermFreq() {
            return this.sumTotalTermFreq;
        }

        @Override
        @NotNull
        public TermsEnum iterator() throws IOException {
            TVTermsEnum termsEnum = new TVTermsEnum();
            termsEnum.reset(this.numTerms, this.flags, this.prefixLengths, this.suffixLengths, this.termFreqs, this.positionIndex, this.positions, this.startOffsets, this.lengths, this.payloadIndex, this.payloadBytes, new ByteArrayDataInput(this.termBytes.getBytes(), this.termBytes.getOffset(), this.termBytes.getLength()));
            return termsEnum;
        }

        @Override
        public long size() throws IOException {
            return this.numTerms;
        }

        @Override
        public long getSumDocFreq() {
            return this.sumDocFreq;
        }

        @Override
        public int getDocCount() {
            return this.docCount;
        }

        @Override
        public boolean hasFreqs() {
            return true;
        }

        @Override
        public boolean hasOffsets() {
            return (this.flags & 2) != 0;
        }

        @Override
        public boolean hasPositions() {
            return (this.flags & 1) != 0;
        }

        @Override
        public boolean hasPayloads() {
            return (this.flags & 4) != 0;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003Jf\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\u0017J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0014H\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u001eH\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0007\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0005H\u0016J\b\u0010 \u001a\u00020\u001eH\u0016J\u001a\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0018\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsReader$TVTermsEnum;", "Lorg/gnit/lucenekmp/index/BaseTermsEnum;", "<init>", "()V", "numTerms", "", "startPos", "ord", "prefixLengths", "", "suffixLengths", "termFreqs", "positionIndex", "positions", "startOffsets", "lengths", "payloadIndex", "in", "Lorg/gnit/lucenekmp/store/ByteArrayDataInput;", "payloads", "Lorg/gnit/lucenekmp/util/BytesRef;", "term", "reset", "", "flags", "next", "seekCeil", "Lorg/gnit/lucenekmp/index/TermsEnum$SeekStatus;", "text", "seekExact", "", "docFreq", "totalTermFreq", "postings", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "reuse", "impacts", "Lorg/gnit/lucenekmp/index/ImpactsEnum;", "core"})
    private static final class TVTermsEnum
    extends BaseTermsEnum {
        private int numTerms;
        private int startPos;
        private int ord;
        private int[] prefixLengths;
        private int[] suffixLengths;
        private int[] termFreqs;
        private int[] positionIndex;
        private int[] positions;
        private int[] startOffsets;
        private int[] lengths;
        private int[] payloadIndex;
        @Nullable
        private ByteArrayDataInput in;
        @Nullable
        private BytesRef payloads;
        @NotNull
        private final BytesRef term = new BytesRef(16);

        public final void reset(int numTerms, int flags, @NotNull int[] prefixLengths, @NotNull int[] suffixLengths, @NotNull int[] termFreqs, @NotNull int[] positionIndex, @NotNull int[] positions, @NotNull int[] startOffsets, @NotNull int[] lengths, @NotNull int[] payloadIndex, @NotNull BytesRef payloads, @NotNull ByteArrayDataInput in) {
            Intrinsics.checkNotNullParameter((Object)prefixLengths, (String)"prefixLengths");
            Intrinsics.checkNotNullParameter((Object)suffixLengths, (String)"suffixLengths");
            Intrinsics.checkNotNullParameter((Object)termFreqs, (String)"termFreqs");
            Intrinsics.checkNotNullParameter((Object)positionIndex, (String)"positionIndex");
            Intrinsics.checkNotNullParameter((Object)positions, (String)"positions");
            Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
            Intrinsics.checkNotNullParameter((Object)lengths, (String)"lengths");
            Intrinsics.checkNotNullParameter((Object)payloadIndex, (String)"payloadIndex");
            Intrinsics.checkNotNullParameter((Object)payloads, (String)"payloads");
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.numTerms = numTerms;
            this.prefixLengths = prefixLengths;
            this.suffixLengths = suffixLengths;
            this.termFreqs = termFreqs;
            this.positionIndex = positionIndex;
            this.positions = positions;
            this.startOffsets = startOffsets;
            this.lengths = lengths;
            this.payloadIndex = payloadIndex;
            this.payloads = payloads;
            this.in = in;
            this.startPos = in.getPosition();
            this.reset();
        }

        public final void reset() {
            this.term.setLength(0);
            ByteArrayDataInput byteArrayDataInput = this.in;
            Intrinsics.checkNotNull((Object)byteArrayDataInput);
            byteArrayDataInput.setPosition(this.startPos);
            this.ord = -1;
        }

        @Override
        @Nullable
        public BytesRef next() throws IOException {
            if (this.ord == this.numTerms - 1) {
                return null;
            }
            if (!(this.ord < this.numTerms)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            ++this.ord;
            this.term.setOffset(0);
            int[] nArray = this.prefixLengths;
            if (this.prefixLengths == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"prefixLengths");
                nArray = null;
            }
            int n = nArray[this.ord];
            int[] nArray2 = this.suffixLengths;
            if (this.suffixLengths == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"suffixLengths");
                nArray2 = null;
            }
            this.term.setLength(n + nArray2[this.ord]);
            if (this.term.getLength() > this.term.getBytes().length) {
                this.term.setBytes(ArrayUtil.Companion.grow(this.term.getBytes(), this.term.getLength()));
            }
            ByteArrayDataInput byteArrayDataInput = this.in;
            Intrinsics.checkNotNull((Object)byteArrayDataInput);
            byte[] byArray = this.term.getBytes();
            int[] nArray3 = this.prefixLengths;
            if (this.prefixLengths == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"prefixLengths");
                nArray3 = null;
            }
            int n2 = nArray3[this.ord];
            int[] nArray4 = this.suffixLengths;
            if (this.suffixLengths == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"suffixLengths");
                nArray4 = null;
            }
            byteArrayDataInput.readBytes(byArray, n2, nArray4[this.ord]);
            return this.term;
        }

        @Override
        @NotNull
        public TermsEnum.SeekStatus seekCeil(@NotNull BytesRef text) throws IOException {
            int cmp;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            if (this.ord < this.numTerms && this.ord >= 0) {
                int cmp2 = this.term().compareTo(text);
                if (cmp2 == 0) {
                    return TermsEnum.SeekStatus.FOUND;
                }
                if (cmp2 > 0) {
                    this.reset();
                }
            }
            do {
                BytesRef term;
                if ((term = this.next()) == null) {
                    return TermsEnum.SeekStatus.END;
                }
                cmp = term.compareTo(text);
                if (cmp <= 0) continue;
                return TermsEnum.SeekStatus.NOT_FOUND;
            } while (cmp != 0);
            return TermsEnum.SeekStatus.FOUND;
        }

        @Override
        public void seekExact(long ord) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public BytesRef term() throws IOException {
            return this.term;
        }

        @Override
        public long ord() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docFreq() throws IOException {
            return 1;
        }

        @Override
        public long totalTermFreq() throws IOException {
            int[] nArray = this.termFreqs;
            if (this.termFreqs == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"termFreqs");
                nArray = null;
            }
            return nArray[this.ord];
        }

        @Override
        @NotNull
        public PostingsEnum postings(@Nullable PostingsEnum reuse, int flags) throws IOException {
            TVPostingsEnum docsEnum = reuse != null && reuse instanceof TVPostingsEnum ? (TVPostingsEnum)reuse : new TVPostingsEnum();
            int[] nArray = this.termFreqs;
            if (this.termFreqs == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"termFreqs");
                nArray = null;
            }
            int n = nArray[this.ord];
            int[] nArray2 = this.positionIndex;
            if (this.positionIndex == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"positionIndex");
                nArray2 = null;
            }
            int n2 = nArray2[this.ord];
            int[] nArray3 = this.positions;
            if (this.positions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"positions");
                nArray3 = null;
            }
            int[] nArray4 = this.startOffsets;
            if (this.startOffsets == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"startOffsets");
                nArray4 = null;
            }
            int[] nArray5 = this.lengths;
            if (this.lengths == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lengths");
                nArray5 = null;
            }
            BytesRef bytesRef = this.payloads;
            Intrinsics.checkNotNull((Object)bytesRef);
            int[] nArray6 = this.payloadIndex;
            if (this.payloadIndex == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"payloadIndex");
                nArray6 = null;
            }
            docsEnum.reset(n, n2, nArray3, nArray4, nArray5, bytesRef, nArray6);
            return docsEnum;
        }

        @Override
        @NotNull
        public ImpactsEnum impacts(int flags) throws IOException {
            PostingsEnum delegate = this.postings(null, PostingsEnum.Companion.getFREQS());
            return new SlowImpactsEnum(delegate);
        }
    }
}

