/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90.compressing;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.ByteCompanionObject;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.ShortCompanionObject;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.ByteExtKt;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.jdkport.ShortExtKt;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.store.IndexInput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J(\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J(\u0010\u0012\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J&\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0005J(\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J(\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J(\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/StoredFieldsInts;", "", "<init>", "()V", "BLOCK_SIZE", "", "BLOCK_SIZE_MINUS_ONE", "writeInts", "", "values", "", "start", "count", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "writeInts8", "offset", "writeInts16", "writeInts32", "readInts", "in", "Lorg/gnit/lucenekmp/store/IndexInput;", "", "readInts8", "readInts16", "readInts32", "core"})
public final class StoredFieldsInts {
    @NotNull
    public static final StoredFieldsInts INSTANCE = new StoredFieldsInts();
    private static final int BLOCK_SIZE = 128;
    private static final int BLOCK_SIZE_MINUS_ONE = 127;

    private StoredFieldsInts() {
    }

    public final void writeInts(@NotNull int[] values2, int start, int count, @NotNull DataOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        boolean allEqual = true;
        for (int i = 1; i < count; ++i) {
            if (values2[start + i] == values2[start]) continue;
            allEqual = false;
            break;
        }
        if (allEqual) {
            out.writeByte((byte)0);
            out.writeVInt(values2[0]);
        } else {
            long max = 0L;
            for (int i = 0; i < count; ++i) {
                max |= IntExtKt.toUnsignedLong(IntCompanionObject.INSTANCE, values2[start + i]);
            }
            if (max <= 255L) {
                out.writeByte((byte)8);
                this.writeInts8(out, count, values2, start);
            } else if (max <= 65535L) {
                out.writeByte((byte)16);
                this.writeInts16(out, count, values2, start);
            } else {
                out.writeByte((byte)32);
                this.writeInts32(out, count, values2, start);
            }
        }
    }

    private final void writeInts8(DataOutput out, int count, int[] values2, int offset) throws IOException {
        int k;
        for (k = 0; k < count - 127; k += 128) {
            int step = offset + k;
            for (int i = 0; i < 16; ++i) {
                long l = (long)values2[step + i] << 56 | (long)values2[step + 16 + i] << 48 | (long)values2[step + 32 + i] << 40 | (long)values2[step + 48 + i] << 32 | (long)values2[step + 64 + i] << 24 | (long)values2[step + 80 + i] << 16 | (long)values2[step + 96 + i] << 8 | (long)values2[step + 112 + i];
                out.writeLong(l);
            }
        }
        while (k < count) {
            out.writeByte((byte)values2[offset + k]);
            ++k;
        }
    }

    private final void writeInts16(DataOutput out, int count, int[] values2, int offset) throws IOException {
        int k;
        for (k = 0; k < count - 127; k += 128) {
            int step = offset + k;
            for (int i = 0; i < 32; ++i) {
                long l = (long)values2[step + i] << 48 | (long)values2[step + 32 + i] << 32 | (long)values2[step + 64 + i] << 16 | (long)values2[step + 96 + i];
                out.writeLong(l);
            }
        }
        while (k < count) {
            out.writeShort((short)values2[offset + k]);
            ++k;
        }
    }

    private final void writeInts32(DataOutput out, int count, int[] values2, int offset) throws IOException {
        int k;
        for (k = 0; k < count - 127; k += 128) {
            int step = offset + k;
            for (int i = 0; i < 64; ++i) {
                long l = (long)values2[step + i] << 32 | (long)values2[step + 64 + i];
                out.writeLong(l);
            }
        }
        while (k < count) {
            out.writeInt(values2[offset + k]);
            ++k;
        }
    }

    public final void readInts(@NotNull IndexInput in, int count, @NotNull long[] values2, int offset) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        byte bpv = in.readByte();
        switch (bpv) {
            case 0: {
                Arrays.INSTANCE.fill(values2, offset, offset + count, (long)in.readVInt());
                break;
            }
            case 8: {
                this.readInts8(in, count, values2, offset);
                break;
            }
            case 16: {
                this.readInts16(in, count, values2, offset);
                break;
            }
            case 32: {
                this.readInts32(in, count, values2, offset);
                break;
            }
            default: {
                throw new IOException("Unsupported number of bits per value: " + bpv);
            }
        }
    }

    private final void readInts8(IndexInput in, int count, long[] values2, int offset) throws IOException {
        int k;
        for (k = 0; k < count - 127; k += 128) {
            int step = offset + k;
            in.readLongs(values2, step, 16);
            for (int i = 0; i < 16; ++i) {
                long l = values2[step + i];
                values2[step + i] = l >>> 56 & 0xFFL;
                values2[step + 16 + i] = l >>> 48 & 0xFFL;
                values2[step + 32 + i] = l >>> 40 & 0xFFL;
                values2[step + 48 + i] = l >>> 32 & 0xFFL;
                values2[step + 64 + i] = l >>> 24 & 0xFFL;
                values2[step + 80 + i] = l >>> 16 & 0xFFL;
                values2[step + 96 + i] = l >>> 8 & 0xFFL;
                values2[step + 112 + i] = l & 0xFFL;
            }
        }
        while (k < count) {
            values2[offset + k] = ByteExtKt.toUnsignedInt(ByteCompanionObject.INSTANCE, in.readByte());
            ++k;
        }
    }

    private final void readInts16(IndexInput in, int count, long[] values2, int offset) throws IOException {
        int k;
        for (k = 0; k < count - 127; k += 128) {
            int step = offset + k;
            in.readLongs(values2, step, 32);
            for (int i = 0; i < 32; ++i) {
                long l = values2[step + i];
                values2[step + i] = l >>> 48 & 0xFFFFL;
                values2[step + 32 + i] = l >>> 32 & 0xFFFFL;
                values2[step + 64 + i] = l >>> 16 & 0xFFFFL;
                values2[step + 96 + i] = l & 0xFFFFL;
            }
        }
        while (k < count) {
            values2[offset + k] = ShortExtKt.toUnsignedInt(ShortCompanionObject.INSTANCE, in.readShort());
            ++k;
        }
    }

    private final void readInts32(IndexInput in, int count, long[] values2, int offset) throws IOException {
        int k;
        for (k = 0; k < count - 127; k += 128) {
            int step = offset + k;
            in.readLongs(values2, step, 64);
            for (int i = 0; i < 64; ++i) {
                long l = values2[step + i];
                values2[step + i] = l >>> 32;
                values2[step + 64 + i] = l & 0xFFFFFFFFL;
            }
        }
        while (k < count) {
            values2[offset + k] = in.readInt();
            ++k;
        }
    }
}

