/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene94;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.FieldInfosFormat;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.DocValuesSkipIndexType;
import org.gnit.lucenekmp.index.DocValuesType;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.SegmentInfo;
import org.gnit.lucenekmp.index.VectorEncoding;
import org.gnit.lucenekmp.index.VectorSimilarityFunction;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.store.ChecksumIndexInput;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.IndexOutput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene94/Lucene94FieldInfosFormat;", "Lorg/gnit/lucenekmp/codecs/FieldInfosFormat;", "<init>", "()V", "read", "Lorg/gnit/lucenekmp/index/FieldInfos;", "directory", "Lorg/gnit/lucenekmp/store/Directory;", "segmentInfo", "Lorg/gnit/lucenekmp/index/SegmentInfo;", "segmentSuffix", "", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "write", "", "infos", "Companion", "core"})
public final class Lucene94FieldInfosFormat
extends FieldInfosFormat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<VectorSimilarityFunction> SIMILARITY_FUNCTIONS;
    @NotNull
    public static final String EXTENSION = "fnm";
    @NotNull
    public static final String CODEC_NAME = "Lucene94FieldInfos";
    public static final int FORMAT_START = 0;
    public static final int FORMAT_PARENT_FIELD = 1;
    public static final int FORMAT_DOCVALUE_SKIPPER = 2;
    public static final int FORMAT_CURRENT = 2;
    public static final byte STORE_TERMVECTOR = 1;
    public static final byte OMIT_NORMS = 2;
    public static final byte STORE_PAYLOADS = 4;
    public static final byte SOFT_DELETES_FIELD = 8;
    public static final byte PARENT_FIELD_FIELD = 16;
    public static final byte DOCVALUES_SKIPPER = 32;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FieldInfos read(@NotNull Directory directory, @NotNull SegmentInfo segmentInfo, @NotNull String segmentSuffix, @NotNull IOContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)segmentInfo, (String)"segmentInfo");
        Intrinsics.checkNotNullParameter((Object)segmentSuffix, (String)"segmentSuffix");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String fileName = IndexFileNames.INSTANCE.segmentFileName(segmentInfo.getName(), segmentSuffix, EXTENSION);
        AutoCloseable autoCloseable = directory.openChecksumInput(fileName);
        Throwable throwable = null;
        try {
            ChecksumIndexInput input = (ChecksumIndexInput)autoCloseable;
            boolean bl = false;
            Throwable priorE = null;
            FieldInfo[] infos = null;
            try {
                int format = CodecUtil.INSTANCE.checkIndexHeader(input, CODEC_NAME, 0, 2, segmentInfo.getId(), segmentSuffix);
                int size2 = input.readVInt();
                infos = new FieldInfo[size2];
                Map lastAttributes = new LinkedHashMap();
                for (int i = 0; i < size2; ++i) {
                    boolean isParentField;
                    boolean isSoftDeletesField;
                    String name = input.readString();
                    int fieldNumber = input.readVInt();
                    if (fieldNumber < 0) {
                        throw new CorruptIndexException("invalid field number for field: " + name + ", fieldNumber=" + fieldNumber, input);
                    }
                    byte bits = input.readByte();
                    boolean storeTermVector = (bits & 1) != 0;
                    boolean omitNorms = (bits & 2) != 0;
                    boolean storePayloads = (bits & 4) != 0;
                    boolean bl2 = isSoftDeletesField = (bits & 8) != 0;
                    boolean bl3 = format >= 1 ? (bits & 0x10) != 0 : (isParentField = false);
                    if ((bits & 0xC0) != 0) {
                        throw new CorruptIndexException("unused bits are set \"" + IntExtKt.toBinaryString(IntCompanionObject.INSTANCE, bits) + "\"", input);
                    }
                    if (format < 1 && (bits & 0xF0) != 0) {
                        throw new CorruptIndexException("parent field bit is set but shouldn't \"" + IntExtKt.toBinaryString(IntCompanionObject.INSTANCE, bits) + "\"", input);
                    }
                    if (format < 2 && (bits & 0x20) != 0) {
                        throw new CorruptIndexException("doc values skipper bit is set but shouldn't \"" + IntExtKt.toBinaryString(IntCompanionObject.INSTANCE, bits) + "\"", input);
                    }
                    IndexOptions indexOptions = Lucene94FieldInfosFormat.Companion.getIndexOptions(input, input.readByte());
                    DocValuesType docValuesType = Lucene94FieldInfosFormat.Companion.getDocValuesType(input, input.readByte());
                    DocValuesSkipIndexType docValuesSkipIndex = format >= 2 ? Lucene94FieldInfosFormat.Companion.getDocValuesSkipIndexType(input, input.readByte()) : DocValuesSkipIndexType.NONE;
                    long dvGen = input.readLong();
                    Map attributes = input.readMapOfStrings();
                    if (Intrinsics.areEqual(attributes, (Object)lastAttributes)) {
                        attributes = lastAttributes;
                    }
                    lastAttributes = attributes;
                    int pointDataDimensionCount = input.readVInt();
                    int pointNumBytes = 0;
                    int pointIndexDimensionCount = pointDataDimensionCount;
                    if (pointDataDimensionCount != 0) {
                        pointIndexDimensionCount = input.readVInt();
                        pointNumBytes = input.readVInt();
                    } else {
                        pointNumBytes = 0;
                    }
                    int vectorDimension = input.readVInt();
                    VectorEncoding vectorEncoding = Lucene94FieldInfosFormat.Companion.getVectorEncoding(input, input.readByte());
                    VectorSimilarityFunction vectorDistFunc = Lucene94FieldInfosFormat.Companion.getDistFunc(input, input.readByte());
                    try {
                        infos[i] = new FieldInfo(name, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, docValuesType, docValuesSkipIndex, dvGen, attributes, pointDataDimensionCount, pointIndexDimensionCount, pointNumBytes, vectorDimension, vectorEncoding, vectorDistFunc, isSoftDeletesField, isParentField);
                        FieldInfo fieldInfo = infos[i];
                        Intrinsics.checkNotNull((Object)fieldInfo);
                        fieldInfo.checkConsistency();
                        continue;
                    }
                    catch (IllegalStateException e) {
                        throw new CorruptIndexException("invalid fieldinfo for field: " + name + ", fieldNumber=" + fieldNumber, input, (Throwable)e);
                    }
                }
            }
            catch (Throwable exception) {
                priorE = exception;
            }
            finally {
                CodecUtil.INSTANCE.checkFooter(input, priorE);
            }
            FieldInfos fieldInfos = new FieldInfos(infos);
            return fieldInfos;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull Directory directory, @NotNull SegmentInfo segmentInfo, @NotNull String segmentSuffix, @NotNull FieldInfos infos, @NotNull IOContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)segmentInfo, (String)"segmentInfo");
        Intrinsics.checkNotNullParameter((Object)segmentSuffix, (String)"segmentSuffix");
        Intrinsics.checkNotNullParameter((Object)infos, (String)"infos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String fileName = IndexFileNames.INSTANCE.segmentFileName(segmentInfo.getName(), segmentSuffix, EXTENSION);
        AutoCloseable autoCloseable = directory.createOutput(fileName, context);
        Throwable throwable = null;
        try {
            IndexOutput output = (IndexOutput)autoCloseable;
            boolean bl = false;
            CodecUtil.INSTANCE.writeIndexHeader(output, CODEC_NAME, 2, segmentInfo.getId(), segmentSuffix);
            output.writeVInt(infos.size());
            for (FieldInfo fi : infos) {
                fi.checkConsistency();
                output.writeString(fi.getName());
                output.writeVInt(fi.getNumber());
                byte bits = 0;
                if (fi.hasTermVectors()) {
                    bits = (byte)(bits | 1);
                }
                if (fi.omitsNorms()) {
                    bits = (byte)(bits | 2);
                }
                if (fi.hasPayloads()) {
                    bits = (byte)(bits | 4);
                }
                if (fi.isSoftDeletesField()) {
                    bits = (byte)(bits | 8);
                }
                if (fi.isParentField()) {
                    bits = (byte)(bits | 0x10);
                }
                output.writeByte(bits);
                output.writeByte(Lucene94FieldInfosFormat.Companion.indexOptionsByte(fi.getIndexOptions()));
                output.writeByte(Lucene94FieldInfosFormat.Companion.docValuesByte(fi.getDocValuesType()));
                output.writeByte(Lucene94FieldInfosFormat.Companion.docValuesSkipIndexByte(fi.docValuesSkipIndexType()));
                output.writeLong(fi.getDocValuesGen());
                output.writeMapOfStrings(fi.attributes());
                output.writeVInt(fi.getPointDimensionCount());
                if (fi.getPointDimensionCount() != 0) {
                    output.writeVInt(fi.getPointIndexDimensionCount());
                    output.writeVInt(fi.getPointNumBytes());
                }
                output.writeVInt(fi.getVectorDimension());
                output.writeByte((byte)fi.getVectorEncoding().ordinal());
                output.writeByte(Companion.distFuncToOrd(fi.getVectorSimilarityFunction()));
            }
            CodecUtil.INSTANCE.writeFooter(output);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    static {
        if (!(DocValuesType.getEntries().size() == 6)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        VectorSimilarityFunction[] vectorSimilarityFunctionArray = new VectorSimilarityFunction[]{VectorSimilarityFunction.EUCLIDEAN, VectorSimilarityFunction.DOT_PRODUCT, VectorSimilarityFunction.COSINE, VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT};
        SIMILARITY_FUNCTIONS = CollectionsKt.mutableListOf((Object[])vectorSimilarityFunctionArray);
        if (!(IndexOptions.getEntries().size() == 5)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0005J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0012J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u001f\u001a\u00020 X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020#X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020#X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020#X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene94/Lucene94FieldInfosFormat$Companion;", "", "<init>", "()V", "docValuesByte", "", "type", "Lorg/gnit/lucenekmp/index/DocValuesType;", "docValuesSkipIndexByte", "Lorg/gnit/lucenekmp/index/DocValuesSkipIndexType;", "getDocValuesType", "input", "Lorg/gnit/lucenekmp/store/IndexInput;", "b", "getDocValuesSkipIndexType", "getVectorEncoding", "Lorg/gnit/lucenekmp/index/VectorEncoding;", "getDistFunc", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "SIMILARITY_FUNCTIONS", "", "getSIMILARITY_FUNCTIONS", "()Ljava/util/List;", "distOrdToFunc", "i", "distFuncToOrd", "func", "indexOptionsByte", "indexOptions", "Lorg/gnit/lucenekmp/index/IndexOptions;", "getIndexOptions", "EXTENSION", "", "CODEC_NAME", "FORMAT_START", "", "FORMAT_PARENT_FIELD", "FORMAT_DOCVALUE_SKIPPER", "FORMAT_CURRENT", "STORE_TERMVECTOR", "OMIT_NORMS", "STORE_PAYLOADS", "SOFT_DELETES_FIELD", "PARENT_FIELD_FIELD", "DOCVALUES_SKIPPER", "core"})
    @SourceDebugExtension(value={"SMAP\nLucene94FieldInfosFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene94FieldInfosFormat.kt\norg/gnit/lucenekmp/codecs/lucene94/Lucene94FieldInfosFormat$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,436:1\n1#2:437\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final byte docValuesByte(DocValuesType type) {
            return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1 -> 0;
                case 2 -> 1;
                case 3 -> 2;
                case 4 -> 3;
                case 5 -> 4;
                case 6 -> 5;
                default -> throw new AssertionError((Object)("unhandled DocValuesType: " + type));
            };
        }

        private final byte docValuesSkipIndexByte(DocValuesSkipIndexType type) {
            return switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
                case 1 -> 0;
                case 2 -> 1;
                default -> throw new AssertionError((Object)("unhandled DocValuesSkipIndexType: " + type));
            };
        }

        private final DocValuesType getDocValuesType(IndexInput input, byte b) throws IOException {
            DocValuesType docValuesType;
            byte by = b;
            if (by == 0) {
                docValuesType = DocValuesType.NONE;
            } else if (by == 1) {
                docValuesType = DocValuesType.NUMERIC;
            } else if (by == 2) {
                docValuesType = DocValuesType.BINARY;
            } else if (by == 3) {
                docValuesType = DocValuesType.SORTED;
            } else if (by == 4) {
                docValuesType = DocValuesType.SORTED_SET;
            } else if (by == 5) {
                docValuesType = DocValuesType.SORTED_NUMERIC;
            } else {
                throw new CorruptIndexException("invalid docvalues byte: " + b, input);
            }
            return docValuesType;
        }

        private final DocValuesSkipIndexType getDocValuesSkipIndexType(IndexInput input, byte b) throws IOException {
            DocValuesSkipIndexType docValuesSkipIndexType;
            byte by = b;
            if (by == 0) {
                docValuesSkipIndexType = DocValuesSkipIndexType.NONE;
            } else if (by == 1) {
                docValuesSkipIndexType = DocValuesSkipIndexType.RANGE;
            } else {
                throw new CorruptIndexException("invalid docvaluesskipindex byte: " + b, input);
            }
            return docValuesSkipIndexType;
        }

        private final VectorEncoding getVectorEncoding(IndexInput input, byte b) throws IOException {
            if (b < 0 || b >= VectorEncoding.getEntries().size()) {
                throw new CorruptIndexException("invalid vector encoding: " + b, input);
            }
            return (VectorEncoding)((Object)VectorEncoding.getEntries().get((int)b));
        }

        private final VectorSimilarityFunction getDistFunc(IndexInput input, byte b) throws IOException {
            try {
                return this.distOrdToFunc(b);
            }
            catch (IllegalArgumentException e) {
                throw new CorruptIndexException("invalid distance function: " + b, input, (Throwable)e);
            }
        }

        @NotNull
        public final List<VectorSimilarityFunction> getSIMILARITY_FUNCTIONS() {
            return SIMILARITY_FUNCTIONS;
        }

        @NotNull
        public final VectorSimilarityFunction distOrdToFunc(byte i) {
            if (!(i >= 0 && i < this.getSIMILARITY_FUNCTIONS().size())) {
                boolean bl = false;
                String string = "invalid distance function: " + i;
                throw new IllegalArgumentException(string.toString());
            }
            return this.getSIMILARITY_FUNCTIONS().get(i);
        }

        public final byte distFuncToOrd(@NotNull VectorSimilarityFunction func) {
            Intrinsics.checkNotNullParameter((Object)((Object)func), (String)"func");
            int n = ((Collection)this.getSIMILARITY_FUNCTIONS()).size();
            for (int i = 0; i < n; ++i) {
                if (this.getSIMILARITY_FUNCTIONS().get(i) != func) continue;
                return (byte)i;
            }
            throw new IllegalArgumentException("invalid distance function: " + func);
        }

        private final byte indexOptionsByte(IndexOptions indexOptions) {
            return switch (WhenMappings.$EnumSwitchMapping$2[indexOptions.ordinal()]) {
                case 1 -> 0;
                case 2 -> 1;
                case 3 -> 2;
                case 4 -> 3;
                case 5 -> 4;
                default -> throw new AssertionError((Object)("unhandled IndexOptions: " + indexOptions));
            };
        }

        private final IndexOptions getIndexOptions(IndexInput input, byte b) throws IOException {
            IndexOptions indexOptions;
            byte by = b;
            if (by == 0) {
                indexOptions = IndexOptions.NONE;
            } else if (by == 1) {
                indexOptions = IndexOptions.DOCS;
            } else if (by == 2) {
                indexOptions = IndexOptions.DOCS_AND_FREQS;
            } else if (by == 3) {
                indexOptions = IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
            } else if (by == 4) {
                indexOptions = IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
            } else {
                throw new CorruptIndexException("invalid IndexOptions byte: " + b, input);
            }
            return indexOptions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;
            public static final /* synthetic */ int[] $EnumSwitchMapping$2;

            static {
                int[] nArray = new int[DocValuesType.values().length];
                try {
                    nArray[DocValuesType.NONE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DocValuesType.NUMERIC.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DocValuesType.BINARY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DocValuesType.SORTED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DocValuesType.SORTED_SET.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DocValuesType.SORTED_NUMERIC.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[DocValuesSkipIndexType.values().length];
                try {
                    nArray[DocValuesSkipIndexType.NONE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DocValuesSkipIndexType.RANGE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
                nArray = new int[IndexOptions.values().length];
                try {
                    nArray[IndexOptions.NONE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IndexOptions.DOCS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IndexOptions.DOCS_AND_FREQS.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IndexOptions.DOCS_AND_FREQS_AND_POSITIONS.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$2 = nArray;
            }
        }
    }
}

