/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene99;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.KnnVectorsWriter;
import org.gnit.lucenekmp.codecs.hnsw.FlatFieldVectorsWriter;
import org.gnit.lucenekmp.codecs.hnsw.FlatVectorsScorer;
import org.gnit.lucenekmp.codecs.hnsw.FlatVectorsWriter;
import org.gnit.lucenekmp.codecs.lucene95.OffHeapByteVectorValues;
import org.gnit.lucenekmp.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.gnit.lucenekmp.index.ByteVectorValues;
import org.gnit.lucenekmp.index.DocsWithFieldSet;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FloatVectorValues;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.KnnVectorValues;
import org.gnit.lucenekmp.index.MergeState;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.index.Sorter;
import org.gnit.lucenekmp.index.VectorEncoding;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.jdkport.ByteOrder;
import org.gnit.lucenekmp.jdkport.FloatBuffer;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.store.ReadAdvice;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.hnsw.CloseableRandomVectorScorerSupplier;
import org.gnit.lucenekmp.util.hnsw.RandomVectorScorerSupplier;
import org.gnit.lucenekmp.util.hnsw.UpdateableRandomVectorScorer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 52\u00020\u0001:\u0003345B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u001c\u0010\u001e\u001a\u00020\u00162\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0014\u0010 \u001a\u00020\u00162\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u0014\u0010!\u001a\u00020\u00162\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J$\u0010\"\u001a\u00020\u00162\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010#\u001a\u00020\u001d2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010$\u001a\u00020%H\u0002J\u001c\u0010&\u001a\u00020\u001d2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010'\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)H\u0016J0\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u00020\u0016H\u0016R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99FlatVectorsWriter;", "Lorg/gnit/lucenekmp/codecs/hnsw/FlatVectorsWriter;", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "scorer", "Lorg/gnit/lucenekmp/codecs/hnsw/FlatVectorsScorer;", "<init>", "(Lorg/gnit/lucenekmp/index/SegmentWriteState;Lorg/gnit/lucenekmp/codecs/hnsw/FlatVectorsScorer;)V", "segmentWriteState", "meta", "Lorg/gnit/lucenekmp/store/IndexOutput;", "vectorData", "fields", "", "Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99FlatVectorsWriter$FieldWriter;", "finished", "", "addField", "Lorg/gnit/lucenekmp/codecs/hnsw/FlatFieldVectorsWriter;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "flush", "", "maxDoc", "", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "finish", "ramBytesUsed", "", "writeField", "fieldData", "writeFloat32Vectors", "writeByteVectors", "writeSortingField", "writeSortedFloat32Vectors", "ordMap", "", "writeSortedByteVectors", "mergeOneField", "mergeState", "Lorg/gnit/lucenekmp/index/MergeState;", "mergeOneFieldToIndex", "Lorg/gnit/lucenekmp/util/hnsw/CloseableRandomVectorScorerSupplier;", "writeMeta", "field", "vectorDataOffset", "vectorDataLength", "docsWithField", "Lorg/gnit/lucenekmp/index/DocsWithFieldSet;", "close", "FieldWriter", "FlatCloseableRandomVectorScorerSupplier", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLucene99FlatVectorsWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene99FlatVectorsWriter.kt\norg/gnit/lucenekmp/codecs/lucene99/Lucene99FlatVectorsWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,498:1\n1#2:499\n*E\n"})
public final class Lucene99FlatVectorsWriter
extends FlatVectorsWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SegmentWriteState segmentWriteState;
    @Nullable
    private final IndexOutput meta;
    @Nullable
    private final IndexOutput vectorData;
    @NotNull
    private final List<FieldWriter<?>> fields;
    private boolean finished;
    private static final long SHALLLOW_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(Lucene99FlatVectorsWriter.class));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lucene99FlatVectorsWriter(@NotNull SegmentWriteState state2, @NotNull FlatVectorsScorer scorer2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
        super(scorer2);
        this.segmentWriteState = state2;
        this.fields = new ArrayList();
        String metaFileName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), "vemf");
        String vectorDataFileName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), "vec");
        boolean success = false;
        try {
            this.meta = state2.getDirectory().createOutput(metaFileName, state2.getContext());
            this.vectorData = state2.getDirectory().createOutput(vectorDataFileName, state2.getContext());
            CodecUtil.INSTANCE.writeIndexHeader(this.meta, "Lucene99FlatVectorsFormatMeta", 0, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
            CodecUtil.INSTANCE.writeIndexHeader(this.vectorData, "Lucene99FlatVectorsFormatData", 0, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
            success = true;
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this};
            IOUtils.INSTANCE.closeWhileHandlingException(autoCloseableArray);
            throw throwable;
        }
    }

    @Override
    @NotNull
    public FlatFieldVectorsWriter<?> addField(@NotNull FieldInfo fieldInfo) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        FieldWriter<?> newField = FieldWriter.Companion.create(fieldInfo);
        this.fields.add(newField);
        return newField;
    }

    @Override
    public void flush(int maxDoc, @Nullable Sorter.DocMap sortMap) throws IOException {
        for (FieldWriter<?> field : this.fields) {
            if (sortMap == null) {
                this.writeField(field, maxDoc);
            } else {
                this.writeSortingField(field, maxDoc, sortMap);
            }
            field.finish();
        }
    }

    @Override
    public void finish() throws IOException {
        if (!(!this.finished)) {
            boolean bl = false;
            String string = "already finished";
            throw new IllegalStateException(string.toString());
        }
        this.finished = true;
        if (this.meta != null) {
            this.meta.writeInt(-1);
            CodecUtil.INSTANCE.writeFooter(this.meta);
        }
        if (this.vectorData != null) {
            CodecUtil.INSTANCE.writeFooter(this.vectorData);
        }
    }

    @Override
    public long ramBytesUsed() {
        long total = SHALLLOW_RAM_BYTES_USED;
        for (FieldWriter<?> field : this.fields) {
            total += field.ramBytesUsed();
        }
        return total;
    }

    private final void writeField(FieldWriter<?> fieldData, int maxDoc) throws IOException {
        IndexOutput indexOutput = this.vectorData;
        Intrinsics.checkNotNull((Object)indexOutput);
        long vectorDataOffset = indexOutput.alignFilePointer(4);
        switch (WhenMappings.$EnumSwitchMapping$0[fieldData.getFieldInfo().getVectorEncoding().ordinal()]) {
            case 1: {
                this.writeByteVectors(fieldData);
                break;
            }
            case 2: {
                this.writeFloat32Vectors(fieldData);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
        this.writeMeta(fieldData.getFieldInfo(), maxDoc, vectorDataOffset, vectorDataLength, fieldData.getDocsWithField());
    }

    private final void writeFloat32Vectors(FieldWriter<?> fieldData) throws IOException {
        ByteBuffer buffer = ByteBuffer.Companion.allocate(fieldData.getDim() * 4).order(ByteOrder.Companion.getLITTLE_ENDIAN());
        for (Object v : fieldData.getVectors()) {
            FloatBuffer floatBuffer = buffer.asFloatBuffer();
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.FloatArray");
            floatBuffer.put((float[])v);
            IndexOutput indexOutput = this.vectorData;
            Intrinsics.checkNotNull((Object)indexOutput);
            indexOutput.writeBytes(buffer.array(), buffer.array().length);
        }
    }

    private final void writeByteVectors(FieldWriter<?> fieldData) throws IOException {
        for (Object v : fieldData.getVectors()) {
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.ByteArray");
            byte[] vector = (byte[])v;
            IndexOutput indexOutput = this.vectorData;
            Intrinsics.checkNotNull((Object)indexOutput);
            indexOutput.writeBytes(vector, vector.length);
        }
    }

    private final void writeSortingField(FieldWriter<?> fieldData, int maxDoc, Sorter.DocMap sortMap) throws IOException {
        int[] ordMap = new int[fieldData.getDocsWithField().cardinality()];
        DocsWithFieldSet newDocsWithField = new DocsWithFieldSet();
        KnnVectorsWriter.Companion.mapOldOrdToNewOrd(fieldData.getDocsWithField(), sortMap, null, ordMap, newDocsWithField);
        long vectorDataOffset = switch (WhenMappings.$EnumSwitchMapping$0[fieldData.getFieldInfo().getVectorEncoding().ordinal()]) {
            case 1 -> this.writeSortedByteVectors(fieldData, ordMap);
            case 2 -> this.writeSortedFloat32Vectors(fieldData, ordMap);
            default -> throw new NoWhenBranchMatchedException();
        };
        IndexOutput indexOutput = this.vectorData;
        Intrinsics.checkNotNull((Object)indexOutput);
        long vectorDataLength = indexOutput.getFilePointer() - vectorDataOffset;
        this.writeMeta(fieldData.getFieldInfo(), maxDoc, vectorDataOffset, vectorDataLength, newDocsWithField);
    }

    private final long writeSortedFloat32Vectors(FieldWriter<?> fieldData, int[] ordMap) throws IOException {
        IndexOutput indexOutput = this.vectorData;
        Intrinsics.checkNotNull((Object)indexOutput);
        long vectorDataOffset = indexOutput.alignFilePointer(4);
        ByteBuffer buffer = ByteBuffer.Companion.allocate(fieldData.getDim() * 4).order(ByteOrder.Companion.getLITTLE_ENDIAN());
        for (int ordinal : ordMap) {
            Object obj = fieldData.getVectors().get(ordinal);
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.FloatArray");
            float[] vector = (float[])obj;
            buffer.asFloatBuffer().put(vector);
            this.vectorData.writeBytes(buffer.array(), buffer.array().length);
        }
        return vectorDataOffset;
    }

    private final long writeSortedByteVectors(FieldWriter<?> fieldData, int[] ordMap) throws IOException {
        IndexOutput indexOutput = this.vectorData;
        Intrinsics.checkNotNull((Object)indexOutput);
        long vectorDataOffset = indexOutput.alignFilePointer(4);
        for (int ordinal : ordMap) {
            Object obj = fieldData.getVectors().get(ordinal);
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.ByteArray");
            byte[] vector = (byte[])obj;
            this.vectorData.writeBytes(vector, vector.length);
        }
        return vectorDataOffset;
    }

    @Override
    public void mergeOneField(@NotNull FieldInfo fieldInfo, @NotNull MergeState mergeState) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
        IndexOutput indexOutput = this.vectorData;
        Intrinsics.checkNotNull((Object)indexOutput);
        long vectorDataOffset = indexOutput.alignFilePointer(4);
        DocsWithFieldSet docsWithField = switch (WhenMappings.$EnumSwitchMapping$0[fieldInfo.getVectorEncoding().ordinal()]) {
            case 1 -> Lucene99FlatVectorsWriter.Companion.writeByteVectorData(this.vectorData, KnnVectorsWriter.MergedVectorValues.INSTANCE.mergeByteVectorValues(fieldInfo, mergeState));
            case 2 -> Lucene99FlatVectorsWriter.Companion.writeVectorData(this.vectorData, KnnVectorsWriter.MergedVectorValues.INSTANCE.mergeFloatVectorValues(fieldInfo, mergeState));
            default -> throw new NoWhenBranchMatchedException();
        };
        long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
        this.writeMeta(fieldInfo, this.segmentWriteState.getSegmentInfo().maxDoc(), vectorDataOffset, vectorDataLength, docsWithField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CloseableRandomVectorScorerSupplier mergeOneFieldToIndex(@NotNull FieldInfo fieldInfo, @NotNull MergeState mergeState) throws IOException {
        CloseableRandomVectorScorerSupplier closeableRandomVectorScorerSupplier;
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
        IndexOutput indexOutput = this.vectorData;
        Intrinsics.checkNotNull((Object)indexOutput);
        long vectorDataOffset = indexOutput.alignFilePointer(4);
        IndexOutput tempVectorData = this.segmentWriteState.getDirectory().createTempOutput(this.vectorData.getName(), "temp", this.segmentWriteState.getContext());
        IndexInput vectorDataInput = null;
        boolean success = false;
        try {
            DocsWithFieldSet docsWithField = switch (WhenMappings.$EnumSwitchMapping$0[fieldInfo.getVectorEncoding().ordinal()]) {
                case 1 -> Lucene99FlatVectorsWriter.Companion.writeByteVectorData(tempVectorData, KnnVectorsWriter.MergedVectorValues.INSTANCE.mergeByteVectorValues(fieldInfo, mergeState));
                case 2 -> Lucene99FlatVectorsWriter.Companion.writeVectorData(tempVectorData, KnnVectorsWriter.MergedVectorValues.INSTANCE.mergeFloatVectorValues(fieldInfo, mergeState));
                default -> throw new NoWhenBranchMatchedException();
            };
            CodecUtil.INSTANCE.writeFooter(tempVectorData);
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{tempVectorData};
            IOUtils.INSTANCE.close(autoCloseableArray);
            vectorDataInput = this.segmentWriteState.getDirectory().openInput(tempVectorData.getName(), IOContext.Companion.getDEFAULT().withReadAdvice(ReadAdvice.RANDOM));
            this.vectorData.copyBytes(vectorDataInput, vectorDataInput.length() - (long)CodecUtil.INSTANCE.footerLength());
            CodecUtil.INSTANCE.retrieveChecksum(vectorDataInput);
            long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
            this.writeMeta(fieldInfo, this.segmentWriteState.getSegmentInfo().maxDoc(), vectorDataOffset, vectorDataLength, docsWithField);
            success = true;
            IndexInput finalVectorDataInput = vectorDataInput;
            RandomVectorScorerSupplier randomVectorScorerSupplier = switch (WhenMappings.$EnumSwitchMapping$0[fieldInfo.getVectorEncoding().ordinal()]) {
                case 1 -> this.getVectorScorer().getRandomVectorScorerSupplier(fieldInfo.getVectorSimilarityFunction(), new OffHeapByteVectorValues.DenseOffHeapVectorValues(fieldInfo.getVectorDimension(), docsWithField.cardinality(), finalVectorDataInput, fieldInfo.getVectorDimension() * 1, this.getVectorScorer(), fieldInfo.getVectorSimilarityFunction()));
                case 2 -> this.getVectorScorer().getRandomVectorScorerSupplier(fieldInfo.getVectorSimilarityFunction(), new OffHeapByteVectorValues.DenseOffHeapVectorValues(fieldInfo.getVectorDimension(), docsWithField.cardinality(), finalVectorDataInput, fieldInfo.getVectorDimension() * 4, this.getVectorScorer(), fieldInfo.getVectorSimilarityFunction()));
                default -> throw new NoWhenBranchMatchedException();
            };
            closeableRandomVectorScorerSupplier = new FlatCloseableRandomVectorScorerSupplier(() -> Lucene99FlatVectorsWriter.mergeOneFieldToIndex$lambda$1(finalVectorDataInput, this, tempVectorData), docsWithField.cardinality(), randomVectorScorerSupplier);
        }
        catch (Throwable throwable) {
            if (!success) {
                Object[] objectArray = new AutoCloseable[2];
                Intrinsics.checkNotNull(vectorDataInput);
                objectArray[1] = tempVectorData;
                IOUtils.INSTANCE.closeWhileHandlingException((AutoCloseable[])objectArray);
                objectArray = new String[]{tempVectorData.getName()};
                IOUtils.INSTANCE.deleteFilesIgnoringExceptions(this.segmentWriteState.getDirectory(), (String[])objectArray);
            }
            throw throwable;
        }
        return closeableRandomVectorScorerSupplier;
    }

    private final void writeMeta(FieldInfo field, int maxDoc, long vectorDataOffset, long vectorDataLength, DocsWithFieldSet docsWithField) throws IOException {
        IndexOutput indexOutput = this.meta;
        Intrinsics.checkNotNull((Object)indexOutput);
        indexOutput.writeInt(field.getNumber());
        this.meta.writeInt(field.getVectorEncoding().ordinal());
        this.meta.writeInt(field.getVectorSimilarityFunction().ordinal());
        this.meta.writeVLong(vectorDataOffset);
        this.meta.writeVLong(vectorDataLength);
        this.meta.writeVInt(field.getVectorDimension());
        int count = docsWithField.cardinality();
        this.meta.writeInt(count);
        IndexOutput indexOutput2 = this.vectorData;
        Intrinsics.checkNotNull((Object)indexOutput2);
        OrdToDocDISIReaderConfiguration.Companion.writeStoredMeta(16, this.meta, indexOutput2, count, maxDoc, docsWithField);
    }

    @Override
    public void close() throws IOException {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
        Intrinsics.checkNotNull((Object)this.meta);
        Intrinsics.checkNotNull((Object)this.vectorData);
        IOUtils.INSTANCE.close(autoCloseableArray);
    }

    private static final void mergeOneFieldToIndex$lambda$1(IndexInput $finalVectorDataInput, Lucene99FlatVectorsWriter this$0, IndexOutput $tempVectorData) {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[]{$finalVectorDataInput};
        IOUtils.INSTANCE.close(autoCloseableArray);
        this$0.segmentWriteState.getDirectory().deleteFile($tempVectorData.getName());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99FlatVectorsWriter$Companion;", "", "<init>", "()V", "SHALLLOW_RAM_BYTES_USED", "", "writeByteVectorData", "Lorg/gnit/lucenekmp/index/DocsWithFieldSet;", "output", "Lorg/gnit/lucenekmp/store/IndexOutput;", "byteVectorValues", "Lorg/gnit/lucenekmp/index/ByteVectorValues;", "writeVectorData", "floatVectorValues", "Lorg/gnit/lucenekmp/index/FloatVectorValues;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final DocsWithFieldSet writeByteVectorData(IndexOutput output, ByteVectorValues byteVectorValues) throws IOException {
            DocsWithFieldSet docsWithField = new DocsWithFieldSet();
            KnnVectorValues.DocIndexIterator iter = byteVectorValues.iterator();
            int docV = iter.nextDoc();
            while (docV != Integer.MAX_VALUE) {
                byte[] binaryValue = byteVectorValues.vectorValue(iter.index());
                if (!(binaryValue.length == byteVectorValues.dimension() * VectorEncoding.BYTE.getByteSize())) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                output.writeBytes(binaryValue, binaryValue.length);
                docsWithField.add(docV);
                docV = iter.nextDoc();
            }
            return docsWithField;
        }

        private final DocsWithFieldSet writeVectorData(IndexOutput output, FloatVectorValues floatVectorValues) throws IOException {
            DocsWithFieldSet docsWithField = new DocsWithFieldSet();
            ByteBuffer buffer = ByteBuffer.Companion.allocate(floatVectorValues.dimension() * VectorEncoding.FLOAT32.getByteSize()).order(ByteOrder.Companion.getLITTLE_ENDIAN());
            KnnVectorValues.DocIndexIterator iter = floatVectorValues.iterator();
            int docV = iter.nextDoc();
            while (docV != Integer.MAX_VALUE) {
                float[] value = floatVectorValues.vectorValue(iter.index());
                buffer.asFloatBuffer().put(value);
                output.writeBytes(buffer.array(), buffer.array().length);
                docsWithField.add(docV);
                docV = iter.nextDoc();
            }
            return docsWithField;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\b\"\u0018\u0000 $*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001$B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010#\u001a\u00020\u001bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0010\u00a8\u0006%"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99FlatVectorsWriter$FieldWriter;", "T", "Lorg/gnit/lucenekmp/codecs/hnsw/FlatFieldVectorsWriter;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "<init>", "(Lorg/gnit/lucenekmp/index/FieldInfo;)V", "getFieldInfo", "()Lorg/gnit/lucenekmp/index/FieldInfo;", "dim", "", "getDim", "()I", "docsWithField", "Lorg/gnit/lucenekmp/index/DocsWithFieldSet;", "getDocsWithField", "()Lorg/gnit/lucenekmp/index/DocsWithFieldSet;", "vectors", "", "getVectors", "()Ljava/util/List;", "value", "", "isFinished", "()Z", "lastDocID", "addValue", "", "docID", "vectorValue", "(ILjava/lang/Object;)V", "ramBytesUsed", "", "docsWithFieldSet", "getDocsWithFieldSet", "finish", "Companion", "core"})
    @SourceDebugExtension(value={"SMAP\nLucene99FlatVectorsWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene99FlatVectorsWriter.kt\norg/gnit/lucenekmp/codecs/lucene99/Lucene99FlatVectorsWriter$FieldWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,498:1\n1#2:499\n*E\n"})
    private static abstract class FieldWriter<T>
    extends FlatFieldVectorsWriter<T> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final FieldInfo fieldInfo;
        private final int dim;
        @NotNull
        private final DocsWithFieldSet docsWithField;
        @NotNull
        private final List<T> vectors;
        private boolean isFinished;
        private int lastDocID;
        private static final long SHALLOW_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(FieldWriter.class));

        public FieldWriter(@NotNull FieldInfo fieldInfo) {
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            this.fieldInfo = fieldInfo;
            this.dim = this.fieldInfo.getVectorDimension();
            this.docsWithField = new DocsWithFieldSet();
            this.vectors = new ArrayList();
            this.lastDocID = -1;
        }

        @NotNull
        public final FieldInfo getFieldInfo() {
            return this.fieldInfo;
        }

        public final int getDim() {
            return this.dim;
        }

        @NotNull
        public final DocsWithFieldSet getDocsWithField() {
            return this.docsWithField;
        }

        @Override
        @NotNull
        public List<T> getVectors() {
            return this.vectors;
        }

        @Override
        public final boolean isFinished() {
            return this.isFinished;
        }

        @Override
        public void addValue(int docID, T vectorValue) throws IOException {
            if (!(!this.isFinished)) {
                boolean $i$a$-check-Lucene99FlatVectorsWriter$FieldWriter$addValue$22 = false;
                String $i$a$-check-Lucene99FlatVectorsWriter$FieldWriter$addValue$22 = "already finished, cannot add more values";
                throw new IllegalStateException($i$a$-check-Lucene99FlatVectorsWriter$FieldWriter$addValue$22.toString());
            }
            if (!(docID != this.lastDocID)) {
                boolean bl = false;
                String string = "VectorValuesField \"" + this.fieldInfo.getName() + "\" appears more than once in this document (only one value is allowed per field)";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(docID > this.lastDocID)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            T copy = this.copyValue(vectorValue);
            this.docsWithField.add(docID);
            this.getVectors().add(copy);
            this.lastDocID = docID;
        }

        @Override
        public long ramBytesUsed() {
            long size2 = SHALLOW_RAM_BYTES_USED;
            if (this.getVectors().isEmpty()) {
                return size2;
            }
            return size2 + this.docsWithField.ramBytesUsed() + (long)this.getVectors().size() * (long)12 + (long)this.getVectors().size() * (long)this.fieldInfo.getVectorDimension() * (long)this.fieldInfo.getVectorEncoding().getByteSize();
        }

        @Override
        @NotNull
        public DocsWithFieldSet getDocsWithFieldSet() {
            return this.docsWithField;
        }

        @Override
        public void finish() throws IOException {
            if (this.isFinished) {
                return;
            }
            this.isFinished = true;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99FlatVectorsWriter$FieldWriter$Companion;", "", "<init>", "()V", "SHALLOW_RAM_BYTES_USED", "", "create", "Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99FlatVectorsWriter$FieldWriter;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final FieldWriter<?> create(@NotNull FieldInfo fieldInfo) {
                Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
                int dim = fieldInfo.getVectorDimension();
                return switch (WhenMappings.$EnumSwitchMapping$0[fieldInfo.getVectorEncoding().ordinal()]) {
                    case 1 -> new FieldWriter<byte[]>(fieldInfo, dim){
                        final /* synthetic */ int $dim;
                        {
                            this.$dim = $dim;
                            super($fieldInfo);
                        }

                        public byte[] copyValue(byte[] value) {
                            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                            return ArrayUtil.Companion.copyOfSubArray(value, 0, this.$dim);
                        }
                    };
                    case 2 -> new FieldWriter<float[]>(fieldInfo, dim){
                        final /* synthetic */ int $dim;
                        {
                            this.$dim = $dim;
                            super($fieldInfo);
                        }

                        public float[] copyValue(float[] value) {
                            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                            return ArrayUtil.Companion.copyOfSubArray(value, 0, this.$dim);
                        }
                    };
                    default -> throw new NoWhenBranchMatchedException();
                };
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[VectorEncoding.values().length];
                    try {
                        nArray[VectorEncoding.BYTE.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[VectorEncoding.FLOAT32.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0016R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99FlatVectorsWriter$FlatCloseableRandomVectorScorerSupplier;", "Lorg/gnit/lucenekmp/util/hnsw/CloseableRandomVectorScorerSupplier;", "onClose", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "numVectors", "", "supplier", "Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorerSupplier;", "<init>", "(Ljava/lang/AutoCloseable;ILorg/gnit/lucenekmp/util/hnsw/RandomVectorScorerSupplier;)V", "scorer", "Lorg/gnit/lucenekmp/util/hnsw/UpdateableRandomVectorScorer;", "copy", "close", "", "totalVectorCount", "core"})
    public static final class FlatCloseableRandomVectorScorerSupplier
    implements CloseableRandomVectorScorerSupplier {
        @NotNull
        private final AutoCloseable onClose;
        private final int numVectors;
        @NotNull
        private final RandomVectorScorerSupplier supplier;

        public FlatCloseableRandomVectorScorerSupplier(@NotNull AutoCloseable onClose, int numVectors, @NotNull RandomVectorScorerSupplier supplier) {
            Intrinsics.checkNotNullParameter((Object)onClose, (String)"onClose");
            Intrinsics.checkNotNullParameter((Object)supplier, (String)"supplier");
            this.onClose = onClose;
            this.numVectors = numVectors;
            this.supplier = supplier;
        }

        @Override
        @NotNull
        public UpdateableRandomVectorScorer scorer() throws IOException {
            return this.supplier.scorer();
        }

        @Override
        @NotNull
        public RandomVectorScorerSupplier copy() throws IOException {
            return this.supplier.copy();
        }

        @Override
        public void close() throws IOException {
            this.onClose.close();
        }

        @Override
        public int totalVectorCount() {
            return this.numVectors;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VectorEncoding.values().length];
            try {
                nArray[VectorEncoding.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VectorEncoding.FLOAT32.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

