/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene99;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.KnnVectorsReader;
import org.gnit.lucenekmp.codecs.hnsw.FlatVectorsReader;
import org.gnit.lucenekmp.codecs.hnsw.HnswGraphProvider;
import org.gnit.lucenekmp.codecs.lucene99.Lucene99HnswVectorsFormat;
import org.gnit.lucenekmp.index.ByteVectorValues;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.FloatVectorValues;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.SegmentReadState;
import org.gnit.lucenekmp.index.VectorEncoding;
import org.gnit.lucenekmp.index.VectorSimilarityFunction;
import org.gnit.lucenekmp.internal.hppc.IntObjectHashMap;
import org.gnit.lucenekmp.search.KnnCollector;
import org.gnit.lucenekmp.store.ChecksumIndexInput;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.RandomAccessInput;
import org.gnit.lucenekmp.store.ReadAdvice;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.BitSet;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.IOSupplier;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.hnsw.HnswGraph;
import org.gnit.lucenekmp.util.hnsw.HnswGraphSearcher;
import org.gnit.lucenekmp.util.hnsw.OrdinalTranslatedKnnCollector;
import org.gnit.lucenekmp.util.hnsw.RandomVectorScorer;
import org.gnit.lucenekmp.util.packed.DirectMonotonicReader;
import org.gnit.lucenekmp.util.quantization.QuantizedByteVectorValues;
import org.gnit.lucenekmp.util.quantization.QuantizedVectorsReader;
import org.gnit.lucenekmp.util.quantization.ScalarQuantizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 B2\u00020\u00012\u00020\u00022\u00020\u0003:\u0003@ABB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0012\u0012\u0006\u0010\n\u001a\u00020\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0010H\u0002J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0017H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010*\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'2\u0006\u0010+\u001a\u00020,H\u0002J*\u0010-\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u000103H\u0016J*\u0010-\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'2\u0006\u0010.\u001a\u0002042\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u000103H\u0016J0\u0010-\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u0001032\f\u00105\u001a\b\u0012\u0004\u0012\u00020706H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0010H\u0002J\b\u0010;\u001a\u00020\u0017H\u0016J\u0012\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010&\u001a\u00020'H\u0016J\u0012\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006C"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99HnswVectorsReader;", "Lorg/gnit/lucenekmp/codecs/KnnVectorsReader;", "Lorg/gnit/lucenekmp/util/quantization/QuantizedVectorsReader;", "Lorg/gnit/lucenekmp/codecs/hnsw/HnswGraphProvider;", "state", "Lorg/gnit/lucenekmp/index/SegmentReadState;", "flatVectorsReader", "Lorg/gnit/lucenekmp/codecs/hnsw/FlatVectorsReader;", "<init>", "(Lorg/gnit/lucenekmp/index/SegmentReadState;Lorg/gnit/lucenekmp/codecs/hnsw/FlatVectorsReader;)V", "reader", "(Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99HnswVectorsReader;Lorg/gnit/lucenekmp/codecs/hnsw/FlatVectorsReader;)V", "fieldInfos", "Lorg/gnit/lucenekmp/index/FieldInfos;", "fields", "Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;", "Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99HnswVectorsReader$FieldEntry;", "vectorIndex", "Lorg/gnit/lucenekmp/store/IndexInput;", "mergeInstance", "getMergeInstance", "()Lorg/gnit/lucenekmp/codecs/KnnVectorsReader;", "finishMerge", "", "readFields", "meta", "Lorg/gnit/lucenekmp/store/ChecksumIndexInput;", "validateFieldEntry", "info", "Lorg/gnit/lucenekmp/index/FieldInfo;", "fieldEntry", "readField", "input", "ramBytesUsed", "", "checkIntegrity", "getFloatVectorValues", "Lorg/gnit/lucenekmp/index/FloatVectorValues;", "field", "", "getByteVectorValues", "Lorg/gnit/lucenekmp/index/ByteVectorValues;", "getFieldEntry", "expectedEncoding", "Lorg/gnit/lucenekmp/index/VectorEncoding;", "search", "target", "", "knnCollector", "Lorg/gnit/lucenekmp/search/KnnCollector;", "acceptDocs", "Lorg/gnit/lucenekmp/util/Bits;", "", "scorerSupplier", "Lorg/gnit/lucenekmp/util/IOSupplier;", "Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorer;", "getGraph", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraph;", "entry", "close", "getQuantizedVectorValues", "Lorg/gnit/lucenekmp/util/quantization/QuantizedByteVectorValues;", "getQuantizationState", "Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizer;", "FieldEntry", "OffHeapHnswGraph", "Companion", "core"})
public final class Lucene99HnswVectorsReader
extends KnnVectorsReader
implements QuantizedVectorsReader,
HnswGraphProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FlatVectorsReader flatVectorsReader;
    @NotNull
    private final FieldInfos fieldInfos;
    @NotNull
    private final IntObjectHashMap<FieldEntry> fields;
    @NotNull
    private final IndexInput vectorIndex;
    private static final long SHALLOW_SIZE = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(Lucene99HnswVectorsFormat.class));
    @NotNull
    private static final List<VectorSimilarityFunction> SIMILARITY_FUNCTIONS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lucene99HnswVectorsReader(@NotNull SegmentReadState state2, @NotNull FlatVectorsReader flatVectorsReader) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)flatVectorsReader, (String)"flatVectorsReader");
        this.fields = new IntObjectHashMap();
        this.flatVectorsReader = flatVectorsReader;
        boolean success = false;
        this.fieldInfos = state2.getFieldInfos();
        String metaFileName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), "vem");
        int versionMeta = 0;
        versionMeta = -1;
        try {
            AutoCloseable autoCloseable = state2.getDirectory().openChecksumInput(metaFileName);
            Throwable throwable = null;
            try {
                ChecksumIndexInput meta = (ChecksumIndexInput)autoCloseable;
                boolean bl = false;
                Throwable priorE = null;
                try {
                    versionMeta = CodecUtil.INSTANCE.checkIndexHeader(meta, "Lucene99HnswVectorsFormatMeta", 0, 0, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
                    this.readFields(meta);
                }
                catch (Throwable exception) {
                    priorE = exception;
                }
                finally {
                    CodecUtil.INSTANCE.checkFooter(meta, priorE);
                }
                this.vectorIndex = Lucene99HnswVectorsReader.Companion.openDataInput(state2, versionMeta, "vex", "Lucene99HnswVectorsFormatIndex", state2.getContext().withReadAdvice(ReadAdvice.RANDOM));
                success = true;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Throwable throwable) {
            if (!success) {
                AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this};
                IOUtils.INSTANCE.closeWhileHandlingException(autoCloseableArray);
            }
            throw throwable;
        }
    }

    private Lucene99HnswVectorsReader(Lucene99HnswVectorsReader reader2, FlatVectorsReader flatVectorsReader) {
        this.flatVectorsReader = flatVectorsReader;
        this.fieldInfos = reader2.fieldInfos;
        this.fields = reader2.fields;
        this.vectorIndex = reader2.vectorIndex;
    }

    @Override
    @NotNull
    public KnnVectorsReader getMergeInstance() {
        return new Lucene99HnswVectorsReader(this, this.flatVectorsReader.getMergeInstance());
    }

    @Override
    public void finishMerge() throws IOException {
        this.flatVectorsReader.finishMerge();
    }

    private final void readFields(ChecksumIndexInput meta) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = this.fieldInfos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            FieldEntry fieldEntry = this.readField(meta, info);
            this.validateFieldEntry(info, fieldEntry);
            this.fields.put(info.getNumber(), fieldEntry);
            fieldNumber = meta.readInt();
        }
    }

    private final void validateFieldEntry(FieldInfo info, FieldEntry fieldEntry) {
        int dimension = info.getVectorDimension();
        if (!(dimension == fieldEntry.getDimension())) {
            boolean bl = false;
            String string = "Inconsistent vector dimension for field=\"" + info.getName() + "\"; " + dimension + " != " + fieldEntry.getDimension();
            throw new IllegalStateException(string.toString());
        }
    }

    private final FieldEntry readField(IndexInput input, FieldInfo info) throws IOException {
        VectorEncoding vectorEncoding = Companion.readVectorEncoding(input);
        VectorSimilarityFunction similarityFunction = Companion.readSimilarityFunction(input);
        if (!(similarityFunction == info.getVectorSimilarityFunction())) {
            boolean bl = false;
            String string = "Inconsistent vector similarity function for field=\"" + info.getName() + "\"; " + similarityFunction + " != " + info.getVectorSimilarityFunction();
            throw new IllegalStateException(string.toString());
        }
        return FieldEntry.Companion.create(input, vectorEncoding, info.getVectorSimilarityFunction());
    }

    @Override
    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.fields.ramBytesUsed() + this.flatVectorsReader.ramBytesUsed();
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.flatVectorsReader.checkIntegrity();
        CodecUtil.INSTANCE.checksumEntireFile(this.vectorIndex);
    }

    @Override
    @NotNull
    public FloatVectorValues getFloatVectorValues(@NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        FloatVectorValues floatVectorValues = this.flatVectorsReader.getFloatVectorValues(field);
        Intrinsics.checkNotNull((Object)floatVectorValues);
        return floatVectorValues;
    }

    @Override
    @NotNull
    public ByteVectorValues getByteVectorValues(@NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        ByteVectorValues byteVectorValues = this.flatVectorsReader.getByteVectorValues(field);
        Intrinsics.checkNotNull((Object)byteVectorValues);
        return byteVectorValues;
    }

    private final FieldEntry getFieldEntry(String field, VectorEncoding expectedEncoding) {
        FieldInfo info;
        FieldInfo fieldInfo = info = this.fieldInfos.fieldInfo(field);
        Intrinsics.checkNotNull((Object)fieldInfo);
        FieldEntry fieldEntry = this.fields.get(fieldInfo.getNumber());
        if (!(fieldEntry != null)) {
            boolean $i$a$-require-Lucene99HnswVectorsReader$getFieldEntry$32 = false;
            String $i$a$-require-Lucene99HnswVectorsReader$getFieldEntry$32 = "field=\"" + field + "\" not found";
            throw new IllegalArgumentException($i$a$-require-Lucene99HnswVectorsReader$getFieldEntry$32.toString());
        }
        if (!(fieldEntry.getVectorEncoding() == expectedEncoding)) {
            boolean bl = false;
            String string = "field=\"" + field + "\" is encoded as: " + fieldEntry.getVectorEncoding() + " expected: " + expectedEncoding;
            throw new IllegalArgumentException(string.toString());
        }
        return fieldEntry;
    }

    @Override
    public void search(@NotNull String field, @NotNull float[] target, @NotNull KnnCollector knnCollector, @Nullable Bits acceptDocs) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)knnCollector, (String)"knnCollector");
        FieldEntry fieldEntry = this.getFieldEntry(field, VectorEncoding.FLOAT32);
        this.search(fieldEntry, knnCollector, acceptDocs, () -> Lucene99HnswVectorsReader.search$lambda$5(this, field, target));
    }

    @Override
    public void search(@NotNull String field, @NotNull byte[] target, @NotNull KnnCollector knnCollector, @Nullable Bits acceptDocs) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)knnCollector, (String)"knnCollector");
        FieldEntry fieldEntry = this.getFieldEntry(field, VectorEncoding.BYTE);
        this.search(fieldEntry, knnCollector, acceptDocs, () -> Lucene99HnswVectorsReader.search$lambda$6(this, field, target));
    }

    private final void search(FieldEntry fieldEntry, KnnCollector knnCollector, Bits acceptDocs, IOSupplier<RandomVectorScorer> scorerSupplier2) throws IOException {
        if (fieldEntry.getSize() == 0 || knnCollector.k() == 0) {
            return;
        }
        RandomVectorScorer scorer2 = scorerSupplier2.get();
        KnnCollector collector2 = new OrdinalTranslatedKnnCollector(knnCollector, (Function1<? super Integer, Integer>)((Function1)arg_0 -> Lucene99HnswVectorsReader.search$lambda$7(scorer2, arg_0)));
        Bits acceptedOrds = scorer2.getAcceptOrds(acceptDocs);
        HnswGraph graph = this.getGraph(fieldEntry);
        boolean doHnsw = knnCollector.k() < scorer2.maxOrd();
        int filteredDocCount = 0;
        int unfilteredVisit = (int)(Math.log(graph.size()) * (double)knnCollector.k());
        if (acceptDocs instanceof BitSet && unfilteredVisit >= (filteredDocCount = Math.min(((BitSet)acceptDocs).approximateCardinality(), graph.size()))) {
            doHnsw = false;
        }
        if (doHnsw) {
            HnswGraphSearcher.Companion.search(scorer2, collector2, this.getGraph(fieldEntry), acceptedOrds, filteredDocCount);
        } else {
            int n = scorer2.maxOrd();
            for (int i = 0; i < n; ++i) {
                if (acceptedOrds != null && !acceptedOrds.get(i)) continue;
                if (knnCollector.earlyTerminated()) break;
                knnCollector.incVisitedCount(1);
                knnCollector.collect(scorer2.ordToDoc(i), scorer2.score(i));
            }
        }
    }

    @Override
    @NotNull
    public HnswGraph getGraph(@NotNull String field) throws IOException {
        FieldInfo info;
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        FieldInfo fieldInfo = info = this.fieldInfos.fieldInfo(field);
        Intrinsics.checkNotNull((Object)fieldInfo);
        FieldEntry entry = this.fields.get(fieldInfo.getNumber());
        if (!(entry != null)) {
            boolean bl = false;
            String string = "field=\"" + field + "\" not found";
            throw new IllegalArgumentException(string.toString());
        }
        return entry.getVectorIndexLength() > 0L ? this.getGraph(entry) : HnswGraph.Companion.getEMPTY();
    }

    private final HnswGraph getGraph(FieldEntry entry) throws IOException {
        return new OffHeapHnswGraph(entry, this.vectorIndex);
    }

    @Override
    public void close() throws IOException {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.flatVectorsReader, this.vectorIndex};
        IOUtils.INSTANCE.close(autoCloseableArray);
    }

    @Override
    @Nullable
    public QuantizedByteVectorValues getQuantizedVectorValues(@NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if (this.flatVectorsReader instanceof QuantizedVectorsReader) {
            FlatVectorsReader flatVectorsReader = this.flatVectorsReader;
            Intrinsics.checkNotNull((Object)flatVectorsReader, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.quantization.QuantizedVectorsReader");
            return ((QuantizedVectorsReader)((Object)flatVectorsReader)).getQuantizedVectorValues(field);
        }
        return null;
    }

    @Override
    @Nullable
    public ScalarQuantizer getQuantizationState(@NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if (this.flatVectorsReader instanceof QuantizedVectorsReader) {
            FlatVectorsReader flatVectorsReader = this.flatVectorsReader;
            Intrinsics.checkNotNull((Object)flatVectorsReader, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.quantization.QuantizedVectorsReader");
            return ((QuantizedVectorsReader)((Object)flatVectorsReader)).getQuantizationState(field);
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return QuantizedVectorsReader.super.getChildResources();
    }

    private static final RandomVectorScorer search$lambda$5(Lucene99HnswVectorsReader this$0, String $field, float[] $target) {
        return this$0.flatVectorsReader.getRandomVectorScorer($field, $target);
    }

    private static final RandomVectorScorer search$lambda$6(Lucene99HnswVectorsReader this$0, String $field, byte[] $target) {
        return this$0.flatVectorsReader.getRandomVectorScorer($field, $target);
    }

    private static final int search$lambda$7(RandomVectorScorer $scorer, int ord) {
        return $scorer.ordToDoc(ord);
    }

    static {
        VectorSimilarityFunction[] vectorSimilarityFunctionArray = new VectorSimilarityFunction[]{VectorSimilarityFunction.EUCLIDEAN, VectorSimilarityFunction.DOT_PRODUCT, VectorSimilarityFunction.COSINE, VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT};
        SIMILARITY_FUNCTIONS = CollectionsKt.mutableListOf((Object[])vectorSimilarityFunctionArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99HnswVectorsReader$Companion;", "", "<init>", "()V", "SHALLOW_SIZE", "", "openDataInput", "Lorg/gnit/lucenekmp/store/IndexInput;", "state", "Lorg/gnit/lucenekmp/index/SegmentReadState;", "versionMeta", "", "fileExtension", "", "codecName", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "SIMILARITY_FUNCTIONS", "", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "getSIMILARITY_FUNCTIONS", "()Ljava/util/List;", "readSimilarityFunction", "input", "Lorg/gnit/lucenekmp/store/DataInput;", "readVectorEncoding", "Lorg/gnit/lucenekmp/index/VectorEncoding;", "core"})
    @SourceDebugExtension(value={"SMAP\nLucene99HnswVectorsReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene99HnswVectorsReader.kt\norg/gnit/lucenekmp/codecs/lucene99/Lucene99HnswVectorsReader$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,561:1\n1#2:562\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final IndexInput openDataInput(SegmentReadState state2, int versionMeta, String fileExtension, String codecName, IOContext context) throws IOException {
            IndexInput indexInput;
            String fileName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), fileExtension);
            IndexInput in = state2.getDirectory().openInput(fileName, context);
            boolean success = false;
            try {
                int versionVectorData = CodecUtil.INSTANCE.checkIndexHeader(in, codecName, 0, 0, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
                if (versionMeta != versionVectorData) {
                    throw new CorruptIndexException("Format versions mismatch: meta=" + versionMeta + ", " + codecName + "=" + versionVectorData, in);
                }
                CodecUtil.INSTANCE.retrieveChecksum(in);
                success = true;
                indexInput = in;
            }
            catch (Throwable throwable) {
                if (!success) {
                    AutoCloseable[] autoCloseableArray = new AutoCloseable[]{in};
                    IOUtils.INSTANCE.closeWhileHandlingException(autoCloseableArray);
                }
                throw throwable;
            }
            return indexInput;
        }

        @NotNull
        public final List<VectorSimilarityFunction> getSIMILARITY_FUNCTIONS() {
            return SIMILARITY_FUNCTIONS;
        }

        @NotNull
        public final VectorSimilarityFunction readSimilarityFunction(@NotNull DataInput input) throws IOException {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            int i = input.readInt();
            if (!(i >= 0 && i < this.getSIMILARITY_FUNCTIONS().size())) {
                boolean bl = false;
                String string = "invalid distance function: " + i;
                throw new IllegalArgumentException(string.toString());
            }
            return this.getSIMILARITY_FUNCTIONS().get(i);
        }

        @NotNull
        public final VectorEncoding readVectorEncoding(@NotNull DataInput input) throws IOException {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            int encodingId = input.readInt();
            if (encodingId < 0 || encodingId >= VectorEncoding.getEntries().size()) {
                throw new CorruptIndexException("Invalid vector encoding id: " + encodingId, input);
            }
            return (VectorEncoding)((Object)VectorEncoding.getEntries().get(encodingId));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b)\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u0000 A2\u00020\u0001:\u0001ABu\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0007\u0012\u0006\u0010\u0014\u001a\u00020\n\u0012\u0006\u0010\u0015\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\u0005H\u00c6\u0003J\t\u0010.\u001a\u00020\u0007H\u00c6\u0003J\t\u0010/\u001a\u00020\u0007H\u00c6\u0003J\t\u00100\u001a\u00020\nH\u00c6\u0003J\t\u00101\u001a\u00020\nH\u00c6\u0003J\t\u00102\u001a\u00020\nH\u00c6\u0003J\t\u00103\u001a\u00020\nH\u00c6\u0003J\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u00c6\u0003\u00a2\u0006\u0002\u0010%J\t\u00105\u001a\u00020\u0012H\u00c6\u0003J\t\u00106\u001a\u00020\u0007H\u00c6\u0003J\t\u00107\u001a\u00020\nH\u00c6\u0003J\t\u00108\u001a\u00020\u0007H\u00c6\u0003J\u0096\u0001\u00109\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\n2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00072\b\b\u0002\u0010\u0014\u001a\u00020\n2\b\b\u0002\u0010\u0015\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010:J\u0013\u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010>\u001a\u00020\nH\u00d6\u0001J\t\u0010?\u001a\u00020@H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010 R\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010 R\u0019\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\n\n\u0002\u0010&\u001a\u0004\b$\u0010%R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u0013\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001dR\u0011\u0010\u0014\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010 R\u0011\u0010\u0015\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u001d\u00a8\u0006B"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99HnswVectorsReader$FieldEntry;", "", "similarityFunction", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "vectorEncoding", "Lorg/gnit/lucenekmp/index/VectorEncoding;", "vectorIndexOffset", "", "vectorIndexLength", "M", "", "numLevels", "dimension", "size", "nodesByLevel", "", "", "offsetsMeta", "Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta;", "offsetsOffset", "offsetsBlockShift", "offsetsLength", "<init>", "(Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;Lorg/gnit/lucenekmp/index/VectorEncoding;JJIIII[[ILorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta;JIJ)V", "getSimilarityFunction", "()Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "getVectorEncoding", "()Lorg/gnit/lucenekmp/index/VectorEncoding;", "getVectorIndexOffset", "()J", "getVectorIndexLength", "getM", "()I", "getNumLevels", "getDimension", "getSize", "getNodesByLevel", "()[[I", "[[I", "getOffsetsMeta", "()Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta;", "getOffsetsOffset", "getOffsetsBlockShift", "getOffsetsLength", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "copy", "(Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;Lorg/gnit/lucenekmp/index/VectorEncoding;JJIIII[[ILorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta;JIJ)Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99HnswVectorsReader$FieldEntry;", "equals", "", "other", "hashCode", "toString", "", "Companion", "core"})
    private static final class FieldEntry {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final VectorSimilarityFunction similarityFunction;
        @NotNull
        private final VectorEncoding vectorEncoding;
        private final long vectorIndexOffset;
        private final long vectorIndexLength;
        private final int M;
        private final int numLevels;
        private final int dimension;
        private final int size;
        @NotNull
        private final int[][] nodesByLevel;
        @NotNull
        private final DirectMonotonicReader.Meta offsetsMeta;
        private final long offsetsOffset;
        private final int offsetsBlockShift;
        private final long offsetsLength;

        public FieldEntry(@NotNull VectorSimilarityFunction similarityFunction, @NotNull VectorEncoding vectorEncoding, long vectorIndexOffset, long vectorIndexLength, int M, int numLevels, int dimension, int size2, @NotNull int[][] nodesByLevel, @NotNull DirectMonotonicReader.Meta offsetsMeta, long offsetsOffset, int offsetsBlockShift, long offsetsLength) {
            Intrinsics.checkNotNullParameter((Object)((Object)similarityFunction), (String)"similarityFunction");
            Intrinsics.checkNotNullParameter((Object)((Object)vectorEncoding), (String)"vectorEncoding");
            Intrinsics.checkNotNullParameter((Object)nodesByLevel, (String)"nodesByLevel");
            Intrinsics.checkNotNullParameter((Object)offsetsMeta, (String)"offsetsMeta");
            this.similarityFunction = similarityFunction;
            this.vectorEncoding = vectorEncoding;
            this.vectorIndexOffset = vectorIndexOffset;
            this.vectorIndexLength = vectorIndexLength;
            this.M = M;
            this.numLevels = numLevels;
            this.dimension = dimension;
            this.size = size2;
            this.nodesByLevel = nodesByLevel;
            this.offsetsMeta = offsetsMeta;
            this.offsetsOffset = offsetsOffset;
            this.offsetsBlockShift = offsetsBlockShift;
            this.offsetsLength = offsetsLength;
        }

        @NotNull
        public final VectorSimilarityFunction getSimilarityFunction() {
            return this.similarityFunction;
        }

        @NotNull
        public final VectorEncoding getVectorEncoding() {
            return this.vectorEncoding;
        }

        public final long getVectorIndexOffset() {
            return this.vectorIndexOffset;
        }

        public final long getVectorIndexLength() {
            return this.vectorIndexLength;
        }

        public final int getM() {
            return this.M;
        }

        public final int getNumLevels() {
            return this.numLevels;
        }

        public final int getDimension() {
            return this.dimension;
        }

        public final int getSize() {
            return this.size;
        }

        @NotNull
        public final int[][] getNodesByLevel() {
            return this.nodesByLevel;
        }

        @NotNull
        public final DirectMonotonicReader.Meta getOffsetsMeta() {
            return this.offsetsMeta;
        }

        public final long getOffsetsOffset() {
            return this.offsetsOffset;
        }

        public final int getOffsetsBlockShift() {
            return this.offsetsBlockShift;
        }

        public final long getOffsetsLength() {
            return this.offsetsLength;
        }

        @NotNull
        public final VectorSimilarityFunction component1() {
            return this.similarityFunction;
        }

        @NotNull
        public final VectorEncoding component2() {
            return this.vectorEncoding;
        }

        public final long component3() {
            return this.vectorIndexOffset;
        }

        public final long component4() {
            return this.vectorIndexLength;
        }

        public final int component5() {
            return this.M;
        }

        public final int component6() {
            return this.numLevels;
        }

        public final int component7() {
            return this.dimension;
        }

        public final int component8() {
            return this.size;
        }

        @NotNull
        public final int[][] component9() {
            return this.nodesByLevel;
        }

        @NotNull
        public final DirectMonotonicReader.Meta component10() {
            return this.offsetsMeta;
        }

        public final long component11() {
            return this.offsetsOffset;
        }

        public final int component12() {
            return this.offsetsBlockShift;
        }

        public final long component13() {
            return this.offsetsLength;
        }

        @NotNull
        public final FieldEntry copy(@NotNull VectorSimilarityFunction similarityFunction, @NotNull VectorEncoding vectorEncoding, long vectorIndexOffset, long vectorIndexLength, int M, int numLevels, int dimension, int size2, @NotNull int[][] nodesByLevel, @NotNull DirectMonotonicReader.Meta offsetsMeta, long offsetsOffset, int offsetsBlockShift, long offsetsLength) {
            Intrinsics.checkNotNullParameter((Object)((Object)similarityFunction), (String)"similarityFunction");
            Intrinsics.checkNotNullParameter((Object)((Object)vectorEncoding), (String)"vectorEncoding");
            Intrinsics.checkNotNullParameter((Object)nodesByLevel, (String)"nodesByLevel");
            Intrinsics.checkNotNullParameter((Object)offsetsMeta, (String)"offsetsMeta");
            return new FieldEntry(similarityFunction, vectorEncoding, vectorIndexOffset, vectorIndexLength, M, numLevels, dimension, size2, nodesByLevel, offsetsMeta, offsetsOffset, offsetsBlockShift, offsetsLength);
        }

        public static /* synthetic */ FieldEntry copy$default(FieldEntry fieldEntry, VectorSimilarityFunction vectorSimilarityFunction, VectorEncoding vectorEncoding, long l, long l2, int n, int n2, int n3, int n4, int[][] nArray, DirectMonotonicReader.Meta meta, long l3, int n5, long l4, int n6, Object object) {
            if ((n6 & 1) != 0) {
                vectorSimilarityFunction = fieldEntry.similarityFunction;
            }
            if ((n6 & 2) != 0) {
                vectorEncoding = fieldEntry.vectorEncoding;
            }
            if ((n6 & 4) != 0) {
                l = fieldEntry.vectorIndexOffset;
            }
            if ((n6 & 8) != 0) {
                l2 = fieldEntry.vectorIndexLength;
            }
            if ((n6 & 0x10) != 0) {
                n = fieldEntry.M;
            }
            if ((n6 & 0x20) != 0) {
                n2 = fieldEntry.numLevels;
            }
            if ((n6 & 0x40) != 0) {
                n3 = fieldEntry.dimension;
            }
            if ((n6 & 0x80) != 0) {
                n4 = fieldEntry.size;
            }
            if ((n6 & 0x100) != 0) {
                nArray = fieldEntry.nodesByLevel;
            }
            if ((n6 & 0x200) != 0) {
                meta = fieldEntry.offsetsMeta;
            }
            if ((n6 & 0x400) != 0) {
                l3 = fieldEntry.offsetsOffset;
            }
            if ((n6 & 0x800) != 0) {
                n5 = fieldEntry.offsetsBlockShift;
            }
            if ((n6 & 0x1000) != 0) {
                l4 = fieldEntry.offsetsLength;
            }
            return fieldEntry.copy(vectorSimilarityFunction, vectorEncoding, l, l2, n, n2, n3, n4, nArray, meta, l3, n5, l4);
        }

        @NotNull
        public String toString() {
            return "FieldEntry(similarityFunction=" + this.similarityFunction + ", vectorEncoding=" + this.vectorEncoding + ", vectorIndexOffset=" + this.vectorIndexOffset + ", vectorIndexLength=" + this.vectorIndexLength + ", M=" + this.M + ", numLevels=" + this.numLevels + ", dimension=" + this.dimension + ", size=" + this.size + ", nodesByLevel=" + Arrays.toString((Object[])this.nodesByLevel) + ", offsetsMeta=" + this.offsetsMeta + ", offsetsOffset=" + this.offsetsOffset + ", offsetsBlockShift=" + this.offsetsBlockShift + ", offsetsLength=" + this.offsetsLength + ")";
        }

        public int hashCode() {
            int result = this.similarityFunction.hashCode();
            result = result * 31 + this.vectorEncoding.hashCode();
            result = result * 31 + Long.hashCode(this.vectorIndexOffset);
            result = result * 31 + Long.hashCode(this.vectorIndexLength);
            result = result * 31 + Integer.hashCode(this.M);
            result = result * 31 + Integer.hashCode(this.numLevels);
            result = result * 31 + Integer.hashCode(this.dimension);
            result = result * 31 + Integer.hashCode(this.size);
            result = result * 31 + Arrays.hashCode((Object[])this.nodesByLevel);
            result = result * 31 + this.offsetsMeta.hashCode();
            result = result * 31 + Long.hashCode(this.offsetsOffset);
            result = result * 31 + Integer.hashCode(this.offsetsBlockShift);
            result = result * 31 + Long.hashCode(this.offsetsLength);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FieldEntry)) {
                return false;
            }
            FieldEntry fieldEntry = (FieldEntry)other;
            if (this.similarityFunction != fieldEntry.similarityFunction) {
                return false;
            }
            if (this.vectorEncoding != fieldEntry.vectorEncoding) {
                return false;
            }
            if (this.vectorIndexOffset != fieldEntry.vectorIndexOffset) {
                return false;
            }
            if (this.vectorIndexLength != fieldEntry.vectorIndexLength) {
                return false;
            }
            if (this.M != fieldEntry.M) {
                return false;
            }
            if (this.numLevels != fieldEntry.numLevels) {
                return false;
            }
            if (this.dimension != fieldEntry.dimension) {
                return false;
            }
            if (this.size != fieldEntry.size) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.nodesByLevel, (Object)fieldEntry.nodesByLevel)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.offsetsMeta, (Object)fieldEntry.offsetsMeta)) {
                return false;
            }
            if (this.offsetsOffset != fieldEntry.offsetsOffset) {
                return false;
            }
            if (this.offsetsBlockShift != fieldEntry.offsetsBlockShift) {
                return false;
            }
            return this.offsetsLength == fieldEntry.offsetsLength;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99HnswVectorsReader$FieldEntry$Companion;", "", "<init>", "()V", "create", "Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99HnswVectorsReader$FieldEntry;", "input", "Lorg/gnit/lucenekmp/store/IndexInput;", "vectorEncoding", "Lorg/gnit/lucenekmp/index/VectorEncoding;", "similarityFunction", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final FieldEntry create(@NotNull IndexInput input, @NotNull VectorEncoding vectorEncoding, @NotNull VectorSimilarityFunction similarityFunction) throws IOException {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Intrinsics.checkNotNullParameter((Object)((Object)vectorEncoding), (String)"vectorEncoding");
                Intrinsics.checkNotNullParameter((Object)((Object)similarityFunction), (String)"similarityFunction");
                long vectorIndexOffset = input.readVLong();
                long vectorIndexLength = input.readVLong();
                int dimension = input.readVInt();
                int size2 = input.readInt();
                int M = input.readVInt();
                int numLevels = input.readVInt();
                int[][] nodesByLevel = new int[numLevels][];
                long numberOfOffsets = 0L;
                long offsetsOffset = 0L;
                int offsetsBlockShift = 0;
                DirectMonotonicReader.Meta offsetsMeta = null;
                long offsetsLength = 0L;
                for (int level = 0; level < numLevels; ++level) {
                    if (level > 0) {
                        int numNodesOnLevel = input.readVInt();
                        numberOfOffsets += (long)numNodesOnLevel;
                        nodesByLevel[level] = new int[numNodesOnLevel];
                        nodesByLevel[level][0] = input.readVInt();
                        for (int i = 1; i < numNodesOnLevel; ++i) {
                            nodesByLevel[level][i] = nodesByLevel[level][i - 1] + input.readVInt();
                        }
                        continue;
                    }
                    numberOfOffsets += (long)size2;
                }
                if (numberOfOffsets > 0L) {
                    offsetsOffset = input.readLong();
                    offsetsBlockShift = input.readVInt();
                    offsetsMeta = DirectMonotonicReader.Companion.loadMeta(input, numberOfOffsets, offsetsBlockShift);
                    offsetsLength = input.readLong();
                } else {
                    offsetsOffset = 0L;
                    offsetsBlockShift = 0;
                    offsetsMeta = null;
                    offsetsLength = 0L;
                }
                DirectMonotonicReader.Meta meta = offsetsMeta;
                Intrinsics.checkNotNull((Object)meta);
                return new FieldEntry(similarityFunction, vectorEncoding, vectorIndexOffset, vectorIndexLength, M, numLevels, dimension, size2, nodesByLevel, meta, offsetsOffset, offsetsBlockShift, offsetsLength);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\b\u0010-\u001a\u00020\u0012H\u0016J\b\u0010.\u001a\u00020\u0012H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010#\u001a\u00020\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u0010+\u001a\u00020\u0012H\u0016R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u001a\u0010\u0019\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0014\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0014\"\u0004\b\u001f\u0010\u001cR\u001a\u0010 \u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0014\"\u0004\b\"\u0010\u001cR\u000e\u0010#\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99HnswVectorsReader$OffHeapHnswGraph;", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraph;", "entry", "Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99HnswVectorsReader$FieldEntry;", "vectorIndex", "Lorg/gnit/lucenekmp/store/IndexInput;", "<init>", "(Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99HnswVectorsReader$FieldEntry;Lorg/gnit/lucenekmp/store/IndexInput;)V", "dataIn", "getDataIn", "()Lorg/gnit/lucenekmp/store/IndexInput;", "nodesByLevel", "", "", "getNodesByLevel", "()[[I", "[[I", "numLevels", "", "getNumLevels", "()I", "entryNode", "getEntryNode", "size", "getSize", "arcCount", "getArcCount", "setArcCount", "(I)V", "arcUpTo", "getArcUpTo", "setArcUpTo", "arc", "getArc", "setArc", "maxConn", "graphLevelNodeOffsets", "Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader;", "graphLevelNodeIndexOffsets", "", "currentNeighborsBuffer", "seek", "", "level", "targetOrd", "nextNeighbor", "neighborCount", "getNodesOnLevel", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraph$NodesIterator;", "core"})
    @SourceDebugExtension(value={"SMAP\nLucene99HnswVectorsReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene99HnswVectorsReader.kt\norg/gnit/lucenekmp/codecs/lucene99/Lucene99HnswVectorsReader$OffHeapHnswGraph\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,561:1\n1#2:562\n*E\n"})
    private static final class OffHeapHnswGraph
    extends HnswGraph {
        @NotNull
        private final IndexInput dataIn;
        @NotNull
        private final int[][] nodesByLevel;
        private final int numLevels;
        private final int entryNode;
        private final int size;
        private int arcCount;
        private int arcUpTo;
        private int arc;
        private final int maxConn;
        @NotNull
        private final DirectMonotonicReader graphLevelNodeOffsets;
        @NotNull
        private final long[] graphLevelNodeIndexOffsets;
        @NotNull
        private final int[] currentNeighborsBuffer;

        public OffHeapHnswGraph(@NotNull FieldEntry entry, @NotNull IndexInput vectorIndex) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Intrinsics.checkNotNullParameter((Object)vectorIndex, (String)"vectorIndex");
            this.dataIn = vectorIndex.slice("graph-data", entry.getVectorIndexOffset(), entry.getVectorIndexLength());
            this.nodesByLevel = entry.getNodesByLevel();
            this.numLevels = entry.getNumLevels();
            this.entryNode = this.numLevels > 1 ? this.nodesByLevel[this.numLevels - 1][0] : 0;
            this.size = entry.getSize();
            RandomAccessInput addressesData = vectorIndex.randomAccessSlice(entry.getOffsetsOffset(), entry.getOffsetsLength());
            this.graphLevelNodeOffsets = DirectMonotonicReader.Companion.getInstance(entry.getOffsetsMeta(), addressesData);
            this.currentNeighborsBuffer = new int[entry.getM() * 2];
            this.maxConn = entry.getM();
            this.graphLevelNodeIndexOffsets = new long[this.numLevels];
            this.graphLevelNodeIndexOffsets[0] = 0L;
            int n = this.numLevels;
            for (int i = 1; i < n; ++i) {
                int nodeCount = this.nodesByLevel[i - 1] == null ? this.size : this.nodesByLevel[i - 1].length;
                this.graphLevelNodeIndexOffsets[i] = this.graphLevelNodeIndexOffsets[i - 1] + (long)nodeCount;
            }
        }

        @NotNull
        public final IndexInput getDataIn() {
            return this.dataIn;
        }

        @NotNull
        public final int[][] getNodesByLevel() {
            return this.nodesByLevel;
        }

        public final int getNumLevels() {
            return this.numLevels;
        }

        public final int getEntryNode() {
            return this.entryNode;
        }

        public final int getSize() {
            return this.size;
        }

        public final int getArcCount() {
            return this.arcCount;
        }

        public final void setArcCount(int n) {
            this.arcCount = n;
        }

        public final int getArcUpTo() {
            return this.arcUpTo;
        }

        public final void setArcUpTo(int n) {
            this.arcUpTo = n;
        }

        public final int getArc() {
            return this.arc;
        }

        public final void setArc(int n) {
            this.arc = n;
        }

        @Override
        public void seek(int level, int targetOrd) throws IOException {
            int targetIndex = level == 0 ? targetOrd : org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.binarySearch(this.nodesByLevel[level], 0, this.nodesByLevel[level].length, targetOrd);
            if (!(targetIndex >= 0)) {
                boolean $i$a$-require-Lucene99HnswVectorsReader$OffHeapHnswGraph$seek$32 = false;
                String $i$a$-require-Lucene99HnswVectorsReader$OffHeapHnswGraph$seek$32 = "seek level=" + level + " target=" + targetOrd + " not found: " + targetIndex;
                throw new IllegalArgumentException($i$a$-require-Lucene99HnswVectorsReader$OffHeapHnswGraph$seek$32.toString());
            }
            this.dataIn.seek(this.graphLevelNodeOffsets.get((long)targetIndex + this.graphLevelNodeIndexOffsets[level]));
            this.arcCount = this.dataIn.readVInt();
            if (!(this.arcCount <= this.currentNeighborsBuffer.length)) {
                boolean bl = false;
                String string = "too many neighbors: " + this.arcCount;
                throw new IllegalArgumentException(string.toString());
            }
            if (this.arcCount > 0) {
                this.currentNeighborsBuffer[0] = this.dataIn.readVInt();
                int n = this.arcCount;
                for (int i = 1; i < n; ++i) {
                    this.currentNeighborsBuffer[i] = this.currentNeighborsBuffer[i - 1] + this.dataIn.readVInt();
                }
            }
            this.arc = -1;
            this.arcUpTo = 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int nextNeighbor() throws IOException {
            if (this.arcUpTo >= this.arcCount) {
                return Integer.MAX_VALUE;
            }
            this.arc = this.currentNeighborsBuffer[this.arcUpTo];
            ++this.arcUpTo;
            return this.arc;
        }

        @Override
        public int neighborCount() {
            return this.arcCount;
        }

        @Override
        public int numLevels() throws IOException {
            return this.numLevels;
        }

        @Override
        public int maxConn() {
            return this.maxConn;
        }

        @Override
        public int entryNode() throws IOException {
            return this.entryNode;
        }

        @Override
        @NotNull
        public HnswGraph.NodesIterator getNodesOnLevel(int level) {
            return level == 0 ? (HnswGraph.NodesIterator)new HnswGraph.ArrayNodesIterator(this.size()) : (HnswGraph.NodesIterator)new HnswGraph.ArrayNodesIterator(this.nodesByLevel[level], this.nodesByLevel[level].length);
        }
    }
}

