/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene99;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.SegmentInfoFormat;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.IndexSorter;
import org.gnit.lucenekmp.index.SegmentInfo;
import org.gnit.lucenekmp.index.SortFieldProvider;
import org.gnit.lucenekmp.search.Sort;
import org.gnit.lucenekmp.search.SortField;
import org.gnit.lucenekmp.store.ChecksumIndexInput;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.util.Version;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0005H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99SegmentInfoFormat;", "Lorg/gnit/lucenekmp/codecs/SegmentInfoFormat;", "<init>", "()V", "read", "Lorg/gnit/lucenekmp/index/SegmentInfo;", "dir", "Lorg/gnit/lucenekmp/store/Directory;", "segment", "", "segmentID", "", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "parseSegmentInfo", "input", "Lorg/gnit/lucenekmp/store/DataInput;", "write", "", "si", "ioContext", "writeSegmentInfo", "output", "Lorg/gnit/lucenekmp/store/DataOutput;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLucene99SegmentInfoFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene99SegmentInfoFormat.kt\norg/gnit/lucenekmp/codecs/lucene99/Lucene99SegmentInfoFormat\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1#2:218\n*E\n"})
public final class Lucene99SegmentInfoFormat
extends SegmentInfoFormat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String SI_EXTENSION = "si";
    @NotNull
    public static final String CODEC_NAME = "Lucene90SegmentInfo";
    public static final int VERSION_START = 0;
    public static final int VERSION_CURRENT = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public SegmentInfo read(@NotNull Directory dir, @NotNull String segment, @NotNull byte[] segmentID, @NotNull IOContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        Intrinsics.checkNotNullParameter((Object)segmentID, (String)"segmentID");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String fileName = IndexFileNames.INSTANCE.segmentFileName(segment, "", SI_EXTENSION);
        AutoCloseable autoCloseable = dir.openChecksumInput(fileName);
        Throwable throwable = null;
        try {
            ChecksumIndexInput input = (ChecksumIndexInput)autoCloseable;
            boolean bl = false;
            Throwable priorE = null;
            SegmentInfo si = null;
            try {
                CodecUtil.INSTANCE.checkIndexHeader(input, CODEC_NAME, 0, 0, segmentID, "");
                si = this.parseSegmentInfo(dir, input, segment, segmentID);
            }
            catch (Throwable exception) {
                priorE = exception;
            }
            finally {
                CodecUtil.INSTANCE.checkFooter(input, priorE);
            }
            SegmentInfo segmentInfo = si;
            Intrinsics.checkNotNull(segmentInfo);
            SegmentInfo segmentInfo2 = segmentInfo;
            return segmentInfo2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final SegmentInfo parseSegmentInfo(Directory dir, DataInput input, String segment, byte[] segmentID) throws IOException {
        Version version;
        Version version2 = Version.Companion.fromBits(input.readInt(), input.readInt(), input.readInt());
        byte hasMinVersion = input.readByte();
        byte by = hasMinVersion;
        if (by == 0) {
            version = null;
        } else if (by == 1) {
            version = Version.Companion.fromBits(input.readInt(), input.readInt(), input.readInt());
        } else {
            throw new CorruptIndexException("Illegal boolean value " + hasMinVersion, input);
        }
        Version minVersion = version;
        int docCount = input.readInt();
        if (docCount < 0) {
            throw new CorruptIndexException("invalid docCount: " + docCount, input);
        }
        boolean isCompoundFile = input.readByte() == 1;
        boolean hasBlocks = input.readByte() == 1;
        Map<String, String> diagnostics = input.readMapOfStrings();
        Set<String> files = input.readSetOfStrings();
        Map<String, String> attributes = input.readMapOfStrings();
        int numSortFields = input.readVInt();
        Sort indexSort = null;
        if (numSortFields > 0) {
            SortField[] sortFields = new SortField[numSortFields];
            for (int i = 0; i < numSortFields; ++i) {
                String name = input.readString();
                sortFields[i] = SortFieldProvider.Companion.forName(name).readSortField(input);
            }
            SortField[] sortFieldArray = sortFields;
            indexSort = new Sort(Arrays.copyOf(sortFieldArray, sortFieldArray.length));
        } else {
            if (numSortFields < 0) {
                throw new CorruptIndexException("invalid index sort field count: " + numSortFields, input);
            }
            indexSort = null;
        }
        SegmentInfo si = new SegmentInfo(dir, version2, minVersion, segment, docCount, isCompoundFile, hasBlocks, null, diagnostics, segmentID, attributes, indexSort);
        si.setFiles((Collection<String>)files);
        return si;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull Directory dir, @NotNull SegmentInfo si, @NotNull IOContext ioContext) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)si, (String)SI_EXTENSION);
        Intrinsics.checkNotNullParameter((Object)ioContext, (String)"ioContext");
        String fileName = IndexFileNames.INSTANCE.segmentFileName(si.getName(), "", SI_EXTENSION);
        AutoCloseable autoCloseable = dir.createOutput(fileName, ioContext);
        Throwable throwable = null;
        try {
            IndexOutput output = (IndexOutput)autoCloseable;
            boolean bl = false;
            si.addFile(fileName);
            CodecUtil.INSTANCE.writeIndexHeader(output, CODEC_NAME, 0, si.getId(), "");
            this.writeSegmentInfo(output, si);
            CodecUtil.INSTANCE.writeFooter(output);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void writeSegmentInfo(DataOutput output, SegmentInfo si) throws IOException {
        SortField[] indexSort;
        Version version = si.getVersion();
        if (!(version.getMajor() >= 7)) {
            boolean $i$a$-require-Lucene99SegmentInfoFormat$writeSegmentInfo$32 = false;
            String $i$a$-require-Lucene99SegmentInfoFormat$writeSegmentInfo$32 = "invalid major version: should be >= 7 but got: " + version.getMajor() + " segment=" + si;
            throw new IllegalArgumentException($i$a$-require-Lucene99SegmentInfoFormat$writeSegmentInfo$32.toString());
        }
        output.writeInt(version.getMajor());
        output.writeInt(version.getMinor());
        output.writeInt(version.getBugfix());
        if (si.getMinVersion() != null) {
            output.writeByte((byte)1);
            Version version2 = si.getMinVersion();
            Intrinsics.checkNotNull((Object)version2);
            Version minVersion = version2;
            output.writeInt(minVersion.getMajor());
            output.writeInt(minVersion.getMinor());
            output.writeInt(minVersion.getBugfix());
        } else {
            output.writeByte((byte)0);
        }
        if (!(version.getPrerelease() == 0)) {
            String $i$a$-require-Lucene99SegmentInfoFormat$writeSegmentInfo$32 = "Failed requirement.";
            throw new IllegalArgumentException($i$a$-require-Lucene99SegmentInfoFormat$writeSegmentInfo$32.toString());
        }
        output.writeInt(si.maxDoc());
        output.writeByte((byte)(si.getUseCompoundFile() ? 1 : -1));
        output.writeByte((byte)(si.getHasBlocks() ? 1 : -1));
        output.writeMapOfStrings(si.getDiagnostics());
        Set<String> files = si.files();
        for (String file : files) {
            if (Intrinsics.areEqual((Object)IndexFileNames.INSTANCE.parseSegmentName(file), (Object)si.getName())) continue;
            boolean $i$a$-require-Lucene99SegmentInfoFormat$writeSegmentInfo$42 = false;
            String $i$a$-require-Lucene99SegmentInfoFormat$writeSegmentInfo$42 = "invalid files: expected segment=" + si.getName() + ", got=" + files;
            throw new IllegalArgumentException($i$a$-require-Lucene99SegmentInfoFormat$writeSegmentInfo$42.toString());
        }
        output.writeSetOfStrings(files);
        output.writeMapOfStrings(si.getAttributes());
        SortField[] sortFieldArray = indexSort = si.getIndexSort();
        int numSortFields = indexSort != null && (sortFieldArray = sortFieldArray.getSort()) != null ? sortFieldArray.length : 0;
        output.writeVInt(numSortFields);
        for (int i = 0; i < numSortFields; ++i) {
            Intrinsics.checkNotNull((Object)indexSort);
            SortField sortField = indexSort.getSort()[i];
            IndexSorter sorter2 = sortField.getIndexSorter();
            if (sorter2 == null) {
                boolean bl = false;
                String string = "cannot serialize SortField " + sortField;
                throw new IllegalArgumentException(string.toString());
            }
            output.writeString(sorter2.getProviderName());
            SortFieldProvider.Companion.write(sortField, output);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99SegmentInfoFormat$Companion;", "", "<init>", "()V", "SI_EXTENSION", "", "CODEC_NAME", "VERSION_START", "", "VERSION_CURRENT", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

