/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.perfield;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.FieldsProducer;
import org.gnit.lucenekmp.index.DocValuesType;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.MergeState;
import org.gnit.lucenekmp.index.Terms;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\n\u000bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/codecs/perfield/PerFieldMergeState;", "", "<init>", "()V", "restrictFields", "Lorg/gnit/lucenekmp/index/MergeState;", "in", "fields", "", "", "FilterFieldInfos", "FilterFieldsProducer", "core"})
public final class PerFieldMergeState {
    @NotNull
    public static final PerFieldMergeState INSTANCE = new PerFieldMergeState();

    private PerFieldMergeState() {
    }

    @NotNull
    public final MergeState restrictFields(@NotNull MergeState in, @NotNull Collection<String> fields) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        FieldInfos[] fieldInfos = new FieldInfos[in.getFieldInfos().length];
        int n = in.getFieldInfos().length;
        for (int i = 0; i < n; ++i) {
            FieldInfos fieldInfos2 = in.getFieldInfos()[i];
            Intrinsics.checkNotNull((Object)fieldInfos2);
            fieldInfos[i] = new FilterFieldInfos(fieldInfos2, fields);
        }
        FieldsProducer[] fieldsProducers = new FieldsProducer[in.getFieldsProducers().length];
        int n2 = in.getFieldsProducers().length;
        for (int i = 0; i < n2; ++i) {
            FilterFieldsProducer filterFieldsProducer;
            if (in.getFieldsProducers()[i] == null) {
                filterFieldsProducer = null;
            } else {
                FieldsProducer fieldsProducer = in.getFieldsProducers()[i];
                Intrinsics.checkNotNull((Object)fieldsProducer);
                filterFieldsProducer = new FilterFieldsProducer(fieldsProducer, fields);
            }
            fieldsProducers[i] = filterFieldsProducer;
        }
        FieldInfos fieldInfos3 = in.getMergeFieldInfos();
        Intrinsics.checkNotNull((Object)fieldInfos3);
        FilterFieldInfos mergeFieldInfos = new FilterFieldInfos(fieldInfos3, fields);
        MergeState.DocMap[] docMapArray = in.getDocMaps();
        Intrinsics.checkNotNull((Object)docMapArray);
        return new MergeState(docMapArray, in.getSegmentInfo(), mergeFieldInfos, in.getStoredFieldsReaders(), in.getTermVectorsReaders(), in.getNormsProducers(), in.getDocValuesProducers(), fieldInfos, in.getLiveDocs(), fieldsProducers, in.getPointsReaders(), in.getKnnVectorsReaders(), in.getMaxDocs(), in.getInfoStream(), in.getIntraMergeTaskExecutor(), in.getNeedsIndexSort());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010)\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u0000 '2\u00020\u0001:\u0001'B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u000eH\u0016J\b\u0010\u001a\u001a\u00020\u000eH\u0016J\b\u0010\u001b\u001a\u00020\u000eH\u0016J\b\u0010\u001c\u001a\u00020\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u000eH\u0016J\b\u0010\u001e\u001a\u00020\u000eH\u0016J\b\u0010\u001f\u001a\u00020\u000eH\u0016J\b\u0010 \u001a\u00020\u000eH\u0016J\b\u0010!\u001a\u00020\u000eH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0014\u0010$\u001a\u0004\u0018\u00010\f2\b\u0010%\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010$\u001a\u00020\f2\u0006\u0010&\u001a\u00020#H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/gnit/lucenekmp/codecs/perfield/PerFieldMergeState$FilterFieldInfos;", "Lorg/gnit/lucenekmp/index/FieldInfos;", "src", "filterFields", "", "", "<init>", "(Lorg/gnit/lucenekmp/index/FieldInfos;Ljava/util/Collection;)V", "filteredNames", "", "filtered", "", "Lorg/gnit/lucenekmp/index/FieldInfo;", "filteredHasVectors", "", "filteredHasPostings", "filteredHasProx", "filteredHasPayloads", "filteredHasOffsets", "filteredHasFreq", "filteredHasNorms", "filteredHasDocValues", "filteredHasPointValues", "iterator", "", "hasFreq", "hasPostings", "hasProx", "hasPayloads", "hasOffsets", "hasTermVectors", "hasNorms", "hasDocValues", "hasPointValues", "size", "", "fieldInfo", "fieldName", "fieldNumber", "Companion", "core"})
    private static final class FilterFieldInfos
    extends FieldInfos {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Set<String> filteredNames;
        @NotNull
        private final List<FieldInfo> filtered;
        private final boolean filteredHasVectors;
        private final boolean filteredHasPostings;
        private final boolean filteredHasProx;
        private final boolean filteredHasPayloads;
        private final boolean filteredHasOffsets;
        private final boolean filteredHasFreq;
        private final boolean filteredHasNorms;
        private final boolean filteredHasDocValues;
        private final boolean filteredHasPointValues;

        public FilterFieldInfos(@NotNull FieldInfos src, @NotNull Collection<String> filterFields) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter(filterFields, (String)"filterFields");
            super(FilterFieldInfos.Companion.toArray(src));
            boolean hasVectors = false;
            boolean hasPostings = false;
            boolean hasProx = false;
            boolean hasPayloads = false;
            boolean hasOffsets = false;
            boolean hasFreq = false;
            boolean hasNorms = false;
            boolean hasDocValues = false;
            boolean hasPointValues = false;
            this.filteredNames = new HashSet<String>(filterFields);
            this.filtered = new ArrayList(filterFields.size());
            for (FieldInfo fi : src) {
                if (!((HashSet)this.filteredNames).contains(fi.getName())) continue;
                ((ArrayList)this.filtered).add(fi);
                hasVectors |= fi.hasTermVectors();
                hasPostings |= fi.getIndexOptions() != IndexOptions.NONE;
                hasProx |= fi.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
                hasFreq |= fi.getIndexOptions() != IndexOptions.DOCS;
                hasOffsets |= fi.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
                hasNorms |= fi.hasNorms();
                hasDocValues |= fi.getDocValuesType() != DocValuesType.NONE;
                hasPayloads |= fi.hasPayloads();
                hasPointValues |= fi.getPointDimensionCount() != 0;
            }
            this.filteredHasVectors = hasVectors;
            this.filteredHasPostings = hasPostings;
            this.filteredHasProx = hasProx;
            this.filteredHasPayloads = hasPayloads;
            this.filteredHasOffsets = hasOffsets;
            this.filteredHasFreq = hasFreq;
            this.filteredHasNorms = hasNorms;
            this.filteredHasDocValues = hasDocValues;
            this.filteredHasPointValues = hasPointValues;
        }

        @Override
        @NotNull
        public Iterator<FieldInfo> iterator() {
            return this.filtered.iterator();
        }

        @Override
        public boolean hasFreq() {
            return this.filteredHasFreq;
        }

        @Override
        public boolean hasPostings() {
            return this.filteredHasPostings;
        }

        @Override
        public boolean hasProx() {
            return this.filteredHasProx;
        }

        @Override
        public boolean hasPayloads() {
            return this.filteredHasPayloads;
        }

        @Override
        public boolean hasOffsets() {
            return this.filteredHasOffsets;
        }

        @Override
        public boolean hasTermVectors() {
            return this.filteredHasVectors;
        }

        @Override
        public boolean hasNorms() {
            return this.filteredHasNorms;
        }

        @Override
        public boolean hasDocValues() {
            return this.filteredHasDocValues;
        }

        @Override
        public boolean hasPointValues() {
            return this.filteredHasPointValues;
        }

        @Override
        public int size() {
            return this.filtered.size();
        }

        @Override
        @Nullable
        public FieldInfo fieldInfo(@Nullable String fieldName) {
            if (!CollectionsKt.contains((Iterable)this.filteredNames, (Object)fieldName)) {
                boolean bl = false;
                String string = "The field named '" + fieldName + "' is not accessible in the current merge context, available ones are: " + this.filteredNames;
                throw new IllegalArgumentException(string.toString());
            }
            return super.fieldInfo(fieldName);
        }

        @Override
        @NotNull
        public FieldInfo fieldInfo(int fieldNumber) {
            FieldInfo fieldInfo = super.fieldInfo(fieldNumber);
            Intrinsics.checkNotNull((Object)fieldInfo);
            FieldInfo res = fieldInfo;
            if (!this.filteredNames.contains(res.getName())) {
                boolean bl = false;
                String string = "The field named '" + res.getName() + "' numbered '" + fieldNumber + "' is not accessible in the current merge context, available ones are: " + this.filteredNames;
                throw new IllegalArgumentException(string.toString());
            }
            return res;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/codecs/perfield/PerFieldMergeState$FilterFieldInfos$Companion;", "", "<init>", "()V", "toArray", "", "Lorg/gnit/lucenekmp/index/FieldInfo;", "src", "Lorg/gnit/lucenekmp/index/FieldInfos;", "(Lorg/gnit/lucenekmp/index/FieldInfos;)[Lorg/gnit/lucenekmp/index/FieldInfo;", "core"})
        public static final class Companion {
            private Companion() {
            }

            private final FieldInfo[] toArray(FieldInfos src) {
                FieldInfo[] res = new FieldInfo[src.size()];
                int i = 0;
                for (FieldInfo fi : src) {
                    res[i++] = fi;
                }
                return res;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0096\u0002J\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/codecs/perfield/PerFieldMergeState$FilterFieldsProducer;", "Lorg/gnit/lucenekmp/codecs/FieldsProducer;", "in", "filterFields", "", "", "<init>", "(Lorg/gnit/lucenekmp/codecs/FieldsProducer;Ljava/util/Collection;)V", "filtered", "", "iterator", "", "terms", "Lorg/gnit/lucenekmp/index/Terms;", "field", "size", "", "close", "", "checkIntegrity", "core"})
    private static final class FilterFieldsProducer
    extends FieldsProducer {
        @NotNull
        private final FieldsProducer in;
        @NotNull
        private final List<String> filtered;

        public FilterFieldsProducer(@NotNull FieldsProducer in, @NotNull Collection<String> filterFields) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Intrinsics.checkNotNullParameter(filterFields, (String)"filterFields");
            this.in = in;
            this.filtered = new ArrayList<String>(filterFields);
        }

        @Override
        @NotNull
        public Iterator<String> iterator() {
            return this.filtered.iterator();
        }

        @Override
        @Nullable
        public Terms terms(@Nullable String field) throws IOException {
            if (!CollectionsKt.contains((Iterable)this.filtered, (Object)field)) {
                boolean bl = false;
                String string = "The field named '" + field + "' is not accessible in the current merge context, available ones are: " + this.filtered;
                throw new IllegalArgumentException(string.toString());
            }
            return this.in.terms(field);
        }

        @Override
        public int size() {
            return this.filtered.size();
        }

        @Override
        public void close() {
            this.in.close();
        }

        @Override
        public void checkIntegrity() throws IOException {
            this.in.checkIntegrity();
        }
    }
}

