/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.document;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.document.Field;
import org.gnit.lucenekmp.document.FieldType;
import org.gnit.lucenekmp.index.IndexableFieldType;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.search.MatchNoDocsQuery;
import org.gnit.lucenekmp.search.PointInSetQuery;
import org.gnit.lucenekmp.search.PointRangeQuery;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.util.BytesRef;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0007\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/document/BinaryPoint;", "Lorg/gnit/lucenekmp/document/Field;", "name", "", "point", "", "", "<init>", "(Ljava/lang/String;[[B)V", "packedPoint", "type", "Lorg/gnit/lucenekmp/index/IndexableFieldType;", "(Ljava/lang/String;[BLorg/gnit/lucenekmp/index/IndexableFieldType;)V", "Companion", "core"})
public final class BinaryPoint
extends Field {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public BinaryPoint(@NotNull String name, @NotNull byte[][] point) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        super(name, BinaryPoint.Companion.pack((byte[][])Arrays.copyOf((Object[])point, ((Object[])point).length)), (IndexableFieldType)BinaryPoint.Companion.getType(point));
    }

    public BinaryPoint(@NotNull String name, @NotNull byte[] packedPoint, @NotNull IndexableFieldType type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)packedPoint, (String)"packedPoint");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        super(name, packedPoint, type);
        if (!(packedPoint.length == type.pointDimensionCount() * type.pointNumBytes())) {
            boolean bl = false;
            String string = "packedPoint is length=" + packedPoint.length + " but type.pointDimensionCount()=" + type.pointDimensionCount() + " and type.pointNumBytes()=" + type.pointNumBytes();
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J!\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bJ\u001e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bJ/\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\u0018J!\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/document/BinaryPoint$Companion;", "", "<init>", "()V", "getType", "Lorg/gnit/lucenekmp/document/FieldType;", "point", "", "", "([[B)Lorg/gnit/lucenekmp/document/FieldType;", "numDims", "", "bytesPerDim", "pack", "Lorg/gnit/lucenekmp/util/BytesRef;", "([[B)Lorg/gnit/lucenekmp/util/BytesRef;", "newExactQuery", "Lorg/gnit/lucenekmp/search/Query;", "field", "", "value", "newRangeQuery", "lowerValue", "upperValue", "(Ljava/lang/String;[[B[[B)Lorg/gnit/lucenekmp/search/Query;", "newSetQuery", "values", "(Ljava/lang/String;[[B)Lorg/gnit/lucenekmp/search/Query;", "core"})
    @SourceDebugExtension(value={"SMAP\nBinaryPoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BinaryPoint.kt\norg/gnit/lucenekmp/document/BinaryPoint$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,251:1\n1#2:252\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final FieldType getType(byte[][] point) {
            byte[][] byArray = point;
            if (point == null) {
                boolean $i$a$-requireNotNull-BinaryPoint$Companion$getType$22 = false;
                String $i$a$-requireNotNull-BinaryPoint$Companion$getType$22 = "point must not be null";
                throw new IllegalArgumentException($i$a$-requireNotNull-BinaryPoint$Companion$getType$22.toString());
            }
            if (!(!(((Object[])point).length == 0))) {
                boolean $i$a$-require-BinaryPoint$Companion$getType$32 = false;
                String $i$a$-require-BinaryPoint$Companion$getType$32 = "point must not be 0 dimensions";
                throw new IllegalArgumentException($i$a$-require-BinaryPoint$Companion$getType$32.toString());
            }
            int bytesPerDim = 0;
            bytesPerDim = -1;
            int n = ((Object[])point).length;
            for (int i = 0; i < n; ++i) {
                byte[] oneDim;
                byte[] byArray2 = oneDim = point[i];
                if (oneDim == null) {
                    boolean bl = false;
                    String string = "point must not have null values";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!(!(oneDim.length == 0))) {
                    boolean $i$a$-require-BinaryPoint$Companion$getType$62 = false;
                    String $i$a$-require-BinaryPoint$Companion$getType$62 = "point must not have 0-length values";
                    throw new IllegalArgumentException($i$a$-require-BinaryPoint$Companion$getType$62.toString());
                }
                if (bytesPerDim == -1) {
                    bytesPerDim = oneDim.length;
                    continue;
                }
                if (bytesPerDim == oneDim.length) continue;
                boolean bl = false;
                String string = "all dimensions must have same bytes length; got " + bytesPerDim + " and " + oneDim.length;
                throw new IllegalArgumentException(string.toString());
            }
            return this.getType(((Object[])point).length, bytesPerDim);
        }

        private final FieldType getType(int numDims, int bytesPerDim) {
            FieldType type = new FieldType();
            type.setDimensions(numDims, bytesPerDim);
            type.freeze();
            return type;
        }

        private final BytesRef pack(byte[] ... point) {
            byte[][] byArray = point;
            if (point == null) {
                boolean $i$a$-requireNotNull-BinaryPoint$Companion$pack$22 = false;
                String $i$a$-requireNotNull-BinaryPoint$Companion$pack$22 = "point must not be null";
                throw new IllegalArgumentException($i$a$-requireNotNull-BinaryPoint$Companion$pack$22.toString());
            }
            if (!(!(((Object[])point).length == 0))) {
                boolean $i$a$-require-BinaryPoint$Companion$pack$32 = false;
                String $i$a$-require-BinaryPoint$Companion$pack$32 = "point must not be 0 dimensions";
                throw new IllegalArgumentException($i$a$-require-BinaryPoint$Companion$pack$32.toString());
            }
            if (((Object[])point).length == 1) {
                return new BytesRef(point[0]);
            }
            int bytesPerDim = 0;
            bytesPerDim = -1;
            int n = ((Object[])point).length;
            for (int $i$a$-require-BinaryPoint$Companion$pack$32 = 0; $i$a$-require-BinaryPoint$Companion$pack$32 < n; ++$i$a$-require-BinaryPoint$Companion$pack$32) {
                byte[] dim;
                byte[] byArray2 = dim = point[$i$a$-require-BinaryPoint$Companion$pack$32];
                if (dim == null) {
                    boolean bl = false;
                    String string = "point must not have null values";
                    throw new IllegalArgumentException(string.toString());
                }
                if (bytesPerDim == -1) {
                    if (!(!(dim.length == 0))) {
                        boolean $i$a$-require-BinaryPoint$Companion$pack$62 = false;
                        String $i$a$-require-BinaryPoint$Companion$pack$62 = "point must not have 0-length values";
                        throw new IllegalArgumentException($i$a$-require-BinaryPoint$Companion$pack$62.toString());
                    }
                    bytesPerDim = dim.length;
                    continue;
                }
                if (dim.length == bytesPerDim) continue;
                boolean bl = false;
                String string = "all dimensions must have same bytes length; got " + bytesPerDim + " and " + dim.length;
                throw new IllegalArgumentException(string.toString());
            }
            byte[] packed = new byte[bytesPerDim * ((Object[])point).length];
            int n2 = ((Object[])point).length;
            for (int i = 0; i < n2; ++i) {
                System.INSTANCE.arraycopy(point[i], 0, packed, i * bytesPerDim, bytesPerDim);
            }
            return new BytesRef(packed);
        }

        @NotNull
        public final Query newExactQuery(@NotNull String field, @NotNull byte[] value) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.newRangeQuery(field, value, value);
        }

        @NotNull
        public final Query newRangeQuery(@NotNull String field, @NotNull byte[] lowerValue, @NotNull byte[] upperValue) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)lowerValue, (String)"lowerValue");
            Intrinsics.checkNotNullParameter((Object)upperValue, (String)"upperValue");
            PointRangeQuery.Companion.checkArgs(field, lowerValue, upperValue);
            byte[][] byArrayArray = new byte[][]{lowerValue};
            byte[][] byArrayArray2 = byArrayArray;
            byArrayArray = new byte[][]{upperValue};
            return this.newRangeQuery(field, byArrayArray2, byArrayArray);
        }

        @NotNull
        public final Query newRangeQuery(@NotNull String field, @NotNull byte[][] lowerValue, @NotNull byte[][] upperValue) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)lowerValue, (String)"lowerValue");
            Intrinsics.checkNotNullParameter((Object)upperValue, (String)"upperValue");
            byte[] byArray = Companion.pack((byte[][])Arrays.copyOf((Object[])lowerValue, ((Object[])lowerValue).length)).getBytes();
            byte[] byArray2 = Companion.pack((byte[][])Arrays.copyOf((Object[])upperValue, ((Object[])upperValue).length)).getBytes();
            int n = ((Object[])lowerValue).length;
            return new PointRangeQuery(field, byArray, byArray2, n){

                protected String toString(int dimension, byte[] value) {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    StringBuilder sb = new StringBuilder();
                    sb.append("binary(");
                    int n = value.length;
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            sb.append(' ');
                        }
                        sb.append(IntExtKt.toHexString(IntCompanionObject.INSTANCE, value[i] & 0xFF));
                    }
                    sb.append(')');
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    return string;
                }
            };
        }

        @NotNull
        public final Query newSetQuery(@NotNull String field, @NotNull byte[][] values2) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            Ref.IntRef bytesPerDim = new Ref.IntRef();
            bytesPerDim.element = -1;
            int n = ((Object[])values2).length;
            for (int i = 0; i < n; ++i) {
                byte[] value = values2[i];
                if (bytesPerDim.element == -1) {
                    bytesPerDim.element = value.length;
                    continue;
                }
                if (value.length == bytesPerDim.element) continue;
                boolean bl = false;
                String string = "all byte[] must be the same length, but saw " + bytesPerDim.element + " and " + value.length;
                throw new IllegalArgumentException(string.toString());
            }
            if (bytesPerDim.element == -1) {
                return new MatchNoDocsQuery("empty BinaryPoint.newSetQuery");
            }
            Object[] objectArray = (Object[])values2;
            Object[] objectArray2 = Arrays.copyOf(objectArray, objectArray.length);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(...)");
            byte[][] sortedValues = (byte[][])objectArray2;
            org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.sort((Object[])sortedValues, Companion::newSetQuery$lambda$11);
            BytesRef encoded = new BytesRef(new byte[bytesPerDim.element]);
            PointInSetQuery.Stream stream = new PointInSetQuery.Stream(sortedValues, encoded){
                private int upto;
                final /* synthetic */ byte[][] $sortedValues;
                final /* synthetic */ BytesRef $encoded;
                {
                    this.$sortedValues = $sortedValues;
                    this.$encoded = $encoded;
                }

                public final int getUpto() {
                    return this.upto;
                }

                public final void setUpto(int n) {
                    this.upto = n;
                }

                public BytesRef next() {
                    if (this.upto == ((Object[])this.$sortedValues).length) {
                        return null;
                    }
                    this.$encoded.setBytes(this.$sortedValues[this.upto]);
                    int n = this.upto;
                    this.upto = n + 1;
                    return this.$encoded;
                }
            };
            return new PointInSetQuery(field, bytesPerDim, stream){

                protected String toString(byte[] value) {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    return new BytesRef(value).toString();
                }
            };
        }

        private static final int newSetQuery$lambda$11(byte[] a, byte[] b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.compareUnsigned(a, 0, a.length, b, 0, b.length);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

