/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.document;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.Instant;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.Month;
import kotlinx.datetime.MonthKt;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.gnit.lucenekmp.jdkport.ParseException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001'B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\tJ\u0016\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001c\u0010\u001f\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001c\u0010 \u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001eH\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001eH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006("}, d2={"Lorg/gnit/lucenekmp/document/DateTools;", "", "<init>", "()V", "GMT", "Lkotlinx/datetime/TimeZone;", "getGMT", "()Lkotlinx/datetime/TimeZone;", "dateToString", "", "date", "Lkotlin/time/Instant;", "resolution", "Lorg/gnit/lucenekmp/document/DateTools$Resolution;", "timeToString", "time", "", "stringToTime", "dateString", "stringToDate", "round", "buildSortable", "ldt", "Lkotlinx/datetime/LocalDateTime;", "append2", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "v", "", "append3", "append4", "daysInMonth", "year", "month", "isLeap", "", "y", "Resolution", "core"})
@SourceDebugExtension(value={"SMAP\nDateTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateTools.kt\norg/gnit/lucenekmp/document/DateTools\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n1#2:221\n*E\n"})
public final class DateTools {
    @NotNull
    public static final DateTools INSTANCE = new DateTools();
    @NotNull
    private static final TimeZone GMT = (TimeZone)TimeZone.Companion.getUTC();

    private DateTools() {
    }

    @NotNull
    public final TimeZone getGMT() {
        return GMT;
    }

    @NotNull
    public final String dateToString(@NotNull Instant date, @NotNull Resolution resolution) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)resolution), (String)"resolution");
        return this.timeToString(date.toEpochMilliseconds(), resolution);
    }

    @NotNull
    public final String timeToString(long time, @NotNull Resolution resolution) {
        Intrinsics.checkNotNullParameter((Object)((Object)resolution), (String)"resolution");
        LocalDateTime date = TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(time), (TimeZone)GMT);
        String full = this.buildSortable(date);
        return StringsKt.take((String)full, (int)resolution.getFormatLen());
    }

    public final long stringToTime(@NotNull String dateString) throws ParseException {
        Intrinsics.checkNotNullParameter((Object)dateString, (String)"dateString");
        int n = dateString.length();
        if (!(4 <= n ? n < 18 : false)) {
            boolean $i$a$-require-DateTools$stringToTime$22 = false;
            String $i$a$-require-DateTools$stringToTime$22 = "Invalid date string length: " + n;
            throw new IllegalArgumentException($i$a$-require-DateTools$stringToTime$22.toString());
        }
        String full = dateString + StringsKt.repeat((CharSequence)"0", (int)(17 - n));
        int y = Integer.parseInt(StringsKt.take((String)full, (int)4));
        String string = full.substring(4, 6);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        int M = RangesKt.coerceIn((int)Integer.parseInt(string), (int)1, (int)12);
        String string2 = full.substring(6, 8);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        int d = RangesKt.coerceAtLeast((int)Integer.parseInt(string2), (int)1);
        String string3 = full.substring(8, 10);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        int h = Integer.parseInt(string3);
        String string4 = full.substring(10, 12);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        int m = Integer.parseInt(string4);
        String string5 = full.substring(12, 14);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        int s = Integer.parseInt(string5);
        String string6 = full.substring(14, 17);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
        int ms = Integer.parseInt(string6);
        int day = RangesKt.coerceAtMost((int)d, (int)this.daysInMonth(y, M));
        LocalDateTime ldt = new LocalDateTime(y, M, day, h, m, s, ms * 1000000);
        return TimeZoneKt.toInstant$default((LocalDateTime)ldt, (TimeZone)GMT, null, (int)2, null).toEpochMilliseconds();
    }

    @NotNull
    public final Instant stringToDate(@NotNull String dateString) throws ParseException {
        Intrinsics.checkNotNullParameter((Object)dateString, (String)"dateString");
        try {
            return Instant.Companion.fromEpochMilliseconds(this.stringToTime(dateString));
        }
        catch (Exception e) {
            ParseException ex = new ParseException("Input is not a valid date string: " + dateString, 0);
            ex.initCause(e);
            throw ex;
        }
    }

    @NotNull
    public final Instant round(@NotNull Instant date, @NotNull Resolution resolution) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)resolution), (String)"resolution");
        return Instant.Companion.fromEpochMilliseconds(this.round(date.toEpochMilliseconds(), resolution));
    }

    public final long round(long time, @NotNull Resolution resolution) {
        Intrinsics.checkNotNullParameter((Object)((Object)resolution), (String)"resolution");
        LocalDateTime ldt = TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(time), (TimeZone)GMT);
        LocalDateTime floored = switch (WhenMappings.$EnumSwitchMapping$0[resolution.ordinal()]) {
            case 1 -> new LocalDateTime(ldt.getYear(), 1, 1, 0, 0, 0, 0);
            case 2 -> new LocalDateTime(ldt.getYear(), MonthKt.getNumber((Month)ldt.getMonth()), 1, 0, 0, 0, 0);
            case 3 -> new LocalDateTime(ldt.getYear(), MonthKt.getNumber((Month)ldt.getMonth()), ldt.getDay(), 0, 0, 0, 0);
            case 4 -> new LocalDateTime(ldt.getYear(), MonthKt.getNumber((Month)ldt.getMonth()), ldt.getDay(), ldt.getHour(), 0, 0, 0);
            case 5 -> new LocalDateTime(ldt.getYear(), MonthKt.getNumber((Month)ldt.getMonth()), ldt.getDay(), ldt.getHour(), ldt.getMinute(), 0, 0);
            case 6 -> new LocalDateTime(ldt.getYear(), MonthKt.getNumber((Month)ldt.getMonth()), ldt.getDay(), ldt.getHour(), ldt.getMinute(), ldt.getSecond(), 0);
            case 7 -> new LocalDateTime(ldt.getYear(), MonthKt.getNumber((Month)ldt.getMonth()), ldt.getDay(), ldt.getHour(), ldt.getMinute(), ldt.getSecond(), ldt.getNanosecond() / 1000000 * 1000000);
            default -> throw new NoWhenBranchMatchedException();
        };
        return TimeZoneKt.toInstant$default((LocalDateTime)floored, (TimeZone)GMT, null, (int)2, null).toEpochMilliseconds();
    }

    private final String buildSortable(LocalDateTime ldt) {
        StringBuilder sb = new StringBuilder(17);
        this.append4(sb, ldt.getYear());
        this.append2(sb, MonthKt.getNumber((Month)ldt.getMonth()));
        this.append2(sb, ldt.getDay());
        this.append2(sb, ldt.getHour());
        this.append2(sb, ldt.getMinute());
        this.append2(sb, ldt.getSecond());
        this.append3(sb, ldt.getNanosecond() / 1000000);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void append2(StringBuilder sb, int v) {
        if (v < 10) {
            sb.append('0');
        }
        sb.append(v);
    }

    private final void append3(StringBuilder sb, int v) {
        StringBuilder stringBuilder = v < 10 ? sb.append("00").append(v) : (v < 100 ? sb.append('0').append(v) : sb.append(v));
    }

    private final void append4(StringBuilder sb, int v) {
        String s = String.valueOf(v);
        int n = 4 - s.length();
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            sb.append('0');
        }
        sb.append(s);
    }

    private final int daysInMonth(int year, int month) {
        return switch (month) {
            case 1, 3, 5, 7, 8, 10, 12 -> 31;
            case 4, 6, 9, 11 -> 30;
            case 2 -> {
                if (this.isLeap(year)) {
                    yield 29;
                }
                yield 28;
            }
            default -> 30;
        };
    }

    private final boolean isLeap(int y) {
        return y % 4 == 0 && (y % 100 != 0 || y % 400 == 0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/document/DateTools$Resolution;", "", "formatLen", "", "<init>", "(Ljava/lang/String;II)V", "getFormatLen", "()I", "YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "MILLISECOND", "toString", "", "core"})
    public static final class Resolution
    extends Enum<Resolution> {
        private final int formatLen;
        public static final /* enum */ Resolution YEAR = new Resolution(4);
        public static final /* enum */ Resolution MONTH = new Resolution(6);
        public static final /* enum */ Resolution DAY = new Resolution(8);
        public static final /* enum */ Resolution HOUR = new Resolution(10);
        public static final /* enum */ Resolution MINUTE = new Resolution(12);
        public static final /* enum */ Resolution SECOND = new Resolution(14);
        public static final /* enum */ Resolution MILLISECOND = new Resolution(17);
        private static final /* synthetic */ Resolution[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Resolution(int formatLen) {
            this.formatLen = formatLen;
        }

        public final int getFormatLen() {
            return this.formatLen;
        }

        @NotNull
        public String toString() {
            String string = super.toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return string;
        }

        public static Resolution[] values() {
            return (Resolution[])$VALUES.clone();
        }

        public static Resolution valueOf(String value) {
            return Enum.valueOf(Resolution.class, value);
        }

        @NotNull
        public static EnumEntries<Resolution> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = resolutionArray = new Resolution[]{Resolution.YEAR, Resolution.MONTH, Resolution.DAY, Resolution.HOUR, Resolution.MINUTE, Resolution.SECOND, Resolution.MILLISECOND};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Resolution.values().length];
            try {
                nArray[Resolution.YEAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Resolution.MONTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Resolution.DAY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Resolution.HOUR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Resolution.MINUTE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Resolution.SECOND.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Resolution.MILLISECOND.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

