/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.gnit.lucenekmp.index.IndexableField;
import org.gnit.lucenekmp.util.BytesRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010)\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0096\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0019\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0017J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006J\u001b\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00112\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0019J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\b\u0010\u001b\u001a\u00020\u000eH\u0016J\u0006\u0010\u001c\u001a\u00020\nR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/gnit/lucenekmp/document/Document;", "", "Lorg/gnit/lucenekmp/index/IndexableField;", "<init>", "()V", "fields", "", "iterator", "", "add", "", "field", "removeField", "name", "", "removeFields", "getBinaryValues", "", "Lorg/gnit/lucenekmp/util/BytesRef;", "(Ljava/lang/String;)[Lorg/gnit/lucenekmp/util/BytesRef;", "getBinaryValue", "getField", "getFields", "(Ljava/lang/String;)[Lorg/gnit/lucenekmp/index/IndexableField;", "getValues", "(Ljava/lang/String;)[Ljava/lang/String;", "get", "toString", "clear", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDocument.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Document.kt\norg/gnit/lucenekmp/document/Document\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,234:1\n37#2:235\n36#2,3:236\n37#2:239\n36#2,3:240\n37#2:243\n36#2,3:244\n*S KotlinDebug\n*F\n+ 1 Document.kt\norg/gnit/lucenekmp/document/Document\n*L\n104#1:235\n104#1:236,3\n155#1:239\n155#1:240,3\n191#1:243\n191#1:244,3\n*E\n"})
public final class Document
implements Iterable<IndexableField>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<IndexableField> fields = new ArrayList();
    @NotNull
    private static final String[] NO_STRINGS = new String[0];

    @Override
    @NotNull
    public Iterator<IndexableField> iterator() {
        return this.fields.iterator();
    }

    public final void add(@NotNull IndexableField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.fields.add(field);
    }

    public final void removeField(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterator<IndexableField> it = this.fields.iterator();
        while (it.hasNext()) {
            IndexableField field = it.next();
            if (!Intrinsics.areEqual((Object)field.name(), (Object)name)) continue;
            it.remove();
            return;
        }
    }

    public final void removeFields(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterator<IndexableField> it = this.fields.iterator();
        while (it.hasNext()) {
            IndexableField field = it.next();
            if (!Intrinsics.areEqual((Object)field.name(), (Object)name)) continue;
            it.remove();
        }
    }

    @NotNull
    public final BytesRef[] getBinaryValues(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List result = new ArrayList();
        for (IndexableField field : this.fields) {
            BytesRef bytes;
            if (!Intrinsics.areEqual((Object)field.name(), (Object)name) || (bytes = field.binaryValue()) == null) continue;
            result.add(bytes);
        }
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new BytesRef[0]);
    }

    @Nullable
    public final BytesRef getBinaryValue(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        for (IndexableField field : this.fields) {
            BytesRef bytes;
            if (!Intrinsics.areEqual((Object)field.name(), (Object)name) || (bytes = field.binaryValue()) == null) continue;
            return bytes;
        }
        return null;
    }

    @Nullable
    public final IndexableField getField(@Nullable String name) {
        for (IndexableField field : this.fields) {
            if (!Intrinsics.areEqual((Object)field.name(), (Object)name)) continue;
            return field;
        }
        return null;
    }

    @NotNull
    public final IndexableField[] getFields(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List result = new ArrayList();
        for (IndexableField field : this.fields) {
            if (!Intrinsics.areEqual((Object)field.name(), (Object)name)) continue;
            result.add(field);
        }
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new IndexableField[0]);
    }

    @NotNull
    public final List<IndexableField> getFields() {
        return this.fields;
    }

    @NotNull
    public final String[] getValues(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List result = new ArrayList();
        for (IndexableField field : this.fields) {
            if (!Intrinsics.areEqual((Object)field.name(), (Object)name) || field.stringValue() == null) continue;
            String string = field.stringValue();
            Intrinsics.checkNotNull((Object)string);
            result.add(string);
        }
        if (result.isEmpty()) {
            return NO_STRINGS;
        }
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @Nullable
    public final String get(@Nullable String name) {
        for (IndexableField field : this.fields) {
            if (!Intrinsics.areEqual((Object)field.name(), (Object)name) || field.stringValue() == null) continue;
            return field.stringValue();
        }
        return null;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Document<");
        int n = ((Collection)this.fields).size();
        for (int i = 0; i < n; ++i) {
            IndexableField field = this.fields.get(i);
            buffer.append(field.toString());
            if (i == this.fields.size() - 1) continue;
            buffer.append(" ");
        }
        buffer.append(">");
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final void clear() {
        this.fields.clear();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/document/Document$Companion;", "", "<init>", "()V", "NO_STRINGS", "", "", "[Ljava/lang/String;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

