/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.document;

import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.document.Field;
import org.gnit.lucenekmp.document.FieldType;
import org.gnit.lucenekmp.index.IndexableFieldType;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.search.PointInSetQuery;
import org.gnit.lucenekmp.search.PointRangeQuery;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.NumericUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00020\u0005\"\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0012\u0010\f\u001a\u00020\n2\n\u0010\u0004\u001a\u00020\u0005\"\u00020\u0006J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/document/FloatPoint;", "Lorg/gnit/lucenekmp/document/Field;", "name", "", "point", "", "", "<init>", "(Ljava/lang/String;[F)V", "setFloatValue", "", "value", "setFloatValues", "setBytesValue", "bytes", "Lorg/gnit/lucenekmp/util/BytesRef;", "numericValue", "", "toString", "Companion", "core"})
public final class FloatPoint
extends Field {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public FloatPoint(@NotNull String name, float ... point) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        super(name, Companion.pack(Arrays.copyOf(point, point.length)), (IndexableFieldType)FloatPoint.Companion.getType(point.length));
    }

    @Override
    public void setFloatValue(float value) {
        float[] fArray = new float[]{value};
        this.setFloatValues(fArray);
    }

    public final void setFloatValues(float ... point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        if (!(this.getType().pointDimensionCount() == point.length)) {
            boolean bl = false;
            String string = "this field (name=" + this.getName() + ") uses " + this.getType().pointDimensionCount() + " dimensions; cannot change to (incoming) " + point.length + " dimensions";
            throw new IllegalArgumentException(string.toString());
        }
        this.setFieldsData(Companion.pack(Arrays.copyOf(point, point.length)));
    }

    @Override
    public void setBytesValue(@NotNull BytesRef bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        throw new IllegalArgumentException("cannot change value type from float to BytesRef");
    }

    @Override
    @NotNull
    public Number numericValue() {
        if (!(this.getType().pointDimensionCount() == 1)) {
            boolean bl = false;
            String string = "this field (name=" + this.getName() + ") uses " + this.getType().pointDimensionCount() + " dimensions; cannot convert to a single numeric value";
            throw new IllegalStateException(string.toString());
        }
        Object object = this.getFieldsData();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.BytesRef");
        BytesRef bytes = (BytesRef)object;
        if (!(bytes.getLength() == 4)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return Float.valueOf(Companion.decodeDimension(bytes.getBytes(), bytes.getOffset()));
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
        result.append(" <");
        result.append(this.getName());
        result.append(':');
        Object object = this.getFieldsData();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.BytesRef");
        BytesRef bytes = (BytesRef)object;
        int n = this.getType().pointDimensionCount();
        for (int dim = 0; dim < n; ++dim) {
            if (dim > 0) {
                result.append(',');
            }
            result.append(Companion.decodeDimension(bytes.getBytes(), bytes.getOffset() + dim * 4));
        }
        result.append('>');
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00020\u000f\"\u00020\u0005J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bJ\u0016\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bJ\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0005J\u001e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005J\u001e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000fJ\u001a\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001f\u001a\u00020\u000f\"\u00020\u0005J\u001c\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 \u00a8\u0006!"}, d2={"Lorg/gnit/lucenekmp/document/FloatPoint$Companion;", "", "<init>", "()V", "nextUp", "", "f", "nextDown", "getType", "Lorg/gnit/lucenekmp/document/FieldType;", "numDims", "", "pack", "Lorg/gnit/lucenekmp/util/BytesRef;", "point", "", "encodeDimension", "", "value", "dest", "", "offset", "decodeDimension", "newExactQuery", "Lorg/gnit/lucenekmp/search/Query;", "field", "", "newRangeQuery", "lowerValue", "upperValue", "newSetQuery", "values", "", "core"})
    @SourceDebugExtension(value={"SMAP\nFloatPoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatPoint.kt\norg/gnit/lucenekmp/document/FloatPoint$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,300:1\n1#2:301\n37#3:302\n36#3,3:303\n*S KotlinDebug\n*F\n+ 1 FloatPoint.kt\norg/gnit/lucenekmp/document/FloatPoint$Companion\n*L\n291#1:302\n291#1:303,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final float nextUp(float f) {
            if (FloatExtKt.floatToIntBits(FloatCompanionObject.INSTANCE, f) == Integer.MIN_VALUE) {
                return 0.0f;
            }
            return Math.INSTANCE.nextUp(f);
        }

        public final float nextDown(float f) {
            if (FloatExtKt.floatToIntBits(FloatCompanionObject.INSTANCE, f) == 0) {
                return -0.0f;
            }
            return Math.INSTANCE.nextDown(f);
        }

        private final FieldType getType(int numDims) {
            FieldType type = new FieldType();
            type.setDimensions(numDims, 4);
            type.freeze();
            return type;
        }

        @NotNull
        public final BytesRef pack(float ... point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            if (!(point.length != 0)) {
                boolean $i$a$-require-FloatPoint$Companion$pack$32 = false;
                String $i$a$-require-FloatPoint$Companion$pack$32 = "point must not be 0 dimensions";
                throw new IllegalArgumentException($i$a$-require-FloatPoint$Companion$pack$32.toString());
            }
            byte[] packed = new byte[point.length * 4];
            int n = point.length;
            for (int dim = 0; dim < n; ++dim) {
                this.encodeDimension(point[dim], packed, dim * 4);
            }
            return new BytesRef(packed);
        }

        public final void encodeDimension(float value, @NotNull byte[] dest, int offset) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            NumericUtils.INSTANCE.intToSortableBytes(NumericUtils.INSTANCE.floatToSortableInt(value), dest, offset);
        }

        public final float decodeDimension(@NotNull byte[] value, int offset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return NumericUtils.INSTANCE.sortableIntToFloat(NumericUtils.INSTANCE.sortableBytesToInt(value, offset));
        }

        @NotNull
        public final Query newExactQuery(@NotNull String field, float value) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return this.newRangeQuery(field, value, value);
        }

        @NotNull
        public final Query newRangeQuery(@NotNull String field, float lowerValue, float upperValue) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            float[] fArray = new float[]{lowerValue};
            float[] fArray2 = fArray;
            fArray = new float[]{upperValue};
            return this.newRangeQuery(field, fArray2, fArray);
        }

        @NotNull
        public final Query newRangeQuery(@NotNull String field, @NotNull float[] lowerValue, @NotNull float[] upperValue) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)lowerValue, (String)"lowerValue");
            Intrinsics.checkNotNullParameter((Object)upperValue, (String)"upperValue");
            PointRangeQuery.Companion.checkArgs(field, lowerValue, upperValue);
            byte[] byArray = Companion.pack(Arrays.copyOf(lowerValue, lowerValue.length)).getBytes();
            byte[] byArray2 = Companion.pack(Arrays.copyOf(upperValue, upperValue.length)).getBytes();
            int n = lowerValue.length;
            return new PointRangeQuery(field, byArray, byArray2, n){

                protected String toString(int dimension, byte[] value) {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    return String.valueOf(FloatPoint.Companion.decodeDimension(value, 0));
                }
            };
        }

        @NotNull
        public final Query newSetQuery(@NotNull String field, float ... values2) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            float[] fArray = Arrays.copyOf(values2, values2.length);
            Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
            float[] sortedValues = fArray;
            org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.sort(sortedValues);
            BytesRef encoded = new BytesRef(new byte[4]);
            PointInSetQuery.Stream stream = new PointInSetQuery.Stream(sortedValues, encoded){
                private int upto;
                final /* synthetic */ float[] $sortedValues;
                final /* synthetic */ BytesRef $encoded;
                {
                    this.$sortedValues = $sortedValues;
                    this.$encoded = $encoded;
                }

                public final int getUpto() {
                    return this.upto;
                }

                public final void setUpto(int n) {
                    this.upto = n;
                }

                public BytesRef next() {
                    if (this.upto == this.$sortedValues.length) {
                        return null;
                    }
                    FloatPoint.Companion.encodeDimension(this.$sortedValues[this.upto], this.$encoded.getBytes(), 0);
                    int n = this.upto;
                    this.upto = n + 1;
                    return this.$encoded;
                }
            };
            return new PointInSetQuery(field, stream){

                protected String toString(byte[] value) {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    if (!(value.length == 4)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    return String.valueOf(FloatPoint.Companion.decodeDimension(value, 0));
                }
            };
        }

        @NotNull
        public final Query newSetQuery(@NotNull String field, @NotNull Collection<Float> values2) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            Collection<Float> $this$toTypedArray$iv = values2;
            boolean $i$f$toTypedArray = false;
            Collection<Float> thisCollection$iv = $this$toTypedArray$iv;
            Float[] boxed = thisCollection$iv.toArray(new Float[0]);
            float[] unboxed = new float[boxed.length];
            int n = boxed.length;
            for (int i = 0; i < n; ++i) {
                unboxed[i] = boxed[i].floatValue();
            }
            return this.newSetQuery(field, Arrays.copyOf(unboxed, unboxed.length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

