/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.document;

import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.document.Field;
import org.gnit.lucenekmp.document.FieldType;
import org.gnit.lucenekmp.index.IndexableFieldType;
import org.gnit.lucenekmp.search.PointInSetQuery;
import org.gnit.lucenekmp.search.PointRangeQuery;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.NumericUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00020\u0005\"\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0012\u0010\f\u001a\u00020\n2\n\u0010\u0004\u001a\u00020\u0005\"\u00020\u0006J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/document/IntPoint;", "Lorg/gnit/lucenekmp/document/Field;", "name", "", "point", "", "", "<init>", "(Ljava/lang/String;[I)V", "setIntValue", "", "value", "setIntValues", "setBytesValue", "bytes", "Lorg/gnit/lucenekmp/util/BytesRef;", "numericValue", "", "toString", "Companion", "core"})
public final class IntPoint
extends Field {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public IntPoint(@NotNull String name, int ... point) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        super(name, Companion.pack(Arrays.copyOf(point, point.length)), (IndexableFieldType)IntPoint.Companion.getType(point.length));
    }

    @Override
    public void setIntValue(int value) {
        int[] nArray = new int[]{value};
        this.setIntValues(nArray);
    }

    public final void setIntValues(int ... point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        if (!(this.getType().pointDimensionCount() == point.length)) {
            boolean bl = false;
            String string = "this field (name=" + this.getName() + ") uses " + this.getType().pointDimensionCount() + " dimensions; cannot change to (incoming) " + point.length + " dimensions";
            throw new IllegalArgumentException(string.toString());
        }
        this.setFieldsData(Companion.pack(Arrays.copyOf(point, point.length)));
    }

    @Override
    public void setBytesValue(@NotNull BytesRef bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        throw new IllegalArgumentException("cannot change value type from int to BytesRef");
    }

    @Override
    @NotNull
    public Number numericValue() {
        if (!(this.getType().pointDimensionCount() == 1)) {
            boolean bl = false;
            String string = "this field (name=" + this.getName() + ") uses " + this.getType().pointDimensionCount() + " dimensions; cannot convert to a single numeric value";
            throw new IllegalStateException(string.toString());
        }
        Object object = this.getFieldsData();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.BytesRef");
        BytesRef bytes = (BytesRef)object;
        if (!(bytes.getLength() == 4)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return Companion.decodeDimension(bytes.getBytes(), bytes.getOffset());
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
        result.append(" <");
        result.append(this.getName());
        result.append(':');
        Object object = this.getFieldsData();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.BytesRef");
        BytesRef bytes = (BytesRef)object;
        int n = this.getType().pointDimensionCount();
        for (int dim = 0; dim < n; ++dim) {
            if (dim > 0) {
                result.append(',');
            }
            result.append(Companion.decodeDimension(bytes.getBytes(), bytes.getOffset() + dim * 4));
        }
        result.append('>');
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00020\u000b\"\u00020\u0007J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u0016\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u0007J\u001e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007J\u001e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000bJ\u001a\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u001b\u001a\u00020\u000b\"\u00020\u0007J\u001c\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001c\u00a8\u0006\u001d"}, d2={"Lorg/gnit/lucenekmp/document/IntPoint$Companion;", "", "<init>", "()V", "getType", "Lorg/gnit/lucenekmp/document/FieldType;", "numDims", "", "pack", "Lorg/gnit/lucenekmp/util/BytesRef;", "point", "", "encodeDimension", "", "value", "dest", "", "offset", "decodeDimension", "newExactQuery", "Lorg/gnit/lucenekmp/search/Query;", "field", "", "newRangeQuery", "lowerValue", "upperValue", "newSetQuery", "values", "", "core"})
    @SourceDebugExtension(value={"SMAP\nIntPoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntPoint.kt\norg/gnit/lucenekmp/document/IntPoint$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,255:1\n1#2:256\n37#3:257\n36#3,3:258\n*S KotlinDebug\n*F\n+ 1 IntPoint.kt\norg/gnit/lucenekmp/document/IntPoint$Companion\n*L\n246#1:257\n246#1:258,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final FieldType getType(int numDims) {
            FieldType type = new FieldType();
            type.setDimensions(numDims, 4);
            type.freeze();
            return type;
        }

        @NotNull
        public final BytesRef pack(int ... point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            if (!(!(point.length == 0))) {
                boolean $i$a$-require-IntPoint$Companion$pack$32 = false;
                String $i$a$-require-IntPoint$Companion$pack$32 = "point must not be 0 dimensions";
                throw new IllegalArgumentException($i$a$-require-IntPoint$Companion$pack$32.toString());
            }
            byte[] packed = new byte[point.length * 4];
            int n = point.length;
            for (int dim = 0; dim < n; ++dim) {
                this.encodeDimension(point[dim], packed, dim * 4);
            }
            return new BytesRef(packed);
        }

        public final void encodeDimension(int value, @NotNull byte[] dest, int offset) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            NumericUtils.INSTANCE.intToSortableBytes(value, dest, offset);
        }

        public final int decodeDimension(@NotNull byte[] value, int offset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return NumericUtils.INSTANCE.sortableBytesToInt(value, offset);
        }

        @NotNull
        public final Query newExactQuery(@NotNull String field, int value) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return this.newRangeQuery(field, value, value);
        }

        @NotNull
        public final Query newRangeQuery(@NotNull String field, int lowerValue, int upperValue) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            int[] nArray = new int[]{lowerValue};
            int[] nArray2 = nArray;
            nArray = new int[]{upperValue};
            return this.newRangeQuery(field, nArray2, nArray);
        }

        @NotNull
        public final Query newRangeQuery(@NotNull String field, @NotNull int[] lowerValue, @NotNull int[] upperValue) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)lowerValue, (String)"lowerValue");
            Intrinsics.checkNotNullParameter((Object)upperValue, (String)"upperValue");
            PointRangeQuery.Companion.checkArgs(field, lowerValue, upperValue);
            byte[] byArray = Companion.pack(Arrays.copyOf(lowerValue, lowerValue.length)).getBytes();
            byte[] byArray2 = Companion.pack(Arrays.copyOf(upperValue, upperValue.length)).getBytes();
            int n = lowerValue.length;
            return new PointRangeQuery(field, byArray, byArray2, n){

                protected String toString(int dimension, byte[] value) {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    return String.valueOf(IntPoint.Companion.decodeDimension(value, 0));
                }
            };
        }

        @NotNull
        public final Query newSetQuery(@NotNull String field, int ... values2) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            int[] nArray = Arrays.copyOf(values2, values2.length);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            Intrinsics.checkNotNull((Object)nArray, (String)"null cannot be cast to non-null type kotlin.IntArray");
            int[] sortedValues = nArray;
            org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.sort(sortedValues);
            BytesRef encoded = new BytesRef(new byte[4]);
            PointInSetQuery.Stream stream = new PointInSetQuery.Stream(sortedValues, encoded){
                private int upto;
                final /* synthetic */ int[] $sortedValues;
                final /* synthetic */ BytesRef $encoded;
                {
                    this.$sortedValues = $sortedValues;
                    this.$encoded = $encoded;
                }

                public final int getUpto() {
                    return this.upto;
                }

                public final void setUpto(int n) {
                    this.upto = n;
                }

                public BytesRef next() {
                    if (this.upto == this.$sortedValues.length) {
                        return null;
                    }
                    IntPoint.Companion.encodeDimension(this.$sortedValues[this.upto], this.$encoded.getBytes(), 0);
                    int n = this.upto;
                    this.upto = n + 1;
                    return this.$encoded;
                }
            };
            return new PointInSetQuery(field, stream){

                protected String toString(byte[] value) {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    if (!(value.length == 4)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    return String.valueOf(IntPoint.Companion.decodeDimension(value, 0));
                }
            };
        }

        @NotNull
        public final Query newSetQuery(@NotNull String field, @NotNull Collection<Integer> values2) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            Collection<Integer> $this$toTypedArray$iv = values2;
            boolean $i$f$toTypedArray = false;
            Collection<Integer> thisCollection$iv = $this$toTypedArray$iv;
            Integer[] boxed = thisCollection$iv.toArray(new Integer[0]);
            int[] unboxed = new int[boxed.length];
            int n = boxed.length;
            for (int i = 0; i < n; ++i) {
                unboxed[i] = boxed[i];
            }
            return this.newSetQuery(field, Arrays.copyOf(unboxed, unboxed.length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

