/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.document;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.document.Field;
import org.gnit.lucenekmp.document.FieldType;
import org.gnit.lucenekmp.index.VectorEncoding;
import org.gnit.lucenekmp.index.VectorSimilarityFunction;
import org.gnit.lucenekmp.search.KnnFloatVectorQuery;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.util.VectorUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\b\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/document/KnnFloatVectorField;", "Lorg/gnit/lucenekmp/document/Field;", "name", "", "vector", "", "similarityFunction", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "<init>", "(Ljava/lang/String;[FLorg/gnit/lucenekmp/index/VectorSimilarityFunction;)V", "(Ljava/lang/String;[F)V", "fieldType", "Lorg/gnit/lucenekmp/document/FieldType;", "(Ljava/lang/String;[FLorg/gnit/lucenekmp/document/FieldType;)V", "vectorValue", "setVectorValue", "", "value", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nKnnFloatVectorField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KnnFloatVectorField.kt\norg/gnit/lucenekmp/document/KnnFloatVectorField\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
public final class KnnFloatVectorField
extends Field {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public KnnFloatVectorField(@NotNull String name, @NotNull float[] vector, @NotNull VectorSimilarityFunction similarityFunction) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        Intrinsics.checkNotNullParameter((Object)((Object)similarityFunction), (String)"similarityFunction");
        super(name, KnnFloatVectorField.Companion.createType(vector, similarityFunction));
        this.setFieldsData(VectorUtil.INSTANCE.checkFinite(vector));
    }

    public KnnFloatVectorField(@NotNull String name, @NotNull float[] vector) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        this(name, vector, VectorSimilarityFunction.EUCLIDEAN);
    }

    public KnnFloatVectorField(@NotNull String name, @NotNull float[] vector, @NotNull FieldType fieldType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        Intrinsics.checkNotNullParameter((Object)fieldType, (String)"fieldType");
        super(name, fieldType);
        if (!(fieldType.vectorEncoding() == VectorEncoding.FLOAT32)) {
            boolean $i$a$-require-KnnFloatVectorField$32 = false;
            String $i$a$-require-KnnFloatVectorField$32 = "Attempt to create a vector for field " + name + " using float[] but the field encoding is " + fieldType.vectorEncoding();
            throw new IllegalArgumentException($i$a$-require-KnnFloatVectorField$32.toString());
        }
        if (!(vector.length == fieldType.vectorDimension())) {
            boolean bl = false;
            String string = "The number of vector dimensions does not match the field type";
            throw new IllegalArgumentException(string.toString());
        }
        this.setFieldsData(VectorUtil.INSTANCE.checkFinite(vector));
    }

    @NotNull
    public final float[] vectorValue() {
        Object object = this.getFieldsData();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.FloatArray");
        return (float[])object;
    }

    public final void setVectorValue(@NotNull float[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(value.length == this.getType().vectorDimension())) {
            boolean bl = false;
            String string = "value length " + value.length + " must match field dimension " + this.getType().vectorDimension();
            throw new IllegalArgumentException(string.toString());
        }
        this.setFieldsData(value);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\f\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/document/KnnFloatVectorField$Companion;", "", "<init>", "()V", "createType", "Lorg/gnit/lucenekmp/document/FieldType;", "v", "", "similarityFunction", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "createFieldType", "dimension", "", "newVectorQuery", "Lorg/gnit/lucenekmp/search/Query;", "field", "", "queryVector", "k", "core"})
    @SourceDebugExtension(value={"SMAP\nKnnFloatVectorField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KnnFloatVectorField.kt\norg/gnit/lucenekmp/document/KnnFloatVectorField$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final FieldType createType(float[] v, VectorSimilarityFunction similarityFunction) {
            float[] fArray = v;
            if (v == null) {
                boolean $i$a$-requireNotNull-KnnFloatVectorField$Companion$createType$22 = false;
                String $i$a$-requireNotNull-KnnFloatVectorField$Companion$createType$22 = "vector value must not be null";
                throw new IllegalArgumentException($i$a$-requireNotNull-KnnFloatVectorField$Companion$createType$22.toString());
            }
            int dimension = v.length;
            if (!(dimension != 0)) {
                boolean bl = false;
                String string = "cannot index an empty vector";
                throw new IllegalArgumentException(string.toString());
            }
            if (similarityFunction == null) {
                boolean $i$a$-requireNotNull-KnnFloatVectorField$Companion$createType$42 = false;
                String $i$a$-requireNotNull-KnnFloatVectorField$Companion$createType$42 = "similarity function must not be null";
                throw new IllegalArgumentException($i$a$-requireNotNull-KnnFloatVectorField$Companion$createType$42.toString());
            }
            FieldType type = new FieldType();
            type.setVectorAttributes(dimension, VectorEncoding.FLOAT32, similarityFunction);
            type.freeze();
            return type;
        }

        @NotNull
        public final FieldType createFieldType(int dimension, @NotNull VectorSimilarityFunction similarityFunction) {
            Intrinsics.checkNotNullParameter((Object)((Object)similarityFunction), (String)"similarityFunction");
            FieldType type = new FieldType();
            type.setVectorAttributes(dimension, VectorEncoding.FLOAT32, similarityFunction);
            type.freeze();
            return type;
        }

        @NotNull
        public final Query newVectorQuery(@NotNull String field, @NotNull float[] queryVector, int k) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)queryVector, (String)"queryVector");
            return new KnnFloatVectorQuery(field, queryVector, k, null, 8, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

