/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.document;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.document.Field;
import org.gnit.lucenekmp.document.FieldType;
import org.gnit.lucenekmp.document.LatLonPointDistanceFeatureQuery;
import org.gnit.lucenekmp.document.LatLonPointDistanceQuery;
import org.gnit.lucenekmp.document.LatLonPointQuery;
import org.gnit.lucenekmp.document.NearestNeighbor;
import org.gnit.lucenekmp.document.ShapeField;
import org.gnit.lucenekmp.geo.Circle;
import org.gnit.lucenekmp.geo.GeoEncodingUtils;
import org.gnit.lucenekmp.geo.GeoUtils;
import org.gnit.lucenekmp.geo.LatLonGeometry;
import org.gnit.lucenekmp.geo.Point;
import org.gnit.lucenekmp.geo.Polygon;
import org.gnit.lucenekmp.geo.Rectangle;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.internal.hppc.IntArrayList;
import org.gnit.lucenekmp.search.BooleanClause;
import org.gnit.lucenekmp.search.BooleanQuery;
import org.gnit.lucenekmp.search.BoostQuery;
import org.gnit.lucenekmp.search.ConstantScoreQuery;
import org.gnit.lucenekmp.search.FieldDoc;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.MatchNoDocsQuery;
import org.gnit.lucenekmp.search.PointRangeQuery;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.ScoreDoc;
import org.gnit.lucenekmp.search.TopFieldDocs;
import org.gnit.lucenekmp.search.TotalHits;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.NumericUtils;
import org.gnit.lucenekmp.util.SloppyMath;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\b\u0010\u000b\u001a\u00020\u0003H\u0016\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/document/LatLonPoint;", "Lorg/gnit/lucenekmp/document/Field;", "name", "", "latitude", "", "longitude", "<init>", "(Ljava/lang/String;DD)V", "setLocationValue", "", "toString", "Companion", "core"})
public final class LatLonPoint
extends Field {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int BYTES = 4;
    @NotNull
    private static final FieldType TYPE = new FieldType();

    public LatLonPoint(@NotNull String name, double latitude, double longitude) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name, TYPE);
        this.setLocationValue(latitude, longitude);
    }

    public final void setLocationValue(double latitude, double longitude) {
        byte[] bytes = null;
        if (!this.isFieldsDataInitialized()) {
            bytes = new byte[8];
            this.setFieldsData(new BytesRef(bytes));
        } else {
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.BytesRef");
            bytes = ((BytesRef)object).getBytes();
        }
        int latitudeEncoded = GeoEncodingUtils.INSTANCE.encodeLatitude(latitude);
        int longitudeEncoded = GeoEncodingUtils.INSTANCE.encodeLongitude(longitude);
        NumericUtils.INSTANCE.intToSortableBytes(latitudeEncoded, bytes, 0);
        NumericUtils.INSTANCE.intToSortableBytes(longitudeEncoded, bytes, 4);
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
        result.append(" <");
        result.append(this.getName());
        result.append(':');
        Object object = this.getFieldsData();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.BytesRef");
        byte[] bytes = ((BytesRef)object).getBytes();
        result.append(GeoEncodingUtils.INSTANCE.decodeLatitude(bytes, 0));
        result.append(',');
        result.append(GeoEncodingUtils.INSTANCE.decodeLongitude(bytes, 4));
        result.append('>');
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static {
        TYPE.setDimensions(2, 4);
        TYPE.freeze();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rJ \u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J&\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010 \u001a\u00020\rJ'\u0010!\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0#\"\u00020$\u00a2\u0006\u0002\u0010%J/\u0010&\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(2\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0#\"\u00020*\u00a2\u0006\u0002\u0010+J)\u0010,\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0#\"\u00020*H\u0002\u00a2\u0006\u0002\u0010-J.\u0010.\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\r2\u0006\u00103\u001a\u00020\rJ.\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u00108\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u00069"}, d2={"Lorg/gnit/lucenekmp/document/LatLonPoint$Companion;", "", "<init>", "()V", "BYTES", "", "TYPE", "Lorg/gnit/lucenekmp/document/FieldType;", "getTYPE", "()Lorg/gnit/lucenekmp/document/FieldType;", "encode", "", "latitude", "", "longitude", "encodeCeil", "checkCompatible", "", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "newBoxQuery", "Lorg/gnit/lucenekmp/search/Query;", "field", "", "minLatitude", "maxLatitude", "minLongitude", "maxLongitude", "newBoxInternal", "min", "max", "newDistanceQuery", "radiusMeters", "newPolygonQuery", "polygons", "", "Lorg/gnit/lucenekmp/geo/Polygon;", "(Ljava/lang/String;[Lorg/gnit/lucenekmp/geo/Polygon;)Lorg/gnit/lucenekmp/search/Query;", "newGeometryQuery", "queryRelation", "Lorg/gnit/lucenekmp/document/ShapeField$QueryRelation;", "latLonGeometries", "Lorg/gnit/lucenekmp/geo/LatLonGeometry;", "(Ljava/lang/String;Lorg/gnit/lucenekmp/document/ShapeField$QueryRelation;[Lorg/gnit/lucenekmp/geo/LatLonGeometry;)Lorg/gnit/lucenekmp/search/Query;", "makeContainsGeometryQuery", "(Ljava/lang/String;[Lorg/gnit/lucenekmp/geo/LatLonGeometry;)Lorg/gnit/lucenekmp/search/Query;", "newDistanceFeatureQuery", "weight", "", "originLat", "originLon", "pivotDistanceMeters", "nearest", "Lorg/gnit/lucenekmp/search/TopFieldDocs;", "searcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "n", "core"})
    @SourceDebugExtension(value={"SMAP\nLatLonPoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LatLonPoint.kt\norg/gnit/lucenekmp/document/LatLonPoint$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,461:1\n1#2:462\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FieldType getTYPE() {
            return TYPE;
        }

        private final byte[] encode(double latitude, double longitude) {
            byte[] bytes = new byte[8];
            NumericUtils.INSTANCE.intToSortableBytes(GeoEncodingUtils.INSTANCE.encodeLatitude(latitude), bytes, 0);
            NumericUtils.INSTANCE.intToSortableBytes(GeoEncodingUtils.INSTANCE.encodeLongitude(longitude), bytes, 4);
            return bytes;
        }

        private final byte[] encodeCeil(double latitude, double longitude) {
            byte[] bytes = new byte[8];
            NumericUtils.INSTANCE.intToSortableBytes(GeoEncodingUtils.INSTANCE.encodeLatitudeCeil(latitude), bytes, 0);
            NumericUtils.INSTANCE.intToSortableBytes(GeoEncodingUtils.INSTANCE.encodeLongitudeCeil(longitude), bytes, 4);
            return bytes;
        }

        public final void checkCompatible(@NotNull FieldInfo fieldInfo) {
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            if (!(fieldInfo.getPointDimensionCount() == 0 || fieldInfo.getPointDimensionCount() == this.getTYPE().pointDimensionCount())) {
                boolean $i$a$-require-LatLonPoint$Companion$checkCompatible$32 = false;
                String $i$a$-require-LatLonPoint$Companion$checkCompatible$32 = "field=\"" + fieldInfo.getName() + "\" was indexed with numDims=" + fieldInfo.getPointDimensionCount() + " but this point type has numDims=" + Companion.getTYPE().pointDimensionCount() + ", is the field really a LatLonPoint";
                throw new IllegalArgumentException($i$a$-require-LatLonPoint$Companion$checkCompatible$32.toString());
            }
            if (!(fieldInfo.getPointNumBytes() == 0 || fieldInfo.getPointNumBytes() == this.getTYPE().pointNumBytes())) {
                boolean bl = false;
                String string = "field=\"" + fieldInfo.getName() + "\" was indexed with bytesPerDim=" + fieldInfo.getPointNumBytes() + " but this point type has bytesPerDim=" + Companion.getTYPE().pointNumBytes() + ", is the field really a LatLonPoint";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final Query newBoxQuery(@NotNull String field, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            double minLongitude2 = minLongitude;
            if (minLatitude == 90.0) {
                return new MatchNoDocsQuery("LatLonPoint.newBoxQuery with minLatitude=90.0");
            }
            if (minLongitude2 == 180.0) {
                if (maxLongitude == 180.0) {
                    return new MatchNoDocsQuery("LatLonPoint.newBoxQuery with minLongitude=maxLongitude=180.0");
                }
                if (maxLongitude < minLongitude2) {
                    minLongitude2 = -180.0;
                }
            }
            byte[] lower = this.encodeCeil(minLatitude, minLongitude2);
            byte[] upper = this.encode(maxLatitude, maxLongitude);
            if (maxLongitude < minLongitude2) {
                BooleanQuery.Builder q = new BooleanQuery.Builder();
                byte[] byArray = Arrays.copyOf(lower, lower.length);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
                byte[] leftOpen = byArray;
                NumericUtils.INSTANCE.intToSortableBytes(Integer.MIN_VALUE, leftOpen, 4);
                Query left = this.newBoxInternal(field, leftOpen, upper);
                q.add(new BooleanClause(left, BooleanClause.Occur.SHOULD));
                byte[] byArray2 = Arrays.copyOf(upper, upper.length);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
                byte[] rightOpen = byArray2;
                NumericUtils.INSTANCE.intToSortableBytes(Integer.MAX_VALUE, rightOpen, 4);
                Query right = this.newBoxInternal(field, lower, rightOpen);
                q.add(new BooleanClause(right, BooleanClause.Occur.SHOULD));
                return new ConstantScoreQuery(q.build());
            }
            return this.newBoxInternal(field, lower, upper);
        }

        private final Query newBoxInternal(String field, byte[] min, byte[] max) {
            return new PointRangeQuery(field, min, max){

                protected String toString(int dimension, byte[] value) {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    return switch (dimension) {
                        case 0 -> String.valueOf(GeoEncodingUtils.INSTANCE.decodeLatitude(value, 0));
                        case 1 -> String.valueOf(GeoEncodingUtils.INSTANCE.decodeLongitude(value, 0));
                        default -> throw new AssertionError();
                    };
                }
            };
        }

        @NotNull
        public final Query newDistanceQuery(@NotNull String field, double latitude, double longitude, double radiusMeters) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new LatLonPointDistanceQuery(field, latitude, longitude, radiusMeters);
        }

        @NotNull
        public final Query newPolygonQuery(@NotNull String field, Polygon ... polygons) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)polygons, (String)"polygons");
            return this.newGeometryQuery(field, ShapeField.QueryRelation.INTERSECTS, Arrays.copyOf(polygons, polygons.length));
        }

        @NotNull
        public final Query newGeometryQuery(@NotNull String field, @NotNull ShapeField.QueryRelation queryRelation, LatLonGeometry ... latLonGeometries) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)((Object)queryRelation), (String)"queryRelation");
            Intrinsics.checkNotNullParameter((Object)latLonGeometries, (String)"latLonGeometries");
            if (queryRelation == ShapeField.QueryRelation.INTERSECTS && latLonGeometries.length == 1) {
                if (latLonGeometries[0] instanceof Rectangle) {
                    LatLonGeometry latLonGeometry = latLonGeometries[0];
                    Intrinsics.checkNotNull((Object)latLonGeometry, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.geo.Rectangle");
                    Rectangle rect = (Rectangle)latLonGeometry;
                    return this.newBoxQuery(field, rect.getMinLat(), rect.getMaxLat(), rect.getMinLon(), rect.getMaxLon());
                }
                if (latLonGeometries[0] instanceof Circle) {
                    LatLonGeometry latLonGeometry = latLonGeometries[0];
                    Intrinsics.checkNotNull((Object)latLonGeometry, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.geo.Circle");
                    Circle circle = (Circle)latLonGeometry;
                    return this.newDistanceQuery(field, circle.getLat(), circle.getLon(), circle.getRadius());
                }
            }
            if (queryRelation == ShapeField.QueryRelation.CONTAINS) {
                return this.makeContainsGeometryQuery(field, Arrays.copyOf(latLonGeometries, latLonGeometries.length));
            }
            return new LatLonPointQuery(field, queryRelation, Arrays.copyOf(latLonGeometries, latLonGeometries.length));
        }

        private final Query makeContainsGeometryQuery(String field, LatLonGeometry ... latLonGeometries) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (LatLonGeometry geometry : latLonGeometries) {
                if (!(geometry instanceof Point)) {
                    return new MatchNoDocsQuery("Contains LatLonPoint.newGeometryQuery with non-point geometries");
                }
                LatLonGeometry[] latLonGeometryArray = new LatLonGeometry[]{geometry};
                builder.add(new LatLonPointQuery(field, ShapeField.QueryRelation.CONTAINS, latLonGeometryArray), BooleanClause.Occur.MUST);
            }
            return new ConstantScoreQuery(builder.build());
        }

        @NotNull
        public final Query newDistanceFeatureQuery(@NotNull String field, float weight, double originLat, double originLon, double pivotDistanceMeters) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Query query = new LatLonPointDistanceFeatureQuery(field, originLat, originLon, pivotDistanceMeters);
            if (!(weight == 1.0f)) {
                query = new BoostQuery(query, weight);
            }
            return query;
        }

        @NotNull
        public final TopFieldDocs nearest(@NotNull IndexSearcher searcher, @NotNull String field, double latitude, double longitude, int n) throws IOException {
            Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            GeoUtils.INSTANCE.checkLatitude(latitude);
            GeoUtils.INSTANCE.checkLongitude(longitude);
            if (!(n >= 1)) {
                boolean $i$a$-require-LatLonPoint$Companion$nearest$22 = false;
                String $i$a$-require-LatLonPoint$Companion$nearest$22 = "n must be at least 1; got " + n;
                throw new IllegalArgumentException($i$a$-require-LatLonPoint$Companion$nearest$22.toString());
            }
            List readers = new ArrayList();
            IntArrayList docBases = new IntArrayList();
            List liveDocs2 = new ArrayList();
            int totalHits = 0;
            for (LeafReaderContext leaf : searcher.getIndexReader().leaves()) {
                PointValues points2 = leaf.reader().getPointValues(field);
                if (points2 == null) continue;
                totalHits += points2.getDocCount();
                readers.add(points2);
                docBases.add(leaf.getDocBase());
                Bits bits = leaf.reader().getLiveDocs();
                Intrinsics.checkNotNull((Object)bits);
                liveDocs2.add(bits);
            }
            NearestNeighbor.NearestHit[] hits = NearestNeighbor.INSTANCE.nearest(latitude, longitude, readers, liveDocs2, docBases, n);
            ScoreDoc[] scoreDocs = new ScoreDoc[hits.length];
            for (NearestNeighbor.NearestHit hit : hits) {
                double hitDistance = SloppyMath.INSTANCE.haversinMeters(hit.getDistanceSortKey());
                Object[] objectArray = new Object[]{hitDistance};
                scoreDocs[i] = new FieldDoc(hit.getDocID(), 0.0f, objectArray);
            }
            return new TopFieldDocs(new TotalHits(totalHits, TotalHits.Relation.EQUAL_TO), scoreDocs, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

