/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.document;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.gnit.lucenekmp.document.LatLonPointDistanceFeatureQuery;
import org.gnit.lucenekmp.geo.GeoEncodingUtils;
import org.gnit.lucenekmp.geo.GeoUtils;
import org.gnit.lucenekmp.geo.Rectangle;
import org.gnit.lucenekmp.index.DocValues;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.index.SortedNumericDocValues;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.Explanation;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.ScorerSupplier;
import org.gnit.lucenekmp.search.Weight;
import org.gnit.lucenekmp.util.DocIdSetBuilder;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.NumericUtils;
import org.gnit.lucenekmp.util.SloppyMath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001#B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0000H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/gnit/lucenekmp/document/LatLonPointDistanceFeatureQuery;", "Lorg/gnit/lucenekmp/search/Query;", "field", "", "originLat", "", "originLon", "pivotDistance", "<init>", "(Ljava/lang/String;DDD)V", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "equals", "", "o", "", "equalsTo", "other", "hashCode", "", "toString", "createWeight", "Lorg/gnit/lucenekmp/search/Weight;", "searcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "boost", "", "getDistanceFromEncoded", "encoded", "", "getDistanceKeyFromEncoded", "DistanceScorer", "core"})
@SourceDebugExtension(value={"SMAP\nLatLonPointDistanceFeatureQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LatLonPointDistanceFeatureQuery.kt\norg/gnit/lucenekmp/document/LatLonPointDistanceFeatureQuery\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,455:1\n1#2:456\n*E\n"})
public final class LatLonPointDistanceFeatureQuery
extends Query {
    @NotNull
    private final String field;
    private final double originLat;
    private final double originLon;
    private final double pivotDistance;

    public LatLonPointDistanceFeatureQuery(@NotNull String field, double originLat, double originLon, double pivotDistance) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.field = field;
        GeoUtils.INSTANCE.checkLatitude(originLat);
        GeoUtils.INSTANCE.checkLongitude(originLon);
        this.originLon = originLon;
        this.originLat = originLat;
        if (!(!(pivotDistance <= 0.0))) {
            boolean bl = false;
            String string = "pivotDistance must be > 0, got " + pivotDistance;
            throw new IllegalArgumentException(string.toString());
        }
        this.pivotDistance = pivotDistance;
    }

    @Override
    public void visit(@NotNull QueryVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        if (visitor2.acceptField(this.field)) {
            visitor2.visitLeaf(this);
        }
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return this.sameClassAs(o) && this.equalsTo((LatLonPointDistanceFeatureQuery)KClasses.cast((KClass)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)o));
    }

    private final boolean equalsTo(LatLonPointDistanceFeatureQuery other) {
        return Intrinsics.areEqual((Object)this.field, (Object)other.field) && this.originLon == other.originLon && this.originLat == other.originLat && this.pivotDistance == other.pivotDistance;
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.field.hashCode();
        h = 31 * h + Double.hashCode(this.originLat);
        h = 31 * h + Double.hashCode(this.originLon);
        h = 31 * h + Double.hashCode(this.pivotDistance);
        return h;
    }

    @Override
    @NotNull
    public String toString(@Nullable String field) {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "(field=" + field + ",originLat=" + this.originLat + ",originLon=" + this.originLon + ",pivotDistance=" + this.pivotDistance + ")";
    }

    @Override
    @NotNull
    public Weight createWeight(@NotNull IndexSearcher searcher, @NotNull ScoreMode scoreMode, float boost) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        return new Weight(this, boost){
            final /* synthetic */ LatLonPointDistanceFeatureQuery this$0;
            final /* synthetic */ float $boost;
            {
                this.this$0 = $receiver;
                this.$boost = $boost;
                super($receiver);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                return false;
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                SortedNumericDocValues multiDocValues = DocValues.INSTANCE.getSortedNumeric(context.reader(), LatLonPointDistanceFeatureQuery.access$getField$p(this.this$0));
                if (!multiDocValues.advanceExact(doc)) {
                    return Explanation.Companion.noMatch("Document " + doc + " doesn't have a value for field " + LatLonPointDistanceFeatureQuery.access$getField$p(this.this$0), new Explanation[0]);
                }
                long encoded = this.selectValue(multiDocValues);
                int latitudeBits = (int)(encoded >> 32);
                int longitudeBits = (int)(encoded & 0xFFFFFFFFL);
                double lat = GeoEncodingUtils.INSTANCE.decodeLatitude(latitudeBits);
                double lon = GeoEncodingUtils.INSTANCE.decodeLongitude(longitudeBits);
                double distance = SloppyMath.INSTANCE.haversinMeters(LatLonPointDistanceFeatureQuery.access$getOriginLat$p(this.this$0), LatLonPointDistanceFeatureQuery.access$getOriginLon$p(this.this$0), lat, lon);
                float score2 = (float)((double)this.$boost * (LatLonPointDistanceFeatureQuery.access$getPivotDistance$p(this.this$0) / (LatLonPointDistanceFeatureQuery.access$getPivotDistance$p(this.this$0) + distance)));
                Explanation[] explanationArray = new Explanation[]{Explanation.Companion.match((Number)Float.valueOf(this.$boost), "weight", new Explanation[0]), Explanation.Companion.match((Number)LatLonPointDistanceFeatureQuery.access$getPivotDistance$p(this.this$0), "pivotDistance", new Explanation[0]), Explanation.Companion.match((Number)LatLonPointDistanceFeatureQuery.access$getOriginLat$p(this.this$0), "originLat", new Explanation[0]), Explanation.Companion.match((Number)LatLonPointDistanceFeatureQuery.access$getOriginLon$p(this.this$0), "originLon", new Explanation[0]), Explanation.Companion.match((Number)lat, "current lat", new Explanation[0]), Explanation.Companion.match((Number)lon, "current lon", new Explanation[0]), Explanation.Companion.match((Number)distance, "distance", new Explanation[0])};
                return Explanation.Companion.match((Number)Float.valueOf(score2), "Distance score, computed as weight * pivotDistance / (pivotDistance + abs(distance)) from:", explanationArray);
            }

            public final long selectValue(SortedNumericDocValues multiDocValues) throws IOException {
                Intrinsics.checkNotNullParameter((Object)multiDocValues, (String)"multiDocValues");
                int count = multiDocValues.docValueCount();
                long value = multiDocValues.nextValue();
                if (count == 1) {
                    return value;
                }
                double distance = LatLonPointDistanceFeatureQuery.access$getDistanceKeyFromEncoded(this.this$0, value);
                for (int i = 1; i < count; ++i) {
                    long nextValue = multiDocValues.nextValue();
                    double nextDistance = LatLonPointDistanceFeatureQuery.access$getDistanceKeyFromEncoded(this.this$0, nextValue);
                    if (!(nextDistance < distance)) continue;
                    distance = nextDistance;
                    value = nextValue;
                }
                return value;
            }

            public final NumericDocValues selectValues(SortedNumericDocValues multiDocValues) {
                Intrinsics.checkNotNullParameter((Object)multiDocValues, (String)"multiDocValues");
                NumericDocValues singleton = DocValues.INSTANCE.unwrapSingleton(multiDocValues);
                if (singleton != null) {
                    return singleton;
                }
                return new NumericDocValues(multiDocValues, this){
                    private long value;
                    final /* synthetic */ SortedNumericDocValues $multiDocValues;
                    final /* synthetic */ createWeight.1 this$0;
                    {
                        this.$multiDocValues = $multiDocValues;
                        this.this$0 = $receiver;
                    }

                    public final long getValue() {
                        return this.value;
                    }

                    public final void setValue(long l) {
                        this.value = l;
                    }

                    public long longValue() throws IOException {
                        return this.value;
                    }

                    public boolean advanceExact(int target) throws IOException {
                        if (this.$multiDocValues.advanceExact(target)) {
                            this.value = this.this$0.selectValue(this.$multiDocValues);
                            return true;
                        }
                        return false;
                    }

                    public int docID() {
                        return this.$multiDocValues.docID();
                    }

                    public int nextDoc() throws IOException {
                        return this.$multiDocValues.nextDoc();
                    }

                    public int advance(int target) throws IOException {
                        return this.$multiDocValues.advance(target);
                    }

                    public long cost() {
                        return this.$multiDocValues.cost();
                    }
                };
            }

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                PointValues pointValues = context.reader().getPointValues(LatLonPointDistanceFeatureQuery.access$getField$p(this.this$0));
                if (pointValues == null) {
                    return null;
                }
                SortedNumericDocValues multiDocValues = DocValues.INSTANCE.getSortedNumeric(context.reader(), LatLonPointDistanceFeatureQuery.access$getField$p(this.this$0));
                NumericDocValues docValues = this.selectValues(multiDocValues);
                return new ScorerSupplier(this.this$0, context, this.$boost, pointValues, docValues){
                    final /* synthetic */ LatLonPointDistanceFeatureQuery this$0;
                    final /* synthetic */ LeafReaderContext $context;
                    final /* synthetic */ float $boost;
                    final /* synthetic */ PointValues $pointValues;
                    final /* synthetic */ NumericDocValues $docValues;
                    {
                        this.this$0 = $receiver;
                        this.$context = $context;
                        this.$boost = $boost;
                        this.$pointValues = $pointValues;
                        this.$docValues = $docValues;
                    }

                    public Scorer get(long leadCost) throws IOException {
                        return this.this$0.new DistanceScorer(this.$context.reader().maxDoc(), leadCost, this.$boost, this.$pointValues, this.$docValues);
                    }

                    public long cost() {
                        return this.$docValues.cost();
                    }
                };
            }
        };
    }

    private final double getDistanceFromEncoded(long encoded) {
        return SloppyMath.INSTANCE.haversinMeters(this.getDistanceKeyFromEncoded(encoded));
    }

    private final double getDistanceKeyFromEncoded(long encoded) {
        int latitudeBits = (int)(encoded >> 32);
        int longitudeBits = (int)(encoded & 0xFFFFFFFFL);
        double lat = GeoEncodingUtils.INSTANCE.decodeLatitude(latitudeBits);
        double lon = GeoEncodingUtils.INSTANCE.decodeLongitude(longitudeBits);
        return SloppyMath.INSTANCE.haversinSortKey(this.originLat, this.originLon, lat, lon);
    }

    public static final /* synthetic */ String access$getField$p(LatLonPointDistanceFeatureQuery $this) {
        return $this.field;
    }

    public static final /* synthetic */ double access$getDistanceKeyFromEncoded(LatLonPointDistanceFeatureQuery $this, long encoded) {
        return $this.getDistanceKeyFromEncoded(encoded);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0010\b\u0082\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0013\u001a\u00020\u0003H\u0016J\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0012J\u0016\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0012J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lorg/gnit/lucenekmp/document/LatLonPointDistanceFeatureQuery$DistanceScorer;", "Lorg/gnit/lucenekmp/search/Scorer;", "maxDoc", "", "leadCost", "", "boost", "", "pointValues", "Lorg/gnit/lucenekmp/index/PointValues;", "docValues", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "<init>", "(Lorg/gnit/lucenekmp/document/LatLonPointDistanceFeatureQuery;IJFLorg/gnit/lucenekmp/index/PointValues;Lorg/gnit/lucenekmp/index/NumericDocValues;)V", "it", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "doc", "maxDistance", "", "docID", "score", "distance", "computeMaxDistance", "minScore", "previousMaxDistance", "iterator", "getMaxScore", "upTo", "setMinCompetitiveScoreCounter", "minCompetitiveScore", "getMinCompetitiveScore", "()F", "setMinCompetitiveScore", "(F)V", "core"})
    private final class DistanceScorer
    extends Scorer {
        private final int maxDoc;
        private final long leadCost;
        private final float boost;
        @NotNull
        private final PointValues pointValues;
        @NotNull
        private final NumericDocValues docValues;
        @NotNull
        private DocIdSetIterator it;
        private int doc;
        private double maxDistance;
        private int setMinCompetitiveScoreCounter;

        public DistanceScorer(int maxDoc, long leadCost, @NotNull float boost, @NotNull PointValues pointValues, NumericDocValues docValues) {
            Intrinsics.checkNotNullParameter((Object)pointValues, (String)"pointValues");
            Intrinsics.checkNotNullParameter((Object)docValues, (String)"docValues");
            this.maxDoc = maxDoc;
            this.leadCost = leadCost;
            this.boost = boost;
            this.pointValues = pointValues;
            this.docValues = docValues;
            this.doc = -1;
            this.maxDistance = 2.0015114352186374E7;
            this.it = this.docValues;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        public final float score(double distance) {
            return (float)((double)this.boost * (LatLonPointDistanceFeatureQuery.this.pivotDistance / (LatLonPointDistanceFeatureQuery.this.pivotDistance + distance)));
        }

        public final double computeMaxDistance(float minScore, double previousMaxDistance) {
            if (!(this.score(0.0) >= minScore)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.score(previousMaxDistance) >= minScore) {
                return previousMaxDistance;
            }
            if (!(this.score(previousMaxDistance) < minScore)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            double min = 0.0;
            double max = previousMaxDistance;
            while (max - min > 1.0) {
                double mid = (min + max) / (double)2;
                float score2 = this.score(mid);
                if (score2 >= minScore) {
                    min = mid;
                    continue;
                }
                max = mid;
            }
            if (!(this.score(min) >= minScore)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(min == Double.MAX_VALUE || this.score(min + 1.0) < minScore)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return min;
        }

        @Override
        public float score() throws IOException {
            if (!this.docValues.advanceExact(this.docID())) {
                return 0.0f;
            }
            return this.score(LatLonPointDistanceFeatureQuery.this.getDistanceFromEncoded(this.docValues.longValue()));
        }

        @Override
        @NotNull
        public DocIdSetIterator iterator() {
            return new DocIdSetIterator(this){
                final /* synthetic */ DistanceScorer this$0;
                {
                    this.this$0 = $receiver;
                }

                public int nextDoc() throws IOException {
                    int n = DistanceScorer.access$getIt$p(this.this$0).nextDoc();
                    DistanceScorer distanceScorer = this.this$0;
                    int it = n;
                    boolean bl = false;
                    DistanceScorer.access$setDoc$p(distanceScorer, it);
                    return n;
                }

                public int docID() {
                    return DistanceScorer.access$getDoc$p(this.this$0);
                }

                public long cost() {
                    return DistanceScorer.access$getIt$p(this.this$0).cost();
                }

                public int advance(int target) throws IOException {
                    int n = DistanceScorer.access$getIt$p(this.this$0).advance(target);
                    DistanceScorer distanceScorer = this.this$0;
                    int it = n;
                    boolean bl = false;
                    DistanceScorer.access$setDoc$p(distanceScorer, it);
                    return n;
                }
            };
        }

        @Override
        public float getMaxScore(int upTo) {
            return this.boost;
        }

        @Override
        public float getMinCompetitiveScore() {
            throw new NotImplementedError(null, 1, null);
        }

        @Override
        public void setMinCompetitiveScore(float minScore) {
            if (minScore > this.boost) {
                this.it = DocIdSetIterator.Companion.empty();
                return;
            }
            int n = this.setMinCompetitiveScoreCounter;
            this.setMinCompetitiveScoreCounter = n + 1;
            if (this.setMinCompetitiveScoreCounter > 256 && (this.setMinCompetitiveScoreCounter & 0x1F) != 31) {
                return;
            }
            double previousMaxDistance = this.maxDistance;
            this.maxDistance = this.computeMaxDistance(minScore, this.maxDistance);
            if (this.maxDistance == previousMaxDistance) {
                return;
            }
            Rectangle box = Rectangle.Companion.fromPointDistance(LatLonPointDistanceFeatureQuery.this.originLat, LatLonPointDistanceFeatureQuery.this.originLon, this.maxDistance);
            int minLat = GeoEncodingUtils.INSTANCE.encodeLatitude(box.getMinLat());
            int maxLat = GeoEncodingUtils.INSTANCE.encodeLatitude(box.getMaxLat());
            int minLon = GeoEncodingUtils.INSTANCE.encodeLongitude(box.getMinLon());
            int maxLon = GeoEncodingUtils.INSTANCE.encodeLongitude(box.getMaxLon());
            boolean crossDateLine = box.crossesDateline();
            DocIdSetBuilder result = new DocIdSetBuilder(this.maxDoc);
            int doc = this.docID();
            PointValues.IntersectVisitor visitor2 = new PointValues.IntersectVisitor(result, doc, maxLat, minLat, crossDateLine, minLon, maxLon){
                private DocIdSetBuilder.BulkAdder adder;
                final /* synthetic */ DocIdSetBuilder $result;
                final /* synthetic */ int $doc;
                final /* synthetic */ int $maxLat;
                final /* synthetic */ int $minLat;
                final /* synthetic */ boolean $crossDateLine;
                final /* synthetic */ int $minLon;
                final /* synthetic */ int $maxLon;
                {
                    this.$result = $result;
                    this.$doc = $doc;
                    this.$maxLat = $maxLat;
                    this.$minLat = $minLat;
                    this.$crossDateLine = $crossDateLine;
                    this.$minLon = $minLon;
                    this.$maxLon = $maxLon;
                }

                public final DocIdSetBuilder.BulkAdder getAdder() {
                    return this.adder;
                }

                public final void setAdder(DocIdSetBuilder.BulkAdder bulkAdder) {
                    this.adder = bulkAdder;
                }

                public void grow(int count) {
                    this.adder = this.$result.grow(count);
                }

                public void visit(int docID) {
                    if (docID <= this.$doc) {
                        return;
                    }
                    DocIdSetBuilder.BulkAdder bulkAdder = this.adder;
                    Intrinsics.checkNotNull((Object)bulkAdder);
                    bulkAdder.add(docID);
                }

                public void visit(int docID, byte[] packedValue) {
                    Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                    if (docID <= this.$doc) {
                        return;
                    }
                    int lat = NumericUtils.INSTANCE.sortableBytesToInt(packedValue, 0);
                    if (lat > this.$maxLat || lat < this.$minLat) {
                        return;
                    }
                    int lon = NumericUtils.INSTANCE.sortableBytesToInt(packedValue, 4);
                    if (this.$crossDateLine ? lon < this.$minLon && lon > this.$maxLon : lon > this.$maxLon || lon < this.$minLon) {
                        return;
                    }
                    DocIdSetBuilder.BulkAdder bulkAdder = this.adder;
                    Intrinsics.checkNotNull((Object)bulkAdder);
                    bulkAdder.add(docID);
                }

                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
                    Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
                    int latLowerBound = NumericUtils.INSTANCE.sortableBytesToInt(minPackedValue, 0);
                    int latUpperBound = NumericUtils.INSTANCE.sortableBytesToInt(maxPackedValue, 0);
                    if (latLowerBound > this.$maxLat || latUpperBound < this.$minLat) {
                        return PointValues.Relation.CELL_OUTSIDE_QUERY;
                    }
                    boolean crosses = latLowerBound < this.$minLat || latUpperBound > this.$maxLat;
                    int lonLowerBound = NumericUtils.INSTANCE.sortableBytesToInt(minPackedValue, 4);
                    int lonUpperBound = NumericUtils.INSTANCE.sortableBytesToInt(maxPackedValue, 4);
                    if (this.$crossDateLine) {
                        if (lonLowerBound > this.$maxLon && lonUpperBound < this.$minLon) {
                            return PointValues.Relation.CELL_OUTSIDE_QUERY;
                        }
                        crosses |= lonLowerBound < this.$maxLon || lonUpperBound > this.$minLon;
                    } else {
                        if (lonLowerBound > this.$maxLon || lonUpperBound < this.$minLon) {
                            return PointValues.Relation.CELL_OUTSIDE_QUERY;
                        }
                        crosses |= lonLowerBound < this.$minLon || lonUpperBound > this.$maxLon;
                    }
                    return crosses ? PointValues.Relation.CELL_CROSSES_QUERY : PointValues.Relation.CELL_INSIDE_QUERY;
                }

                public void visit(DocIdSetIterator iterator2) throws IOException {
                    PointValues.IntersectVisitor.super.visit(iterator2);
                }

                public void visit(IntsRef ref) throws IOException {
                    PointValues.IntersectVisitor.super.visit(ref);
                }

                public void visit(DocIdSetIterator iterator2, byte[] packedValue) throws IOException {
                    PointValues.IntersectVisitor.super.visit(iterator2, packedValue);
                }
            };
            long currentQueryCost = Math.min(this.leadCost, this.it.cost());
            long threshold = currentQueryCost >>> 3;
            if (PointValues.Companion.isEstimatedPointCountGreaterThanOrEqualTo(visitor2, this.pointValues.getPointTree(), threshold)) {
                return;
            }
            this.pointValues.intersect(visitor2);
            this.it = result.build().iterator();
        }

        public static final /* synthetic */ DocIdSetIterator access$getIt$p(DistanceScorer $this) {
            return $this.it;
        }

        public static final /* synthetic */ int access$getDoc$p(DistanceScorer $this) {
            return $this.doc;
        }

        public static final /* synthetic */ void access$setDoc$p(DistanceScorer $this, int n) {
            $this.doc = n;
        }
    }
}

