/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.document;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gnit.lucenekmp.document.LatLonPointQuery;
import org.gnit.lucenekmp.document.ShapeField;
import org.gnit.lucenekmp.document.SpatialQuery;
import org.gnit.lucenekmp.geo.Component2D;
import org.gnit.lucenekmp.geo.GeoEncodingUtils;
import org.gnit.lucenekmp.geo.Geometry;
import org.gnit.lucenekmp.geo.LatLonGeometry;
import org.gnit.lucenekmp.geo.Line;
import org.gnit.lucenekmp.geo.Point;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.util.NumericUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0007\"\u00020\rH\u0014\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u0013\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u000f\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/document/LatLonPointQuery;", "Lorg/gnit/lucenekmp/document/SpatialQuery;", "field", "", "queryRelation", "Lorg/gnit/lucenekmp/document/ShapeField$QueryRelation;", "geometries", "", "Lorg/gnit/lucenekmp/geo/LatLonGeometry;", "<init>", "(Ljava/lang/String;Lorg/gnit/lucenekmp/document/ShapeField$QueryRelation;[Lorg/gnit/lucenekmp/geo/LatLonGeometry;)V", "createComponent2D", "Lorg/gnit/lucenekmp/geo/Component2D;", "Lorg/gnit/lucenekmp/geo/Geometry;", "([Lorg/gnit/lucenekmp/geo/Geometry;)Lorg/gnit/lucenekmp/geo/Component2D;", "spatialVisitor", "Lorg/gnit/lucenekmp/document/SpatialQuery$SpatialVisitor;", "getSpatialVisitor", "()Lorg/gnit/lucenekmp/document/SpatialQuery$SpatialVisitor;", "toString", "equalsTo", "", "o", "", "hashCode", "", "Companion", "core"})
public final class LatLonPointQuery
extends SpatialQuery {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public LatLonPointQuery(@NotNull String field, @NotNull ShapeField.QueryRelation queryRelation, LatLonGeometry ... geometries) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)((Object)queryRelation), (String)"queryRelation");
        Intrinsics.checkNotNullParameter((Object)geometries, (String)"geometries");
        LatLonGeometry[] latLonGeometryArray = LatLonPointQuery.Companion.validateGeometry(queryRelation, Arrays.copyOf(geometries, geometries.length));
        super(field, queryRelation, Arrays.copyOf(latLonGeometryArray, latLonGeometryArray.length));
    }

    @Override
    @NotNull
    protected Component2D createComponent2D(Geometry ... geometries) {
        Intrinsics.checkNotNullParameter((Object)geometries, (String)"geometries");
        LatLonGeometry[] latLonGeometryArray = (LatLonGeometry[])geometries;
        return LatLonGeometry.Companion.create(Arrays.copyOf(latLonGeometryArray, latLonGeometryArray.length));
    }

    @Override
    @NotNull
    protected SpatialQuery.SpatialVisitor getSpatialVisitor() {
        GeoEncodingUtils.Component2DPredicate component2DPredicate = GeoEncodingUtils.INSTANCE.createComponentPredicate(this.getQueryComponent2D());
        int minLat = GeoEncodingUtils.INSTANCE.encodeLatitude(this.getQueryComponent2D().getMinY());
        int maxLat = GeoEncodingUtils.INSTANCE.encodeLatitude(this.getQueryComponent2D().getMaxY());
        int minLon = GeoEncodingUtils.INSTANCE.encodeLongitude(this.getQueryComponent2D().getMinX());
        int maxLon = GeoEncodingUtils.INSTANCE.encodeLongitude(this.getQueryComponent2D().getMaxX());
        return new SpatialQuery.SpatialVisitor(maxLat, minLat, maxLon, minLon, this, component2DPredicate){
            final /* synthetic */ int $maxLat;
            final /* synthetic */ int $minLat;
            final /* synthetic */ int $maxLon;
            final /* synthetic */ int $minLon;
            final /* synthetic */ LatLonPointQuery this$0;
            final /* synthetic */ GeoEncodingUtils.Component2DPredicate $component2DPredicate;
            {
                this.$maxLat = $maxLat;
                this.$minLat = $minLat;
                this.$maxLon = $maxLon;
                this.$minLon = $minLon;
                this.this$0 = $receiver;
                this.$component2DPredicate = $component2DPredicate;
            }

            protected PointValues.Relation relate(byte[] minPackedValue, byte[] maxPackedValue) {
                Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
                Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
                int latLowerBound = NumericUtils.INSTANCE.sortableBytesToInt(minPackedValue, 0);
                int latUpperBound = NumericUtils.INSTANCE.sortableBytesToInt(maxPackedValue, 0);
                if (latLowerBound > this.$maxLat || latUpperBound < this.$minLat) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                int lonLowerBound = NumericUtils.INSTANCE.sortableBytesToInt(minPackedValue, 4);
                int lonUpperBound = NumericUtils.INSTANCE.sortableBytesToInt(maxPackedValue, 4);
                if (lonLowerBound > this.$maxLon || lonUpperBound < this.$minLon) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                double cellMinLat = GeoEncodingUtils.INSTANCE.decodeLatitude(latLowerBound);
                double cellMinLon = GeoEncodingUtils.INSTANCE.decodeLongitude(lonLowerBound);
                double cellMaxLat = GeoEncodingUtils.INSTANCE.decodeLatitude(latUpperBound);
                double cellMaxLon = GeoEncodingUtils.INSTANCE.decodeLongitude(lonUpperBound);
                return this.this$0.getQueryComponent2D().relate(cellMinLon, cellMaxLon, cellMinLat, cellMaxLat);
            }

            protected Function1<byte[], Boolean> intersects() {
                return arg_0 -> spatialVisitor.1.intersects$lambda$0(this.$component2DPredicate, arg_0);
            }

            protected Function1<byte[], Boolean> within() {
                return arg_0 -> spatialVisitor.1.within$lambda$1(this.$component2DPredicate, arg_0);
            }

            public Function1<byte[], Component2D.WithinRelation> contains() {
                return arg_0 -> spatialVisitor.1.contains$lambda$2(this.this$0, arg_0);
            }

            private static final boolean intersects$lambda$0(GeoEncodingUtils.Component2DPredicate $component2DPredicate, byte[] packedValue) {
                Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                return $component2DPredicate.test(NumericUtils.INSTANCE.sortableBytesToInt(packedValue, 0), NumericUtils.INSTANCE.sortableBytesToInt(packedValue, 4));
            }

            private static final boolean within$lambda$1(GeoEncodingUtils.Component2DPredicate $component2DPredicate, byte[] packedValue) {
                Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                return $component2DPredicate.test(NumericUtils.INSTANCE.sortableBytesToInt(packedValue, 0), NumericUtils.INSTANCE.sortableBytesToInt(packedValue, 4));
            }

            private static final Component2D.WithinRelation contains$lambda$2(LatLonPointQuery this$0, byte[] packedValue) {
                Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                return this$0.getQueryComponent2D().withinPoint(GeoEncodingUtils.INSTANCE.decodeLongitude(NumericUtils.INSTANCE.sortableBytesToInt(packedValue, 4)), GeoEncodingUtils.INSTANCE.decodeLatitude(NumericUtils.INSTANCE.sortableBytesToInt(packedValue, 0)));
            }
        };
    }

    @Override
    @NotNull
    public String toString(@Nullable String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
        sb.append(':');
        if (!Intrinsics.areEqual((Object)this.getField(), (Object)field)) {
            sb.append(" field=");
            sb.append(this.getField());
            sb.append(':');
        }
        sb.append("[");
        int n = this.getGeometries().length;
        for (int i = 0; i < n; ++i) {
            sb.append(this.getGeometries()[i].toString());
            sb.append(',');
        }
        sb.append(']');
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean equalsTo(@Nullable Object o) {
        if (!super.equalsTo(o)) return false;
        Object[] objectArray = this.getGeometries();
        Intrinsics.checkNotNull((Object)o, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.document.LatLonPointQuery");
        if (!Arrays.equals(objectArray, ((LatLonPointQuery)o).getGeometries())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.getGeometries());
        return hash;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/document/LatLonPointQuery$Companion;", "", "<init>", "()V", "validateGeometry", "", "Lorg/gnit/lucenekmp/geo/LatLonGeometry;", "queryRelation", "Lorg/gnit/lucenekmp/document/ShapeField$QueryRelation;", "geometries", "(Lorg/gnit/lucenekmp/document/ShapeField$QueryRelation;[Lorg/gnit/lucenekmp/geo/LatLonGeometry;)[Lorg/gnit/lucenekmp/geo/LatLonGeometry;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final LatLonGeometry[] validateGeometry(ShapeField.QueryRelation queryRelation, LatLonGeometry ... geometries) {
            if (geometries != null) {
                LatLonGeometry geometry;
                int n;
                int n2;
                if (queryRelation == ShapeField.QueryRelation.WITHIN) {
                    n2 = geometries.length;
                    for (n = 0; n < n2; ++n) {
                        geometry = geometries[n];
                        if (!(geometry instanceof Line)) continue;
                        boolean $i$a$-require-LatLonPointQuery$Companion$validateGeometry$32 = false;
                        String $i$a$-require-LatLonPointQuery$Companion$validateGeometry$32 = "LatLonPointQuery does not support " + ShapeField.QueryRelation.WITHIN + " queries with line geometries";
                        throw new IllegalArgumentException($i$a$-require-LatLonPointQuery$Companion$validateGeometry$32.toString());
                    }
                }
                if (queryRelation == ShapeField.QueryRelation.CONTAINS) {
                    n2 = geometries.length;
                    for (n = 0; n < n2; ++n) {
                        geometry = geometries[n];
                        if (geometry instanceof Point) continue;
                        boolean bl = false;
                        String string = "LatLonPointQuery does not support " + ShapeField.QueryRelation.CONTAINS + " queries with non-points geometries";
                        throw new IllegalArgumentException(string.toString());
                    }
                }
            }
            return geometries;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

