/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.document;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.geo.GeoEncodingUtils;
import org.gnit.lucenekmp.geo.Rectangle;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.internal.hppc.IntArrayList;
import org.gnit.lucenekmp.jdkport.DoubleExtKt;
import org.gnit.lucenekmp.jdkport.PriorityQueue;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.SloppyMath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\t\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0003\u001c\u001d\u001eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JM\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J(\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J8\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/gnit/lucenekmp/document/NearestNeighbor;", "", "<init>", "()V", "nearest", "", "Lorg/gnit/lucenekmp/document/NearestNeighbor$NearestHit;", "pointLat", "", "pointLon", "readers", "", "Lorg/gnit/lucenekmp/index/PointValues;", "liveDocs", "Lorg/gnit/lucenekmp/util/Bits;", "docBases", "Lorg/gnit/lucenekmp/internal/hppc/IntArrayList;", "n", "", "(DDLjava/util/List;Ljava/util/List;Lorg/gnit/lucenekmp/internal/hppc/IntArrayList;I)[Lorg/gnit/lucenekmp/document/NearestNeighbor$NearestHit;", "approxBestDistance", "minPackedValue", "", "maxPackedValue", "minLat", "maxLat", "minLon", "maxLon", "Cell", "NearestVisitor", "NearestHit", "core"})
public final class NearestNeighbor {
    @NotNull
    public static final NearestNeighbor INSTANCE = new NearestNeighbor();

    private NearestNeighbor() {
    }

    @NotNull
    public final NearestHit[] nearest(double pointLat, double pointLon, @NotNull List<PointValues> readers, @NotNull List<Bits> liveDocs2, @NotNull IntArrayList docBases, int n) throws IOException {
        Intrinsics.checkNotNullParameter(readers, (String)"readers");
        Intrinsics.checkNotNullParameter(liveDocs2, (String)"liveDocs");
        Intrinsics.checkNotNullParameter((Object)docBases, (String)"docBases");
        PriorityQueue<NearestHit> hitQueue = new PriorityQueue<NearestHit>(n, NearestNeighbor::nearest$lambda$0);
        PriorityQueue<Cell> cellQueue = new PriorityQueue<Cell>(0, null, 3, null);
        NearestVisitor visitor2 = new NearestVisitor(hitQueue, n, pointLat, pointLon);
        int n2 = ((Collection)readers).size();
        for (int i = 0; i < n2; ++i) {
            PointValues reader2 = readers.get(i);
            byte[] minPackedValue = reader2.getMinPackedValue();
            byte[] maxPackedValue = reader2.getMaxPackedValue();
            PointValues.PointTree indexTree = reader2.getPointTree();
            cellQueue.offer(new Cell(indexTree, i, reader2.getMinPackedValue(), reader2.getMaxPackedValue(), this.approxBestDistance(minPackedValue, maxPackedValue, pointLat, pointLon)));
        }
        while (cellQueue.size() > 0) {
            Cell cell;
            Cell cell2 = cell = (Cell)cellQueue.poll();
            Intrinsics.checkNotNull((Object)cell2);
            if (visitor2.compare(cell2.getMinPacked(), cell.getMaxPacked()) == PointValues.Relation.CELL_OUTSIDE_QUERY) continue;
            if (!cell.getIndex().moveToChild()) {
                visitor2.setCurDocBase(docBases.get(cell.getReaderIndex()));
                visitor2.setCurLiveDocs(liveDocs2.get(cell.getReaderIndex()));
                cell.getIndex().visitDocValues(visitor2);
                continue;
            }
            PointValues.PointTree newIndex = cell.getIndex().clone();
            cellQueue.offer(new Cell(newIndex, cell.getReaderIndex(), newIndex.getMinPackedValue(), newIndex.getMaxPackedValue(), this.approxBestDistance(newIndex.getMinPackedValue(), newIndex.getMaxPackedValue(), pointLat, pointLon)));
            if (!cell.getIndex().moveToSibling()) continue;
            cellQueue.offer(new Cell(cell.getIndex(), cell.getReaderIndex(), cell.getIndex().getMinPackedValue(), cell.getIndex().getMaxPackedValue(), this.approxBestDistance(cell.getIndex().getMinPackedValue(), cell.getIndex().getMaxPackedValue(), pointLat, pointLon)));
        }
        NearestHit[] hits = new NearestHit[hitQueue.size()];
        int downTo = hitQueue.size() - 1;
        while (hitQueue.size() != 0) {
            hits[downTo] = hitQueue.poll();
            --downTo;
        }
        return hits;
    }

    private final double approxBestDistance(byte[] minPackedValue, byte[] maxPackedValue, double pointLat, double pointLon) {
        double minLat = GeoEncodingUtils.INSTANCE.decodeLatitude(minPackedValue, 0);
        double minLon = GeoEncodingUtils.INSTANCE.decodeLongitude(minPackedValue, 4);
        double maxLat = GeoEncodingUtils.INSTANCE.decodeLatitude(maxPackedValue, 0);
        double maxLon = GeoEncodingUtils.INSTANCE.decodeLongitude(maxPackedValue, 4);
        return this.approxBestDistance(minLat, maxLat, minLon, maxLon, pointLat, pointLon);
    }

    private final double approxBestDistance(double minLat, double maxLat, double minLon, double maxLon, double pointLat, double pointLon) {
        if (pointLat >= minLat && pointLat <= maxLat && pointLon >= minLon && pointLon <= maxLon) {
            return 0.0;
        }
        double d1 = SloppyMath.INSTANCE.haversinSortKey(pointLat, pointLon, minLat, minLon);
        double d2 = SloppyMath.INSTANCE.haversinSortKey(pointLat, pointLon, minLat, maxLon);
        double d3 = SloppyMath.INSTANCE.haversinSortKey(pointLat, pointLon, maxLat, maxLon);
        double d4 = SloppyMath.INSTANCE.haversinSortKey(pointLat, pointLon, maxLat, minLon);
        return Math.min(Math.min(d1, d2), Math.min(d3, d4));
    }

    private static final int nearest$lambda$0(NearestHit a, NearestHit b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int cmp = DoubleExtKt.compare(DoubleCompanionObject.INSTANCE, a.getDistanceSortKey(), b.getDistanceSortKey());
        if (cmp != 0) {
            return -cmp;
        }
        return b.getDocID() - a.getDocID();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0011\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/document/NearestNeighbor$Cell;", "", "index", "Lorg/gnit/lucenekmp/index/PointValues$PointTree;", "readerIndex", "", "minPacked", "", "maxPacked", "distanceSortKey", "", "<init>", "(Lorg/gnit/lucenekmp/index/PointValues$PointTree;I[B[BD)V", "getReaderIndex", "()I", "getDistanceSortKey", "()D", "compareTo", "other", "toString", "", "getIndex", "()Lorg/gnit/lucenekmp/index/PointValues$PointTree;", "getMinPacked", "()[B", "getMaxPacked", "core"})
    public static final class Cell
    implements Comparable<Cell> {
        private final int readerIndex;
        private final double distanceSortKey;
        @NotNull
        private final PointValues.PointTree index;
        @NotNull
        private final byte[] minPacked;
        @NotNull
        private final byte[] maxPacked;

        public Cell(@NotNull PointValues.PointTree index, int readerIndex, @NotNull byte[] minPacked, @NotNull byte[] maxPacked, double distanceSortKey) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Intrinsics.checkNotNullParameter((Object)minPacked, (String)"minPacked");
            Intrinsics.checkNotNullParameter((Object)maxPacked, (String)"maxPacked");
            this.readerIndex = readerIndex;
            this.distanceSortKey = distanceSortKey;
            this.index = index;
            byte[] minPacked2 = minPacked;
            byte[] maxPacked2 = maxPacked;
            byte[] byArray = Arrays.copyOf(minPacked2, minPacked2.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
            minPacked2 = byArray;
            byte[] byArray2 = Arrays.copyOf(maxPacked2, maxPacked2.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
            maxPacked2 = byArray2;
            this.minPacked = minPacked2;
            this.maxPacked = maxPacked2;
        }

        public final int getReaderIndex() {
            return this.readerIndex;
        }

        public final double getDistanceSortKey() {
            return this.distanceSortKey;
        }

        @Override
        public int compareTo(@NotNull Cell other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return DoubleExtKt.compare(DoubleCompanionObject.INSTANCE, this.distanceSortKey, other.distanceSortKey);
        }

        @NotNull
        public String toString() {
            double minLat = GeoEncodingUtils.INSTANCE.decodeLatitude(this.minPacked, 0);
            double minLon = GeoEncodingUtils.INSTANCE.decodeLongitude(this.minPacked, 4);
            double maxLat = GeoEncodingUtils.INSTANCE.decodeLatitude(this.maxPacked, 0);
            double maxLon = GeoEncodingUtils.INSTANCE.decodeLongitude(this.maxPacked, 4);
            return "Cell(readerIndex=" + this.readerIndex + " " + this.index + " lat=" + minLat + " TO " + maxLat + ", lon=" + minLon + " TO " + maxLon + "; distanceSortKey=" + this.distanceSortKey + ")";
        }

        @NotNull
        public final PointValues.PointTree getIndex() {
            return this.index;
        }

        @NotNull
        public final byte[] getMinPacked() {
            return this.minPacked;
        }

        @NotNull
        public final byte[] getMaxPacked() {
            return this.maxPacked;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/document/NearestNeighbor$NearestHit;", "", "<init>", "()V", "docID", "", "getDocID", "()I", "setDocID", "(I)V", "distanceSortKey", "", "getDistanceSortKey", "()D", "setDistanceSortKey", "(D)V", "toString", "", "core"})
    public static final class NearestHit {
        private int docID;
        private double distanceSortKey;

        public final int getDocID() {
            return this.docID;
        }

        public final void setDocID(int n) {
            this.docID = n;
        }

        public final double getDistanceSortKey() {
            return this.distanceSortKey;
        }

        public final void setDistanceSortKey(double d) {
            this.distanceSortKey = d;
        }

        @NotNull
        public String toString() {
            return "NearestHit(docID=" + this.docID + " distanceSortKey=" + this.distanceSortKey + ")";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0006H\u0016J\u0006\u0010&\u001a\u00020$J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020(H\u0016R\u001a\u0010\f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u000e\u0010\u001d\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/gnit/lucenekmp/document/NearestNeighbor$NearestVisitor;", "Lorg/gnit/lucenekmp/index/PointValues$IntersectVisitor;", "hitQueue", "Lorg/gnit/lucenekmp/jdkport/PriorityQueue;", "Lorg/gnit/lucenekmp/document/NearestNeighbor$NearestHit;", "topN", "", "pointLat", "", "pointLon", "<init>", "(Lorg/gnit/lucenekmp/jdkport/PriorityQueue;IDD)V", "curDocBase", "getCurDocBase", "()I", "setCurDocBase", "(I)V", "curLiveDocs", "Lorg/gnit/lucenekmp/util/Bits;", "getCurLiveDocs", "()Lorg/gnit/lucenekmp/util/Bits;", "setCurLiveDocs", "(Lorg/gnit/lucenekmp/util/Bits;)V", "getTopN", "getHitQueue", "()Lorg/gnit/lucenekmp/jdkport/PriorityQueue;", "getPointLat", "()D", "getPointLon", "setBottomCounter", "minLon", "maxLon", "minLat", "maxLat", "minLon2", "visit", "", "docID", "maybeUpdateBBox", "packedValue", "", "compare", "Lorg/gnit/lucenekmp/index/PointValues$Relation;", "minPackedValue", "maxPackedValue", "core"})
    private static final class NearestVisitor
    implements PointValues.IntersectVisitor {
        private int curDocBase;
        @Nullable
        private Bits curLiveDocs;
        private final int topN;
        @NotNull
        private final PriorityQueue<NearestHit> hitQueue;
        private final double pointLat;
        private final double pointLon;
        private int setBottomCounter;
        private double minLon;
        private double maxLon;
        private double minLat;
        private double maxLat;
        private double minLon2;

        public NearestVisitor(@NotNull PriorityQueue<NearestHit> hitQueue, int topN, double pointLat, double pointLon) {
            Intrinsics.checkNotNullParameter(hitQueue, (String)"hitQueue");
            this.minLon = Double.NEGATIVE_INFINITY;
            this.maxLon = Double.POSITIVE_INFINITY;
            this.minLat = Double.NEGATIVE_INFINITY;
            this.maxLat = Double.POSITIVE_INFINITY;
            this.minLon2 = Double.POSITIVE_INFINITY;
            this.hitQueue = hitQueue;
            this.topN = topN;
            this.pointLat = pointLat;
            this.pointLon = pointLon;
        }

        public final int getCurDocBase() {
            return this.curDocBase;
        }

        public final void setCurDocBase(int n) {
            this.curDocBase = n;
        }

        @Nullable
        public final Bits getCurLiveDocs() {
            return this.curLiveDocs;
        }

        public final void setCurLiveDocs(@Nullable Bits bits) {
            this.curLiveDocs = bits;
        }

        public final int getTopN() {
            return this.topN;
        }

        @NotNull
        public final PriorityQueue<NearestHit> getHitQueue() {
            return this.hitQueue;
        }

        public final double getPointLat() {
            return this.pointLat;
        }

        public final double getPointLon() {
            return this.pointLon;
        }

        @Override
        public void visit(int docID) {
            throw new AssertionError();
        }

        public final void maybeUpdateBBox() {
            if (this.setBottomCounter < 1024 || (this.setBottomCounter & 0x3F) == 63) {
                NearestHit hit;
                NearestHit nearestHit = hit = this.hitQueue.peek();
                Intrinsics.checkNotNull((Object)nearestHit);
                Rectangle box = Rectangle.Companion.fromPointDistance(this.pointLat, this.pointLon, SloppyMath.INSTANCE.haversinMeters(nearestHit.getDistanceSortKey()));
                this.minLat = box.getMinLat();
                this.maxLat = box.getMaxLat();
                if (box.crossesDateline()) {
                    this.minLon = Double.NEGATIVE_INFINITY;
                    this.maxLon = box.getMaxLon();
                    this.minLon2 = box.getMinLon();
                } else {
                    this.minLon = box.getMinLon();
                    this.maxLon = box.getMaxLon();
                    this.minLon2 = Double.POSITIVE_INFINITY;
                }
            }
            int n = this.setBottomCounter;
            this.setBottomCounter = n + 1;
        }

        @Override
        public void visit(int docID, @NotNull byte[] packedValue) {
            Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
            if (this.curLiveDocs != null) {
                Bits bits = this.curLiveDocs;
                Intrinsics.checkNotNull((Object)bits);
                if (!bits.get(docID)) {
                    return;
                }
            }
            double docLatitude = GeoEncodingUtils.INSTANCE.decodeLatitude(packedValue, 0);
            double docLongitude = GeoEncodingUtils.INSTANCE.decodeLongitude(packedValue, 4);
            if (docLatitude < this.minLat || docLatitude > this.maxLat) {
                return;
            }
            if ((docLongitude < this.minLon || docLongitude > this.maxLon) && docLongitude < this.minLon2) {
                return;
            }
            double distanceSortKey = SloppyMath.INSTANCE.haversinSortKey(this.pointLat, this.pointLon, docLatitude, docLongitude);
            int fullDocID = this.curDocBase + docID;
            if (this.hitQueue.size() == this.topN) {
                NearestHit hit;
                NearestHit nearestHit = hit = this.hitQueue.peek();
                Intrinsics.checkNotNull((Object)nearestHit);
                if (distanceSortKey < nearestHit.getDistanceSortKey() || distanceSortKey == hit.getDistanceSortKey() && fullDocID < hit.getDocID()) {
                    this.hitQueue.poll();
                    hit.setDocID(fullDocID);
                    hit.setDistanceSortKey(distanceSortKey);
                    this.hitQueue.offer(hit);
                    this.maybeUpdateBBox();
                }
            } else {
                NearestHit hit = new NearestHit();
                hit.setDocID(fullDocID);
                hit.setDistanceSortKey(distanceSortKey);
                this.hitQueue.offer(hit);
            }
        }

        @Override
        @NotNull
        public PointValues.Relation compare(@NotNull byte[] minPackedValue, @NotNull byte[] maxPackedValue) {
            Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
            Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
            double cellMinLat = GeoEncodingUtils.INSTANCE.decodeLatitude(minPackedValue, 0);
            double cellMinLon = GeoEncodingUtils.INSTANCE.decodeLongitude(minPackedValue, 4);
            double cellMaxLat = GeoEncodingUtils.INSTANCE.decodeLatitude(maxPackedValue, 0);
            double cellMaxLon = GeoEncodingUtils.INSTANCE.decodeLongitude(maxPackedValue, 4);
            if (cellMaxLat < this.minLat || this.maxLat < cellMinLat || (cellMaxLon < this.minLon || this.maxLon < cellMinLon) && cellMaxLon < this.minLon2) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }

        @Override
        public void visit(@NotNull DocIdSetIterator iterator2) throws IOException {
            PointValues.IntersectVisitor.super.visit(iterator2);
        }

        @Override
        public void visit(@NotNull IntsRef ref) throws IOException {
            PointValues.IntersectVisitor.super.visit(ref);
        }

        @Override
        public void visit(@NotNull DocIdSetIterator iterator2, @NotNull byte[] packedValue) throws IOException {
            PointValues.IntersectVisitor.super.visit(iterator2, packedValue);
        }

        @Override
        public void grow(int count) {
            PointValues.IntersectVisitor.super.grow(count);
        }
    }
}

