/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.document;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.document.Field;
import org.gnit.lucenekmp.document.FieldType;
import org.gnit.lucenekmp.document.SortedNumericDocValuesRangeQuery;
import org.gnit.lucenekmp.document.SortedNumericDocValuesSetQuery;
import org.gnit.lucenekmp.index.DocValuesSkipIndexType;
import org.gnit.lucenekmp.index.DocValuesType;
import org.gnit.lucenekmp.search.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nB\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/document/NumericDocValuesField;", "Lorg/gnit/lucenekmp/document/Field;", "name", "", "value", "", "fieldType", "Lorg/gnit/lucenekmp/document/FieldType;", "<init>", "(Ljava/lang/String;JLorg/gnit/lucenekmp/document/FieldType;)V", "(Ljava/lang/String;J)V", "(Ljava/lang/String;Ljava/lang/Long;)V", "Companion", "core"})
public final class NumericDocValuesField
extends Field {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final FieldType TYPE = new FieldType();
    @NotNull
    private static final FieldType INDEXED_TYPE;

    public NumericDocValuesField(@NotNull String name, long value, @NotNull FieldType fieldType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fieldType, (String)"fieldType");
        super(name, fieldType);
        this.setFieldsData(value);
    }

    public NumericDocValuesField(@NotNull String name, long value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name, value, INDEXED_TYPE);
    }

    public NumericDocValuesField(@NotNull String name, @Nullable Long value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Long l = value;
        Intrinsics.checkNotNull((Object)l);
        this(name, l, TYPE);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.NUMERIC);
        TYPE.freeze();
        INDEXED_TYPE = new FieldType(TYPE);
        INDEXED_TYPE.setDocValuesSkipIndexType(DocValuesSkipIndexType.RANGE);
        INDEXED_TYPE.freeze();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eJ\u001a\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\n\u0010\u0015\u001a\u00020\u0016\"\u00020\u000eJ\u0016\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/document/NumericDocValuesField$Companion;", "", "<init>", "()V", "TYPE", "Lorg/gnit/lucenekmp/document/FieldType;", "getTYPE", "()Lorg/gnit/lucenekmp/document/FieldType;", "INDEXED_TYPE", "indexedField", "Lorg/gnit/lucenekmp/document/NumericDocValuesField;", "name", "", "value", "", "newSlowRangeQuery", "Lorg/gnit/lucenekmp/search/Query;", "field", "lowerValue", "upperValue", "newSlowSetQuery", "values", "", "newSlowExactQuery", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FieldType getTYPE() {
            return TYPE;
        }

        @NotNull
        public final NumericDocValuesField indexedField(@NotNull String name, long value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new NumericDocValuesField(name, value, INDEXED_TYPE);
        }

        @NotNull
        public final Query newSlowRangeQuery(@NotNull String field, long lowerValue, long upperValue) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new SortedNumericDocValuesRangeQuery(field, lowerValue, upperValue);
        }

        @NotNull
        public final Query newSlowSetQuery(@NotNull String field, long ... values2) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            long[] lArray = Arrays.copyOf(values2, values2.length);
            Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
            Intrinsics.checkNotNull((Object)lArray, (String)"null cannot be cast to non-null type kotlin.LongArray");
            return new SortedNumericDocValuesSetQuery(field, lArray);
        }

        @NotNull
        public final Query newSlowExactQuery(@NotNull String field, long value) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return this.newSlowRangeQuery(field, value, value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

