/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.document;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.document.Field;
import org.gnit.lucenekmp.document.FieldType;
import org.gnit.lucenekmp.geo.GeoUtils;
import org.gnit.lucenekmp.geo.Tessellator;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.jdkport.StrictMath;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.NumericUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003%&'B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JV\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0019J\u0016\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/gnit/lucenekmp/document/ShapeField;", "", "<init>", "()V", "BYTES", "", "TYPE", "Lorg/gnit/lucenekmp/document/FieldType;", "getTYPE$core", "()Lorg/gnit/lucenekmp/document/FieldType;", "MINY_MINX_MAXY_MAXX_Y_X", "MINY_MINX_Y_X_MAXY_MAXX", "MAXY_MINX_Y_X_MINY_MAXX", "MAXY_MINX_MINY_MAXX_Y_X", "Y_MINX_MINY_X_MAXY_MAXX", "Y_MINX_MINY_MAXX_MAXY_X", "MAXY_MINX_MINY_X_Y_MAXX", "MINY_MINX_Y_MAXX_MAXY_X", "encodeTriangle", "", "bytes", "", "aY", "aX", "ab", "", "bY", "bX", "bc", "cY", "cX", "ca", "decodeTriangle", "t", "triangle", "Lorg/gnit/lucenekmp/document/ShapeField$DecodedTriangle;", "resolveTriangleType", "Triangle", "QueryRelation", "DecodedTriangle", "core"})
public final class ShapeField {
    @NotNull
    public static final ShapeField INSTANCE = new ShapeField();
    public static final int BYTES = 4;
    @NotNull
    private static final FieldType TYPE = new FieldType();
    private static final int MINY_MINX_MAXY_MAXX_Y_X = 0;
    private static final int MINY_MINX_Y_X_MAXY_MAXX = 1;
    private static final int MAXY_MINX_Y_X_MINY_MAXX = 2;
    private static final int MAXY_MINX_MINY_MAXX_Y_X = 3;
    private static final int Y_MINX_MINY_X_MAXY_MAXX = 4;
    private static final int Y_MINX_MINY_MAXX_MAXY_X = 5;
    private static final int MAXY_MINX_MINY_X_Y_MAXX = 6;
    private static final int MINY_MINX_Y_MAXX_MAXY_X = 7;

    private ShapeField() {
    }

    @NotNull
    public final FieldType getTYPE$core() {
        return TYPE;
    }

    public final void encodeTriangle(@NotNull byte[] bytes, int aY, int aX, boolean ab, int bY, int bX, boolean bc, int cY, int cX, boolean ca) {
        boolean tempBool;
        int tempY;
        int tempX;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int aY2 = aY;
        int aX2 = aX;
        boolean ab2 = ab;
        int bY2 = bY;
        int bX2 = bX;
        boolean bc2 = bc;
        int cY2 = cY;
        int cX2 = cX;
        boolean ca2 = ca;
        if (!(bytes.length == 28)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (bX2 < aX2 || cX2 < aX2) {
            tempX = aX2;
            tempY = aY2;
            tempBool = ab2;
            if (bX2 < cX2) {
                aX2 = bX2;
                aY2 = bY2;
                ab2 = bc2;
                bX2 = cX2;
                bY2 = cY2;
                bc2 = ca2;
                cX2 = tempX;
                cY2 = tempY;
                ca2 = tempBool;
            } else {
                aX2 = cX2;
                aY2 = cY2;
                ab2 = ca2;
                cX2 = bX2;
                cY2 = bY2;
                ca2 = bc2;
                bX2 = tempX;
                bY2 = tempY;
                bc2 = tempBool;
            }
        } else if (aX2 == bX2 && aX2 == cX2 && (bY2 < aY2 || cY2 < aY2)) {
            tempX = aX2;
            tempY = aY2;
            tempBool = ab2;
            if (bY2 < cY2) {
                aX2 = bX2;
                aY2 = bY2;
                ab2 = bc2;
                bX2 = cX2;
                bY2 = cY2;
                bc2 = ca2;
                cX2 = tempX;
                cY2 = tempY;
                ca2 = tempBool;
            } else {
                aX2 = cX2;
                aY2 = cY2;
                ab2 = ca2;
                cX2 = bX2;
                cY2 = bY2;
                ca2 = bc2;
                bX2 = tempX;
                bY2 = tempY;
                bc2 = tempBool;
            }
        }
        if (GeoUtils.INSTANCE.orient(aX2, aY2, bX2, bY2, cX2, cY2) == -1) {
            tempX = bX2;
            tempY = bY2;
            tempBool = ab2;
            ab2 = bc2;
            bX2 = cX2;
            bY2 = cY2;
            cX2 = tempX;
            cY2 = tempY;
            ca2 = tempBool;
        }
        int minX = aX2;
        int minY = StrictMath.INSTANCE.min(aY2, StrictMath.INSTANCE.min(bY2, cY2));
        int maxX = StrictMath.INSTANCE.max(aX2, StrictMath.INSTANCE.max(bX2, cX2));
        int maxY = StrictMath.INSTANCE.max(aY2, StrictMath.INSTANCE.max(bY2, cY2));
        int bits = 0;
        int x = 0;
        int y = 0;
        if (minY == aY2) {
            if (maxY == bY2 && maxX == bX2) {
                y = cY2;
                x = cX2;
                bits = 0;
            } else if (maxY == cY2 && maxX == cX2) {
                y = bY2;
                x = bX2;
                bits = 1;
            } else {
                y = bY2;
                x = cX2;
                bits = 7;
            }
        } else if (maxY == aY2) {
            if (minY == bY2 && maxX == bX2) {
                y = cY2;
                x = cX2;
                bits = 3;
            } else if (minY == cY2 && maxX == cX2) {
                y = bY2;
                x = bX2;
                bits = 2;
            } else {
                y = cY2;
                x = bX2;
                bits = 6;
            }
        } else if (maxX == bX2 && minY == bY2) {
            y = aY2;
            x = cX2;
            bits = 5;
        } else if (maxX == cX2 && maxY == cY2) {
            y = aY2;
            x = bX2;
            bits = 4;
        } else {
            throw new IllegalArgumentException("Could not encode the provided triangle");
        }
        bits |= ab2 ? 8 : 0;
        bits |= bc2 ? 16 : 0;
        bits |= ca2 ? 32 : 0;
        NumericUtils.INSTANCE.intToSortableBytes(minY, bytes, 0);
        NumericUtils.INSTANCE.intToSortableBytes(minX, bytes, 4);
        NumericUtils.INSTANCE.intToSortableBytes(maxY, bytes, 8);
        NumericUtils.INSTANCE.intToSortableBytes(maxX, bytes, 12);
        NumericUtils.INSTANCE.intToSortableBytes(y, bytes, 16);
        NumericUtils.INSTANCE.intToSortableBytes(x, bytes, 20);
        NumericUtils.INSTANCE.intToSortableBytes(bits, bytes, 24);
    }

    public final void decodeTriangle(@NotNull byte[] t, @NotNull DecodedTriangle triangle) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)triangle, (String)"triangle");
        int aX = 0;
        int aY = 0;
        int bX = 0;
        int bY = 0;
        int cX = 0;
        int cY = 0;
        boolean ab = false;
        boolean bc = false;
        boolean ca = false;
        int bits = NumericUtils.INSTANCE.sortableBytesToInt(t, 24);
        int tCode = 7 & bits >> 0;
        switch (tCode) {
            case 0: {
                aY = NumericUtils.INSTANCE.sortableBytesToInt(t, 0);
                aX = NumericUtils.INSTANCE.sortableBytesToInt(t, 4);
                bY = NumericUtils.INSTANCE.sortableBytesToInt(t, 8);
                bX = NumericUtils.INSTANCE.sortableBytesToInt(t, 12);
                cY = NumericUtils.INSTANCE.sortableBytesToInt(t, 16);
                cX = NumericUtils.INSTANCE.sortableBytesToInt(t, 20);
                break;
            }
            case 1: {
                aY = NumericUtils.INSTANCE.sortableBytesToInt(t, 0);
                aX = NumericUtils.INSTANCE.sortableBytesToInt(t, 4);
                bY = NumericUtils.INSTANCE.sortableBytesToInt(t, 16);
                bX = NumericUtils.INSTANCE.sortableBytesToInt(t, 20);
                cY = NumericUtils.INSTANCE.sortableBytesToInt(t, 8);
                cX = NumericUtils.INSTANCE.sortableBytesToInt(t, 12);
                break;
            }
            case 2: {
                aY = NumericUtils.INSTANCE.sortableBytesToInt(t, 8);
                aX = NumericUtils.INSTANCE.sortableBytesToInt(t, 4);
                bY = NumericUtils.INSTANCE.sortableBytesToInt(t, 16);
                bX = NumericUtils.INSTANCE.sortableBytesToInt(t, 20);
                cY = NumericUtils.INSTANCE.sortableBytesToInt(t, 0);
                cX = NumericUtils.INSTANCE.sortableBytesToInt(t, 12);
                break;
            }
            case 3: {
                aY = NumericUtils.INSTANCE.sortableBytesToInt(t, 8);
                aX = NumericUtils.INSTANCE.sortableBytesToInt(t, 4);
                bY = NumericUtils.INSTANCE.sortableBytesToInt(t, 0);
                bX = NumericUtils.INSTANCE.sortableBytesToInt(t, 12);
                cY = NumericUtils.INSTANCE.sortableBytesToInt(t, 16);
                cX = NumericUtils.INSTANCE.sortableBytesToInt(t, 20);
                break;
            }
            case 4: {
                aY = NumericUtils.INSTANCE.sortableBytesToInt(t, 16);
                aX = NumericUtils.INSTANCE.sortableBytesToInt(t, 4);
                bY = NumericUtils.INSTANCE.sortableBytesToInt(t, 0);
                bX = NumericUtils.INSTANCE.sortableBytesToInt(t, 20);
                cY = NumericUtils.INSTANCE.sortableBytesToInt(t, 8);
                cX = NumericUtils.INSTANCE.sortableBytesToInt(t, 12);
                break;
            }
            case 5: {
                aY = NumericUtils.INSTANCE.sortableBytesToInt(t, 16);
                aX = NumericUtils.INSTANCE.sortableBytesToInt(t, 4);
                bY = NumericUtils.INSTANCE.sortableBytesToInt(t, 0);
                bX = NumericUtils.INSTANCE.sortableBytesToInt(t, 12);
                cY = NumericUtils.INSTANCE.sortableBytesToInt(t, 8);
                cX = NumericUtils.INSTANCE.sortableBytesToInt(t, 20);
                break;
            }
            case 6: {
                aY = NumericUtils.INSTANCE.sortableBytesToInt(t, 8);
                aX = NumericUtils.INSTANCE.sortableBytesToInt(t, 4);
                bY = NumericUtils.INSTANCE.sortableBytesToInt(t, 0);
                bX = NumericUtils.INSTANCE.sortableBytesToInt(t, 20);
                cY = NumericUtils.INSTANCE.sortableBytesToInt(t, 16);
                cX = NumericUtils.INSTANCE.sortableBytesToInt(t, 12);
                break;
            }
            case 7: {
                aY = NumericUtils.INSTANCE.sortableBytesToInt(t, 0);
                aX = NumericUtils.INSTANCE.sortableBytesToInt(t, 4);
                bY = NumericUtils.INSTANCE.sortableBytesToInt(t, 16);
                bX = NumericUtils.INSTANCE.sortableBytesToInt(t, 12);
                cY = NumericUtils.INSTANCE.sortableBytesToInt(t, 8);
                cX = NumericUtils.INSTANCE.sortableBytesToInt(t, 20);
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not decode the provided triangle");
            }
        }
        if (!(GeoUtils.INSTANCE.orient(aX, aY, bX, bY, cX, cY) >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ab = (bits & 8) == 8;
        bc = (bits & 0x10) == 16;
        ca = (bits & 0x20) == 32;
        triangle.setValues(aX, aY, ab, bX, bY, bc, cX, cY, ca);
        this.resolveTriangleType(triangle);
    }

    public final void resolveTriangleType(@NotNull DecodedTriangle triangle) {
        Intrinsics.checkNotNullParameter((Object)triangle, (String)"triangle");
        if (triangle.getAX() == triangle.getBX() && triangle.getAY() == triangle.getBY()) {
            if (triangle.getAX() == triangle.getCX() && triangle.getAY() == triangle.getCY()) {
                triangle.setType(DecodedTriangle.TYPE.POINT);
            } else {
                triangle.setAb(triangle.getBc() | triangle.getCa());
                triangle.setBX(triangle.getCX());
                triangle.setBY(triangle.getCY());
                triangle.setCX(triangle.getAX());
                triangle.setCY(triangle.getAY());
                triangle.setType(DecodedTriangle.TYPE.LINE);
            }
        } else if (triangle.getAX() == triangle.getCX() && triangle.getAY() == triangle.getCY()) {
            triangle.setAb(triangle.getAb() | triangle.getBc());
            triangle.setType(DecodedTriangle.TYPE.LINE);
        } else if (triangle.getBX() == triangle.getCX() && triangle.getBY() == triangle.getCY()) {
            triangle.setAb(triangle.getAb() | triangle.getCa());
            triangle.setCX(triangle.getAX());
            triangle.setCY(triangle.getAY());
            triangle.setType(DecodedTriangle.TYPE.LINE);
        } else {
            triangle.setType(DecodedTriangle.TYPE.TRIANGLE);
        }
    }

    static {
        TYPE.setDimensions(7, 4, 4);
        TYPE.freeze();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JN\u0010+\u001a\u00020,2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u001aJ\b\u0010-\u001a\u00020\u0005H\u0016J\u0013\u0010.\u001a\u00020\u001a2\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u00100\u001a\u000201H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001a\u0010\u0013\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\tR\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u001a\u0010\"\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001c\"\u0004\b$\u0010\u001eR\u001a\u0010%\u001a\u00020&X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u00063"}, d2={"Lorg/gnit/lucenekmp/document/ShapeField$DecodedTriangle;", "", "<init>", "()V", "aX", "", "getAX", "()I", "setAX", "(I)V", "aY", "getAY", "setAY", "bX", "getBX", "setBX", "bY", "getBY", "setBY", "cX", "getCX", "setCX", "cY", "getCY", "setCY", "ab", "", "getAb", "()Z", "setAb", "(Z)V", "bc", "getBc", "setBc", "ca", "getCa", "setCa", "type", "Lorg/gnit/lucenekmp/document/ShapeField$DecodedTriangle$TYPE;", "getType", "()Lorg/gnit/lucenekmp/document/ShapeField$DecodedTriangle$TYPE;", "setType", "(Lorg/gnit/lucenekmp/document/ShapeField$DecodedTriangle$TYPE;)V", "setValues", "", "hashCode", "equals", "o", "toString", "", "TYPE", "core"})
    public static final class DecodedTriangle {
        private int aX;
        private int aY;
        private int bX;
        private int bY;
        private int cX;
        private int cY;
        private boolean ab;
        private boolean bc;
        private boolean ca;
        public TYPE type;

        public final int getAX() {
            return this.aX;
        }

        public final void setAX(int n) {
            this.aX = n;
        }

        public final int getAY() {
            return this.aY;
        }

        public final void setAY(int n) {
            this.aY = n;
        }

        public final int getBX() {
            return this.bX;
        }

        public final void setBX(int n) {
            this.bX = n;
        }

        public final int getBY() {
            return this.bY;
        }

        public final void setBY(int n) {
            this.bY = n;
        }

        public final int getCX() {
            return this.cX;
        }

        public final void setCX(int n) {
            this.cX = n;
        }

        public final int getCY() {
            return this.cY;
        }

        public final void setCY(int n) {
            this.cY = n;
        }

        public final boolean getAb() {
            return this.ab;
        }

        public final void setAb(boolean bl) {
            this.ab = bl;
        }

        public final boolean getBc() {
            return this.bc;
        }

        public final void setBc(boolean bl) {
            this.bc = bl;
        }

        public final boolean getCa() {
            return this.ca;
        }

        public final void setCa(boolean bl) {
            this.ca = bl;
        }

        @NotNull
        public final TYPE getType() {
            TYPE tYPE = this.type;
            if (tYPE != null) {
                return tYPE;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"type");
            return null;
        }

        public final void setType(@NotNull TYPE tYPE) {
            Intrinsics.checkNotNullParameter((Object)((Object)tYPE), (String)"<set-?>");
            this.type = tYPE;
        }

        public final void setValues(int aX, int aY, boolean ab, int bX, int bY, boolean bc, int cX, int cY, boolean ca) {
            this.aX = aX;
            this.aY = aY;
            this.ab = ab;
            this.bX = bX;
            this.bY = bY;
            this.bc = bc;
            this.cX = cX;
            this.cY = cY;
            this.ca = ca;
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.aX, this.aY, this.bX, this.bY, this.cX, this.cY, this.ab, this.bc, this.ca};
            return Objects.INSTANCE.hash(objectArray);
        }

        public boolean equals(@Nullable Object o) {
            Intrinsics.checkNotNull((Object)o, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.document.ShapeField.DecodedTriangle");
            DecodedTriangle other = (DecodedTriangle)o;
            return this.aX == other.aX && this.bX == other.bX && this.cX == other.cX && this.aY == other.aY && this.bY == other.bY && this.cY == other.cY && this.ab == other.ab && this.bc == other.bc && this.ca == other.ca;
        }

        @NotNull
        public String toString() {
            String result = this.aX + ", " + this.aY + " " + this.bX + ", " + this.bY + " " + this.cX + ", " + this.cY + " [" + this.ab + "," + this.bc + "," + this.ca + "]";
            return result;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/document/ShapeField$DecodedTriangle$TYPE;", "", "<init>", "(Ljava/lang/String;I)V", "POINT", "LINE", "TRIANGLE", "core"})
        public static final class TYPE
        extends Enum<TYPE> {
            public static final /* enum */ TYPE POINT = new TYPE();
            public static final /* enum */ TYPE LINE = new TYPE();
            public static final /* enum */ TYPE TRIANGLE = new TYPE();
            private static final /* synthetic */ TYPE[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static TYPE[] values() {
                return (TYPE[])$VALUES.clone();
            }

            public static TYPE valueOf(String value) {
                return Enum.valueOf(TYPE.class, value);
            }

            @NotNull
            public static EnumEntries<TYPE> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = tYPEArray = new TYPE[]{org.gnit.lucenekmp.document.ShapeField$DecodedTriangle$TYPE.POINT, org.gnit.lucenekmp.document.ShapeField$DecodedTriangle$TYPE.LINE, org.gnit.lucenekmp.document.ShapeField$DecodedTriangle$TYPE.TRIANGLE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/document/ShapeField$QueryRelation;", "", "<init>", "(Ljava/lang/String;I)V", "INTERSECTS", "WITHIN", "DISJOINT", "CONTAINS", "core"})
    public static final class QueryRelation
    extends Enum<QueryRelation> {
        public static final /* enum */ QueryRelation INTERSECTS = new QueryRelation();
        public static final /* enum */ QueryRelation WITHIN = new QueryRelation();
        public static final /* enum */ QueryRelation DISJOINT = new QueryRelation();
        public static final /* enum */ QueryRelation CONTAINS = new QueryRelation();
        private static final /* synthetic */ QueryRelation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static QueryRelation[] values() {
            return (QueryRelation[])$VALUES.clone();
        }

        public static QueryRelation valueOf(String value) {
            return Enum.valueOf(QueryRelation.class, value);
        }

        @NotNull
        public static EnumEntries<QueryRelation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = queryRelationArray = new QueryRelation[]{QueryRelation.INTERSECTS, QueryRelation.WITHIN, QueryRelation.DISJOINT, QueryRelation.CONTAINS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001BA\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fB\u0019\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000b\u0010\u000fJP\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0015H\u0004\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/document/ShapeField$Triangle;", "Lorg/gnit/lucenekmp/document/Field;", "name", "", "aXencoded", "", "aYencoded", "bXencoded", "bYencoded", "cXencoded", "cYencoded", "<init>", "(Ljava/lang/String;IIIIII)V", "t", "Lorg/gnit/lucenekmp/geo/Tessellator$Triangle;", "(Ljava/lang/String;Lorg/gnit/lucenekmp/geo/Tessellator$Triangle;)V", "setTriangleValue", "", "aX", "aY", "abFromShape", "", "bX", "bY", "bcFromShape", "cX", "cY", "caFromShape", "core"})
    public static class Triangle
    extends Field {
        public Triangle(@NotNull String name, int aXencoded, int aYencoded, int bXencoded, int bYencoded, int cXencoded, int cYencoded) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name, INSTANCE.getTYPE$core());
            this.setTriangleValue(aXencoded, aYencoded, true, bXencoded, bYencoded, true, cXencoded, cYencoded, true);
        }

        public Triangle(@NotNull String name, @NotNull Tessellator.Triangle t) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            super(name, INSTANCE.getTYPE$core());
            this.setTriangleValue(t.getEncodedX(0), t.getEncodedY(0), t.isEdgefromPolygon(0), t.getEncodedX(1), t.getEncodedY(1), t.isEdgefromPolygon(1), t.getEncodedX(2), t.getEncodedY(2), t.isEdgefromPolygon(2));
        }

        protected final void setTriangleValue(int aX, int aY, boolean abFromShape, int bX, int bY, boolean bcFromShape, int cX, int cY, boolean caFromShape) {
            byte[] bytes = null;
            if (this.getFieldsData() == null) {
                bytes = new byte[28];
                this.setFieldsData(new BytesRef(bytes));
            } else {
                Object object = this.getFieldsData();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.BytesRef");
                bytes = ((BytesRef)object).getBytes();
            }
            INSTANCE.encodeTriangle(bytes, aY, aX, abFromShape, bY, bX, bcFromShape, cY, cX, caFromShape);
        }
    }
}

