/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.document;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.analysis.TokenStream;
import org.gnit.lucenekmp.document.Field;
import org.gnit.lucenekmp.document.FieldType;
import org.gnit.lucenekmp.document.StoredValue;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.IndexableFieldType;
import org.gnit.lucenekmp.jdkport.Reader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0006\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u0006\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u0003H\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/document/TextField;", "Lorg/gnit/lucenekmp/document/Field;", "name", "", "reader", "Lorg/gnit/lucenekmp/jdkport/Reader;", "<init>", "(Ljava/lang/String;Lorg/gnit/lucenekmp/jdkport/Reader;)V", "value", "store", "Lorg/gnit/lucenekmp/document/Field$Store;", "(Ljava/lang/String;Ljava/lang/String;Lorg/gnit/lucenekmp/document/Field$Store;)V", "stream", "Lorg/gnit/lucenekmp/analysis/TokenStream;", "(Ljava/lang/String;Lorg/gnit/lucenekmp/analysis/TokenStream;)V", "storedValue", "Lorg/gnit/lucenekmp/document/StoredValue;", "setStringValue", "", "Companion", "core"})
public final class TextField
extends Field {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private StoredValue storedValue;
    @NotNull
    private static final FieldType TYPE_NOT_STORED = new FieldType();
    @NotNull
    private static final FieldType TYPE_STORED = new FieldType();

    public TextField(@NotNull String name, @NotNull Reader reader2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        super(name, reader2, (IndexableFieldType)TYPE_NOT_STORED);
        this.storedValue = null;
    }

    public TextField(@NotNull String name, @NotNull String value, @NotNull Field.Store store) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)((Object)store), (String)"store");
        super(name, value, (IndexableFieldType)(store == Field.Store.YES ? TYPE_STORED : TYPE_NOT_STORED));
        this.storedValue = store == Field.Store.YES ? new StoredValue(value) : null;
    }

    public TextField(@NotNull String name, @NotNull TokenStream stream) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        super(name, stream, (IndexableFieldType)TYPE_NOT_STORED);
        this.storedValue = null;
    }

    @Override
    public void setStringValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super.setStringValue(value);
        if (this.storedValue != null) {
            StoredValue storedValue = this.storedValue;
            Intrinsics.checkNotNull((Object)storedValue);
            storedValue.setStringValue(value);
        }
    }

    @Override
    @Nullable
    public StoredValue storedValue() {
        return this.storedValue;
    }

    static {
        TYPE_NOT_STORED.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        TYPE_NOT_STORED.setTokenized(true);
        TYPE_NOT_STORED.freeze();
        TYPE_STORED.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        TYPE_STORED.setTokenized(true);
        TYPE_STORED.setStored(true);
        TYPE_STORED.freeze();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/document/TextField$Companion;", "", "<init>", "()V", "TYPE_NOT_STORED", "Lorg/gnit/lucenekmp/document/FieldType;", "getTYPE_NOT_STORED", "()Lorg/gnit/lucenekmp/document/FieldType;", "TYPE_STORED", "getTYPE_STORED", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FieldType getTYPE_NOT_STORED() {
            return TYPE_NOT_STORED;
        }

        @NotNull
        public final FieldType getTYPE_STORED() {
            return TYPE_STORED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

