/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.geo.Circle;
import org.gnit.lucenekmp.geo.Component2D;
import org.gnit.lucenekmp.geo.GeoUtils;
import org.gnit.lucenekmp.geo.Rectangle;
import org.gnit.lucenekmp.geo.XYCircle;
import org.gnit.lucenekmp.geo.XYRectangle;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.jdkport.StrictMath;
import org.gnit.lucenekmp.util.SloppyMath;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 *2\u00020\u0001:\u0004'()*B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0016JH\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0016JX\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0016JH\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0016JX\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0016JP\u0010\"\u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0016Jp\u0010$\u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\u00a8\u0006+"}, d2={"Lorg/gnit/lucenekmp/geo/Circle2D;", "Lorg/gnit/lucenekmp/geo/Component2D;", "calculator", "Lorg/gnit/lucenekmp/geo/Circle2D$DistanceCalculator;", "<init>", "(Lorg/gnit/lucenekmp/geo/Circle2D$DistanceCalculator;)V", "minX", "", "getMinX", "()D", "maxX", "getMaxX", "minY", "getMinY", "maxY", "getMaxY", "contains", "", "x", "y", "relate", "Lorg/gnit/lucenekmp/index/PointValues$Relation;", "intersectsLine", "aX", "aY", "bX", "bY", "intersectsTriangle", "cX", "cY", "containsLine", "containsTriangle", "withinPoint", "Lorg/gnit/lucenekmp/geo/Component2D$WithinRelation;", "withinLine", "ab", "withinTriangle", "bc", "ca", "DistanceCalculator", "CartesianDistance", "HaversinDistance", "Companion", "core"})
public final class Circle2D
implements Component2D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DistanceCalculator calculator;

    private Circle2D(DistanceCalculator calculator) {
        this.calculator = calculator;
    }

    @Override
    public double getMinX() {
        return this.calculator.getMinX();
    }

    @Override
    public double getMaxX() {
        return this.calculator.getMaxX();
    }

    @Override
    public double getMinY() {
        return this.calculator.getMinY();
    }

    @Override
    public double getMaxY() {
        return this.calculator.getMaxY();
    }

    @Override
    public boolean contains(double x, double y) {
        return this.calculator.contains(x, y);
    }

    @Override
    @NotNull
    public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
        if (this.calculator.disjoint(minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (this.calculator.within(minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        return this.calculator.relate(minX, maxX, minY, maxY);
    }

    @Override
    public boolean intersectsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        if (this.calculator.disjoint(minX, maxX, minY, maxY)) {
            return false;
        }
        return this.contains(aX, aY) || this.contains(bX, bY) || this.calculator.intersectsLine(aX, aY, bX, bY);
    }

    @Override
    public boolean intersectsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        if (this.calculator.disjoint(minX, maxX, minY, maxY)) {
            return false;
        }
        return this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY) || Component2D.Companion.pointInTriangle(minX, maxX, minY, maxY, this.calculator.getX(), this.calculator.getY(), aX, aY, bX, bY, cX, cY) || this.calculator.intersectsLine(aX, aY, bX, bY) || this.calculator.intersectsLine(bX, bY, cX, cY) || this.calculator.intersectsLine(cX, cY, aX, aY);
    }

    @Override
    public boolean containsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        if (this.calculator.disjoint(minX, maxX, minY, maxY)) {
            return false;
        }
        return this.contains(aX, aY) && this.contains(bX, bY);
    }

    @Override
    public boolean containsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        if (this.calculator.disjoint(minX, maxX, minY, maxY)) {
            return false;
        }
        return this.contains(aX, aY) && this.contains(bX, bY) && this.contains(cX, cY);
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinPoint(double x, double y) {
        return this.contains(x, y) ? Component2D.WithinRelation.NOTWITHIN : Component2D.WithinRelation.DISJOINT;
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinLine(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY) {
        if (this.calculator.disjoint(minX, maxX, minY, maxY)) {
            return Component2D.WithinRelation.DISJOINT;
        }
        if (this.contains(aX, aY) || this.contains(bX, bY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        if (ab && this.calculator.intersectsLine(aX, aY, bX, bY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        return Component2D.WithinRelation.DISJOINT;
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        if (this.calculator.disjoint(minX, maxX, minY, maxY)) {
            return Component2D.WithinRelation.DISJOINT;
        }
        if (this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        if (ab && this.calculator.intersectsLine(aX, aY, bX, bY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        if (bc && this.calculator.intersectsLine(bX, bY, cX, cY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        if (ca && this.calculator.intersectsLine(cX, cY, aX, aY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        if (Component2D.Companion.pointInTriangle(minX, maxX, minY, maxY, this.calculator.getX(), this.calculator.getY(), aX, aY, bX, bY, cX, cY)) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        return Component2D.WithinRelation.DISJOINT;
    }

    @Override
    public boolean intersectsLine(double aX, double aY, double bX, double bY) {
        return Component2D.super.intersectsLine(aX, aY, bX, bY);
    }

    @Override
    public boolean intersectsTriangle(double aX, double aY, double bX, double bY, double cX, double cY) {
        return Component2D.super.intersectsTriangle(aX, aY, bX, bY, cX, cY);
    }

    @Override
    public boolean containsLine(double aX, double aY, double bX, double bY) {
        return Component2D.super.containsLine(aX, aY, bX, bY);
    }

    @Override
    public boolean containsTriangle(double aX, double aY, double bX, double bY, double cX, double cY) {
        return Component2D.super.containsTriangle(aX, aY, bX, bY, cX, cY);
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinLine(double aX, double aY, boolean ab, double bX, double bY) {
        return Component2D.super.withinLine(aX, aY, ab, bX, bY);
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinTriangle(double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        return Component2D.super.withinTriangle(aX, aY, ab, bX, bY, bc, cX, cY, ca);
    }

    public /* synthetic */ Circle2D(DistanceCalculator calculator, DefaultConstructorMarker $constructor_marker) {
        this(calculator);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0011\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0016J(\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0016J(\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0016J(\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u000f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001eR\u0014\u0010\u0010\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0014\u0010\u0011\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001eR\u0014\u0010\u0014\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001eR\u0014\u0010\u0015\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001e\u00a8\u0006$"}, d2={"Lorg/gnit/lucenekmp/geo/Circle2D$CartesianDistance;", "Lorg/gnit/lucenekmp/geo/Circle2D$DistanceCalculator;", "centerX", "", "centerY", "radius", "<init>", "(FFF)V", "", "radiusSquared", "rectangle", "Lorg/gnit/lucenekmp/geo/XYRectangle;", "relate", "Lorg/gnit/lucenekmp/index/PointValues$Relation;", "minX", "maxX", "minY", "maxY", "contains", "", "x", "y", "intersectsLine", "aX", "aY", "bX", "bY", "disjoint", "within", "getMinX", "()D", "getMaxX", "getMinY", "getMaxY", "getX", "getY", "core"})
    private static final class CartesianDistance
    implements DistanceCalculator {
        private final double centerX;
        private final double centerY;
        private final double radiusSquared;
        @NotNull
        private final XYRectangle rectangle;

        public CartesianDistance(float centerX, float centerY, float radius) {
            this.centerX = centerX;
            this.centerY = centerY;
            this.radiusSquared = (double)radius * (double)radius;
            this.rectangle = XYRectangle.Companion.fromPointDistance(centerX, centerY, radius);
        }

        @Override
        @NotNull
        public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
            if (Component2D.Companion.containsPoint(this.centerX, this.centerY, minX, maxX, minY, maxY)) {
                if (this.contains(minX, minY) && this.contains(maxX, minY) && this.contains(maxX, maxY) && this.contains(minX, maxY)) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
            } else {
                double diff;
                double sumOfSquaredDiffs = 0.0;
                if (this.centerX < minX) {
                    diff = minX - this.centerX;
                    sumOfSquaredDiffs += diff * diff;
                } else if (this.centerX > maxX) {
                    diff = maxX - this.centerX;
                    sumOfSquaredDiffs += diff * diff;
                }
                if (this.centerY < minY) {
                    diff = minY - this.centerY;
                    sumOfSquaredDiffs += diff * diff;
                } else if (this.centerY > maxY) {
                    diff = maxY - this.centerY;
                    sumOfSquaredDiffs += diff * diff;
                }
                if (sumOfSquaredDiffs > this.radiusSquared) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
            }
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }

        @Override
        public boolean contains(double x, double y) {
            if (Component2D.Companion.containsPoint(x, y, this.rectangle.getMinX(), this.rectangle.getMaxX(), this.rectangle.getMinY(), this.rectangle.getMaxY())) {
                double diffX = x - this.centerX;
                double diffY = y - this.centerY;
                return diffX * diffX + diffY * diffY <= this.radiusSquared;
            }
            return false;
        }

        @Override
        public boolean intersectsLine(double aX, double aY, double bX, double bY) {
            return Companion.intersectsLine(this.centerX, this.centerY, aX, aY, bX, bY, this);
        }

        @Override
        public boolean disjoint(double minX, double maxX, double minY, double maxY) {
            return Component2D.Companion.disjoint(this.rectangle.getMinX(), this.rectangle.getMaxX(), this.rectangle.getMinY(), this.rectangle.getMaxY(), minX, maxX, minY, maxY);
        }

        @Override
        public boolean within(double minX, double maxX, double minY, double maxY) {
            return Component2D.Companion.within(this.rectangle.getMinX(), this.rectangle.getMaxX(), this.rectangle.getMinY(), this.rectangle.getMaxY(), minX, maxX, minY, maxY);
        }

        @Override
        public double getMinX() {
            return this.rectangle.getMinX();
        }

        @Override
        public double getMaxX() {
            return this.rectangle.getMaxX();
        }

        @Override
        public double getMinY() {
            return this.rectangle.getMinY();
        }

        @Override
        public double getMaxY() {
            return this.rectangle.getMaxY();
        }

        @Override
        public double getX() {
            return this.centerX;
        }

        @Override
        public double getY() {
            return this.centerY;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/geo/Circle2D$Companion;", "", "<init>", "()V", "intersectsLine", "", "centerX", "", "centerY", "aX", "aY", "bX", "bY", "calculator", "Lorg/gnit/lucenekmp/geo/Circle2D$DistanceCalculator;", "create", "Lorg/gnit/lucenekmp/geo/Component2D;", "circle", "Lorg/gnit/lucenekmp/geo/XYCircle;", "Lorg/gnit/lucenekmp/geo/Circle;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean intersectsLine(double centerX, double centerY, double aX, double aY, double bX, double bY, DistanceCalculator calculator) {
            double vectorAPX = centerX - aX;
            double vectorABX = bX - aX;
            double vectorAPY = centerY - aY;
            double vectorABY = bY - aY;
            double dotProduct = vectorAPX * vectorABX + vectorAPY * vectorABY;
            double magnitudeAB = vectorABX * vectorABX + vectorABY * vectorABY;
            double distance = dotProduct / magnitudeAB;
            if (distance < 0.0 || distance > 1.0) {
                return false;
            }
            double pX = aX + vectorABX * distance;
            double pY = aY + vectorABY * distance;
            double minX = StrictMath.INSTANCE.min(aX, bX);
            double minY = StrictMath.INSTANCE.min(aY, bY);
            double maxX = StrictMath.INSTANCE.max(aX, bX);
            double maxY = StrictMath.INSTANCE.max(aY, bY);
            if (pX >= minX && pX <= maxX && pY >= minY && pY <= maxY) {
                return calculator.contains(pX, pY);
            }
            return false;
        }

        @NotNull
        public final Component2D create(@NotNull XYCircle circle) {
            Intrinsics.checkNotNullParameter((Object)circle, (String)"circle");
            DistanceCalculator calculator = new CartesianDistance(circle.getX(), circle.getY(), circle.getRadius());
            return new Circle2D(calculator, null);
        }

        @NotNull
        public final Component2D create(@NotNull Circle circle) {
            Intrinsics.checkNotNullParameter((Object)circle, (String)"circle");
            DistanceCalculator calculator = new HaversinDistance(circle.getLon(), circle.getLat(), circle.getRadius());
            return new Circle2D(calculator, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\bb\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J(\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H&J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H&J(\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H&J(\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H&R\u0012\u0010\u000e\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u000f\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0012\u0010\u0010\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0012\u0010\u0011\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0015R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\u0012\u0010\u0006\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0015\u00a8\u0006\u001b\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/geo/Circle2D$DistanceCalculator;", "", "contains", "", "x", "", "y", "intersectsLine", "aX", "aY", "bX", "bY", "relate", "Lorg/gnit/lucenekmp/index/PointValues$Relation;", "minX", "maxX", "minY", "maxY", "disjoint", "within", "getMinX", "()D", "getMaxX", "getMinY", "getMaxY", "getX", "getY", "core"})
    private static interface DistanceCalculator {
        public boolean contains(double var1, double var3);

        public boolean intersectsLine(double var1, double var3, double var5, double var7);

        @NotNull
        public PointValues.Relation relate(double var1, double var3, double var5, double var7);

        public boolean disjoint(double var1, double var3, double var5, double var7);

        public boolean within(double var1, double var3, double var5, double var7);

        public double getMinX();

        public double getMaxX();

        public double getMinY();

        public double getMaxY();

        public double getX();

        public double getY();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J(\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003H\u0016J(\u0010%\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J(\u0010&\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\tR\u0014\u0010\u001a\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\tR\u0014\u0010\u001b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\tR\u0014\u0010\u001c\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\tR\u0014\u0010\u001e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\tR\u0014\u0010\u001f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\t\u00a8\u0006-"}, d2={"Lorg/gnit/lucenekmp/geo/Circle2D$HaversinDistance;", "Lorg/gnit/lucenekmp/geo/Circle2D$DistanceCalculator;", "centerLon", "", "centerLat", "radius", "<init>", "(DDD)V", "getCenterLon", "()D", "getCenterLat", "sortKey", "getSortKey", "axisLat", "getAxisLat", "rectangle", "Lorg/gnit/lucenekmp/geo/Rectangle;", "getRectangle", "()Lorg/gnit/lucenekmp/geo/Rectangle;", "crossesDateline", "", "getCrossesDateline", "()Z", "relate", "Lorg/gnit/lucenekmp/index/PointValues$Relation;", "minX", "maxX", "minY", "maxY", "contains", "x", "y", "intersectsLine", "aX", "aY", "bX", "bY", "disjoint", "within", "getMinX", "getMaxX", "getMinY", "getMaxY", "getX", "getY", "core"})
    private static final class HaversinDistance
    implements DistanceCalculator {
        private final double centerLon;
        private final double centerLat;
        private final double sortKey;
        private final double axisLat;
        @NotNull
        private final Rectangle rectangle;
        private final boolean crossesDateline;

        public HaversinDistance(double centerLon, double centerLat, double radius) {
            this.centerLon = centerLon;
            this.centerLat = centerLat;
            this.sortKey = GeoUtils.INSTANCE.distanceQuerySortKey(radius);
            this.axisLat = Rectangle.Companion.axisLat(this.centerLat, radius);
            this.rectangle = Rectangle.Companion.fromPointDistance(this.centerLat, this.centerLon, radius);
            this.crossesDateline = this.rectangle.getMinLon() > this.rectangle.getMaxLon();
        }

        public final double getCenterLon() {
            return this.centerLon;
        }

        public final double getCenterLat() {
            return this.centerLat;
        }

        public final double getSortKey() {
            return this.sortKey;
        }

        public final double getAxisLat() {
            return this.axisLat;
        }

        @NotNull
        public final Rectangle getRectangle() {
            return this.rectangle;
        }

        public final boolean getCrossesDateline() {
            return this.crossesDateline;
        }

        @Override
        @NotNull
        public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
            return GeoUtils.INSTANCE.relate(minY, maxY, minX, maxX, this.centerLat, this.centerLon, this.sortKey, this.axisLat);
        }

        @Override
        public boolean contains(double x, double y) {
            if (this.crossesDateline ? Component2D.Companion.containsPoint(x, y, this.rectangle.getMinLon(), 180.0, this.rectangle.getMinLat(), this.rectangle.getMaxLat()) || Component2D.Companion.containsPoint(x, y, -180.0, this.rectangle.getMaxLon(), this.rectangle.getMinLat(), this.rectangle.getMaxLat()) : Component2D.Companion.containsPoint(x, y, this.rectangle.getMinLon(), this.rectangle.getMaxLon(), this.rectangle.getMinLat(), this.rectangle.getMaxLat())) {
                return SloppyMath.INSTANCE.haversinSortKey(y, x, this.centerLat, this.centerLon) <= this.sortKey;
            }
            return false;
        }

        @Override
        public boolean intersectsLine(double aX, double aY, double bX, double bY) {
            if (Companion.intersectsLine(this.centerLon, this.centerLat, aX, aY, bX, bY, this)) {
                return true;
            }
            if (this.crossesDateline) {
                double newCenterLon = this.centerLon > 0.0 ? this.centerLon - (double)360 : this.centerLon + (double)360;
                return Companion.intersectsLine(newCenterLon, this.centerLat, aX, aY, bX, bY, this);
            }
            return false;
        }

        @Override
        public boolean disjoint(double minX, double maxX, double minY, double maxY) {
            if (this.crossesDateline) {
                return Component2D.Companion.disjoint(this.rectangle.getMinLon(), 180.0, this.rectangle.getMinLat(), this.rectangle.getMaxLat(), minX, maxX, minY, maxY) && Component2D.Companion.disjoint(-180.0, this.rectangle.getMaxLon(), this.rectangle.getMinLat(), this.rectangle.getMaxLat(), minX, maxX, minY, maxY);
            }
            return Component2D.Companion.disjoint(this.rectangle.getMinLon(), this.rectangle.getMaxLon(), this.rectangle.getMinLat(), this.rectangle.getMaxLat(), minX, maxX, minY, maxY);
        }

        @Override
        public boolean within(double minX, double maxX, double minY, double maxY) {
            if (this.crossesDateline) {
                return Component2D.Companion.within(this.rectangle.getMinLon(), 180.0, this.rectangle.getMinLat(), this.rectangle.getMaxLat(), minX, maxX, minY, maxY) || Component2D.Companion.within(-180.0, this.rectangle.getMaxLon(), this.rectangle.getMinLat(), this.rectangle.getMaxLat(), minX, maxX, minY, maxY);
            }
            return Component2D.Companion.within(this.rectangle.getMinLon(), this.rectangle.getMaxLon(), this.rectangle.getMinLat(), this.rectangle.getMaxLat(), minX, maxX, minY, maxY);
        }

        @Override
        public double getMinX() {
            return this.crossesDateline ? -180.0 : this.rectangle.getMinLon();
        }

        @Override
        public double getMaxX() {
            return this.crossesDateline ? 180.0 : this.rectangle.getMaxLon();
        }

        @Override
        public double getMinY() {
            return this.rectangle.getMinLat();
        }

        @Override
        public double getMaxY() {
            return this.rectangle.getMaxLat();
        }

        @Override
        public double getX() {
            return this.centerLon;
        }

        @Override
        public double getY() {
            return this.centerLat;
        }
    }
}

