/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.geo.Component2D;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.jdkport.DoubleExtKt;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0016JH\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0016JX\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0016JH\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0016JX\u0010 \u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0016JP\u0010#\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0016Jp\u0010%\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010'\u001a\u00020\u0004H\u0016J(\u0010(\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0016R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u001e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/gnit/lucenekmp/geo/ComponentTree;", "Lorg/gnit/lucenekmp/geo/Component2D;", "component", "splitX", "", "<init>", "(Lorg/gnit/lucenekmp/geo/Component2D;Z)V", "value", "", "minY", "getMinY", "()D", "maxY", "getMaxY", "minX", "getMinX", "maxX", "getMaxX", "left", "right", "contains", "x", "y", "intersectsLine", "aX", "aY", "bX", "bY", "intersectsTriangle", "cX", "cY", "containsLine", "containsTriangle", "withinPoint", "Lorg/gnit/lucenekmp/geo/Component2D$WithinRelation;", "withinLine", "ab", "withinTriangle", "bc", "ca", "relate", "Lorg/gnit/lucenekmp/index/PointValues$Relation;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nComponentTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentTree.kt\norg/gnit/lucenekmp/geo/ComponentTree\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,344:1\n1#2:345\n*E\n"})
public final class ComponentTree
implements Component2D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double minY;
    private double maxY;
    private double minX;
    private double maxX;
    @Nullable
    private Component2D left;
    @Nullable
    private Component2D right;
    private final boolean splitX;
    @NotNull
    private final Component2D component;

    private ComponentTree(Component2D component, boolean splitX) {
        this.minY = component.getMinY();
        this.maxY = component.getMaxY();
        this.minX = component.getMinX();
        this.maxX = component.getMaxX();
        this.component = component;
        this.splitX = splitX;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public boolean contains(double x, double y) {
        if (y <= this.getMaxY() && x <= this.getMaxX()) {
            if (this.component.contains(x, y)) {
                return true;
            }
            if (this.left != null) {
                Component2D component2D = this.left;
                Intrinsics.checkNotNull((Object)component2D);
                if (component2D.contains(x, y)) {
                    return true;
                }
            }
            if (this.right != null && (!this.splitX && y >= this.component.getMinY() || this.splitX && x >= this.component.getMinX())) {
                Component2D component2D = this.right;
                Intrinsics.checkNotNull((Object)component2D);
                if (component2D.contains(x, y)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean intersectsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        if (minY <= this.getMaxY() && minX <= this.getMaxX()) {
            if (this.component.intersectsLine(minX, maxX, minY, maxY, aX, aY, bX, bY)) {
                return true;
            }
            if (this.left != null) {
                Component2D component2D = this.left;
                Intrinsics.checkNotNull((Object)component2D);
                if (component2D.intersectsLine(minX, maxX, minY, maxY, aX, aY, bX, bY)) {
                    return true;
                }
            }
            if (this.right != null && (!this.splitX && maxY >= this.component.getMinY() || this.splitX && maxX >= this.component.getMinX())) {
                Component2D component2D = this.right;
                Intrinsics.checkNotNull((Object)component2D);
                if (component2D.intersectsLine(minX, maxX, minY, maxY, aX, aY, bX, bY)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean intersectsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        if (minY <= this.getMaxY() && minX <= this.getMaxX()) {
            if (this.component.intersectsTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY)) {
                return true;
            }
            if (this.left != null) {
                Component2D component2D = this.left;
                Intrinsics.checkNotNull((Object)component2D);
                if (component2D.intersectsTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY)) {
                    return true;
                }
            }
            if (this.right != null && (!this.splitX && maxY >= this.component.getMinY() || this.splitX && maxX >= this.component.getMinX())) {
                Component2D component2D = this.right;
                Intrinsics.checkNotNull((Object)component2D);
                if (component2D.intersectsTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean containsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        if (minY <= this.getMaxY() && minX <= this.getMaxX()) {
            if (this.component.containsLine(minX, maxX, minY, maxY, aX, aY, bX, bY)) {
                return true;
            }
            if (this.left != null) {
                Component2D component2D = this.left;
                Intrinsics.checkNotNull((Object)component2D);
                if (component2D.containsLine(minX, maxX, minY, maxY, aX, aY, bX, bY)) {
                    return true;
                }
            }
            if (this.right != null && (!this.splitX && maxY >= this.component.getMinY() || this.splitX && maxX >= this.component.getMinX())) {
                Component2D component2D = this.right;
                Intrinsics.checkNotNull((Object)component2D);
                if (component2D.containsLine(minX, maxX, minY, maxY, aX, aY, bX, bY)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean containsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        if (minY <= this.getMaxY() && minX <= this.getMaxX()) {
            if (this.component.containsTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY)) {
                return true;
            }
            if (this.left != null) {
                Component2D component2D = this.left;
                Intrinsics.checkNotNull((Object)component2D);
                if (component2D.containsTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY)) {
                    return true;
                }
            }
            if (this.right != null && (!this.splitX && maxY >= this.component.getMinY() || this.splitX && maxX >= this.component.getMinX())) {
                Component2D component2D = this.right;
                Intrinsics.checkNotNull((Object)component2D);
                if (component2D.containsTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinPoint(double x, double y) {
        if (!(this.left == null && this.right == null)) {
            boolean bl = false;
            String string = "withinPoint is not supported for shapes with more than one component";
            throw new IllegalArgumentException(string.toString());
        }
        return this.component.withinPoint(x, y);
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinLine(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY) {
        if (!(this.left == null && this.right == null)) {
            boolean bl = false;
            String string = "withinLine is not supported for shapes with more than one component";
            throw new IllegalArgumentException(string.toString());
        }
        return this.component.withinLine(minX, maxX, minY, maxY, aX, aY, ab, bX, bY);
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        if (!(this.left == null && this.right == null)) {
            boolean bl = false;
            String string = "withinTriangle is not supported for shapes with more than one component";
            throw new IllegalArgumentException(string.toString());
        }
        return this.component.withinTriangle(minX, maxX, minY, maxY, aX, aY, ab, bX, bY, bc, cX, cY, ca);
    }

    @Override
    @NotNull
    public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
        if (minY <= this.getMaxY() && minX <= this.getMaxX()) {
            PointValues.Relation relation = this.component.relate(minX, maxX, minY, maxY);
            if (relation != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
            if (this.left != null) {
                Component2D component2D = this.left;
                Intrinsics.checkNotNull((Object)component2D);
                relation = component2D.relate(minX, maxX, minY, maxY);
                if (relation != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                    return relation;
                }
            }
            if (this.right != null && (!this.splitX && maxY >= this.component.getMinY() || this.splitX && maxX >= this.component.getMinX())) {
                Component2D component2D = this.right;
                Intrinsics.checkNotNull((Object)component2D);
                relation = component2D.relate(minX, maxX, minY, maxY);
                if (relation != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                    return relation;
                }
            }
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    @Override
    public boolean intersectsLine(double aX, double aY, double bX, double bY) {
        return Component2D.super.intersectsLine(aX, aY, bX, bY);
    }

    @Override
    public boolean intersectsTriangle(double aX, double aY, double bX, double bY, double cX, double cY) {
        return Component2D.super.intersectsTriangle(aX, aY, bX, bY, cX, cY);
    }

    @Override
    public boolean containsLine(double aX, double aY, double bX, double bY) {
        return Component2D.super.containsLine(aX, aY, bX, bY);
    }

    @Override
    public boolean containsTriangle(double aX, double aY, double bX, double bY, double cX, double cY) {
        return Component2D.super.containsTriangle(aX, aY, bX, bY, cX, cY);
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinLine(double aX, double aY, boolean ab, double bX, double bY) {
        return Component2D.super.withinLine(aX, aY, ab, bX, bY);
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinTriangle(double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        return Component2D.super.withinTriangle(aX, aY, ab, bX, bY, bc, cX, cY, ca);
    }

    public /* synthetic */ ComponentTree(Component2D component, boolean splitX, DefaultConstructorMarker $constructor_marker) {
        this(component, splitX);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bJ5\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/geo/ComponentTree$Companion;", "", "<init>", "()V", "create", "Lorg/gnit/lucenekmp/geo/Component2D;", "components", "", "([Lorg/gnit/lucenekmp/geo/Component2D;)Lorg/gnit/lucenekmp/geo/Component2D;", "createTree", "Lorg/gnit/lucenekmp/geo/ComponentTree;", "low", "", "high", "splitX", "", "([Lorg/gnit/lucenekmp/geo/Component2D;IIZ)Lorg/gnit/lucenekmp/geo/ComponentTree;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Component2D create(@NotNull Component2D[] components) {
            Intrinsics.checkNotNullParameter((Object)components, (String)"components");
            if (components.length == 1) {
                return components[0];
            }
            ComponentTree componentTree = this.createTree(components, 0, components.length - 1, false);
            Intrinsics.checkNotNull((Object)componentTree);
            ComponentTree root = componentTree;
            for (Component2D component : components) {
                root.minY = Math.min(root.getMinY(), component.getMinY());
                root.minX = Math.min(root.getMinX(), component.getMinX());
            }
            return root;
        }

        private final ComponentTree createTree(Component2D[] components, int low, int high, boolean splitX) {
            if (low > high) {
                return null;
            }
            int mid = low + high >>> 1;
            if (low < high) {
                Comparator comparator2 = null;
                comparator2 = splitX ? Companion::createTree$lambda$0 : Companion::createTree$lambda$1;
                ArrayUtil.Companion.select(components, low, high + 1, mid, comparator2);
            }
            ComponentTree newNode = new ComponentTree(components[mid], splitX, null);
            newNode.left = this.createTree(components, low, mid - 1, !splitX);
            newNode.right = this.createTree(components, mid + 1, high, !splitX);
            if (newNode.left != null) {
                double d = newNode.getMaxX();
                Component2D component2D = newNode.left;
                Intrinsics.checkNotNull((Object)component2D);
                newNode.maxX = Math.max(d, component2D.getMaxX());
                double d2 = newNode.getMaxY();
                Component2D component2D2 = newNode.left;
                Intrinsics.checkNotNull((Object)component2D2);
                newNode.maxY = Math.max(d2, component2D2.getMaxY());
            }
            if (newNode.right != null) {
                double d = newNode.getMaxX();
                Component2D component2D = newNode.right;
                Intrinsics.checkNotNull((Object)component2D);
                newNode.maxX = Math.max(d, component2D.getMaxX());
                double d3 = newNode.getMaxY();
                Component2D component2D3 = newNode.right;
                Intrinsics.checkNotNull((Object)component2D3);
                newNode.maxY = Math.max(d3, component2D3.getMaxY());
            }
            return newNode;
        }

        private static final int createTree$lambda$0(Component2D left, Component2D right) {
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            int ret = DoubleExtKt.compare(DoubleCompanionObject.INSTANCE, left.getMinX(), right.getMinX());
            if (ret == 0) {
                ret = DoubleExtKt.compare(DoubleCompanionObject.INSTANCE, left.getMaxX(), right.getMaxX());
            }
            return ret;
        }

        private static final int createTree$lambda$1(Component2D left, Component2D right) {
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            int ret = DoubleExtKt.compare(DoubleCompanionObject.INSTANCE, left.getMinY(), right.getMinY());
            if (ret == 0) {
                ret = DoubleExtKt.compare(DoubleCompanionObject.INSTANCE, left.getMaxY(), right.getMaxY());
            }
            return ret;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

