/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.geo.GeoUtils;
import org.gnit.lucenekmp.geo.Rectangle;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.DoubleExtKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0015\b\u0010\u0018\u0000 52\u00020\u0001:\u00015B9\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u0016\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003J^\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u001dJ.\u0010/\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u001dJN\u00100\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018\u00a8\u00066"}, d2={"Lorg/gnit/lucenekmp/geo/EdgeTree;", "", "x1", "", "y1", "x2", "y2", "low", "max", "<init>", "(DDDDDD)V", "getX1", "()D", "getY1", "getX2", "getY2", "getLow", "getMax", "setMax", "(D)V", "left", "getLeft", "()Lorg/gnit/lucenekmp/geo/EdgeTree;", "setLeft", "(Lorg/gnit/lucenekmp/geo/EdgeTree;)V", "right", "getRight", "setRight", "contains", "", "x", "y", "containsPnPoly", "", "isPointOnLine", "crossesTriangle", "minX", "maxX", "minY", "maxY", "ax", "ay", "bx", "by", "cx", "cy", "includeBoundary", "crossesBox", "crossesLine", "a2x", "a2y", "b2x", "b2y", "Companion", "core"})
public class EdgeTree {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x1;
    private final double y1;
    private final double x2;
    private final double y2;
    private final double low;
    private double max;
    @Nullable
    private EdgeTree left;
    @Nullable
    private EdgeTree right;
    private static final byte FALSE = 0;
    private static final byte TRUE = 1;
    private static final byte ON_EDGE = 2;

    private EdgeTree(double x1, double y1, double x2, double y2, double low, double max) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.low = low;
        this.max = max;
    }

    public final double getX1() {
        return this.x1;
    }

    public final double getY1() {
        return this.y1;
    }

    public final double getX2() {
        return this.x2;
    }

    public final double getY2() {
        return this.y2;
    }

    public final double getLow() {
        return this.low;
    }

    public final double getMax() {
        return this.max;
    }

    public final void setMax(double d) {
        this.max = d;
    }

    @Nullable
    public final EdgeTree getLeft() {
        return this.left;
    }

    public final void setLeft(@Nullable EdgeTree edgeTree) {
        this.left = edgeTree;
    }

    @Nullable
    public final EdgeTree getRight() {
        return this.right;
    }

    public final void setRight(@Nullable EdgeTree edgeTree) {
        this.right = edgeTree;
    }

    public final boolean contains(double x, double y) {
        return this.containsPnPoly(x, y) > 0;
    }

    private final byte containsPnPoly(double x, double y) {
        byte res = 0;
        if (y <= this.max) {
            if (y == this.y1 && y == this.y2 || (y <= this.y1 && y >= this.y2) != (y >= this.y1 && y <= this.y2)) {
                if (x == this.x1 && x == this.x2 || (x <= this.x1 && x >= this.x2) != (x >= this.x1 && x <= this.x2) && GeoUtils.INSTANCE.orient(this.x1, this.y1, this.x2, this.y2, x, y) == 0) {
                    return 2;
                }
                if (this.y1 > y != this.y2 > y) {
                    byte by = res = x < (this.x2 - this.x1) * (y - this.y1) / (this.y2 - this.y1) + this.x1 ? (byte)1 : 0;
                }
            }
            if (this.left != null) {
                EdgeTree edgeTree = this.left;
                Intrinsics.checkNotNull((Object)edgeTree);
                res = (byte)(res ^ edgeTree.containsPnPoly(x, y));
                if ((res & 2) == 2) {
                    return 2;
                }
            }
            if (this.right != null && y >= this.low) {
                EdgeTree edgeTree = this.right;
                Intrinsics.checkNotNull((Object)edgeTree);
                res = (byte)(res ^ edgeTree.containsPnPoly(x, y));
                if ((res & 2) == 2) {
                    return 2;
                }
            }
        }
        if (!(res >= 0 && res <= 2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return res;
    }

    public final boolean isPointOnLine(double x, double y) {
        if (y <= this.max) {
            boolean outside;
            double a1x = this.x1;
            double a1y = this.y1;
            double b1x = this.x2;
            double b1y = this.y2;
            boolean bl = outside = a1y < y && b1y < y || a1y > y && b1y > y || a1x < x && b1x < x || a1x > x && b1x > x;
            if (!outside && GeoUtils.INSTANCE.orient(a1x, a1y, b1x, b1y, x, y) == 0) {
                return true;
            }
            if (this.left != null) {
                EdgeTree edgeTree = this.left;
                Intrinsics.checkNotNull((Object)edgeTree);
                if (edgeTree.isPointOnLine(x, y)) {
                    return true;
                }
            }
            if (this.right != null && y >= this.low) {
                EdgeTree edgeTree = this.right;
                Intrinsics.checkNotNull((Object)edgeTree);
                if (edgeTree.isPointOnLine(x, y)) {
                    return true;
                }
            }
        }
        return false;
    }

    public final boolean crossesTriangle(double minX, double maxX, double minY, double maxY, double ax, double ay, double bx, double by, double cx, double cy, boolean includeBoundary) {
        if (minY <= this.max) {
            boolean outside;
            double dy = this.y1;
            double ey = this.y2;
            double dx = this.x1;
            double ex = this.x2;
            boolean bl = outside = dy < minY && ey < minY || dy > maxY && ey > maxY || dx < minX && ex < minX || dx > maxX && ex > maxX;
            if (!outside && (includeBoundary ? GeoUtils.INSTANCE.lineCrossesLineWithBoundary(dx, dy, ex, ey, ax, ay, bx, by) || GeoUtils.INSTANCE.lineCrossesLineWithBoundary(dx, dy, ex, ey, bx, by, cx, cy) || GeoUtils.INSTANCE.lineCrossesLineWithBoundary(dx, dy, ex, ey, cx, cy, ax, ay) : GeoUtils.INSTANCE.lineCrossesLine(dx, dy, ex, ey, ax, ay, bx, by) || GeoUtils.INSTANCE.lineCrossesLine(dx, dy, ex, ey, bx, by, cx, cy) || GeoUtils.INSTANCE.lineCrossesLine(dx, dy, ex, ey, cx, cy, ax, ay))) {
                return true;
            }
            if (this.left != null) {
                EdgeTree edgeTree = this.left;
                Intrinsics.checkNotNull((Object)edgeTree);
                if (edgeTree.crossesTriangle(minX, maxX, minY, maxY, ax, ay, bx, by, cx, cy, includeBoundary)) {
                    return true;
                }
            }
            if (this.right != null && maxY >= this.low) {
                EdgeTree edgeTree = this.right;
                Intrinsics.checkNotNull((Object)edgeTree);
                if (edgeTree.crossesTriangle(minX, maxX, minY, maxY, ax, ay, bx, by, cx, cy, includeBoundary)) {
                    return true;
                }
            }
        }
        return false;
    }

    public final boolean crossesBox(double minX, double maxX, double minY, double maxY, boolean includeBoundary) {
        if (minY <= this.max) {
            boolean outside;
            double cy = this.y1;
            double dy = this.y2;
            double cx = this.x1;
            double dx = this.x2;
            if (Rectangle.Companion.containsPoint(cy, cx, minY, maxY, minX, maxX) || Rectangle.Companion.containsPoint(dy, dx, minY, maxY, minX, maxX)) {
                return true;
            }
            boolean bl = outside = cy < minY && dy < minY || cy > maxY && dy > maxY || cx < minX && dx < minX || cx > maxX && dx > maxX;
            if (!outside && (includeBoundary ? GeoUtils.INSTANCE.lineCrossesLineWithBoundary(cx, cy, dx, dy, minX, minY, maxX, minY) || GeoUtils.INSTANCE.lineCrossesLineWithBoundary(cx, cy, dx, dy, maxX, minY, maxX, maxY) || GeoUtils.INSTANCE.lineCrossesLineWithBoundary(cx, cy, dx, dy, maxX, maxY, minX, maxY) || GeoUtils.INSTANCE.lineCrossesLineWithBoundary(cx, cy, dx, dy, minX, maxY, minX, minY) : GeoUtils.INSTANCE.lineCrossesLine(cx, cy, dx, dy, minX, minY, maxX, minY) || GeoUtils.INSTANCE.lineCrossesLine(cx, cy, dx, dy, maxX, minY, maxX, maxY) || GeoUtils.INSTANCE.lineCrossesLine(cx, cy, dx, dy, maxX, maxY, minX, maxY) || GeoUtils.INSTANCE.lineCrossesLine(cx, cy, dx, dy, minX, maxY, minX, minY))) {
                return true;
            }
            if (this.left != null) {
                EdgeTree edgeTree = this.left;
                Intrinsics.checkNotNull((Object)edgeTree);
                if (edgeTree.crossesBox(minX, maxX, minY, maxY, includeBoundary)) {
                    return true;
                }
            }
            if (this.right != null && maxY >= this.low) {
                EdgeTree edgeTree = this.right;
                Intrinsics.checkNotNull((Object)edgeTree);
                if (edgeTree.crossesBox(minX, maxX, minY, maxY, includeBoundary)) {
                    return true;
                }
            }
        }
        return false;
    }

    public final boolean crossesLine(double minX, double maxX, double minY, double maxY, double a2x, double a2y, double b2x, double b2y, boolean includeBoundary) {
        if (minY <= this.max) {
            boolean outside;
            double a1x = this.x1;
            double a1y = this.y1;
            double b1x = this.x2;
            double b1y = this.y2;
            boolean bl = outside = a1y < minY && b1y < minY || a1y > maxY && b1y > maxY || a1x < minX && b1x < minX || a1x > maxX && b1x > maxX;
            if (!outside && (includeBoundary ? GeoUtils.INSTANCE.lineCrossesLineWithBoundary(a1x, a1y, b1x, b1y, a2x, a2y, b2x, b2y) : GeoUtils.INSTANCE.lineCrossesLine(a1x, a1y, b1x, b1y, a2x, a2y, b2x, b2y))) {
                return true;
            }
            if (this.left != null) {
                EdgeTree edgeTree = this.left;
                Intrinsics.checkNotNull((Object)edgeTree);
                if (edgeTree.crossesLine(minX, maxX, minY, maxY, a2x, a2y, b2x, b2y, includeBoundary)) {
                    return true;
                }
            }
            if (this.right != null && maxY >= this.low) {
                EdgeTree edgeTree = this.right;
                Intrinsics.checkNotNull((Object)edgeTree);
                if (edgeTree.crossesLine(minX, maxX, minY, maxY, a2x, a2y, b2x, b2y, includeBoundary)) {
                    return true;
                }
            }
        }
        return false;
    }

    public /* synthetic */ EdgeTree(double x1, double y1, double x2, double y2, double low, double max, DefaultConstructorMarker $constructor_marker) {
        this(x1, y1, x2, y2, low, max);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ-\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/geo/EdgeTree$Companion;", "", "<init>", "()V", "FALSE", "", "TRUE", "ON_EDGE", "createTree", "Lorg/gnit/lucenekmp/geo/EdgeTree;", "x", "", "y", "edges", "", "low", "", "high", "([Lorg/gnit/lucenekmp/geo/EdgeTree;II)Lorg/gnit/lucenekmp/geo/EdgeTree;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EdgeTree createTree(@NotNull double[] x, @NotNull double[] y) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            int n = 0;
            int n2 = x.length - 1;
            EdgeTree[] edgeTreeArray = new EdgeTree[n2];
            while (n < n2) {
                int n3 = n++;
                edgeTreeArray[n3] = new EdgeTree(x[n3], y[n3], x[n3 + 1], y[n3 + 1], Math.min(y[n3], y[n3 + 1]), Math.max(y[n3], y[n3 + 1]), null);
            }
            EdgeTree[] edges = edgeTreeArray;
            Arrays.INSTANCE.sort(edges, Companion::createTree$lambda$0);
            EdgeTree edgeTree = this.createTree(edges, 0, edges.length - 1);
            Intrinsics.checkNotNull((Object)edgeTree);
            return edgeTree;
        }

        private final EdgeTree createTree(EdgeTree[] edges, int low, int high) {
            if (low > high) {
                return null;
            }
            int mid = low + high >>> 1;
            EdgeTree newNode = edges[mid];
            newNode.setLeft(this.createTree(edges, low, mid - 1));
            newNode.setRight(this.createTree(edges, mid + 1, high));
            if (newNode.getLeft() != null) {
                double d = newNode.getMax();
                EdgeTree edgeTree = newNode.getLeft();
                Intrinsics.checkNotNull((Object)edgeTree);
                newNode.setMax(Math.max(d, edgeTree.getMax()));
            }
            if (newNode.getRight() != null) {
                double d = newNode.getMax();
                EdgeTree edgeTree = newNode.getRight();
                Intrinsics.checkNotNull((Object)edgeTree);
                newNode.setMax(Math.max(d, edgeTree.getMax()));
            }
            return newNode;
        }

        private static final int createTree$lambda$0(EdgeTree left, EdgeTree right) {
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            int ret = DoubleExtKt.compare(DoubleCompanionObject.INSTANCE, left.getLow(), right.getLow());
            if (ret == 0) {
                ret = DoubleExtKt.compare(DoubleCompanionObject.INSTANCE, left.getMax(), right.getMax());
            }
            return ret;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

