/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.geo.Component2D;
import org.gnit.lucenekmp.geo.GeoUtils;
import org.gnit.lucenekmp.geo.LatLonGeometry;
import org.gnit.lucenekmp.geo.Line2D;
import org.gnit.lucenekmp.geo.Polygon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0003J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u0012H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0006\u0010!\u001a\u00020 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\""}, d2={"Lorg/gnit/lucenekmp/geo/Line;", "Lorg/gnit/lucenekmp/geo/LatLonGeometry;", "lats", "", "lons", "<init>", "([D[D)V", "minLat", "", "getMinLat", "()D", "maxLat", "getMaxLat", "minLon", "getMinLon", "maxLon", "getMaxLon", "numPoints", "", "getLat", "vertex", "getLon", "getLats", "getLons", "toComponent2D", "Lorg/gnit/lucenekmp/geo/Component2D;", "equals", "", "o", "", "hashCode", "toString", "", "toGeoJSON", "core"})
@SourceDebugExtension(value={"SMAP\nLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Line.kt\norg/gnit/lucenekmp/geo/Line\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
public final class Line
extends LatLonGeometry {
    @NotNull
    private final double[] lats;
    @NotNull
    private final double[] lons;
    private final double minLat;
    private final double maxLat;
    private final double minLon;
    private final double maxLon;

    public Line(@NotNull double[] lats, @NotNull double[] lons) {
        Intrinsics.checkNotNullParameter((Object)lats, (String)"lats");
        Intrinsics.checkNotNullParameter((Object)lons, (String)"lons");
        if (!(lats.length == lons.length)) {
            boolean $i$a$-require-Line$52 = false;
            String $i$a$-require-Line$52 = "lats and lons must be equal length";
            throw new IllegalArgumentException($i$a$-require-Line$52.toString());
        }
        if (!(lats.length >= 2)) {
            boolean bl = false;
            String string = "at least 2 line points required";
            throw new IllegalArgumentException(string.toString());
        }
        double minLat = lats[0];
        double minLon = lons[0];
        double maxLat = lats[0];
        double maxLon = lons[0];
        int n = lats.length;
        for (int i = 0; i < n; ++i) {
            GeoUtils.INSTANCE.checkLatitude(lats[i]);
            GeoUtils.INSTANCE.checkLongitude(lons[i]);
            minLat = Math.min(lats[i], minLat);
            minLon = Math.min(lons[i], minLon);
            maxLat = Math.max(lats[i], maxLat);
            maxLon = Math.max(lons[i], maxLon);
        }
        double[] dArray = lats;
        double[] dArray2 = Arrays.copyOf(dArray, dArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)dArray2, (String)"copyOf(...)");
        this.lats = dArray2;
        dArray = lons;
        double[] dArray3 = Arrays.copyOf(dArray, dArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)dArray3, (String)"copyOf(...)");
        this.lons = dArray3;
        this.minLat = minLat;
        this.maxLat = maxLat;
        this.minLon = minLon;
        this.maxLon = maxLon;
    }

    public final double getMinLat() {
        return this.minLat;
    }

    public final double getMaxLat() {
        return this.maxLat;
    }

    public final double getMinLon() {
        return this.minLon;
    }

    public final double getMaxLon() {
        return this.maxLon;
    }

    public final int numPoints() {
        return this.lats.length;
    }

    public final double getLat(int vertex) {
        return this.lats[vertex];
    }

    public final double getLon(int vertex) {
        return this.lons[vertex];
    }

    @NotNull
    public final double[] getLats() {
        double[] dArray = Arrays.copyOf(this.lats, this.lats.length);
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"copyOf(...)");
        return dArray;
    }

    @NotNull
    public final double[] getLons() {
        double[] dArray = Arrays.copyOf(this.lons, this.lons.length);
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"copyOf(...)");
        return dArray;
    }

    @Override
    @NotNull
    protected Component2D toComponent2D() {
        return Line2D.Companion.create(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Line)) {
            return false;
        }
        Object line = o;
        return Arrays.equals(this.lats, ((Line)line).lats) && Arrays.equals(this.lons, ((Line)line).lons);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.lats);
        result = 31 * result + Arrays.hashCode(this.lons);
        return result;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Line(");
        int n = this.lats.length;
        for (int i = 0; i < n; ++i) {
            sb.append("[").append(this.lons[i]).append(", ").append(this.lats[i]).append("]");
        }
        sb.append(')');
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String toGeoJSON() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(Polygon.Companion.verticesToGeoJSON(this.lats, this.lons));
        sb.append("]");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

