/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.geo.Component2D;
import org.gnit.lucenekmp.geo.EdgeTree;
import org.gnit.lucenekmp.geo.Line;
import org.gnit.lucenekmp.geo.XYEncodingUtils;
import org.gnit.lucenekmp.geo.XYLine;
import org.gnit.lucenekmp.index.PointValues;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 +2\u00020\u0001:\u0001+B\u0011\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0016J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0016JH\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0016JX\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0016JH\u0010\"\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0016JX\u0010#\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0016JP\u0010&\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0016Jp\u0010(\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u0015H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/gnit/lucenekmp/geo/Line2D;", "Lorg/gnit/lucenekmp/geo/Component2D;", "line", "Lorg/gnit/lucenekmp/geo/Line;", "<init>", "(Lorg/gnit/lucenekmp/geo/Line;)V", "Lorg/gnit/lucenekmp/geo/XYLine;", "(Lorg/gnit/lucenekmp/geo/XYLine;)V", "minY", "", "getMinY", "()D", "maxY", "getMaxY", "minX", "getMinX", "maxX", "getMaxX", "tree", "Lorg/gnit/lucenekmp/geo/EdgeTree;", "contains", "", "x", "y", "relate", "Lorg/gnit/lucenekmp/index/PointValues$Relation;", "intersectsLine", "aX", "aY", "bX", "bY", "intersectsTriangle", "cX", "cY", "containsLine", "containsTriangle", "withinPoint", "Lorg/gnit/lucenekmp/geo/Component2D$WithinRelation;", "withinLine", "ab", "withinTriangle", "bc", "ca", "Companion", "core"})
public final class Line2D
implements Component2D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double minY;
    private final double maxY;
    private final double minX;
    private final double maxX;
    @NotNull
    private final EdgeTree tree;

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    private Line2D(Line line) {
        this.minY = line.getMinLat();
        this.maxY = line.getMaxLat();
        this.minX = line.getMinLon();
        this.maxX = line.getMaxLon();
        this.tree = EdgeTree.Companion.createTree(line.getLons(), line.getLats());
    }

    private Line2D(XYLine line) {
        this.minY = line.getMinY();
        this.maxY = line.getMaxY();
        this.minX = line.getMinX();
        this.maxX = line.getMaxX();
        this.tree = EdgeTree.Companion.createTree(XYEncodingUtils.INSTANCE.floatArrayToDoubleArray(line.getX()), XYEncodingUtils.INSTANCE.floatArrayToDoubleArray(line.getY()));
    }

    @Override
    public boolean contains(double x, double y) {
        if (Component2D.Companion.containsPoint(x, y, this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY())) {
            return this.tree.isPointOnLine(x, y);
        }
        return false;
    }

    @Override
    @NotNull
    public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
        if (Component2D.Companion.disjoint(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY(), minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (Component2D.Companion.within(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY(), minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        if (this.tree.crossesBox(minX, maxX, minY, maxY, true)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    @Override
    public boolean intersectsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        if (Component2D.Companion.disjoint(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY(), minX, maxX, minY, maxY)) {
            return false;
        }
        return this.tree.crossesLine(minX, maxX, minY, maxY, aX, aY, bX, bY, true);
    }

    @Override
    public boolean intersectsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        if (Component2D.Companion.disjoint(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY(), minX, maxX, minY, maxY)) {
            return false;
        }
        return Component2D.Companion.pointInTriangle(minX, maxX, minY, maxY, this.tree.getX1(), this.tree.getY1(), aX, aY, bX, bY, cX, cY) || this.tree.crossesTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY, true);
    }

    @Override
    public boolean containsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        return false;
    }

    @Override
    public boolean containsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        return false;
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinPoint(double x, double y) {
        return this.contains(x, y) ? Component2D.WithinRelation.NOTWITHIN : Component2D.WithinRelation.DISJOINT;
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinLine(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY) {
        if (ab && this.intersectsLine(minX, maxX, minY, maxY, aX, aY, bX, bY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        return Component2D.WithinRelation.DISJOINT;
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        if (Component2D.Companion.disjoint(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY(), minX, maxX, minY, maxY)) {
            return Component2D.WithinRelation.DISJOINT;
        }
        Component2D.WithinRelation relation = Component2D.WithinRelation.DISJOINT;
        if (this.tree.crossesLine(minX, maxX, minY, maxY, aX, aY, bX, bY, true)) {
            if (ab) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.tree.crossesLine(minX, maxX, minY, maxY, bX, bY, cX, cY, true)) {
            if (bc) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.tree.crossesLine(minX, maxX, minY, maxY, cX, cY, aX, aY, true)) {
            if (ca) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (relation == Component2D.WithinRelation.CANDIDATE) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        if (Component2D.Companion.pointInTriangle(minX, maxX, minY, maxY, this.tree.getX1(), this.tree.getY1(), aX, aY, bX, bY, cX, cY)) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        return relation;
    }

    @Override
    public boolean intersectsLine(double aX, double aY, double bX, double bY) {
        return Component2D.super.intersectsLine(aX, aY, bX, bY);
    }

    @Override
    public boolean intersectsTriangle(double aX, double aY, double bX, double bY, double cX, double cY) {
        return Component2D.super.intersectsTriangle(aX, aY, bX, bY, cX, cY);
    }

    @Override
    public boolean containsLine(double aX, double aY, double bX, double bY) {
        return Component2D.super.containsLine(aX, aY, bX, bY);
    }

    @Override
    public boolean containsTriangle(double aX, double aY, double bX, double bY, double cX, double cY) {
        return Component2D.super.containsTriangle(aX, aY, bX, bY, cX, cY);
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinLine(double aX, double aY, boolean ab, double bX, double bY) {
        return Component2D.super.withinLine(aX, aY, ab, bX, bY);
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinTriangle(double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        return Component2D.super.withinTriangle(aX, aY, ab, bX, bY, bc, cX, cY, ca);
    }

    public /* synthetic */ Line2D(Line line, DefaultConstructorMarker $constructor_marker) {
        this(line);
    }

    public /* synthetic */ Line2D(XYLine line, DefaultConstructorMarker $constructor_marker) {
        this(line);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/gnit/lucenekmp/geo/Line2D$Companion;", "", "<init>", "()V", "create", "Lorg/gnit/lucenekmp/geo/Component2D;", "line", "Lorg/gnit/lucenekmp/geo/Line;", "Lorg/gnit/lucenekmp/geo/XYLine;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Component2D create(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            return new Line2D(line, null);
        }

        @NotNull
        public final Component2D create(@NotNull XYLine line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            return new Line2D(line, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

