/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.geo.Component2D;
import org.gnit.lucenekmp.geo.GeoUtils;
import org.gnit.lucenekmp.geo.LatLonGeometry;
import org.gnit.lucenekmp.geo.Polygon2D;
import org.gnit.lucenekmp.geo.SimpleGeoJSONPolygonParser;
import org.gnit.lucenekmp.jdkport.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 -2\u00020\u0001:\u0001-B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0006\"\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0003J\u000e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u0003J\u000e\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0017J\u0011\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0017J\u0006\u0010!\u001a\u00020\u0015J\u0006\u0010\"\u001a\u00020\u0017J\b\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020\u0017H\u0016J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0096\u0002J\b\u0010*\u001a\u00020+H\u0016J\u0006\u0010,\u001a\u00020+R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/gnit/lucenekmp/geo/Polygon;", "Lorg/gnit/lucenekmp/geo/LatLonGeometry;", "polyLats", "", "polyLons", "holes", "", "<init>", "([D[D[Lorg/gnit/lucenekmp/geo/Polygon;)V", "[Lorg/gnit/lucenekmp/geo/Polygon;", "minLat", "", "getMinLat", "()D", "maxLat", "getMaxLat", "minLon", "getMinLon", "maxLon", "getMaxLon", "windingOrder", "Lorg/gnit/lucenekmp/geo/GeoUtils$WindingOrder;", "numPoints", "", "getPolyLats", "getPolyLat", "vertex", "getPolyLons", "getPolyLon", "getHoles", "()[Lorg/gnit/lucenekmp/geo/Polygon;", "getHole", "i", "getWindingOrder", "numHoles", "toComponent2D", "Lorg/gnit/lucenekmp/geo/Component2D;", "hashCode", "equals", "", "obj", "", "toString", "", "toGeoJSON", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nPolygon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Polygon.kt\norg/gnit/lucenekmp/geo/Polygon\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,236:1\n1#2:237\n*E\n"})
public final class Polygon
extends LatLonGeometry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final double[] polyLats;
    @NotNull
    private final double[] polyLons;
    @NotNull
    private final Polygon[] holes;
    private final double minLat;
    private final double maxLat;
    private final double minLon;
    private final double maxLon;
    @NotNull
    private final GeoUtils.WindingOrder windingOrder;

    public Polygon(@NotNull double[] polyLats, @NotNull double[] polyLons, Polygon ... holes) {
        int i;
        Intrinsics.checkNotNullParameter((Object)polyLats, (String)"polyLats");
        Intrinsics.checkNotNullParameter((Object)polyLons, (String)"polyLons");
        Intrinsics.checkNotNullParameter((Object)holes, (String)"holes");
        if (!(polyLats.length == polyLons.length)) {
            boolean $i$a$-require-Polygon$92 = false;
            String $i$a$-require-Polygon$92 = "polyLats and polyLons must be equal length";
            throw new IllegalArgumentException($i$a$-require-Polygon$92.toString());
        }
        if (!(polyLats.length >= 4)) {
            boolean $i$a$-require-Polygon$102 = false;
            String $i$a$-require-Polygon$102 = "at least 4 polygon points required";
            throw new IllegalArgumentException($i$a$-require-Polygon$102.toString());
        }
        if (!(polyLats[0] == polyLats[polyLats.length - 1])) {
            boolean $i$a$-require-Polygon$112 = false;
            String $i$a$-require-Polygon$112 = "first and last points of the polygon must be the same (it must close itself): polyLats[0]=" + polyLats[0] + " polyLats[" + (polyLats.length - 1) + "]=" + polyLats[polyLats.length - 1];
            throw new IllegalArgumentException($i$a$-require-Polygon$112.toString());
        }
        if (!(polyLons[0] == polyLons[polyLons.length - 1])) {
            boolean bl = false;
            String string = "first and last points of the polygon must be the same (it must close itself): polyLons[0]=" + polyLons[0] + " polyLons[" + (polyLons.length - 1) + "]=" + polyLons[polyLons.length - 1];
            throw new IllegalArgumentException(string.toString());
        }
        int n = polyLats.length;
        for (i = 0; i < n; ++i) {
            GeoUtils.INSTANCE.checkLatitude(polyLats[i]);
            GeoUtils.INSTANCE.checkLongitude(polyLons[i]);
        }
        n = holes.length;
        for (i = 0; i < n; ++i) {
            Polygon inner = holes[i];
            if (inner.holes.length == 0) continue;
            boolean $i$a$-require-Polygon$122 = false;
            String $i$a$-require-Polygon$122 = "holes may not contain holes: polygons may not nest.";
            throw new IllegalArgumentException($i$a$-require-Polygon$122.toString());
        }
        Object[] i2 = polyLats;
        double[] dArray = Arrays.copyOf(i2, i2.length);
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"copyOf(...)");
        this.polyLats = dArray;
        i2 = polyLons;
        double[] dArray2 = Arrays.copyOf(i2, i2.length);
        Intrinsics.checkNotNullExpressionValue((Object)dArray2, (String)"copyOf(...)");
        this.polyLons = dArray2;
        i2 = holes;
        double[] dArray3 = Arrays.copyOf(i2, i2.length);
        Intrinsics.checkNotNullExpressionValue((Object)dArray3, (String)"copyOf(...)");
        this.holes = (Polygon[])dArray3;
        double minLat = polyLats[0];
        double maxLat = polyLats[0];
        double minLon = polyLons[0];
        double maxLon = polyLons[0];
        double windingSum = 0.0;
        int numPts = polyLats.length - 1;
        int i3 = 1;
        int j = 0;
        while (i3 < numPts) {
            minLat = Math.min(polyLats[i3], minLat);
            maxLat = Math.max(polyLats[i3], maxLat);
            minLon = Math.min(polyLons[i3], minLon);
            maxLon = Math.max(polyLons[i3], maxLon);
            windingSum += (polyLons[j] - polyLons[numPts]) * (polyLats[i3] - polyLats[numPts]) - (polyLats[j] - polyLats[numPts]) * (polyLons[i3] - polyLons[numPts]);
            j = i3++;
        }
        this.minLat = minLat;
        this.maxLat = maxLat;
        this.minLon = minLon;
        this.maxLon = maxLon;
        this.windingOrder = windingSum < 0.0 ? GeoUtils.WindingOrder.CCW : GeoUtils.WindingOrder.CW;
    }

    public final double getMinLat() {
        return this.minLat;
    }

    public final double getMaxLat() {
        return this.maxLat;
    }

    public final double getMinLon() {
        return this.minLon;
    }

    public final double getMaxLon() {
        return this.maxLon;
    }

    public final int numPoints() {
        return this.polyLats.length;
    }

    @NotNull
    public final double[] getPolyLats() {
        double[] dArray = Arrays.copyOf(this.polyLats, this.polyLats.length);
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"copyOf(...)");
        return dArray;
    }

    public final double getPolyLat(int vertex) {
        return this.polyLats[vertex];
    }

    @NotNull
    public final double[] getPolyLons() {
        double[] dArray = Arrays.copyOf(this.polyLons, this.polyLons.length);
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"copyOf(...)");
        return dArray;
    }

    public final double getPolyLon(int vertex) {
        return this.polyLons[vertex];
    }

    @NotNull
    public final Polygon[] getHoles() {
        Polygon[] polygonArray = Arrays.copyOf(this.holes, this.holes.length);
        Intrinsics.checkNotNullExpressionValue((Object)polygonArray, (String)"copyOf(...)");
        return polygonArray;
    }

    @NotNull
    public final Polygon getHole(int i) {
        return this.holes[i];
    }

    @NotNull
    public final GeoUtils.WindingOrder getWindingOrder() {
        return this.windingOrder;
    }

    public final int numHoles() {
        return this.holes.length;
    }

    @Override
    @NotNull
    protected Component2D toComponent2D() {
        return Polygon2D.Companion.create(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(this.holes);
        result = prime * result + Arrays.hashCode(this.polyLats);
        result = prime * result + Arrays.hashCode(this.polyLons);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Polygon other = (Polygon)obj;
        if (!Arrays.equals(this.holes, other.holes)) {
            return false;
        }
        if (!Arrays.equals(this.polyLats, other.polyLats)) {
            return false;
        }
        return Arrays.equals(this.polyLons, other.polyLons);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Polygon");
        int n = this.polyLats.length;
        for (int i = 0; i < n; ++i) {
            sb.append("[").append(this.polyLats[i]).append(", ").append(this.polyLons[i]).append("] ");
        }
        if (!(this.holes.length == 0)) {
            sb.append(", holes=");
            String string = Arrays.toString(this.holes);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            sb.append(string);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String toGeoJSON() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(Companion.verticesToGeoJSON(this.polyLats, this.polyLons));
        for (Polygon hole : this.holes) {
            sb.append(",");
            sb.append(Companion.verticesToGeoJSON(hole.polyLats, hole.polyLons));
        }
        sb.append("]");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u001b\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/geo/Polygon$Companion;", "", "<init>", "()V", "verticesToGeoJSON", "", "lats", "", "lons", "fromGeoJSON", "", "Lorg/gnit/lucenekmp/geo/Polygon;", "geojson", "(Ljava/lang/String;)[Lorg/gnit/lucenekmp/geo/Polygon;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String verticesToGeoJSON(@NotNull double[] lats, @NotNull double[] lons) {
            Intrinsics.checkNotNullParameter((Object)lats, (String)"lats");
            Intrinsics.checkNotNullParameter((Object)lons, (String)"lons");
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            int n = lats.length;
            for (int i = 0; i < n; ++i) {
                sb.append("[").append(lons[i]).append(", ").append(lats[i]).append("]");
                if (i == lats.length - 1) continue;
                sb.append(", ");
            }
            sb.append(']');
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @Nullable
        public final Polygon[] fromGeoJSON(@NotNull String geojson) throws ParseException {
            Intrinsics.checkNotNullParameter((Object)geojson, (String)"geojson");
            return new SimpleGeoJSONPolygonParser(geojson).parse();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

