/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.geo.Component2D;
import org.gnit.lucenekmp.geo.EdgeTree;
import org.gnit.lucenekmp.geo.LatLonGeometry;
import org.gnit.lucenekmp.geo.Polygon;
import org.gnit.lucenekmp.geo.XYEncodingUtils;
import org.gnit.lucenekmp.geo.XYGeometry;
import org.gnit.lucenekmp.geo.XYPolygon;
import org.gnit.lucenekmp.index.PointValues;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 42\u00020\u0001:\u00014BC\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u000b\u0010\fB\u001b\b\u0012\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u000b\u0010\u000fB\u001b\b\u0012\u0012\u0006\u0010\r\u001a\u00020\u0010\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u000b\u0010\u0011J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016J(\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0016JH\u0010!\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0016JX\u0010&\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H\u0016JH\u0010)\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0016JX\u0010*\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H\u0016J\u0018\u0010+\u001a\u00020,2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016JP\u0010-\u001a\u00020,2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0016Jp\u0010/\u001a\u00020,2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u001eH\u0016J(\u00102\u001a\u0002032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0016\u0010\n\u001a\u0004\u0018\u00010\u0001X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00065"}, d2={"Lorg/gnit/lucenekmp/geo/Polygon2D;", "Lorg/gnit/lucenekmp/geo/Component2D;", "minX", "", "maxX", "minY", "maxY", "x", "", "y", "holes", "<init>", "(DDDD[D[DLorg/gnit/lucenekmp/geo/Component2D;)V", "polygon", "Lorg/gnit/lucenekmp/geo/XYPolygon;", "(Lorg/gnit/lucenekmp/geo/XYPolygon;Lorg/gnit/lucenekmp/geo/Component2D;)V", "Lorg/gnit/lucenekmp/geo/Polygon;", "(Lorg/gnit/lucenekmp/geo/Polygon;Lorg/gnit/lucenekmp/geo/Component2D;)V", "getMinX", "()D", "getMaxX", "getMinY", "getMaxY", "getHoles", "()Lorg/gnit/lucenekmp/geo/Component2D;", "tree", "Lorg/gnit/lucenekmp/geo/EdgeTree;", "getTree", "()Lorg/gnit/lucenekmp/geo/EdgeTree;", "contains", "", "relate", "Lorg/gnit/lucenekmp/index/PointValues$Relation;", "intersectsLine", "aX", "aY", "bX", "bY", "intersectsTriangle", "cX", "cY", "containsLine", "containsTriangle", "withinPoint", "Lorg/gnit/lucenekmp/geo/Component2D$WithinRelation;", "withinLine", "ab", "withinTriangle", "bc", "ca", "numberOfCorners", "", "Companion", "core"})
public final class Polygon2D
implements Component2D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double minX;
    private final double maxX;
    private final double minY;
    private final double maxY;
    @Nullable
    private final Component2D holes;
    @NotNull
    private final EdgeTree tree;

    private Polygon2D(double minX, double maxX, double minY, double maxY, double[] x, double[] y, Component2D holes) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.holes = holes;
        this.tree = EdgeTree.Companion.createTree(x, y);
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    @Nullable
    protected final Component2D getHoles() {
        return this.holes;
    }

    @NotNull
    public final EdgeTree getTree() {
        return this.tree;
    }

    private Polygon2D(XYPolygon polygon, Component2D holes) {
        this(polygon.getMinX(), polygon.getMaxX(), polygon.getMinY(), polygon.getMaxY(), XYEncodingUtils.INSTANCE.floatArrayToDoubleArray(polygon.getPolyX()), XYEncodingUtils.INSTANCE.floatArrayToDoubleArray(polygon.getPolyY()), holes);
    }

    private Polygon2D(Polygon polygon, Component2D holes) {
        this(polygon.getMinLon(), polygon.getMaxLon(), polygon.getMinLat(), polygon.getMaxLat(), polygon.getPolyLons(), polygon.getPolyLats(), holes);
    }

    @Override
    public boolean contains(double x, double y) {
        if (Component2D.Companion.containsPoint(x, y, this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY()) && this.tree.contains(x, y)) {
            return this.holes == null || !this.holes.contains(x, y);
        }
        return false;
    }

    @Override
    @NotNull
    public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
        if (Component2D.Companion.disjoint(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY(), minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (Component2D.Companion.within(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY(), minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        if (this.holes != null) {
            PointValues.Relation holeRelation = this.holes.relate(minX, maxX, minY, maxY);
            if (holeRelation == PointValues.Relation.CELL_CROSSES_QUERY) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            if (holeRelation == PointValues.Relation.CELL_INSIDE_QUERY) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
        }
        int numCorners = this.numberOfCorners(minX, maxX, minY, maxY);
        switch (numCorners) {
            case 4: {
                if (this.tree.crossesBox(minX, maxX, minY, maxY, true)) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }
            case 0: {
                if (Component2D.Companion.containsPoint(this.tree.getX1(), this.tree.getY1(), minX, maxX, minY, maxY)) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
                if (this.tree.crossesBox(minX, maxX, minY, maxY, true)) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    @Override
    public boolean intersectsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        if (Component2D.Companion.disjoint(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY(), minX, maxX, minY, maxY)) {
            return false;
        }
        if (this.contains(aX, aY) || this.contains(bX, bY) || this.tree.crossesLine(minX, maxX, minY, maxY, aX, aY, bX, bY, true)) {
            return this.holes == null || !this.holes.containsLine(minX, maxX, minY, maxY, aX, aY, bX, bY);
        }
        return false;
    }

    @Override
    public boolean intersectsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        if (Component2D.Companion.disjoint(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY(), minX, maxX, minY, maxY)) {
            return false;
        }
        if (this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY) || Component2D.Companion.pointInTriangle(minX, maxX, minY, maxY, this.tree.getX1(), this.tree.getY1(), aX, aY, bX, bY, cX, cY) || this.tree.crossesTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY, true)) {
            return this.holes == null || !this.holes.containsTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY);
        }
        return false;
    }

    @Override
    public boolean containsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        if (Component2D.Companion.disjoint(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY(), minX, maxX, minY, maxY)) {
            return false;
        }
        if (this.contains(aX, aY) && this.contains(bX, bY) && !this.tree.crossesLine(minX, maxX, minY, maxY, aX, aY, bX, bY, false)) {
            return this.holes == null || !this.holes.intersectsLine(minX, maxX, minY, maxY, aX, aY, bX, bY);
        }
        return false;
    }

    @Override
    public boolean containsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        if (Component2D.Companion.disjoint(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY(), minX, maxX, minY, maxY)) {
            return false;
        }
        if (this.contains(aX, aY) && this.contains(bX, bY) && this.contains(cX, cY) && !this.tree.crossesTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY, false)) {
            return this.holes == null || !this.holes.intersectsTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY);
        }
        return false;
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinPoint(double x, double y) {
        return this.contains(x, y) ? Component2D.WithinRelation.NOTWITHIN : Component2D.WithinRelation.DISJOINT;
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinLine(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY) {
        if (Component2D.Companion.disjoint(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY(), minX, maxX, minY, maxY)) {
            return Component2D.WithinRelation.DISJOINT;
        }
        if (this.contains(aX, aY) || this.contains(bX, bY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        if (ab && this.tree.crossesLine(minX, maxX, minY, maxY, aX, aY, bX, bY, true)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        return Component2D.WithinRelation.DISJOINT;
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        if (Component2D.Companion.disjoint(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY(), minX, maxX, minY, maxY)) {
            return Component2D.WithinRelation.DISJOINT;
        }
        if (this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        Component2D.WithinRelation relation = Component2D.WithinRelation.DISJOINT;
        if (this.tree.crossesLine(minX, maxX, minY, maxY, aX, aY, bX, bY, true)) {
            if (ab) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.tree.crossesLine(minX, maxX, minY, maxY, bX, bY, cX, cY, true)) {
            if (bc) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.tree.crossesLine(minX, maxX, minY, maxY, cX, cY, aX, aY, true)) {
            if (ca) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (relation == Component2D.WithinRelation.CANDIDATE) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        if (Component2D.Companion.pointInTriangle(minX, maxX, minY, maxY, this.tree.getX1(), this.tree.getY1(), aX, aY, bX, bY, cX, cY)) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        return relation;
    }

    private final int numberOfCorners(double minX, double maxX, double minY, double maxY) {
        int containsCount = 0;
        if (this.contains(minX, minY)) {
            ++containsCount;
        }
        if (this.contains(maxX, minY)) {
            ++containsCount;
        }
        if (containsCount == 1) {
            return containsCount;
        }
        if (this.contains(maxX, maxY)) {
            ++containsCount;
        }
        if (containsCount == 2) {
            return containsCount;
        }
        if (this.contains(minX, maxY)) {
            ++containsCount;
        }
        return containsCount;
    }

    @Override
    public boolean intersectsLine(double aX, double aY, double bX, double bY) {
        return Component2D.super.intersectsLine(aX, aY, bX, bY);
    }

    @Override
    public boolean intersectsTriangle(double aX, double aY, double bX, double bY, double cX, double cY) {
        return Component2D.super.intersectsTriangle(aX, aY, bX, bY, cX, cY);
    }

    @Override
    public boolean containsLine(double aX, double aY, double bX, double bY) {
        return Component2D.super.containsLine(aX, aY, bX, bY);
    }

    @Override
    public boolean containsTriangle(double aX, double aY, double bX, double bY, double cX, double cY) {
        return Component2D.super.containsTriangle(aX, aY, bX, bY, cX, cY);
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinLine(double aX, double aY, boolean ab, double bX, double bY) {
        return Component2D.super.withinLine(aX, aY, ab, bX, bY);
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinTriangle(double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        return Component2D.super.withinTriangle(aX, aY, ab, bX, bY, bc, cX, cY, ca);
    }

    public /* synthetic */ Polygon2D(Polygon polygon, Component2D holes, DefaultConstructorMarker $constructor_marker) {
        this(polygon, holes);
    }

    public /* synthetic */ Polygon2D(XYPolygon polygon, Component2D holes, DefaultConstructorMarker $constructor_marker) {
        this(polygon, holes);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/gnit/lucenekmp/geo/Polygon2D$Companion;", "", "<init>", "()V", "create", "Lorg/gnit/lucenekmp/geo/Component2D;", "polygon", "Lorg/gnit/lucenekmp/geo/Polygon;", "Lorg/gnit/lucenekmp/geo/XYPolygon;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Component2D create(@NotNull Polygon polygon) {
            Intrinsics.checkNotNullParameter((Object)polygon, (String)"polygon");
            Polygon[] gonHoles = polygon.getHoles();
            Component2D holes = null;
            if (!(gonHoles.length == 0)) {
                holes = LatLonGeometry.Companion.create(Arrays.copyOf(gonHoles, gonHoles.length));
            }
            return new Polygon2D(polygon, holes, null);
        }

        @NotNull
        public final Component2D create(@NotNull XYPolygon polygon) {
            Intrinsics.checkNotNullParameter((Object)polygon, (String)"polygon");
            XYPolygon[] gonHoles = polygon.getHoles();
            Component2D holes = null;
            if (!(gonHoles.length == 0)) {
                holes = XYGeometry.Companion.create(Arrays.copyOf(gonHoles, gonHoles.length));
            }
            return new Polygon2D(polygon, holes, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

