/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.geo.Component2D;
import org.gnit.lucenekmp.geo.GeoUtils;
import org.gnit.lucenekmp.geo.LatLonGeometry;
import org.gnit.lucenekmp.geo.Polygon;
import org.gnit.lucenekmp.geo.Rectangle2D;
import org.gnit.lucenekmp.jdkport.DoubleExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.util.SloppyMath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u0013J\u0013\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/geo/Rectangle;", "Lorg/gnit/lucenekmp/geo/LatLonGeometry;", "minLat", "", "maxLat", "minLon", "maxLon", "<init>", "(DDDD)V", "getMinLat", "()D", "getMinLon", "getMaxLat", "getMaxLon", "toComponent2D", "Lorg/gnit/lucenekmp/geo/Component2D;", "toString", "", "crossesDateline", "", "equals", "o", "", "hashCode", "", "Companion", "core"})
public final class Rectangle
extends LatLonGeometry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double minLat;
    private final double minLon;
    private final double maxLat;
    private final double maxLon;
    private static final double AXISLAT_ERROR = Math.INSTANCE.toDegrees(1.5696101447687296E-8);

    public Rectangle(double minLat, double maxLat, double minLon, double maxLon) {
        GeoUtils.INSTANCE.checkLatitude(minLat);
        GeoUtils.INSTANCE.checkLatitude(maxLat);
        GeoUtils.INSTANCE.checkLongitude(minLon);
        GeoUtils.INSTANCE.checkLongitude(maxLon);
        this.minLon = minLon;
        this.maxLon = maxLon;
        this.minLat = minLat;
        this.maxLat = maxLat;
        if (!(maxLat >= minLat)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final double getMinLat() {
        return this.minLat;
    }

    public final double getMinLon() {
        return this.minLon;
    }

    public final double getMaxLat() {
        return this.maxLat;
    }

    public final double getMaxLon() {
        return this.maxLon;
    }

    @Override
    @NotNull
    protected Component2D toComponent2D() {
        return Rectangle2D.Companion.create(this);
    }

    @NotNull
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Rectangle(lat=");
        b.append(this.minLat);
        b.append(" TO ");
        b.append(this.maxLat);
        b.append(" lon=");
        b.append(this.minLon);
        b.append(" TO ");
        b.append(this.maxLon);
        if (this.maxLon < this.minLon) {
            b.append(" [crosses dateline!]");
        }
        b.append(")");
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final boolean crossesDateline() {
        return this.maxLon < this.minLon;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rectangle rectangle = (Rectangle)o;
        if (DoubleExtKt.compare(DoubleCompanionObject.INSTANCE, rectangle.minLat, this.minLat) != 0) {
            return false;
        }
        if (DoubleExtKt.compare(DoubleCompanionObject.INSTANCE, rectangle.minLon, this.minLon) != 0) {
            return false;
        }
        if (DoubleExtKt.compare(DoubleCompanionObject.INSTANCE, rectangle.maxLat, this.maxLat) != 0) {
            return false;
        }
        return DoubleExtKt.compare(DoubleCompanionObject.INSTANCE, rectangle.maxLon, this.maxLon) == 0;
    }

    public int hashCode() {
        int result = 0;
        long temp = DoubleExtKt.doubleToLongBits(DoubleCompanionObject.INSTANCE, this.minLat);
        result = (int)(temp ^ temp >>> 32);
        temp = DoubleExtKt.doubleToLongBits(DoubleCompanionObject.INSTANCE, this.minLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = DoubleExtKt.doubleToLongBits(DoubleCompanionObject.INSTANCE, this.maxLat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = DoubleExtKt.doubleToLongBits(DoubleCompanionObject.INSTANCE, this.maxLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007J\u0016\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007J\u0019\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\u0002\u0010\u001aR\u0011\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/geo/Rectangle$Companion;", "", "<init>", "()V", "containsPoint", "", "lat", "", "lon", "minLat", "maxLat", "minLon", "maxLon", "fromPointDistance", "Lorg/gnit/lucenekmp/geo/Rectangle;", "centerLat", "centerLon", "radiusMeters", "AXISLAT_ERROR", "getAXISLAT_ERROR", "()D", "axisLat", "fromPolygon", "polygons", "", "Lorg/gnit/lucenekmp/geo/Polygon;", "([Lorg/gnit/lucenekmp/geo/Polygon;)Lorg/gnit/lucenekmp/geo/Rectangle;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean containsPoint(double lat, double lon, double minLat, double maxLat, double minLon, double maxLon) {
            return lat >= minLat && lat <= maxLat && lon >= minLon && lon <= maxLon;
        }

        @NotNull
        public final Rectangle fromPointDistance(double centerLat, double centerLon, double radiusMeters) {
            GeoUtils.INSTANCE.checkLatitude(centerLat);
            GeoUtils.INSTANCE.checkLongitude(centerLon);
            double radLat = Math.INSTANCE.toRadians(centerLat);
            double radLon = Math.INSTANCE.toRadians(centerLon);
            double radDistance = (radiusMeters + 0.07) / 6371008.7714;
            double minLat = radLat - radDistance;
            double maxLat = radLat + radDistance;
            double minLon = 0.0;
            double maxLon = 0.0;
            if (minLat > GeoUtils.INSTANCE.getMIN_LAT_RADIANS() && maxLat < GeoUtils.INSTANCE.getMAX_LAT_RADIANS()) {
                double deltaLon = SloppyMath.INSTANCE.asin(GeoUtils.INSTANCE.sloppySin(radDistance) / SloppyMath.INSTANCE.cos(radLat));
                minLon = radLon - deltaLon;
                if (minLon < GeoUtils.INSTANCE.getMIN_LON_RADIANS()) {
                    minLon += java.lang.Math.PI * 2;
                }
                if ((maxLon = radLon + deltaLon) > GeoUtils.INSTANCE.getMAX_LON_RADIANS()) {
                    maxLon -= java.lang.Math.PI * 2;
                }
            } else {
                minLat = java.lang.Math.max(minLat, GeoUtils.INSTANCE.getMIN_LAT_RADIANS());
                maxLat = java.lang.Math.min(maxLat, GeoUtils.INSTANCE.getMAX_LAT_RADIANS());
                minLon = GeoUtils.INSTANCE.getMIN_LON_RADIANS();
                maxLon = GeoUtils.INSTANCE.getMAX_LON_RADIANS();
            }
            return new Rectangle(Math.INSTANCE.toDegrees(minLat), Math.INSTANCE.toDegrees(maxLat), Math.INSTANCE.toDegrees(minLon), Math.INSTANCE.toDegrees(maxLon));
        }

        public final double getAXISLAT_ERROR() {
            return AXISLAT_ERROR;
        }

        public final double axisLat(double centerLat, double radiusMeters) {
            double PIO2 = 1.5707963267948966;
            double l1 = Math.INSTANCE.toRadians(centerLat);
            double r = (radiusMeters + 0.07) / 6371008.7714;
            if (java.lang.Math.abs(l1) + r >= GeoUtils.INSTANCE.getMAX_LAT_RADIANS()) {
                return centerLat >= 0.0 ? 90.0 : -90.0;
            }
            l1 = centerLat >= 0.0 ? PIO2 - l1 : l1 + PIO2;
            double l2 = java.lang.Math.acos(java.lang.Math.cos(l1) / java.lang.Math.cos(r));
            if (!(!DoubleExtKt.isNaN(DoubleCompanionObject.INSTANCE, l2))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            l2 = centerLat >= 0.0 ? PIO2 - l2 : l2 - PIO2;
            return Math.INSTANCE.toDegrees(l2);
        }

        @NotNull
        public final Rectangle fromPolygon(@NotNull Polygon[] polygons) {
            Intrinsics.checkNotNullParameter((Object)polygons, (String)"polygons");
            double minLat = Double.POSITIVE_INFINITY;
            double maxLat = Double.NEGATIVE_INFINITY;
            double minLon = Double.POSITIVE_INFINITY;
            double maxLon = Double.NEGATIVE_INFINITY;
            int n = polygons.length;
            for (int i = 0; i < n; ++i) {
                minLat = java.lang.Math.min(polygons[i].getMinLat(), minLat);
                maxLat = java.lang.Math.max(polygons[i].getMaxLat(), maxLat);
                minLon = java.lang.Math.min(polygons[i].getMinLon(), minLon);
                maxLon = java.lang.Math.max(polygons[i].getMaxLon(), maxLon);
            }
            return new Rectangle(minLat, maxLat, minLon, maxLon);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

