/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import kotlin.Metadata;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.geo.Circle2D;
import org.gnit.lucenekmp.geo.Component2D;
import org.gnit.lucenekmp.geo.XYEncodingUtils;
import org.gnit.lucenekmp.geo.XYGeometry;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0014J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/geo/XYCircle;", "Lorg/gnit/lucenekmp/geo/XYGeometry;", "x", "", "y", "radius", "<init>", "(FFF)V", "getX", "()F", "getY", "getRadius", "toComponent2D", "Lorg/gnit/lucenekmp/geo/Component2D;", "equals", "", "o", "", "hashCode", "", "toString", "", "core"})
@SourceDebugExtension(value={"SMAP\nXYCircle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XYCircle.kt\norg/gnit/lucenekmp/geo/XYCircle\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class XYCircle
extends XYGeometry {
    private final float x;
    private final float y;
    private final float radius;

    public XYCircle(float x, float y, float radius) {
        if (!(!(radius <= 0.0f))) {
            boolean $i$a$-require-XYCircle$32 = false;
            String $i$a$-require-XYCircle$32 = "radius must be bigger than 0, got " + radius;
            throw new IllegalArgumentException($i$a$-require-XYCircle$32.toString());
        }
        if (!FloatExtKt.isFinite(FloatCompanionObject.INSTANCE, radius)) {
            boolean bl = false;
            String string = "radius must be finite, got " + radius;
            throw new IllegalArgumentException(string.toString());
        }
        this.x = XYEncodingUtils.INSTANCE.checkVal(x);
        this.y = XYEncodingUtils.INSTANCE.checkVal(y);
        this.radius = radius;
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final float getRadius() {
        return this.radius;
    }

    @Override
    @NotNull
    protected Component2D toComponent2D() {
        return Circle2D.Companion.create(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XYCircle)) {
            return false;
        }
        Object circle = o;
        return FloatExtKt.compare(FloatCompanionObject.INSTANCE, this.x, ((XYCircle)circle).x) == 0 && FloatExtKt.compare(FloatCompanionObject.INSTANCE, this.y, ((XYCircle)circle).y) == 0 && FloatExtKt.compare(FloatCompanionObject.INSTANCE, this.radius, ((XYCircle)circle).radius) == 0;
    }

    public int hashCode() {
        int result = Float.hashCode(this.x);
        result = 31 * result + Float.hashCode(this.y);
        result = 31 * result + Float.hashCode(this.radius);
        return result;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XYCircle(");
        sb.append("[" + this.x + "," + this.y + "]");
        sb.append(" radius = " + this.radius);
        sb.append(')');
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

