/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0002\u0010\rJ!\u0010\u000e\u001a\u0004\u0018\u00018\u00002\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/index/ApproximatePriorityQueue;", "T", "", "<init>", "()V", "slots", "", "usedSlots", "", "add", "", "entry", "weight", "(Ljava/lang/Object;J)V", "poll", "predicate", "Lkotlin/Function1;", "", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "contains", "o", "(Ljava/lang/Object;)Z", "isEmpty", "()Z", "remove", "core"})
@SourceDebugExtension(value={"SMAP\nApproximatePriorityQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApproximatePriorityQueue.kt\norg/gnit/lucenekmp/index/ApproximatePriorityQueue\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,121:1\n3#2,8:122\n3#2,8:131\n10#3:130\n10#3:139\n*S KotlinDebug\n*F\n+ 1 ApproximatePriorityQueue.kt\norg/gnit/lucenekmp/index/ApproximatePriorityQueue\n*L\n42#1:122,8\n46#1:131,8\n42#1:130\n46#1:139\n*E\n"})
public final class ApproximatePriorityQueue<T> {
    @NotNull
    private final List<T> slots = new ArrayList(64);
    private long usedSlots;

    public ApproximatePriorityQueue() {
        for (int i = 0; i < 64; ++i) {
            this.slots.add(null);
        }
    }

    public final void add(@Nullable T entry, long weight) {
        long freeSlots;
        if (entry == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        int expectedSlot = LongExtKt.numberOfLeadingZeros(LongCompanionObject.INSTANCE, weight);
        int destinationSlot = expectedSlot + LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, (freeSlots = this.usedSlots ^ 0xFFFFFFFFFFFFFFFFL) >>> expectedSlot);
        boolean condition$iv = destinationSlot >= expectedSlot;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        if (destinationSlot < 64) {
            this.usedSlots |= 1L << destinationSlot;
            T previous = this.slots.set(destinationSlot, entry);
            boolean condition$iv2 = previous == null;
            boolean $i$f$assert2 = false;
            if (_Assertions.ENABLED && !condition$iv2) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
        } else {
            this.slots.add(entry);
        }
    }

    @Nullable
    public final T poll(@NotNull Function1<? super T, Boolean> predicate) {
        T entry;
        int nextUsedSlot;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        int nextSlot = 0;
        while ((nextUsedSlot = nextSlot + LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, this.usedSlots >>> nextSlot)) < 64) {
            Intrinsics.checkNotNull(this.slots.get(nextUsedSlot));
            if (((Boolean)predicate.invoke(entry)).booleanValue()) {
                this.usedSlots &= 1L << nextUsedSlot ^ 0xFFFFFFFFFFFFFFFFL;
                this.slots.set(nextUsedSlot, null);
                return entry;
            }
            nextSlot = nextUsedSlot + 1;
            if (nextSlot < 64) continue;
        }
        ListIterator<T> lit = this.slots.listIterator(this.slots.size());
        while (lit.previousIndex() >= 64) {
            Intrinsics.checkNotNull(lit.previous());
            if (!((Boolean)predicate.invoke(entry)).booleanValue()) continue;
            lit.remove();
            return entry;
        }
        return null;
    }

    public final boolean contains(@Nullable T o) {
        if (o == null) {
            throw new NullPointerException();
        }
        return this.slots.contains(o);
    }

    public final boolean isEmpty() {
        return this.usedSlots == 0L && this.slots.size() == 64;
    }

    public final boolean remove(T o) {
        if (o == null) {
            throw new NullPointerException();
        }
        int index = this.slots.indexOf(o);
        if (index == -1) {
            return false;
        }
        if (index >= 64) {
            this.slots.remove(index);
        } else {
            this.usedSlots &= 1L << index ^ 0xFFFFFFFFFFFFFFFFL;
            this.slots.set(index, null);
        }
        return true;
    }
}

