/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.FilteredTermsEnum;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.IntsRefBuilder;
import org.gnit.lucenekmp.util.StringHelper;
import org.gnit.lucenekmp.util.automaton.ByteRunnable;
import org.gnit.lucenekmp.util.automaton.CompiledAutomaton;
import org.gnit.lucenekmp.util.automaton.Transition;
import org.gnit.lucenekmp.util.automaton.TransitionAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000bH\u0014J\u0014\u0010$\u001a\u0004\u0018\u00010\u000b2\b\u0010#\u001a\u0004\u0018\u00010\u000bH\u0014J\u0010\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u001fH\u0002J\b\u0010'\u001a\u00020\rH\u0002J\u0018\u0010'\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u001fH\u0002J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u001fH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/gnit/lucenekmp/index/AutomatonTermsEnum;", "Lorg/gnit/lucenekmp/index/FilteredTermsEnum;", "tenum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "compiled", "Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;", "<init>", "(Lorg/gnit/lucenekmp/index/TermsEnum;Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;)V", "byteRunnable", "Lorg/gnit/lucenekmp/util/automaton/ByteRunnable;", "commonSuffixRef", "Lorg/gnit/lucenekmp/util/BytesRef;", "finite", "", "transitionAccessor", "Lorg/gnit/lucenekmp/util/automaton/TransitionAccessor;", "visited", "", "curGen", "", "seekBytesRef", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "linear", "linearUpperBound", "transition", "Lorg/gnit/lucenekmp/util/automaton/Transition;", "savedStates", "Lorg/gnit/lucenekmp/util/IntsRefBuilder;", "setVisited", "", "state", "", "isVisited", "accept", "Lorg/gnit/lucenekmp/index/FilteredTermsEnum$AcceptStatus;", "term", "nextSeekTerm", "setLinear", "position", "nextString", "backtrack", "core"})
@SourceDebugExtension(value={"SMAP\nAutomatonTermsEnum.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutomatonTermsEnum.kt\norg/gnit/lucenekmp/index/AutomatonTermsEnum\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,351:1\n1#2:352\n*E\n"})
public class AutomatonTermsEnum
extends FilteredTermsEnum {
    @NotNull
    private final ByteRunnable byteRunnable;
    @Nullable
    private final BytesRef commonSuffixRef;
    private final boolean finite;
    @NotNull
    private final TransitionAccessor transitionAccessor;
    @Nullable
    private short[] visited;
    private short curGen;
    @NotNull
    private final BytesRefBuilder seekBytesRef;
    private boolean linear;
    @NotNull
    private final BytesRef linearUpperBound;
    @NotNull
    private final Transition transition;
    @NotNull
    private final IntsRefBuilder savedStates;

    public AutomatonTermsEnum(@Nullable TermsEnum tenum, @NotNull CompiledAutomaton compiled) {
        Intrinsics.checkNotNullParameter((Object)compiled, (String)"compiled");
        TermsEnum termsEnum = tenum;
        Intrinsics.checkNotNull((Object)termsEnum);
        super(termsEnum);
        this.seekBytesRef = new BytesRefBuilder();
        this.linearUpperBound = new BytesRef();
        this.transition = new Transition();
        this.savedStates = new IntsRefBuilder();
        if (!(compiled.getType() == CompiledAutomaton.AUTOMATON_TYPE.NORMAL)) {
            boolean bl = false;
            String string = "please use CompiledAutomaton.getTermsEnum instead";
            throw new IllegalArgumentException(string.toString());
        }
        this.finite = compiled.getFinite();
        ByteRunnable byteRunnable = compiled.getByteRunnable();
        Intrinsics.checkNotNull((Object)byteRunnable);
        this.byteRunnable = byteRunnable;
        TransitionAccessor transitionAccessor = compiled.getTransitionAccessor();
        Intrinsics.checkNotNull((Object)transitionAccessor);
        this.transitionAccessor = transitionAccessor;
        BytesRef bytesRef = compiled.getCommonSuffixRef();
        Intrinsics.checkNotNull((Object)bytesRef);
        this.commonSuffixRef = bytesRef;
        this.visited = this.finite ? null : new short[this.byteRunnable.getSize()];
    }

    private final void setVisited(int state2) {
        if (!this.finite) {
            Intrinsics.checkNotNull((Object)this.visited);
            if (state2 >= this.visited.length) {
                Intrinsics.checkNotNull((Object)this.visited);
                this.visited = ArrayUtil.Companion.grow(this.visited, state2 + 1);
            }
            Intrinsics.checkNotNull((Object)this.visited);
            this.visited[state2] = this.curGen;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isVisited(int state2) {
        if (this.finite) return false;
        Intrinsics.checkNotNull((Object)this.visited);
        if (state2 >= this.visited.length) return false;
        Intrinsics.checkNotNull((Object)this.visited);
        if (this.visited[state2] != this.curGen) return false;
        return true;
    }

    @Override
    @NotNull
    protected FilteredTermsEnum.AcceptStatus accept(@NotNull BytesRef term) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        if (this.commonSuffixRef == null || StringHelper.INSTANCE.endsWith(term, this.commonSuffixRef)) {
            return this.byteRunnable.run(term.getBytes(), term.getOffset(), term.getLength()) ? (this.linear ? FilteredTermsEnum.AcceptStatus.YES : FilteredTermsEnum.AcceptStatus.YES_AND_SEEK) : (this.linear && term.compareTo(this.linearUpperBound) < 0 ? FilteredTermsEnum.AcceptStatus.NO : FilteredTermsEnum.AcceptStatus.NO_AND_SEEK);
        }
        return this.linear && term.compareTo(this.linearUpperBound) < 0 ? FilteredTermsEnum.AcceptStatus.NO : FilteredTermsEnum.AcceptStatus.NO_AND_SEEK;
    }

    @Override
    @Nullable
    protected BytesRef nextSeekTerm(@Nullable BytesRef term) throws IOException {
        if (term == null) {
            if (!(this.seekBytesRef.length() == 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.byteRunnable.isAccept(0)) {
                return this.seekBytesRef.get();
            }
        } else {
            this.seekBytesRef.copyBytes(term);
        }
        return this.nextString() ? this.seekBytesRef.get() : null;
    }

    private final void setLinear(int position) {
        if (!(!this.linear)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int state2 = 0;
        int maxInterval = 255;
        for (int i = 0; i < position; ++i) {
            if ((state2 = this.byteRunnable.step(state2, (byte)(this.seekBytesRef.byteAt(i) & 0xFFFFFFFF))) >= 0) continue;
            boolean bl = false;
            String string = "state=" + state2;
            throw new IllegalArgumentException(string.toString());
        }
        int numTransitions = this.transitionAccessor.getNumTransitions(state2);
        this.transitionAccessor.initTransition(state2, this.transition);
        for (int i = 0; i < numTransitions; ++i) {
            this.transitionAccessor.getNextTransition(this.transition);
            if (this.transition.getMin() > (byte)(this.seekBytesRef.byteAt(position) & 0xFFFFFFFF) || (byte)(this.seekBytesRef.byteAt(position) & 0xFFFFFFFF) > this.transition.getMax()) continue;
            maxInterval = this.transition.getMax();
            break;
        }
        if (maxInterval != 255) {
            ++maxInterval;
        }
        int length = position + 1;
        if (this.linearUpperBound.getBytes().length < length) {
            this.linearUpperBound.setBytes(new byte[ArrayUtil.Companion.oversize(length, 1)]);
        }
        ArraysKt.copyInto((byte[])this.seekBytesRef.bytes(), (byte[])this.linearUpperBound.getBytes(), (int)0, (int)0, (int)position);
        this.linearUpperBound.getBytes()[position] = (byte)maxInterval;
        this.linearUpperBound.setLength(length);
        this.linear = true;
    }

    private final boolean nextString() {
        int state2 = 0;
        int pos = 0;
        this.savedStates.grow(this.seekBytesRef.length() + 1);
        this.savedStates.setIntAt(0, 0);
        while (true) {
            int nextState;
            if (!this.finite) {
                this.curGen = (short)(this.curGen + 1);
                if (this.curGen == 0) {
                    Intrinsics.checkNotNull((Object)this.visited);
                    ArraysKt.fill$default((short[])this.visited, (short)-1, (int)0, (int)0, (int)6, null);
                }
            }
            this.linear = false;
            state2 = this.savedStates.intAt(pos);
            while (pos < this.seekBytesRef.length()) {
                this.setVisited(state2);
                nextState = this.byteRunnable.step(state2, (byte)(this.seekBytesRef.byteAt(pos) & 0xFFFFFFFF));
                if (nextState == -1) break;
                this.savedStates.setIntAt(pos + 1, nextState);
                if (!this.linear && this.isVisited(nextState)) {
                    this.setLinear(pos);
                }
                state2 = nextState;
                int n = pos;
                pos = n + 1;
            }
            if (this.nextString(state2, pos)) {
                return true;
            }
            int it = nextState = this.backtrack(pos);
            boolean bl = false;
            pos = it;
            if (nextState < 0) {
                return false;
            }
            int newState = this.byteRunnable.step(this.savedStates.intAt(pos), (byte)(this.seekBytesRef.byteAt(pos) & 0xFFFFFFFF));
            if (newState >= 0 && this.byteRunnable.isAccept(newState)) {
                return true;
            }
            if (this.finite) continue;
            pos = 0;
        }
    }

    private final boolean nextString(int state2, int position) {
        int state3 = state2;
        byte c = 0;
        if (position < this.seekBytesRef.length()) {
            byte by = c = (byte)(this.seekBytesRef.byteAt(position) & 0xFFFFFFFF);
            c = (byte)(c + 1);
            if (by == 255) {
                return false;
            }
        }
        this.seekBytesRef.setLength(position);
        this.setVisited(state3);
        int numTransitions = this.transitionAccessor.getNumTransitions(state3);
        this.transitionAccessor.initTransition(state3, this.transition);
        for (int i = 0; i < numTransitions; ++i) {
            this.transitionAccessor.getNextTransition(this.transition);
            if (this.transition.getMax() < c) continue;
            int nextChar = Math.max(c, this.transition.getMin());
            this.seekBytesRef.append((byte)nextChar);
            state3 = this.transition.getDest();
            while (!this.isVisited(state3) && !this.byteRunnable.isAccept(state3)) {
                this.setVisited(state3);
                this.transitionAccessor.initTransition(state3, this.transition);
                this.transitionAccessor.getNextTransition(this.transition);
                state3 = this.transition.getDest();
                this.seekBytesRef.append((byte)this.transition.getMin());
                if (this.linear || !this.isVisited(state3)) continue;
                this.setLinear(this.seekBytesRef.length() - 1);
            }
            return true;
        }
        return false;
    }

    private final int backtrack(int position) {
        int position2 = position;
        while (position2-- > 0) {
            int nextChar = this.seekBytesRef.byteAt(position2) & 0xFFFFFFFF;
            if (nextChar++ == 255) continue;
            this.seekBytesRef.setByteAt(position2, (byte)nextChar);
            this.seekBytesRef.setLength(position2 + 1);
            return position2;
        }
        return -1;
    }
}

