/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.CompositeReader;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.DirectoryReader;
import org.gnit.lucenekmp.index.Fields;
import org.gnit.lucenekmp.index.IndexReader;
import org.gnit.lucenekmp.index.IndexWriter;
import org.gnit.lucenekmp.index.ReaderUtil;
import org.gnit.lucenekmp.index.StoredFieldVisitor;
import org.gnit.lucenekmp.index.StoredFields;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.TermVectors;
import org.gnit.lucenekmp.jdkport.AtomicIntExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B9\b\u0004\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0005\u0012\u001e\u0010\u0006\u001a\u001a\u0012\u0006\b\u0001\u0012\u00028\u0000\u0018\u00010\u0007j\f\u0012\u0006\b\u0001\u0012\u00028\u0000\u0018\u0001`\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010'\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u0011H\u0004J\u0010\u0010*\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u0011H\u0004R\u0018\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR,\u0010\u0006\u001a\u001a\u0012\u0006\b\u0001\u0012\u00028\u0000\u0018\u00010\u0007j\f\u0012\u0006\b\u0001\u0012\u00028\u0000\u0018\u0001`\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u0017\u0012\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lorg/gnit/lucenekmp/index/BaseCompositeReader;", "R", "Lorg/gnit/lucenekmp/index/IndexReader;", "Lorg/gnit/lucenekmp/index/CompositeReader;", "subReaders", "", "subReadersSorter", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "<init>", "([Lorg/gnit/lucenekmp/index/IndexReader;Ljava/util/Comparator;)V", "[Lorg/gnit/lucenekmp/index/IndexReader;", "getSubReadersSorter", "()Ljava/util/Comparator;", "starts", "", "maxDoc", "", "numDocs", "Lkotlin/concurrent/atomics/AtomicInt;", "Lorg/gnit/lucenekmp/jdkport/AtomicInteger;", "getNumDocs$annotations", "()V", "Ljava/util/concurrent/atomic/AtomicInteger;", "subReadersList", "", "termVectors", "Lorg/gnit/lucenekmp/index/TermVectors;", "storedFields", "Lorg/gnit/lucenekmp/index/StoredFields;", "docFreq", "term", "Lorg/gnit/lucenekmp/index/Term;", "totalTermFreq", "", "getSumDocFreq", "field", "", "getDocCount", "getSumTotalTermFreq", "readerIndex", "docID", "readerBase", "sequentialSubReaders", "getSequentialSubReaders", "()Ljava/util/List;", "core"})
@SourceDebugExtension(value={"SMAP\nBaseCompositeReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseCompositeReader.kt\norg/gnit/lucenekmp/index/BaseCompositeReader\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,272:1\n3#2,8:273\n3#2,8:282\n3#2,8:291\n3#2,8:300\n3#2,8:309\n3#2,8:318\n3#2,8:327\n3#2,8:336\n3#2,8:345\n3#2,8:354\n3#2,8:363\n10#3:281\n10#3:290\n10#3:299\n10#3:308\n10#3:317\n10#3:326\n10#3:335\n10#3:344\n10#3:353\n10#3:362\n10#3:371\n1#4:372\n*S KotlinDebug\n*F\n+ 1 BaseCompositeReader.kt\norg/gnit/lucenekmp/index/BaseCompositeReader\n*L\n154#1:273,8\n198#1:282,8\n199#1:291,8\n211#1:300,8\n212#1:309,8\n224#1:318,8\n225#1:327,8\n237#1:336,8\n238#1:345,8\n250#1:354,8\n251#1:363,8\n154#1:281\n198#1:290\n199#1:299\n211#1:308\n212#1:317\n224#1:326\n225#1:335\n237#1:344\n238#1:353\n250#1:362\n251#1:371\n*E\n"})
public abstract class BaseCompositeReader<R extends IndexReader>
extends CompositeReader {
    @NotNull
    private final R[] subReaders;
    @Nullable
    private final Comparator<? extends R> subReadersSorter;
    @NotNull
    private final int[] starts;
    private final int maxDoc;
    @NotNull
    private final AtomicInteger numDocs;
    @NotNull
    private final List<R> subReadersList;

    protected BaseCompositeReader(@NotNull R[] subReaders, @Nullable Comparator<? extends R> subReadersSorter) {
        Intrinsics.checkNotNullParameter(subReaders, (String)"subReaders");
        this.numDocs = new AtomicInteger(-1);
        if (subReadersSorter != null) {
            org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.sort(subReaders, subReadersSorter);
        }
        this.subReaders = subReaders;
        this.subReadersSorter = subReadersSorter;
        this.subReadersList = ArraysKt.toList((Object[])subReaders);
        this.starts = new int[subReaders.length + 1];
        long maxDoc = 0L;
        int n = subReaders.length;
        for (int i = 0; i < n; ++i) {
            this.starts[i] = (int)maxDoc;
            R r = subReaders[i];
            maxDoc += (long)((IndexReader)r).maxDoc();
            ((IndexReader)r).registerParentReader(this);
        }
        if (maxDoc > (long)IndexWriter.Companion.getActualMaxDocs()) {
            if (this instanceof DirectoryReader) {
                String string = "Too many documents: an index cannot exceed " + IndexWriter.Companion.getActualMaxDocs() + " but readers have total maxDoc=" + maxDoc;
                String string2 = Arrays.toString(subReaders);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                throw new CorruptIndexException(string, string2, null, 4, null);
            }
            throw new IllegalArgumentException("Too many documents: composite IndexReaders cannot exceed " + IndexWriter.Companion.getActualMaxDocs() + " but readers have total maxDoc=" + maxDoc);
        }
        this.starts[subReaders.length] = this.maxDoc = Math.INSTANCE.toIntExact(maxDoc);
    }

    @Nullable
    protected final Comparator<? extends R> getSubReadersSorter() {
        return this.subReadersSorter;
    }

    private static /* synthetic */ void getNumDocs$annotations() {
    }

    @Override
    @NotNull
    public TermVectors termVectors() throws IOException {
        this.ensureOpen();
        TermVectors[] subVectors = new TermVectors[this.subReaders.length];
        return new TermVectors(this, subVectors){
            final /* synthetic */ BaseCompositeReader<R> this$0;
            final /* synthetic */ TermVectors[] $subVectors;
            {
                this.this$0 = $receiver;
                this.$subVectors = $subVectors;
            }

            public void prefetch(int docID) throws IOException {
                int i = this.this$0.readerIndex(docID);
                if (this.$subVectors[i] == null) {
                    this.$subVectors[i] = BaseCompositeReader.access$getSubReaders$p(this.this$0)[i].termVectors();
                }
                this.$subVectors[i].prefetch(docID - BaseCompositeReader.access$getStarts$p(this.this$0)[i]);
            }

            public Fields get(int docID) throws IOException {
                int i = this.this$0.readerIndex(docID);
                if (this.$subVectors[i] == null) {
                    this.$subVectors[i] = BaseCompositeReader.access$getSubReaders$p(this.this$0)[i].termVectors();
                }
                return this.$subVectors[i].get(docID - BaseCompositeReader.access$getStarts$p(this.this$0)[i]);
            }
        };
    }

    @Override
    public int numDocs() {
        int numDocs = this.numDocs.get();
        if (numDocs == -1) {
            numDocs = 0;
            for (R r : this.subReaders) {
                numDocs += ((IndexReader)r).numDocs();
            }
            boolean condition$iv = numDocs >= 0;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            AtomicIntExtKt.set(this.numDocs, numDocs);
        }
        return numDocs;
    }

    @Override
    public int maxDoc() {
        return this.maxDoc;
    }

    @Override
    @NotNull
    public StoredFields storedFields() throws IOException {
        this.ensureOpen();
        StoredFields[] subFields = new StoredFields[this.subReaders.length];
        return new StoredFields(this, subFields){
            final /* synthetic */ BaseCompositeReader<R> this$0;
            final /* synthetic */ StoredFields[] $subFields;
            {
                this.this$0 = $receiver;
                this.$subFields = $subFields;
            }

            public void prefetch(int docID) throws IOException {
                int i = this.this$0.readerIndex(docID);
                if (this.$subFields[i] == null) {
                    this.$subFields[i] = BaseCompositeReader.access$getSubReaders$p(this.this$0)[i].storedFields();
                }
                this.$subFields[i].prefetch(docID - BaseCompositeReader.access$getStarts$p(this.this$0)[i]);
            }

            public void document(int docID, StoredFieldVisitor visitor2) throws IOException {
                Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
                int i = this.this$0.readerIndex(docID);
                if (this.$subFields[i] == null) {
                    this.$subFields[i] = BaseCompositeReader.access$getSubReaders$p(this.this$0)[i].storedFields();
                }
                this.$subFields[i].document(docID - BaseCompositeReader.access$getStarts$p(this.this$0)[i], visitor2);
            }
        };
    }

    @Override
    public int docFreq(@NotNull Term term) throws IOException {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        this.ensureOpen();
        int total = 0;
        int n = this.subReaders.length;
        for (int i = 0; i < n; ++i) {
            int sub = ((IndexReader)this.subReaders[i]).docFreq(term);
            boolean condition$iv = sub >= 0;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            condition$iv = sub <= ((IndexReader)this.subReaders[i]).getDocCount(term.field());
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            total += sub;
        }
        return total;
    }

    @Override
    public long totalTermFreq(@NotNull Term term) throws IOException {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        this.ensureOpen();
        long total = 0L;
        int n = this.subReaders.length;
        for (int i = 0; i < n; ++i) {
            long sub = ((IndexReader)this.subReaders[i]).totalTermFreq(term);
            boolean condition$iv = sub >= 0L;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            condition$iv = sub <= ((IndexReader)this.subReaders[i]).getSumTotalTermFreq(term.field());
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            total += sub;
        }
        return total;
    }

    @Override
    public long getSumDocFreq(@NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.ensureOpen();
        long total = 0L;
        for (R reader2 : this.subReaders) {
            long sub = ((IndexReader)reader2).getSumDocFreq(field);
            boolean condition$iv = sub >= 0L;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            condition$iv = sub <= ((IndexReader)reader2).getSumTotalTermFreq(field);
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            total += sub;
        }
        return total;
    }

    @Override
    public int getDocCount(@NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.ensureOpen();
        int total = 0;
        for (R reader2 : this.subReaders) {
            int sub = ((IndexReader)reader2).getDocCount(field);
            boolean condition$iv = sub >= 0;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            condition$iv = sub <= ((IndexReader)reader2).maxDoc();
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            total += sub;
        }
        return total;
    }

    @Override
    public long getSumTotalTermFreq(@NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.ensureOpen();
        long total = 0L;
        for (R reader2 : this.subReaders) {
            long sub = ((IndexReader)reader2).getSumTotalTermFreq(field);
            boolean condition$iv = sub >= 0L;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            condition$iv = sub >= ((IndexReader)reader2).getSumDocFreq(field);
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            total += sub;
        }
        return total;
    }

    protected final int readerIndex(int docID) {
        if (!(docID >= 0 && docID < this.maxDoc)) {
            boolean bl = false;
            String string = "docID must be >= 0 and < maxDoc=" + this.maxDoc + " (got docID=" + docID + ")";
            throw new IllegalArgumentException(string.toString());
        }
        return ReaderUtil.INSTANCE.subIndex(docID, this.starts);
    }

    protected final int readerBase(int readerIndex) {
        if (!(readerIndex >= 0 && readerIndex < this.subReaders.length)) {
            boolean bl = false;
            String string = "readerIndex must be >= 0 and < getSequentialSubReaders().size()";
            throw new IllegalArgumentException(string.toString());
        }
        return this.starts[readerIndex];
    }

    @NotNull
    public List<R> getSequentialSubReaders() {
        return this.subReadersList;
    }

    public static final /* synthetic */ IndexReader[] access$getSubReaders$p(BaseCompositeReader $this) {
        return $this.subReaders;
    }

    public static final /* synthetic */ int[] access$getStarts$p(BaseCompositeReader $this) {
        return $this.starts;
    }
}

