/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.DocValuesConsumer;
import org.gnit.lucenekmp.index.BinaryDocValues;
import org.gnit.lucenekmp.index.DocValuesWriter;
import org.gnit.lucenekmp.index.DocsWithFieldSet;
import org.gnit.lucenekmp.index.EmptyDocValuesProducer;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.index.Sorter;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefArray;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.Counter;
import org.gnit.lucenekmp.util.PagedBytes;
import org.gnit.lucenekmp.util.packed.PackedLongValues;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004()*+B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u0019H\u0002J\"\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006,"}, d2={"Lorg/gnit/lucenekmp/index/BinaryDocValuesWriter;", "Lorg/gnit/lucenekmp/index/DocValuesWriter;", "Lorg/gnit/lucenekmp/index/BinaryDocValues;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "iwBytesUsed", "Lorg/gnit/lucenekmp/util/Counter;", "<init>", "(Lorg/gnit/lucenekmp/index/FieldInfo;Lorg/gnit/lucenekmp/util/Counter;)V", "bytes", "Lorg/gnit/lucenekmp/util/PagedBytes;", "bytesOut", "Lorg/gnit/lucenekmp/store/DataOutput;", "lengths", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Builder;", "docsWithField", "Lorg/gnit/lucenekmp/index/DocsWithFieldSet;", "bytesUsed", "", "lastDocID", "", "maxLength", "finalLengths", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues;", "addValue", "", "docID", "value", "Lorg/gnit/lucenekmp/util/BytesRef;", "updateBytesUsed", "docValues", "getDocValues", "()Lorg/gnit/lucenekmp/index/BinaryDocValues;", "flush", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "dvConsumer", "Lorg/gnit/lucenekmp/codecs/DocValuesConsumer;", "BufferedBinaryDocValues", "SortingBinaryDocValues", "BinaryDVs", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nBinaryDocValuesWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BinaryDocValuesWriter.kt\norg/gnit/lucenekmp/index/BinaryDocValuesWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1#2:238\n*E\n"})
public final class BinaryDocValuesWriter
extends DocValuesWriter<BinaryDocValues> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FieldInfo fieldInfo;
    @NotNull
    private final Counter iwBytesUsed;
    @NotNull
    private final PagedBytes bytes;
    @NotNull
    private final DataOutput bytesOut;
    @NotNull
    private final PackedLongValues.Builder lengths;
    @NotNull
    private final DocsWithFieldSet docsWithField;
    private long bytesUsed;
    private int lastDocID;
    private int maxLength;
    @Nullable
    private PackedLongValues finalLengths;
    private static final int MAX_LENGTH = ArrayUtil.Companion.getMAX_ARRAY_LENGTH();
    private static final int BLOCK_BITS = 12;

    public BinaryDocValuesWriter(@NotNull FieldInfo fieldInfo, @NotNull Counter iwBytesUsed) {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkNotNullParameter((Object)iwBytesUsed, (String)"iwBytesUsed");
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        this.bytes = new PagedBytes(12);
        this.bytesOut = this.bytes.getDataOutput();
        this.lengths = PackedLongValues.Companion.deltaPackedBuilder(0.0f);
        this.lastDocID = -1;
        this.docsWithField = new DocsWithFieldSet();
        this.bytesUsed = this.lengths.ramBytesUsed() + this.docsWithField.ramBytesUsed();
        this.iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public final void addValue(int docID, @NotNull BytesRef value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(docID > this.lastDocID)) {
            boolean $i$a$-require-BinaryDocValuesWriter$addValue$22 = false;
            String $i$a$-require-BinaryDocValuesWriter$addValue$22 = "DocValuesField \"" + this.fieldInfo.getName() + "\" appears more than once in this document (only one value is allowed per field)";
            throw new IllegalArgumentException($i$a$-require-BinaryDocValuesWriter$addValue$22.toString());
        }
        if (!(value.getLength() <= MAX_LENGTH)) {
            boolean bl = false;
            String string = "DocValuesField \"" + this.fieldInfo.getName() + "\" is too large, must be <= " + MAX_LENGTH;
            throw new IllegalArgumentException(string.toString());
        }
        int n = value.getLength();
        int n2 = this.maxLength;
        this.maxLength = java.lang.Math.max(n, n2);
        this.lengths.add(value.getLength());
        try {
            this.bytesOut.writeBytes(value.getBytes(), value.getOffset(), value.getLength());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.docsWithField.add(docID);
        this.updateBytesUsed();
        this.lastDocID = docID;
    }

    private final void updateBytesUsed() {
        long newBytesUsed = this.lengths.ramBytesUsed() + this.bytes.ramBytesUsed() + this.docsWithField.ramBytesUsed();
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    @Override
    @NotNull
    public BinaryDocValues getDocValues() {
        if (this.finalLengths == null) {
            this.finalLengths = this.lengths.build();
        }
        PackedLongValues packedLongValues = this.finalLengths;
        Intrinsics.checkNotNull((Object)packedLongValues);
        return new BufferedBinaryDocValues(packedLongValues, this.maxLength, this.bytes.getDataInput(), this.docsWithField.iterator());
    }

    @Override
    public void flush(@NotNull SegmentWriteState state2, @Nullable Sorter.DocMap sortMap, @NotNull DocValuesConsumer dvConsumer) throws IOException {
        BinaryDVs binaryDVs;
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)dvConsumer, (String)"dvConsumer");
        this.bytes.freeze(false);
        if (this.finalLengths == null) {
            this.finalLengths = this.lengths.build();
        }
        if (sortMap != null) {
            int n = state2.getSegmentInfo().maxDoc();
            PackedLongValues packedLongValues = this.finalLengths;
            Intrinsics.checkNotNull((Object)packedLongValues);
            binaryDVs = new BinaryDVs(n, sortMap, new BufferedBinaryDocValues(packedLongValues, this.maxLength, this.bytes.getDataInput(), this.docsWithField.iterator()));
        } else {
            binaryDVs = null;
        }
        BinaryDVs sorted = binaryDVs;
        dvConsumer.addBinaryField(this.fieldInfo, new EmptyDocValuesProducer(this, sorted){
            final /* synthetic */ BinaryDocValuesWriter this$0;
            final /* synthetic */ BinaryDVs $sorted;
            {
                this.this$0 = $receiver;
                this.$sorted = $sorted;
            }

            public BinaryDocValues getBinary(FieldInfo fieldInfoIn) {
                BinaryDocValues binaryDocValues;
                Intrinsics.checkNotNullParameter((Object)fieldInfoIn, (String)"fieldInfoIn");
                if (!Intrinsics.areEqual((Object)fieldInfoIn, (Object)BinaryDocValuesWriter.access$getFieldInfo$p(this.this$0))) {
                    boolean bl = false;
                    String string = "wrong fieldInfo";
                    throw new IllegalArgumentException(string.toString());
                }
                if (this.$sorted == null) {
                    PackedLongValues packedLongValues = BinaryDocValuesWriter.access$getFinalLengths$p(this.this$0);
                    Intrinsics.checkNotNull((Object)packedLongValues);
                    binaryDocValues = new BufferedBinaryDocValues(packedLongValues, BinaryDocValuesWriter.access$getMaxLength$p(this.this$0), BinaryDocValuesWriter.access$getBytes$p(this.this$0).getDataInput(), BinaryDocValuesWriter.access$getDocsWithField$p(this.this$0).iterator());
                } else {
                    binaryDocValues = new SortingBinaryDocValues(this.$sorted);
                }
                return binaryDocValues;
            }
        });
    }

    public static final /* synthetic */ FieldInfo access$getFieldInfo$p(BinaryDocValuesWriter $this) {
        return $this.fieldInfo;
    }

    public static final /* synthetic */ PackedLongValues access$getFinalLengths$p(BinaryDocValuesWriter $this) {
        return $this.finalLengths;
    }

    public static final /* synthetic */ int access$getMaxLength$p(BinaryDocValuesWriter $this) {
        return $this.maxLength;
    }

    public static final /* synthetic */ PagedBytes access$getBytes$p(BinaryDocValuesWriter $this) {
        return $this.bytes;
    }

    public static final /* synthetic */ DocsWithFieldSet access$getDocsWithField$p(BinaryDocValuesWriter $this) {
        return $this.docsWithField;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/index/BinaryDocValuesWriter$BinaryDVs;", "", "maxDoc", "", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "oldValues", "Lorg/gnit/lucenekmp/index/BinaryDocValues;", "<init>", "(ILorg/gnit/lucenekmp/index/Sorter$DocMap;Lorg/gnit/lucenekmp/index/BinaryDocValues;)V", "offsets", "", "getOffsets", "()[I", "values", "Lorg/gnit/lucenekmp/util/BytesRefArray;", "getValues", "()Lorg/gnit/lucenekmp/util/BytesRefArray;", "core"})
    @SourceDebugExtension(value={"SMAP\nBinaryDocValuesWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BinaryDocValuesWriter.kt\norg/gnit/lucenekmp/index/BinaryDocValuesWriter$BinaryDVs\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1#2:238\n*E\n"})
    public static final class BinaryDVs {
        @NotNull
        private final int[] offsets;
        @NotNull
        private final BytesRefArray values;

        public BinaryDVs(int maxDoc, @NotNull Sorter.DocMap sortMap, @NotNull BinaryDocValues oldValues) {
            Intrinsics.checkNotNullParameter((Object)sortMap, (String)"sortMap");
            Intrinsics.checkNotNullParameter((Object)oldValues, (String)"oldValues");
            this.offsets = new int[maxDoc];
            this.values = new BytesRefArray(Counter.Companion.newCounter$default(Counter.Companion, false, 1, null));
            int offset = 1;
            int docID = 0;
            while (true) {
                int n;
                int it = n = oldValues.nextDoc();
                boolean bl = false;
                docID = it;
                if (n == Integer.MAX_VALUE) break;
                int newDocID = sortMap.oldToNew(docID);
                BytesRef bytesRef = oldValues.binaryValue();
                Intrinsics.checkNotNull((Object)bytesRef);
                this.values.append(bytesRef);
                this.offsets[newDocID] = offset++;
            }
        }

        @NotNull
        public final int[] getOffsets() {
            return this.offsets;
        }

        @NotNull
        public final BytesRefArray getValues() {
            return this.values;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0019\u001a\u00020\u0005H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0010\u001a\u00060\u0011R\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006#"}, d2={"Lorg/gnit/lucenekmp/index/BinaryDocValuesWriter$BufferedBinaryDocValues;", "Lorg/gnit/lucenekmp/index/BinaryDocValues;", "lengths", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues;", "maxLength", "", "bytesIterator", "Lorg/gnit/lucenekmp/store/DataInput;", "docsWithFields", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "<init>", "(Lorg/gnit/lucenekmp/util/packed/PackedLongValues;ILorg/gnit/lucenekmp/store/DataInput;Lorg/gnit/lucenekmp/search/DocIdSetIterator;)V", "value", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "getValue", "()Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "lengthsIterator", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Iterator;", "getLengthsIterator", "()Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Iterator;", "docsWithField", "getDocsWithField", "()Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "getBytesIterator", "()Lorg/gnit/lucenekmp/store/DataInput;", "docID", "nextDoc", "advance", "target", "advanceExact", "", "cost", "", "binaryValue", "Lorg/gnit/lucenekmp/util/BytesRef;", "core"})
    private static final class BufferedBinaryDocValues
    extends BinaryDocValues {
        @NotNull
        private final BytesRefBuilder value;
        @NotNull
        private final PackedLongValues.Iterator lengthsIterator;
        @NotNull
        private final DocIdSetIterator docsWithField;
        @NotNull
        private final DataInput bytesIterator;

        public BufferedBinaryDocValues(@NotNull PackedLongValues lengths, int maxLength, @NotNull DataInput bytesIterator, @NotNull DocIdSetIterator docsWithFields) {
            Intrinsics.checkNotNullParameter((Object)lengths, (String)"lengths");
            Intrinsics.checkNotNullParameter((Object)bytesIterator, (String)"bytesIterator");
            Intrinsics.checkNotNullParameter((Object)docsWithFields, (String)"docsWithFields");
            this.value = new BytesRefBuilder();
            this.value.grow(maxLength);
            this.lengthsIterator = lengths.iterator();
            this.bytesIterator = bytesIterator;
            this.docsWithField = docsWithFields;
        }

        @NotNull
        public final BytesRefBuilder getValue() {
            return this.value;
        }

        @NotNull
        public final PackedLongValues.Iterator getLengthsIterator() {
            return this.lengthsIterator;
        }

        @NotNull
        public final DocIdSetIterator getDocsWithField() {
            return this.docsWithField;
        }

        @NotNull
        public final DataInput getBytesIterator() {
            return this.bytesIterator;
        }

        @Override
        public int docID() {
            return this.docsWithField.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int docID = this.docsWithField.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                int length = Math.INSTANCE.toIntExact(this.lengthsIterator.next());
                this.value.setLength(length);
                this.bytesIterator.readBytes(this.value.bytes(), 0, length);
            }
            return docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            return this.docsWithField.cost();
        }

        @Override
        @NotNull
        public BytesRef binaryValue() {
            return this.value.get();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/index/BinaryDocValuesWriter$Companion;", "", "<init>", "()V", "MAX_LENGTH", "", "BLOCK_BITS", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/index/BinaryDocValuesWriter$SortingBinaryDocValues;", "Lorg/gnit/lucenekmp/index/BinaryDocValues;", "dvs", "Lorg/gnit/lucenekmp/index/BinaryDocValuesWriter$BinaryDVs;", "<init>", "(Lorg/gnit/lucenekmp/index/BinaryDocValuesWriter$BinaryDVs;)V", "spare", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "docID", "", "nextDoc", "advance", "target", "advanceExact", "", "binaryValue", "Lorg/gnit/lucenekmp/util/BytesRef;", "cost", "", "core"})
    @SourceDebugExtension(value={"SMAP\nBinaryDocValuesWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BinaryDocValuesWriter.kt\norg/gnit/lucenekmp/index/BinaryDocValuesWriter$SortingBinaryDocValues\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1#2:238\n*E\n"})
    public static final class SortingBinaryDocValues
    extends BinaryDocValues {
        @NotNull
        private final BinaryDVs dvs;
        @NotNull
        private final BytesRefBuilder spare;
        private int docID;

        public SortingBinaryDocValues(@NotNull BinaryDVs dvs) {
            Intrinsics.checkNotNullParameter((Object)dvs, (String)"dvs");
            this.dvs = dvs;
            this.spare = new BytesRefBuilder();
            this.docID = -1;
        }

        @Override
        public int nextDoc() {
            do {
                int n = this.docID;
                this.docID = n + 1;
                if (this.docID != this.dvs.getOffsets().length) continue;
                int it = n = Integer.MAX_VALUE;
                boolean bl = false;
                this.docID = it;
                return n;
            } while (this.dvs.getOffsets()[this.docID] <= 0);
            return this.docID;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException("use nextDoc instead");
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            throw new UnsupportedOperationException("use nextDoc instead");
        }

        @Override
        @NotNull
        public BytesRef binaryValue() {
            this.dvs.getValues().get(this.spare, this.dvs.getOffsets()[this.docID] - 1);
            return this.spare.get();
        }

        @Override
        public long cost() {
            return this.dvs.getValues().size();
        }
    }
}

