/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.concurrent.atomics.AtomicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.DocValuesUpdate;
import org.gnit.lucenekmp.index.FieldUpdatesBuffer;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.jdkport.AtomicIntExtKt;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.ByteBlockPool;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefHash;
import org.gnit.lucenekmp.util.Counter;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 ;2\u00020\u0001:\u00039:;B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010'\u001a\u00020\u0003H\u0016J\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u0016J\u0016\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020.2\u0006\u0010+\u001a\u00020\u0016J\u0016\u0010/\u001a\u00020)2\u0006\u00100\u001a\u0002012\u0006\u0010+\u001a\u00020\u0016J\u0016\u00102\u001a\u00020)2\u0006\u00100\u001a\u0002032\u0006\u0010+\u001a\u00020\u0016J\u0006\u00104\u001a\u00020)J\u0006\u00105\u001a\u00020)J\u0006\u00106\u001a\u000207J\b\u00108\u001a\u00020\"H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\u00020\t\u00a2\u0006\u0010\n\u0002\u0010\u000e\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001a0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006<"}, d2={"Lorg/gnit/lucenekmp/index/BufferedUpdates;", "Lorg/gnit/lucenekmp/util/Accountable;", "segmentName", "", "<init>", "(Ljava/lang/String;)V", "getSegmentName", "()Ljava/lang/String;", "numFieldUpdates", "Lkotlin/concurrent/atomics/AtomicInt;", "getNumFieldUpdates$annotations", "()V", "getNumFieldUpdates", "()Ljava/util/concurrent/atomic/AtomicInteger;", "Ljava/util/concurrent/atomic/AtomicInteger;", "deleteTerms", "Lorg/gnit/lucenekmp/index/BufferedUpdates$DeletedTerms;", "getDeleteTerms", "()Lorg/gnit/lucenekmp/index/BufferedUpdates$DeletedTerms;", "deleteQueries", "", "Lorg/gnit/lucenekmp/search/Query;", "", "getDeleteQueries", "()Ljava/util/Map;", "fieldUpdates", "Lorg/gnit/lucenekmp/index/FieldUpdatesBuffer;", "getFieldUpdates", "bytesUsed", "Lorg/gnit/lucenekmp/util/Counter;", "fieldUpdatesBytesUsed", "getFieldUpdatesBytesUsed", "()Lorg/gnit/lucenekmp/util/Counter;", "gen", "", "getGen", "()J", "setGen", "(J)V", "toString", "addQuery", "", "query", "docIDUpto", "addTerm", "term", "Lorg/gnit/lucenekmp/index/Term;", "addNumericUpdate", "update", "Lorg/gnit/lucenekmp/index/DocValuesUpdate$NumericDocValuesUpdate;", "addBinaryUpdate", "Lorg/gnit/lucenekmp/index/DocValuesUpdate$BinaryDocValuesUpdate;", "clearDeleteTerms", "clear", "any", "", "ramBytesUsed", "DeletedTerms", "BytesRefIntMap", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nBufferedUpdates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferedUpdates.kt\norg/gnit/lucenekmp/index/BufferedUpdates\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,320:1\n382#2,7:321\n382#2,7:328\n*S KotlinDebug\n*F\n+ 1 BufferedUpdates.kt\norg/gnit/lucenekmp/index/BufferedUpdates\n*L\n97#1:321,7\n111#1:328,7\n*E\n"})
public final class BufferedUpdates
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String segmentName;
    @NotNull
    private final AtomicInteger numFieldUpdates;
    @NotNull
    private final DeletedTerms deleteTerms;
    @NotNull
    private final Map<Query, Integer> deleteQueries;
    @NotNull
    private final Map<String, FieldUpdatesBuffer> fieldUpdates;
    @NotNull
    private final Counter bytesUsed;
    @NotNull
    private final Counter fieldUpdatesBytesUsed;
    private long gen;
    public static final int BYTES_PER_DEL_QUERY = 68;
    public static final int MAX_INT = Integer.MAX_VALUE;
    private static final boolean VERBOSE_DELETES = false;

    public BufferedUpdates(@NotNull String segmentName) {
        Intrinsics.checkNotNullParameter((Object)segmentName, (String)"segmentName");
        this.segmentName = segmentName;
        this.numFieldUpdates = new AtomicInteger(0);
        this.deleteTerms = new DeletedTerms();
        this.deleteQueries = new LinkedHashMap();
        this.fieldUpdates = new LinkedHashMap();
        this.bytesUsed = Counter.Companion.newCounter(true);
        this.fieldUpdatesBytesUsed = Counter.Companion.newCounter(true);
    }

    @NotNull
    public final String getSegmentName() {
        return this.segmentName;
    }

    @NotNull
    public final AtomicInteger getNumFieldUpdates() {
        return this.numFieldUpdates;
    }

    public static /* synthetic */ void getNumFieldUpdates$annotations() {
    }

    @NotNull
    public final DeletedTerms getDeleteTerms() {
        return this.deleteTerms;
    }

    @NotNull
    public final Map<Query, Integer> getDeleteQueries() {
        return this.deleteQueries;
    }

    @NotNull
    public final Map<String, FieldUpdatesBuffer> getFieldUpdates() {
        return this.fieldUpdates;
    }

    @NotNull
    public final Counter getFieldUpdatesBytesUsed() {
        return this.fieldUpdatesBytesUsed;
    }

    public final long getGen() {
        return this.gen;
    }

    public final void setGen(long l) {
        this.gen = l;
    }

    @NotNull
    public String toString() {
        String s = "gen=" + this.gen;
        if (!this.deleteTerms.isEmpty()) {
            s = s + " " + this.deleteTerms.size() + " unique deleted terms ";
        }
        if (!this.deleteQueries.isEmpty()) {
            s = s + " " + this.deleteQueries.size() + " deleted queries";
        }
        if (AtomicIntExtKt.get(this.numFieldUpdates) != 0) {
            s = s + " " + AtomicIntExtKt.get(this.numFieldUpdates) + " field updates";
        }
        if (this.bytesUsed.get() != 0L) {
            s = s + " bytesUsed=" + this.bytesUsed.get();
        }
        return s;
    }

    public final void addQuery(@NotNull Query query, int docIDUpto) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Integer current = this.deleteQueries.put(query, docIDUpto);
        if (current == null) {
            this.bytesUsed.addAndGet(68L);
        }
    }

    public final void addTerm(@NotNull Term term, int docIDUpto) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        int current = this.deleteTerms.get(term);
        if (current != -1 && docIDUpto < current) {
            return;
        }
        this.deleteTerms.put(term, docIDUpto);
    }

    /*
     * WARNING - void declaration
     */
    public final void addNumericUpdate(@NotNull DocValuesUpdate.NumericDocValuesUpdate update, int docIDUpto) {
        Object object;
        void key$iv;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        Map<String, FieldUpdatesBuffer> map2 = this.fieldUpdates;
        String string = update.getField();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            FieldUpdatesBuffer answer$iv = new FieldUpdatesBuffer(this.fieldUpdatesBytesUsed, update, docIDUpto);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        FieldUpdatesBuffer buffer = (FieldUpdatesBuffer)object;
        if (update.getHasValue()) {
            Term term = update.getTerm();
            Intrinsics.checkNotNull((Object)term);
            buffer.addUpdate(term, update.getValue(), docIDUpto);
        } else {
            Term term = update.getTerm();
            Intrinsics.checkNotNull((Object)term);
            buffer.addNoValue(term, docIDUpto);
        }
        AtomicsKt.incrementAndFetch((AtomicInteger)this.numFieldUpdates);
    }

    /*
     * WARNING - void declaration
     */
    public final void addBinaryUpdate(@NotNull DocValuesUpdate.BinaryDocValuesUpdate update, int docIDUpto) {
        Object object;
        void key$iv;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        Map<String, FieldUpdatesBuffer> map2 = this.fieldUpdates;
        String string = update.getField();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            FieldUpdatesBuffer answer$iv = new FieldUpdatesBuffer(this.fieldUpdatesBytesUsed, update, docIDUpto);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        FieldUpdatesBuffer buffer = (FieldUpdatesBuffer)object;
        if (update.getHasValue()) {
            Term term = update.getTerm();
            Intrinsics.checkNotNull((Object)term);
            buffer.addUpdate(term, update.getValue(), docIDUpto);
        } else {
            Term term = update.getTerm();
            Intrinsics.checkNotNull((Object)term);
            buffer.addNoValue(term, docIDUpto);
        }
        AtomicsKt.incrementAndFetch((AtomicInteger)this.numFieldUpdates);
    }

    public final void clearDeleteTerms() {
        this.deleteTerms.clear();
    }

    public final void clear() {
        this.deleteTerms.clear();
        this.deleteQueries.clear();
        AtomicIntExtKt.set(this.numFieldUpdates, 0);
        this.fieldUpdates.clear();
        this.bytesUsed.addAndGet(-this.bytesUsed.get());
        this.fieldUpdatesBytesUsed.addAndGet(-this.fieldUpdatesBytesUsed.get());
    }

    public final boolean any() {
        return this.deleteTerms.size() > 0 || !this.deleteQueries.isEmpty() || AtomicIntExtKt.get(this.numFieldUpdates) > 0;
    }

    @Override
    public long ramBytesUsed() {
        return this.bytesUsed.get() + this.fieldUpdatesBytesUsed.get() + this.deleteTerms.ramBytesUsed();
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/index/BufferedUpdates$BytesRefIntMap;", "", "pool", "Lorg/gnit/lucenekmp/util/ByteBlockPool;", "counter", "Lorg/gnit/lucenekmp/util/Counter;", "<init>", "(Lorg/gnit/lucenekmp/util/ByteBlockPool;Lorg/gnit/lucenekmp/util/Counter;)V", "bytesRefHash", "Lorg/gnit/lucenekmp/util/BytesRefHash;", "getBytesRefHash", "()Lorg/gnit/lucenekmp/util/BytesRefHash;", "values", "", "getValues", "()[I", "setValues", "([I)V", "keySet", "", "Lorg/gnit/lucenekmp/util/BytesRef;", "put", "", "key", "value", "", "get", "Companion", "core"})
    private static final class BytesRefIntMap {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Counter counter;
        @NotNull
        private final BytesRefHash bytesRefHash;
        @NotNull
        private int[] values;
        private static final long INIT_RAM_BYTES = RamUsageEstimator.Companion.shallowSizeOf(Reflection.getOrCreateKotlinClass(BytesRefIntMap.class)) + RamUsageEstimator.Companion.shallowSizeOf(Reflection.getOrCreateKotlinClass(BytesRefHash.class)) + RamUsageEstimator.Companion.sizeOf(new int[16]);

        public BytesRefIntMap(@NotNull ByteBlockPool pool, @NotNull Counter counter) {
            Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
            Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
            this.counter = counter;
            this.bytesRefHash = new BytesRefHash(pool, 16, new BytesRefHash.DirectBytesStartArray(16, this.counter));
            this.values = new int[16];
            this.counter.addAndGet(INIT_RAM_BYTES);
        }

        @NotNull
        public final BytesRefHash getBytesRefHash() {
            return this.bytesRefHash;
        }

        @NotNull
        public final int[] getValues() {
            return this.values;
        }

        public final void setValues(@NotNull int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
            this.values = nArray;
        }

        @NotNull
        public final Set<BytesRef> keySet() {
            BytesRef scratch = new BytesRef();
            Set set = new HashSet();
            int n = this.bytesRefHash.size();
            for (int i = 0; i < n; ++i) {
                this.bytesRefHash.get(i, scratch);
                set.add(BytesRef.Companion.deepCopyOf(scratch));
            }
            return set;
        }

        public final boolean put(@NotNull BytesRef key, int value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (!(value >= 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int e = this.bytesRefHash.add(key);
            if (e < 0) {
                this.values[-e - 1] = value;
                return false;
            }
            if (e >= this.values.length) {
                int originLength = this.values.length;
                this.values = ArrayUtil.Companion.grow(this.values, e + 1);
                this.counter.addAndGet((long)(this.values.length - originLength) * (long)4);
            }
            this.values[e] = value;
            return true;
        }

        public final int get(@NotNull BytesRef key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            int e = this.bytesRefHash.find(key);
            if (e == -1) {
                return -1;
            }
            return this.values[e];
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/index/BufferedUpdates$BytesRefIntMap$Companion;", "", "<init>", "()V", "INIT_RAM_BYTES", "", "core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/gnit/lucenekmp/index/BufferedUpdates$Companion;", "", "<init>", "()V", "BYTES_PER_DEL_QUERY", "", "MAX_INT", "VERBOSE_DELETES", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\rJ\u0006\u0010\u0014\u001a\u00020\u0012J\u0006\u0010\u0015\u001a\u00020\rJ\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001aJ\"\u0010\u001b\u001a\u00020\u0012\"\f\b\u0000\u0010\u001c*\u00060\u001dj\u0002`\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001c0 J\u0006\u0010!\u001a\u00020\u0007J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018\u00a8\u0006&"}, d2={"Lorg/gnit/lucenekmp/index/BufferedUpdates$DeletedTerms;", "Lorg/gnit/lucenekmp/util/Accountable;", "<init>", "()V", "bytesUsed", "Lorg/gnit/lucenekmp/util/Counter;", "pool", "Lorg/gnit/lucenekmp/util/ByteBlockPool;", "deleteTerms", "", "", "Lorg/gnit/lucenekmp/index/BufferedUpdates$BytesRefIntMap;", "termsSize", "", "get", "term", "Lorg/gnit/lucenekmp/index/Term;", "put", "", "value", "clear", "size", "isEmpty", "", "()Z", "keySet", "", "forEachOrdered", "E", "Ljava/lang/Exception;", "Lkotlin/Exception;", "consumer", "Lorg/gnit/lucenekmp/index/BufferedUpdates$DeletedTerms$DeletedTermConsumer;", "getPool", "ramBytesUsed", "", "toString", "DeletedTermConsumer", "core"})
    @SourceDebugExtension(value={"SMAP\nBufferedUpdates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferedUpdates.kt\norg/gnit/lucenekmp/index/BufferedUpdates$DeletedTerms\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,320:1\n1374#2:321\n1460#2,2:322\n1563#2:324\n1634#2,3:325\n1462#2,3:328\n1011#2,2:331\n*S KotlinDebug\n*F\n+ 1 BufferedUpdates.kt\norg/gnit/lucenekmp/index/BufferedUpdates$DeletedTerms\n*L\n199#1:321\n199#1:322,2\n200#1:324\n200#1:325,3\n199#1:328,3\n223#1:331,2\n*E\n"})
    public static final class DeletedTerms
    implements Accountable {
        @NotNull
        private final Counter bytesUsed = Counter.Companion.newCounter$default(Counter.Companion, false, 1, null);
        @NotNull
        private final ByteBlockPool pool = new ByteBlockPool(new ByteBlockPool.DirectTrackingAllocator(this.bytesUsed));
        @NotNull
        private final Map<String, BytesRefIntMap> deleteTerms = new HashMap();
        private int termsSize;

        public final int get(@NotNull Term term) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            BytesRefIntMap hash = this.deleteTerms.get(term.getField());
            if (hash == null) {
                return -1;
            }
            return hash.get(term.getBytes());
        }

        public final void put(@NotNull Term term, int value) {
            BytesRefIntMap hash;
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            BytesRefIntMap bytesRefIntMap = this.deleteTerms.get(term.getField());
            if (bytesRefIntMap == null) {
                BytesRefIntMap bytesRefIntMap2;
                DeletedTerms $this$put_u24lambda_u241 = this;
                boolean bl = false;
                $this$put_u24lambda_u241.bytesUsed.addAndGet(RamUsageEstimator.Companion.sizeOf(term.getField()));
                BytesRefIntMap it = bytesRefIntMap2 = new BytesRefIntMap($this$put_u24lambda_u241.pool, $this$put_u24lambda_u241.bytesUsed);
                boolean bl2 = false;
                $this$put_u24lambda_u241.deleteTerms.put(term.getField(), it);
                bytesRefIntMap = bytesRefIntMap2;
            }
            if ((hash = bytesRefIntMap).put(term.getBytes(), value)) {
                int n = this.termsSize;
                this.termsSize = n + 1;
            }
        }

        public final void clear() {
            this.pool.reset(false, false);
            this.bytesUsed.addAndGet(-this.bytesUsed.get());
            this.deleteTerms.clear();
            this.termsSize = 0;
        }

        public final int size() {
            return this.termsSize;
        }

        public final boolean isEmpty() {
            return this.termsSize == 0;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<Term> keySet() {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this.deleteTerms.entrySet();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv = ((BytesRefIntMap)entry.getValue()).keySet();
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void bytesRef;
                    BytesRef bytesRef2 = (BytesRef)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(new Term((String)entry.getKey(), (BytesRef)bytesRef));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        }

        public final <E extends Exception> void forEachOrdered(@NotNull DeletedTermConsumer<E> consumer) throws Exception {
            List deleteFields;
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            List $this$sortBy$iv = deleteFields = CollectionsKt.toMutableList((Collection)this.deleteTerms.entrySet());
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
                    }
                });
            }
            Term scratch = new Term("", new BytesRef());
            for (Map.Entry deleteFieldEntry : deleteFields) {
                scratch.setField((String)deleteFieldEntry.getKey());
                BytesRefIntMap terms = (BytesRefIntMap)deleteFieldEntry.getValue();
                int[] indices = terms.getBytesRefHash().sort();
                int n = terms.getBytesRefHash().size();
                for (int i = 0; i < n; ++i) {
                    int index = indices[i];
                    terms.getBytesRefHash().get(index, scratch.getBytes());
                    consumer.accept(scratch, terms.getValues()[index]);
                }
            }
        }

        @NotNull
        public final ByteBlockPool getPool() {
            return this.pool;
        }

        @Override
        public long ramBytesUsed() {
            return this.bytesUsed.get();
        }

        @NotNull
        public String toString() {
            return CollectionsKt.joinToString$default((Iterable)this.keySet(), (CharSequence)", ", (CharSequence)"{", (CharSequence)"}", (int)0, null, arg_0 -> DeletedTerms.toString$lambda$5(this, arg_0), (int)24, null);
        }

        @Override
        @NotNull
        public Collection<Accountable> getChildResources() {
            return Accountable.super.getChildResources();
        }

        private static final CharSequence toString$lambda$5(DeletedTerms this$0, Term t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            return t + "=" + this$0.get(t);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00e6\u0080\u0001\u0018\u0000*\f\b\u0000\u0010\u0001*\u00060\u0002j\u0002`\u00032\u00020\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000b\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/index/BufferedUpdates$DeletedTerms$DeletedTermConsumer;", "E", "Ljava/lang/Exception;", "Lkotlin/Exception;", "", "accept", "", "term", "Lorg/gnit/lucenekmp/index/Term;", "docId", "", "core"})
        public static interface DeletedTermConsumer<E extends Exception> {
            public void accept(@NotNull Term var1, int var2) throws Exception;
        }
    }
}

