/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.gnit.lucenekmp.index.FrozenBufferedUpdates;
import org.gnit.lucenekmp.index.IndexWriter;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.ReadersAndUpdates;
import org.gnit.lucenekmp.index.SegmentCommitInfo;
import org.gnit.lucenekmp.index.SegmentReader;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.internal.hppc.LongHashSet;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.jdkport.TimeUnit;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.IOConsumer;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.InfoStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0003/01B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\bJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\nH\u0016J\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\nJ\u000e\u0010\"\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\nJ\u000e\u0010#\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\bJ\u001c\u0010'\u001a\u00020\u00192\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001e\u0010+\u001a\u00020\u00192\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0006\u0010-\u001a\u00020\nJ\b\u0010.\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u0012\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010$\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u00062"}, d2={"Lorg/gnit/lucenekmp/index/BufferedUpdatesStream;", "Lorg/gnit/lucenekmp/util/Accountable;", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "<init>", "(Lorg/gnit/lucenekmp/util/InfoStream;)V", "updates", "", "Lorg/gnit/lucenekmp/index/FrozenBufferedUpdates;", "nextGen", "", "finishedSegments", "Lorg/gnit/lucenekmp/index/BufferedUpdatesStream$FinishedSegments;", "bytesUsed", "Lkotlin/concurrent/atomics/AtomicLong;", "getBytesUsed$annotations", "()V", "Ljava/util/concurrent/atomic/AtomicLong;", "push", "packet", "pendingUpdatesCount", "", "getPendingUpdatesCount", "()I", "clear", "", "any", "", "ramBytesUsed", "waitApplyAll", "writer", "Lorg/gnit/lucenekmp/index/IndexWriter;", "stillRunning", "delGen", "finishedSegment", "finished", "completedDelGen", "getCompletedDelGen", "()J", "waitApplyForMerge", "mergeInfos", "", "Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "waitApply", "waitFor", "getNextGen", "checkDeleteStats", "ApplyDeletesResult", "SegmentState", "FinishedSegments", "core"})
@SourceDebugExtension(value={"SMAP\nBufferedUpdatesStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferedUpdatesStream.kt\norg/gnit/lucenekmp/index/BufferedUpdatesStream\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,335:1\n3#2,8:336\n3#2,8:345\n3#2,8:354\n8#2,2:363\n8#2,2:365\n10#3:344\n10#3:353\n10#3:362\n*S KotlinDebug\n*F\n+ 1 BufferedUpdatesStream.kt\norg/gnit/lucenekmp/index/BufferedUpdatesStream\n*L\n57#1:336,8\n58#1:345,8\n68#1:354,8\n145#1:363,2\n282#1:365,2\n57#1:344\n58#1:353\n68#1:362\n*E\n"})
public final class BufferedUpdatesStream
implements Accountable {
    @NotNull
    private final InfoStream infoStream;
    @NotNull
    private final Set<FrozenBufferedUpdates> updates;
    private long nextGen;
    @NotNull
    private final FinishedSegments finishedSegments;
    @NotNull
    private final AtomicLong bytesUsed;

    public BufferedUpdatesStream(@NotNull InfoStream infoStream) {
        Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
        this.infoStream = infoStream;
        this.updates = new HashSet();
        this.nextGen = 1L;
        this.finishedSegments = new FinishedSegments(this.infoStream);
        this.bytesUsed = new AtomicLong(0L);
    }

    private static /* synthetic */ void getBytesUsed$annotations() {
    }

    public final long push(@NotNull FrozenBufferedUpdates packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        long l = this.nextGen;
        this.nextGen = l + 1L;
        packet.setDelGen(l);
        boolean condition$iv = packet.any();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        condition$iv = this.checkDeleteStats();
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$32 = false;
            String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
        }
        this.updates.add(packet);
        this.bytesUsed.addAndGet(packet.getBytesUsed());
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "push new packet (" + packet + "), packetCount=" + this.updates.size() + ", bytesUsed=" + (double)this.bytesUsed.get() / 1024.0 / 1024.0 + " MB");
        }
        condition$iv = this.checkDeleteStats();
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        return packet.delGen();
    }

    public final int getPendingUpdatesCount() {
        return this.updates.size();
    }

    public final void clear() {
        this.updates.clear();
        this.nextGen = 1L;
        this.finishedSegments.clear();
        this.bytesUsed.set(0L);
    }

    public final boolean any() {
        return this.bytesUsed.get() != 0L;
    }

    @Override
    public long ramBytesUsed() {
        return this.bytesUsed.get();
    }

    public final void waitApplyAll(@NotNull IndexWriter writer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        HashSet waitFor = new HashSet(this.updates);
        this.waitApply(waitFor, writer);
    }

    public final boolean stillRunning(long delGen) {
        return this.finishedSegments.stillRunning(delGen);
    }

    public final void finishedSegment(long delGen) {
        this.finishedSegments.finishedSegment(delGen);
    }

    public final void finished(@NotNull FrozenBufferedUpdates packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        boolean condition$iv = packet.getApplied().getCount() == 1L;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "packet=" + packet;
            throw new AssertionError((Object)string);
        }
        packet.getApplied().countDown();
        this.updates.remove(packet);
        this.bytesUsed.addAndGet(-((long)packet.getBytesUsed()));
        this.finishedSegment(packet.delGen());
    }

    public final long getCompletedDelGen() {
        return this.finishedSegments.getCompletedDelGen();
    }

    public final void waitApplyForMerge(@NotNull List<SegmentCommitInfo> mergeInfos, @NotNull IndexWriter writer) throws IOException {
        Intrinsics.checkNotNullParameter(mergeInfos, (String)"mergeInfos");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        long maxDelGen = Long.MIN_VALUE;
        for (SegmentCommitInfo info : mergeInfos) {
            maxDelGen = Math.max(maxDelGen, info.getBufferedDeletesGen());
        }
        Set waitFor = new HashSet();
        for (FrozenBufferedUpdates packet : this.updates) {
            if (packet.delGen() > maxDelGen) continue;
            waitFor.add(packet);
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "waitApplyForMerge: " + waitFor.size() + " packets, " + mergeInfos.size() + " merging segments");
        }
        this.waitApply(waitFor, writer);
    }

    private final void waitApply(Set<FrozenBufferedUpdates> waitFor, IndexWriter writer) throws IOException {
        long startNS = System.INSTANCE.nanoTime();
        int packetCount = waitFor.size();
        if (waitFor.isEmpty()) {
            if (this.infoStream.isEnabled("BD")) {
                this.infoStream.message("BD", "waitApply: no deletes to apply");
            }
            return;
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "waitApply: " + waitFor.size() + " packets: " + waitFor);
        }
        ArrayList<FrozenBufferedUpdates> pendingPackets = new ArrayList<FrozenBufferedUpdates>();
        long totalDelCount = 0L;
        for (FrozenBufferedUpdates packet : waitFor) {
            if (!writer.tryApply(packet)) {
                pendingPackets.add(packet);
            }
            totalDelCount += packet.getTotalDelCount();
        }
        Iterator iterator2 = pendingPackets.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<FrozenBufferedUpdates> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            FrozenBufferedUpdates packet;
            packet = iterator3.next();
            writer.forceApply(packet);
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "waitApply: done " + packetCount + " packets; totalDelCount=" + totalDelCount + "; totBytesUsed=" + this.bytesUsed.get() + "; took " + (double)(System.INSTANCE.nanoTime() - startNS) / (double)TimeUnit.MILLISECONDS.toNanos(1L) + " msec");
        }
    }

    public final long getNextGen() {
        long l = this.nextGen;
        this.nextGen = l + 1L;
        return l;
    }

    private final boolean checkDeleteStats() {
        long bytesUsed2 = 0L;
        for (FrozenBufferedUpdates packet : this.updates) {
            bytesUsed2 += (long)packet.getBytesUsed();
        }
        boolean condition$iv = bytesUsed2 == this.bytesUsed.get();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "bytesUsed2=" + bytesUsed2 + " vs " + this.bytesUsed;
            throw new AssertionError((Object)string);
        }
        return true;
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/index/BufferedUpdatesStream$ApplyDeletesResult;", "", "anyDeletes", "", "allDeleted", "", "Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "<init>", "(ZLjava/util/List;)V", "getAnyDeletes", "()Z", "getAllDeleted", "()Ljava/util/List;", "core"})
    public static final class ApplyDeletesResult {
        private final boolean anyDeletes;
        @NotNull
        private final List<SegmentCommitInfo> allDeleted;

        public ApplyDeletesResult(boolean anyDeletes, @NotNull List<SegmentCommitInfo> allDeleted) {
            Intrinsics.checkNotNullParameter(allDeleted, (String)"allDeleted");
            this.anyDeletes = anyDeletes;
            this.allDeleted = allDeleted;
        }

        public final boolean getAnyDeletes() {
            return this.anyDeletes;
        }

        @NotNull
        public final List<SegmentCommitInfo> getAllDeleted() {
            return this.allDeleted;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/index/BufferedUpdatesStream$FinishedSegments;", "", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "<init>", "(Lorg/gnit/lucenekmp/util/InfoStream;)V", "value", "", "completedDelGen", "getCompletedDelGen", "()J", "finishedDelGens", "Lorg/gnit/lucenekmp/internal/hppc/LongHashSet;", "clear", "", "stillRunning", "", "delGen", "finishedSegment", "core"})
    private static final class FinishedSegments {
        @NotNull
        private final InfoStream infoStream;
        private long completedDelGen;
        @NotNull
        private final LongHashSet finishedDelGens;

        public FinishedSegments(@NotNull InfoStream infoStream) {
            Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
            this.infoStream = infoStream;
            this.finishedDelGens = new LongHashSet();
        }

        public final long getCompletedDelGen() {
            return this.completedDelGen;
        }

        public final void clear() {
            this.finishedDelGens.clear();
            this.completedDelGen = 0L;
        }

        public final boolean stillRunning(long delGen) {
            return delGen > this.completedDelGen && !this.finishedDelGens.contains(delGen);
        }

        public final void finishedSegment(long delGen) {
            this.finishedDelGens.add(delGen);
            while (this.finishedDelGens.contains(this.completedDelGen + 1L)) {
                this.finishedDelGens.remove(this.completedDelGen + 1L);
                long l = this.completedDelGen;
                this.completedDelGen = l + 1L;
            }
            if (this.infoStream.isEnabled("BD")) {
                this.infoStream.message("BD", "finished packet delGen=" + delGen + " now completedDelGen=" + this.completedDelGen);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020.H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006/"}, d2={"Lorg/gnit/lucenekmp/index/BufferedUpdatesStream$SegmentState;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "rld", "Lorg/gnit/lucenekmp/index/ReadersAndUpdates;", "onClose", "Lorg/gnit/lucenekmp/util/IOConsumer;", "info", "Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "<init>", "(Lorg/gnit/lucenekmp/index/ReadersAndUpdates;Lorg/gnit/lucenekmp/util/IOConsumer;Lorg/gnit/lucenekmp/index/SegmentCommitInfo;)V", "getRld", "()Lorg/gnit/lucenekmp/index/ReadersAndUpdates;", "delGen", "", "getDelGen", "()J", "reader", "Lorg/gnit/lucenekmp/index/SegmentReader;", "getReader", "()Lorg/gnit/lucenekmp/index/SegmentReader;", "startDelCount", "", "getStartDelCount", "()I", "termsEnum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "getTermsEnum", "()Lorg/gnit/lucenekmp/index/TermsEnum;", "setTermsEnum", "(Lorg/gnit/lucenekmp/index/TermsEnum;)V", "postingsEnum", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "getPostingsEnum", "()Lorg/gnit/lucenekmp/index/PostingsEnum;", "setPostingsEnum", "(Lorg/gnit/lucenekmp/index/PostingsEnum;)V", "term", "Lorg/gnit/lucenekmp/util/BytesRef;", "getTerm", "()Lorg/gnit/lucenekmp/util/BytesRef;", "setTerm", "(Lorg/gnit/lucenekmp/util/BytesRef;)V", "toString", "", "close", "", "core"})
    public static final class SegmentState
    implements AutoCloseable {
        @NotNull
        private final ReadersAndUpdates rld;
        @NotNull
        private final IOConsumer<ReadersAndUpdates> onClose;
        private final long delGen;
        @NotNull
        private final SegmentReader reader;
        private final int startDelCount;
        @Nullable
        private TermsEnum termsEnum;
        @Nullable
        private PostingsEnum postingsEnum;
        @Nullable
        private BytesRef term;

        public SegmentState(@NotNull ReadersAndUpdates rld, @NotNull IOConsumer<ReadersAndUpdates> onClose, @NotNull SegmentCommitInfo info) {
            Intrinsics.checkNotNullParameter((Object)rld, (String)"rld");
            Intrinsics.checkNotNullParameter(onClose, (String)"onClose");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            this.rld = rld;
            this.onClose = onClose;
            this.delGen = info.getBufferedDeletesGen();
            this.reader = this.rld.getReader(IOContext.Companion.getDEFAULT());
            this.startDelCount = this.rld.getDelCount();
        }

        @NotNull
        public final ReadersAndUpdates getRld() {
            return this.rld;
        }

        public final long getDelGen() {
            return this.delGen;
        }

        @NotNull
        public final SegmentReader getReader() {
            return this.reader;
        }

        public final int getStartDelCount() {
            return this.startDelCount;
        }

        @Nullable
        public final TermsEnum getTermsEnum() {
            return this.termsEnum;
        }

        public final void setTermsEnum(@Nullable TermsEnum termsEnum) {
            this.termsEnum = termsEnum;
        }

        @Nullable
        public final PostingsEnum getPostingsEnum() {
            return this.postingsEnum;
        }

        public final void setPostingsEnum(@Nullable PostingsEnum postingsEnum) {
            this.postingsEnum = postingsEnum;
        }

        @Nullable
        public final BytesRef getTerm() {
            return this.term;
        }

        public final void setTerm(@Nullable BytesRef bytesRef) {
            this.term = bytesRef;
        }

        @NotNull
        public String toString() {
            return "SegmentState(" + this.rld.getInfo() + ")";
        }

        @Override
        public void close() {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{() -> SegmentState.close$lambda$0(this), () -> SegmentState.close$lambda$1(this)};
            IOUtils.INSTANCE.close(autoCloseableArray);
        }

        private static final void close$lambda$0(SegmentState this$0) {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
                int label;
                final /* synthetic */ SegmentState this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.this$0.getRld().release(this.this$0.getReader(), (Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        private static final void close$lambda$1(SegmentState this$0) {
            this$0.onClose.accept(this$0.rld);
        }
    }
}

