/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.ByteSlicePool;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.BitUtil;
import org.gnit.lucenekmp.util.ByteBlockPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010%\u001a\u00020&2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000bJ\u0006\u0010(\u001a\u00020)J\b\u0010*\u001a\u00020+H\u0016J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020&J \u00101\u001a\u00020&2\u0006\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u000bH\u0016J\u0010\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020-H\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR\u001a\u0010\u0019\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000fR\u001a\u0010\u001c\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\r\"\u0004\b\u001e\u0010\u000fR\u001a\u0010\u001f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\r\"\u0004\b!\u0010\u000fR\u001a\u0010\"\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\r\"\u0004\b$\u0010\u000f\u00a8\u00067"}, d2={"Lorg/gnit/lucenekmp/index/ByteSliceReader;", "Lorg/gnit/lucenekmp/store/DataInput;", "<init>", "()V", "pool", "Lorg/gnit/lucenekmp/util/ByteBlockPool;", "getPool", "()Lorg/gnit/lucenekmp/util/ByteBlockPool;", "setPool", "(Lorg/gnit/lucenekmp/util/ByteBlockPool;)V", "bufferUpto", "", "getBufferUpto", "()I", "setBufferUpto", "(I)V", "buffer", "", "getBuffer", "()[B", "setBuffer", "([B)V", "upto", "getUpto", "setUpto", "limit", "getLimit", "setLimit", "level", "getLevel", "setLevel", "bufferOffset", "getBufferOffset", "setBufferOffset", "endIndex", "getEndIndex", "setEndIndex", "init", "", "startIndex", "eof", "", "readByte", "", "writeTo", "", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "nextSlice", "readBytes", "b", "offset", "len", "skipBytes", "numBytes", "core"})
@SourceDebugExtension(value={"SMAP\nByteSliceReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteSliceReader.kt\norg/gnit/lucenekmp/index/ByteSliceReader\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n3#2,8:141\n3#2,8:150\n3#2,8:159\n3#2,8:168\n3#2,8:177\n3#2,8:186\n3#2,8:195\n3#2,8:204\n10#3:149\n10#3:158\n10#3:167\n10#3:176\n10#3:185\n10#3:194\n10#3:203\n10#3:212\n1#4:213\n*S KotlinDebug\n*F\n+ 1 ByteSliceReader.kt\norg/gnit/lucenekmp/index/ByteSliceReader\n*L\n28#1:141,8\n29#1:150,8\n30#1:159,8\n50#1:168,8\n55#1:177,8\n56#1:186,8\n66#1:195,8\n96#1:204,8\n28#1:149\n29#1:158\n30#1:167\n50#1:176\n55#1:185\n56#1:194\n66#1:203\n96#1:212\n*E\n"})
public final class ByteSliceReader
extends DataInput {
    @Nullable
    private ByteBlockPool pool;
    private int bufferUpto;
    public byte[] buffer;
    private int upto;
    private int limit;
    private int level;
    private int bufferOffset;
    private int endIndex;

    @Nullable
    public final ByteBlockPool getPool() {
        return this.pool;
    }

    public final void setPool(@Nullable ByteBlockPool byteBlockPool) {
        this.pool = byteBlockPool;
    }

    public final int getBufferUpto() {
        return this.bufferUpto;
    }

    public final void setBufferUpto(int n) {
        this.bufferUpto = n;
    }

    @NotNull
    public final byte[] getBuffer() {
        if (this.buffer != null) {
            return this.buffer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
        return null;
    }

    public final void setBuffer(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.buffer = byArray;
    }

    public final int getUpto() {
        return this.upto;
    }

    public final void setUpto(int n) {
        this.upto = n;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final void setLimit(int n) {
        this.limit = n;
    }

    public final int getLevel() {
        return this.level;
    }

    public final void setLevel(int n) {
        this.level = n;
    }

    public final int getBufferOffset() {
        return this.bufferOffset;
    }

    public final void setBufferOffset(int n) {
        this.bufferOffset = n;
    }

    public final int getEndIndex() {
        return this.endIndex;
    }

    public final void setEndIndex(int n) {
        this.endIndex = n;
    }

    public final void init(@NotNull ByteBlockPool pool, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        boolean condition$iv = endIndex - startIndex >= 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        condition$iv = startIndex >= 0;
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$32 = false;
            String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
        }
        condition$iv = endIndex >= 0;
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        this.pool = pool;
        this.endIndex = endIndex;
        this.level = 0;
        this.bufferUpto = startIndex / 32768;
        this.bufferOffset = this.bufferUpto * 32768;
        this.setBuffer(pool.getBuffer(this.bufferUpto));
        this.upto = startIndex & Short.MAX_VALUE;
        int firstSize = ByteSlicePool.Companion.getLEVEL_SIZE_ARRAY()[0];
        this.limit = startIndex + firstSize >= endIndex ? endIndex & Short.MAX_VALUE : this.upto + firstSize - 4;
    }

    public final boolean eof() {
        boolean condition$iv = this.upto + this.bufferOffset <= this.endIndex;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        return this.upto + this.bufferOffset == this.endIndex;
    }

    @Override
    public byte readByte() {
        boolean condition$iv = !this.eof();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        condition$iv = this.upto <= this.limit;
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        if (this.upto == this.limit) {
            this.nextSlice();
        }
        int n = this.upto;
        this.upto = n + 1;
        return this.getBuffer()[n];
    }

    public final long writeTo(@NotNull DataOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        long size2 = 0L;
        while (true) {
            if (this.limit + this.bufferOffset == this.endIndex) {
                boolean condition$iv = this.endIndex - this.bufferOffset >= this.upto;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
                break;
            }
            out.writeBytes(this.getBuffer(), this.upto, this.limit - this.upto);
            size2 += (long)(this.limit - this.upto);
            this.nextSlice();
        }
        out.writeBytes(this.getBuffer(), this.upto, this.limit - this.upto);
        return size2 += (long)(this.limit - this.upto);
    }

    public final void nextSlice() {
        int nextIndex = BitUtil.VH_LE_INT.INSTANCE.get(this.getBuffer(), this.limit);
        this.level = ByteSlicePool.Companion.getNEXT_LEVEL_ARRAY()[this.level];
        int newSize = ByteSlicePool.Companion.getLEVEL_SIZE_ARRAY()[this.level];
        this.bufferUpto = nextIndex / 32768;
        this.bufferOffset = this.bufferUpto * 32768;
        ByteBlockPool byteBlockPool = this.pool;
        Intrinsics.checkNotNull((Object)byteBlockPool);
        this.setBuffer(byteBlockPool.getBuffer(this.bufferUpto));
        this.upto = nextIndex & Short.MAX_VALUE;
        if (nextIndex + newSize >= this.endIndex) {
            boolean condition$iv = this.endIndex - nextIndex > 0;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.limit = this.endIndex - this.bufferOffset;
        } else {
            this.limit = this.upto + newSize - 4;
        }
    }

    @Override
    public void readBytes(@NotNull byte[] b, int offset, int len) {
        int numLeft;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int offset2 = offset;
        for (int len2 = len; len2 > 0; len2 -= numLeft) {
            numLeft = this.limit - this.upto;
            if (numLeft < len2) {
                System.INSTANCE.arraycopy(this.getBuffer(), this.upto, b, offset2, numLeft);
                offset2 += numLeft;
                this.nextSlice();
                continue;
            }
            System.INSTANCE.arraycopy(this.getBuffer(), this.upto, b, offset2, len2);
            this.upto += len2;
            break;
        }
    }

    @Override
    public void skipBytes(long numBytes) {
        long numBytes2 = 0L;
        numBytes2 = numBytes;
        if (!(numBytes2 >= 0L)) {
            boolean bl = false;
            String string = "numBytes must be >= 0, got " + numBytes2;
            throw new IllegalArgumentException(string.toString());
        }
        while (numBytes2 > 0L) {
            int numLeft = this.limit - this.upto;
            if ((long)numLeft < numBytes2) {
                numBytes2 -= (long)numLeft;
                this.nextSlice();
                continue;
            }
            this.upto += (int)numBytes2;
            break;
        }
    }
}

