/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.DocValuesProducer;
import org.gnit.lucenekmp.codecs.FieldsProducer;
import org.gnit.lucenekmp.codecs.KnnVectorsReader;
import org.gnit.lucenekmp.codecs.NormsProducer;
import org.gnit.lucenekmp.codecs.PointsReader;
import org.gnit.lucenekmp.codecs.StoredFieldsReader;
import org.gnit.lucenekmp.codecs.TermVectorsReader;
import org.gnit.lucenekmp.index.BinaryDocValues;
import org.gnit.lucenekmp.index.ByteVectorValues;
import org.gnit.lucenekmp.index.DocValuesSkipIndexType;
import org.gnit.lucenekmp.index.DocValuesSkipper;
import org.gnit.lucenekmp.index.DocValuesType;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FloatVectorValues;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.index.SortedDocValues;
import org.gnit.lucenekmp.index.SortedNumericDocValues;
import org.gnit.lucenekmp.index.SortedSetDocValues;
import org.gnit.lucenekmp.index.StoredFieldVisitor;
import org.gnit.lucenekmp.index.StoredFields;
import org.gnit.lucenekmp.index.TermVectors;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.VectorEncoding;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.search.KnnCollector;
import org.gnit.lucenekmp.util.Bits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0016J\u001a\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020+H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010&\u001a\u00020'H\u0016J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010&\u001a\u00020'H\u0016J\u0012\u00100\u001a\u0004\u0018\u0001012\u0006\u0010&\u001a\u00020'H\u0016J\u0012\u00102\u001a\u0004\u0018\u0001032\u0006\u0010&\u001a\u00020'H\u0016J\u0012\u00104\u001a\u0004\u0018\u0001052\u0006\u0010&\u001a\u00020'H\u0016J\u0012\u00106\u001a\u0004\u0018\u0001072\u0006\u0010&\u001a\u00020'H\u0016J\u0012\u00108\u001a\u0004\u0018\u00010-2\u0006\u0010&\u001a\u00020'H\u0016J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010&\u001a\u00020'H\u0016J\u0012\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010&\u001a\u00020'H\u0016J\u0012\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010&\u001a\u00020'H\u0016J(\u0010?\u001a\u00020@2\u0006\u0010&\u001a\u00020'2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FH\u0016J(\u0010?\u001a\u00020@2\u0006\u0010&\u001a\u00020'2\u0006\u0010A\u001a\u00020G2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FH\u0016J\b\u0010H\u001a\u00020@H\u0016J\b\u0010I\u001a\u00020@H\u0016R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u0004\u0018\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006J"}, d2={"Lorg/gnit/lucenekmp/index/CodecReader;", "Lorg/gnit/lucenekmp/index/LeafReader;", "<init>", "()V", "fieldsReader", "Lorg/gnit/lucenekmp/codecs/StoredFieldsReader;", "getFieldsReader", "()Lorg/gnit/lucenekmp/codecs/StoredFieldsReader;", "termVectorsReader", "Lorg/gnit/lucenekmp/codecs/TermVectorsReader;", "getTermVectorsReader", "()Lorg/gnit/lucenekmp/codecs/TermVectorsReader;", "normsReader", "Lorg/gnit/lucenekmp/codecs/NormsProducer;", "getNormsReader", "()Lorg/gnit/lucenekmp/codecs/NormsProducer;", "docValuesReader", "Lorg/gnit/lucenekmp/codecs/DocValuesProducer;", "getDocValuesReader", "()Lorg/gnit/lucenekmp/codecs/DocValuesProducer;", "postingsReader", "Lorg/gnit/lucenekmp/codecs/FieldsProducer;", "getPostingsReader", "()Lorg/gnit/lucenekmp/codecs/FieldsProducer;", "pointsReader", "Lorg/gnit/lucenekmp/codecs/PointsReader;", "getPointsReader", "()Lorg/gnit/lucenekmp/codecs/PointsReader;", "vectorReader", "Lorg/gnit/lucenekmp/codecs/KnnVectorsReader;", "getVectorReader", "()Lorg/gnit/lucenekmp/codecs/KnnVectorsReader;", "storedFields", "Lorg/gnit/lucenekmp/index/StoredFields;", "termVectors", "Lorg/gnit/lucenekmp/index/TermVectors;", "terms", "Lorg/gnit/lucenekmp/index/Terms;", "field", "", "getDVField", "Lorg/gnit/lucenekmp/index/FieldInfo;", "type", "Lorg/gnit/lucenekmp/index/DocValuesType;", "getNumericDocValues", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "getBinaryDocValues", "Lorg/gnit/lucenekmp/index/BinaryDocValues;", "getSortedDocValues", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "getSortedNumericDocValues", "Lorg/gnit/lucenekmp/index/SortedNumericDocValues;", "getSortedSetDocValues", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "getDocValuesSkipper", "Lorg/gnit/lucenekmp/index/DocValuesSkipper;", "getNormValues", "getPointValues", "Lorg/gnit/lucenekmp/index/PointValues;", "getFloatVectorValues", "Lorg/gnit/lucenekmp/index/FloatVectorValues;", "getByteVectorValues", "Lorg/gnit/lucenekmp/index/ByteVectorValues;", "searchNearestVectors", "", "target", "", "knnCollector", "Lorg/gnit/lucenekmp/search/KnnCollector;", "acceptDocs", "Lorg/gnit/lucenekmp/util/Bits;", "", "doClose", "checkIntegrity", "core"})
public abstract class CodecReader
extends LeafReader {
    protected CodecReader() {
    }

    @Nullable
    public abstract StoredFieldsReader getFieldsReader();

    @Nullable
    public abstract TermVectorsReader getTermVectorsReader();

    @Nullable
    public abstract NormsProducer getNormsReader();

    @Nullable
    public abstract DocValuesProducer getDocValuesReader();

    @Nullable
    public abstract FieldsProducer getPostingsReader();

    @Nullable
    public abstract PointsReader getPointsReader();

    @Nullable
    public abstract KnnVectorsReader getVectorReader();

    @Override
    @NotNull
    public StoredFields storedFields() throws IOException {
        StoredFieldsReader storedFieldsReader = this.getFieldsReader();
        Intrinsics.checkNotNull((Object)storedFieldsReader);
        StoredFields reader2 = storedFieldsReader;
        return new StoredFields(this, reader2){
            final /* synthetic */ CodecReader this$0;
            final /* synthetic */ StoredFields $reader;
            {
                this.this$0 = $receiver;
                this.$reader = $reader;
            }

            public void prefetch(int docID) throws IOException {
                Objects.INSTANCE.checkIndex(docID, this.this$0.maxDoc());
                this.$reader.prefetch(docID);
            }

            public void document(int docID, StoredFieldVisitor visitor2) throws IOException {
                Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
                Objects.INSTANCE.checkIndex(docID, this.this$0.maxDoc());
                this.$reader.document(docID, visitor2);
            }
        };
    }

    @Override
    @NotNull
    public TermVectors termVectors() throws IOException {
        TermVectorsReader reader2 = this.getTermVectorsReader();
        return reader2 == null ? TermVectors.Companion.getEMPTY() : (TermVectors)reader2;
    }

    @Override
    @Nullable
    public Terms terms(@NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getIndexOptions() == IndexOptions.NONE) {
            return null;
        }
        FieldsProducer fieldsProducer = this.getPostingsReader();
        Intrinsics.checkNotNull((Object)fieldsProducer);
        return fieldsProducer.terms(field);
    }

    private final FieldInfo getDVField(String field, DocValuesType type) {
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() == DocValuesType.NONE) {
            return null;
        }
        if (fi.getDocValuesType() != type) {
            return null;
        }
        return fi;
    }

    @Override
    @Nullable
    public NumericDocValues getNumericDocValues(@NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.NUMERIC);
        if (fi == null) {
            return null;
        }
        DocValuesProducer docValuesProducer = this.getDocValuesReader();
        Intrinsics.checkNotNull((Object)docValuesProducer);
        return docValuesProducer.getNumeric(fi);
    }

    @Override
    @Nullable
    public BinaryDocValues getBinaryDocValues(@NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.BINARY);
        if (fi == null) {
            return null;
        }
        DocValuesProducer docValuesProducer = this.getDocValuesReader();
        Intrinsics.checkNotNull((Object)docValuesProducer);
        return docValuesProducer.getBinary(fi);
    }

    @Override
    @Nullable
    public SortedDocValues getSortedDocValues(@NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.SORTED);
        if (fi == null) {
            return null;
        }
        DocValuesProducer docValuesProducer = this.getDocValuesReader();
        Intrinsics.checkNotNull((Object)docValuesProducer);
        return docValuesProducer.getSorted(fi);
    }

    @Override
    @Nullable
    public SortedNumericDocValues getSortedNumericDocValues(@NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.SORTED_NUMERIC);
        if (fi == null) {
            return null;
        }
        DocValuesProducer docValuesProducer = this.getDocValuesReader();
        Intrinsics.checkNotNull((Object)docValuesProducer);
        return docValuesProducer.getSortedNumeric(fi);
    }

    @Override
    @Nullable
    public SortedSetDocValues getSortedSetDocValues(@NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.SORTED_SET);
        if (fi == null) {
            return null;
        }
        DocValuesProducer docValuesProducer = this.getDocValuesReader();
        Intrinsics.checkNotNull((Object)docValuesProducer);
        return docValuesProducer.getSortedSet(fi);
    }

    @Override
    @Nullable
    public DocValuesSkipper getDocValuesSkipper(@NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.docValuesSkipIndexType() == DocValuesSkipIndexType.NONE) {
            return null;
        }
        DocValuesProducer docValuesProducer = this.getDocValuesReader();
        Intrinsics.checkNotNull((Object)docValuesProducer);
        return docValuesProducer.getSkipper(fi);
    }

    @Override
    @Nullable
    public NumericDocValues getNormValues(@NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || !fi.hasNorms()) {
            return null;
        }
        NormsProducer normsProducer = this.getNormsReader();
        Intrinsics.checkNotNull((Object)normsProducer);
        return normsProducer.getNorms(fi);
    }

    @Override
    @Nullable
    public PointValues getPointValues(@NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getPointDimensionCount() == 0) {
            return null;
        }
        PointsReader pointsReader2 = this.getPointsReader();
        Intrinsics.checkNotNull((Object)pointsReader2);
        return pointsReader2.getValues(field);
    }

    @Override
    @Nullable
    public FloatVectorValues getFloatVectorValues(@NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getVectorDimension() == 0 || fi.getVectorEncoding() != VectorEncoding.FLOAT32) {
            return null;
        }
        KnnVectorsReader knnVectorsReader = this.getVectorReader();
        Intrinsics.checkNotNull((Object)knnVectorsReader);
        return knnVectorsReader.getFloatVectorValues(field);
    }

    @Override
    @Nullable
    public ByteVectorValues getByteVectorValues(@NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getVectorDimension() == 0 || fi.getVectorEncoding() != VectorEncoding.BYTE) {
            return null;
        }
        KnnVectorsReader knnVectorsReader = this.getVectorReader();
        Intrinsics.checkNotNull((Object)knnVectorsReader);
        return knnVectorsReader.getByteVectorValues(field);
    }

    @Override
    public void searchNearestVectors(@NotNull String field, @NotNull float[] target, @NotNull KnnCollector knnCollector, @NotNull Bits acceptDocs) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)knnCollector, (String)"knnCollector");
        Intrinsics.checkNotNullParameter((Object)acceptDocs, (String)"acceptDocs");
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getVectorDimension() == 0 || fi.getVectorEncoding() != VectorEncoding.FLOAT32) {
            return;
        }
        KnnVectorsReader knnVectorsReader = this.getVectorReader();
        Intrinsics.checkNotNull((Object)knnVectorsReader);
        knnVectorsReader.search(field, target, knnCollector, acceptDocs);
    }

    @Override
    public void searchNearestVectors(@NotNull String field, @NotNull byte[] target, @NotNull KnnCollector knnCollector, @NotNull Bits acceptDocs) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)knnCollector, (String)"knnCollector");
        Intrinsics.checkNotNullParameter((Object)acceptDocs, (String)"acceptDocs");
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getVectorDimension() == 0 || fi.getVectorEncoding() != VectorEncoding.BYTE) {
            return;
        }
        KnnVectorsReader knnVectorsReader = this.getVectorReader();
        Intrinsics.checkNotNull((Object)knnVectorsReader);
        knnVectorsReader.search(field, target, knnCollector, acceptDocs);
    }

    @Override
    public void doClose() throws IOException {
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.ensureOpen();
        if (this.getPostingsReader() != null) {
            FieldsProducer fieldsProducer = this.getPostingsReader();
            Intrinsics.checkNotNull((Object)fieldsProducer);
            fieldsProducer.checkIntegrity();
        }
        if (this.getNormsReader() != null) {
            NormsProducer normsProducer = this.getNormsReader();
            Intrinsics.checkNotNull((Object)normsProducer);
            normsProducer.checkIntegrity();
        }
        if (this.getDocValuesReader() != null) {
            DocValuesProducer docValuesProducer = this.getDocValuesReader();
            Intrinsics.checkNotNull((Object)docValuesProducer);
            docValuesProducer.checkIntegrity();
        }
        if (this.getFieldsReader() != null) {
            StoredFieldsReader storedFieldsReader = this.getFieldsReader();
            Intrinsics.checkNotNull((Object)storedFieldsReader);
            storedFieldsReader.checkIntegrity();
        }
        if (this.getTermVectorsReader() != null) {
            TermVectorsReader termVectorsReader = this.getTermVectorsReader();
            if (termVectorsReader != null) {
                termVectorsReader.checkIntegrity();
            }
        }
        if (this.getPointsReader() != null) {
            PointsReader pointsReader2 = this.getPointsReader();
            Intrinsics.checkNotNull((Object)pointsReader2);
            pointsReader2.checkIntegrity();
        }
        if (this.getVectorReader() != null) {
            KnnVectorsReader knnVectorsReader = this.getVectorReader();
            Intrinsics.checkNotNull((Object)knnVectorsReader);
            knnVectorsReader.checkIntegrity();
        }
    }
}

