/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gnit.lucenekmp.index.BaseCompositeReader;
import org.gnit.lucenekmp.index.IndexCommit;
import org.gnit.lucenekmp.index.IndexReader;
import org.gnit.lucenekmp.index.IndexWriter;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.SegmentInfos;
import org.gnit.lucenekmp.index.StandardDirectoryReader;
import org.gnit.lucenekmp.jdkport.NoSuchFileException;
import org.gnit.lucenekmp.store.Directory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b&\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eBA\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0006\u0012\u001e\u0010\u0007\u001a\u001a\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\bj\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u0001`\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0003\u001a\u00020\u0004J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0000H&J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H&J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H&R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lorg/gnit/lucenekmp/index/DirectoryReader;", "Lorg/gnit/lucenekmp/index/BaseCompositeReader;", "Lorg/gnit/lucenekmp/index/LeafReader;", "directory", "Lorg/gnit/lucenekmp/store/Directory;", "segmentReaders", "", "leafSorter", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "<init>", "(Lorg/gnit/lucenekmp/store/Directory;[Lorg/gnit/lucenekmp/index/LeafReader;Ljava/util/Comparator;)V", "getDirectory", "()Lorg/gnit/lucenekmp/store/Directory;", "doOpenIfChanged", "commit", "Lorg/gnit/lucenekmp/index/IndexCommit;", "writer", "Lorg/gnit/lucenekmp/index/IndexWriter;", "applyAllDeletes", "", "version", "", "getVersion", "()J", "isCurrent", "()Z", "indexCommit", "getIndexCommit", "()Lorg/gnit/lucenekmp/index/IndexCommit;", "Companion", "core"})
public abstract class DirectoryReader
extends BaseCompositeReader<LeafReader> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Directory directory;

    protected DirectoryReader(@NotNull Directory directory, @NotNull LeafReader[] segmentReaders, @Nullable Comparator<? extends LeafReader> leafSorter) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)segmentReaders, (String)"segmentReaders");
        super((IndexReader[])segmentReaders, leafSorter);
        this.directory = directory;
    }

    @NotNull
    protected final Directory getDirectory() {
        return this.directory;
    }

    @NotNull
    public final Directory directory() {
        return this.directory;
    }

    @Nullable
    public abstract DirectoryReader doOpenIfChanged() throws IOException;

    @Nullable
    public abstract DirectoryReader doOpenIfChanged(@Nullable IndexCommit var1) throws IOException;

    @Nullable
    public abstract DirectoryReader doOpenIfChanged(@NotNull IndexWriter var1, boolean var2) throws IOException;

    public abstract long getVersion();

    public abstract boolean isCurrent();

    @NotNull
    public abstract IndexCommit getIndexCommit();

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bJ$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fH\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u0005J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012J$\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\u0019\u001a\u00020\u0007J\u000e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/index/DirectoryReader$Companion;", "", "<init>", "()V", "open", "Lorg/gnit/lucenekmp/index/DirectoryReader;", "directory", "Lorg/gnit/lucenekmp/store/Directory;", "leafSorter", "Ljava/util/Comparator;", "Lorg/gnit/lucenekmp/index/LeafReader;", "Lkotlin/Comparator;", "writer", "Lorg/gnit/lucenekmp/index/IndexWriter;", "applyAllDeletes", "", "writeAllDeletes", "commit", "Lorg/gnit/lucenekmp/index/IndexCommit;", "minSupportedMajorVersion", "", "openIfChanged", "oldReader", "listCommits", "", "dir", "indexExists", "core"})
    @SourceDebugExtension(value={"SMAP\nDirectoryReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryReader.kt\norg/gnit/lucenekmp/index/DirectoryReader$Companion\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,395:1\n3#2,8:396\n3#2,8:405\n3#2,8:414\n10#3:404\n10#3:413\n10#3:422\n*S KotlinDebug\n*F\n+ 1 DirectoryReader.kt\norg/gnit/lucenekmp/index/DirectoryReader$Companion\n*L\n223#1:396,8\n236#1:405,8\n301#1:414,8\n223#1:404\n236#1:413\n301#1:422\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DirectoryReader open(@NotNull Directory directory) throws IOException {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            return StandardDirectoryReader.Companion.open(directory, null, null);
        }

        @NotNull
        public final DirectoryReader open(@NotNull Directory directory, @NotNull Comparator<LeafReader> leafSorter) throws IOException {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Intrinsics.checkNotNullParameter(leafSorter, (String)"leafSorter");
            return StandardDirectoryReader.Companion.open(directory, null, leafSorter);
        }

        @JvmOverloads
        @NotNull
        public final DirectoryReader open(@NotNull IndexWriter writer, boolean applyAllDeletes, boolean writeAllDeletes) throws IOException {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            return writer.getReader(applyAllDeletes, writeAllDeletes);
        }

        public static /* synthetic */ DirectoryReader open$default(Companion companion, IndexWriter indexWriter, boolean bl, boolean bl2, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            return companion.open(indexWriter, bl, bl2);
        }

        @NotNull
        public final DirectoryReader open(@NotNull IndexCommit commit2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)commit2, (String)"commit");
            return StandardDirectoryReader.Companion.open(commit2.getDirectory(), commit2, null);
        }

        @NotNull
        public final DirectoryReader open(@NotNull IndexCommit commit2, int minSupportedMajorVersion, @NotNull Comparator<LeafReader> leafSorter) throws IOException {
            Intrinsics.checkNotNullParameter((Object)commit2, (String)"commit");
            Intrinsics.checkNotNullParameter(leafSorter, (String)"leafSorter");
            return StandardDirectoryReader.Companion.open(commit2.getDirectory(), minSupportedMajorVersion, commit2, leafSorter);
        }

        @Nullable
        public final DirectoryReader openIfChanged(@NotNull DirectoryReader oldReader) throws IOException {
            Intrinsics.checkNotNullParameter((Object)oldReader, (String)"oldReader");
            DirectoryReader newReader = oldReader.doOpenIfChanged();
            boolean condition$iv = newReader != oldReader;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            return newReader;
        }

        @Nullable
        public final DirectoryReader openIfChanged(@NotNull DirectoryReader oldReader, @NotNull IndexCommit commit2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)oldReader, (String)"oldReader");
            Intrinsics.checkNotNullParameter((Object)commit2, (String)"commit");
            DirectoryReader newReader = oldReader.doOpenIfChanged(commit2);
            boolean condition$iv = newReader != oldReader;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            return newReader;
        }

        @JvmOverloads
        @Nullable
        public final DirectoryReader openIfChanged(@NotNull DirectoryReader oldReader, @NotNull IndexWriter writer, boolean applyAllDeletes) throws IOException {
            Intrinsics.checkNotNullParameter((Object)oldReader, (String)"oldReader");
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            DirectoryReader newReader = oldReader.doOpenIfChanged(writer, applyAllDeletes);
            boolean condition$iv = newReader != oldReader;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            return newReader;
        }

        public static /* synthetic */ DirectoryReader openIfChanged$default(Companion companion, DirectoryReader directoryReader, IndexWriter indexWriter, boolean bl, int n, Object object) throws IOException {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.openIfChanged(directoryReader, indexWriter, bl);
        }

        @NotNull
        public final List<IndexCommit> listCommits(@NotNull Directory dir) throws IOException {
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            String[] files = dir.listAll();
            List commits = new ArrayList();
            SegmentInfos latest = SegmentInfos.Companion.readLatestCommit(dir, 0);
            long currentGen = latest.getGeneration();
            commits.add(new StandardDirectoryReader.ReaderCommit(null, latest, dir));
            for (String fileName : files) {
                if (!StringsKt.startsWith$default((String)fileName, (String)"segments", (boolean)false, (int)2, null) || SegmentInfos.Companion.generationFromSegmentsFileName(fileName) >= currentGen) continue;
                SegmentInfos sis = null;
                try {
                    sis = SegmentInfos.Companion.readCommit(dir, fileName, 0);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
                if (sis == null) continue;
                commits.add(new StandardDirectoryReader.ReaderCommit(null, sis, dir));
            }
            CollectionsKt.sort((List)commits);
            return commits;
        }

        public final boolean indexExists(@NotNull Directory directory) throws IOException {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            String[] files = directory.listAll();
            String prefix = "segments_";
            for (String file : files) {
                if (!StringsKt.startsWith$default((String)file, (String)prefix, (boolean)false, (int)2, null)) continue;
                return true;
            }
            return false;
        }

        @JvmOverloads
        @NotNull
        public final DirectoryReader open(@NotNull IndexWriter writer, boolean applyAllDeletes) throws IOException {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            return org.gnit.lucenekmp.index.DirectoryReader$Companion.open$default(this, writer, applyAllDeletes, false, 4, null);
        }

        @JvmOverloads
        @NotNull
        public final DirectoryReader open(@NotNull IndexWriter writer) throws IOException {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            return org.gnit.lucenekmp.index.DirectoryReader$Companion.open$default(this, writer, false, false, 6, null);
        }

        @JvmOverloads
        @Nullable
        public final DirectoryReader openIfChanged(@NotNull DirectoryReader oldReader, @NotNull IndexWriter writer) throws IOException {
            Intrinsics.checkNotNullParameter((Object)oldReader, (String)"oldReader");
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            return org.gnit.lucenekmp.index.DirectoryReader$Companion.openIfChanged$default(this, oldReader, writer, false, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

