/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.DocValuesType;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 #2\u00020\u0001:\u0003!\"#B3\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0018\u001a\u00020\u0019H&J\u0006\u0010\u001a\u001a\u00020\u0019J\b\u0010\u001b\u001a\u00020\u0007H&J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH&J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010 \u001a\u00020\u0007H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lorg/gnit/lucenekmp/index/DocValuesUpdate;", "", "type", "Lorg/gnit/lucenekmp/index/DocValuesType;", "term", "Lorg/gnit/lucenekmp/index/Term;", "field", "", "docIDUpTo", "", "hasValue", "", "<init>", "(Lorg/gnit/lucenekmp/index/DocValuesType;Lorg/gnit/lucenekmp/index/Term;Ljava/lang/String;IZ)V", "getType", "()Lorg/gnit/lucenekmp/index/DocValuesType;", "getTerm", "()Lorg/gnit/lucenekmp/index/Term;", "getField", "()Ljava/lang/String;", "getDocIDUpTo", "()I", "getHasValue", "()Z", "valueSizeInBytes", "", "sizeInBytes", "valueToString", "writeTo", "", "output", "Lorg/gnit/lucenekmp/store/DataOutput;", "toString", "BinaryDocValuesUpdate", "NumericDocValuesUpdate", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDocValuesUpdate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocValuesUpdate.kt\norg/gnit/lucenekmp/index/DocValuesUpdate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1#2:200\n*E\n"})
public abstract class DocValuesUpdate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DocValuesType type;
    @Nullable
    private final Term term;
    @NotNull
    private final String field;
    private final int docIDUpTo;
    private final boolean hasValue;
    private static final int RAW_SIZE_IN_BYTES = 128;

    protected DocValuesUpdate(@NotNull DocValuesType type, @Nullable Term term, @NotNull String field, int docIDUpTo, boolean hasValue) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if (!(docIDUpTo >= 0)) {
            boolean bl = false;
            String string = docIDUpTo + " must be >= 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.type = type;
        this.term = term;
        this.field = field;
        this.docIDUpTo = docIDUpTo;
        this.hasValue = hasValue;
    }

    @NotNull
    public final DocValuesType getType() {
        return this.type;
    }

    @Nullable
    public final Term getTerm() {
        return this.term;
    }

    @NotNull
    public final String getField() {
        return this.field;
    }

    public final int getDocIDUpTo() {
        return this.docIDUpTo;
    }

    public final boolean getHasValue() {
        return this.hasValue;
    }

    public abstract long valueSizeInBytes();

    public final long sizeInBytes() {
        long sizeInBytes = 128L;
        Term term = this.term;
        Intrinsics.checkNotNull((Object)term);
        sizeInBytes += (long)term.getField().length() * 2L;
        sizeInBytes += (long)this.term.getBytes().getBytes().length;
        sizeInBytes += (long)this.field.length() * 2L;
        sizeInBytes += this.valueSizeInBytes();
        return ++sizeInBytes;
    }

    @NotNull
    public abstract String valueToString();

    public abstract void writeTo(@NotNull DataOutput var1) throws IOException;

    public final boolean hasValue() {
        return this.hasValue;
    }

    @NotNull
    public String toString() {
        return "term=" + this.term + ",field=" + this.field + ",value=" + this.valueToString() + ",docIDUpTo=" + this.docIDUpTo;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B-\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB#\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/index/DocValuesUpdate$BinaryDocValuesUpdate;", "Lorg/gnit/lucenekmp/index/DocValuesUpdate;", "term", "Lorg/gnit/lucenekmp/index/Term;", "field", "", "value", "Lorg/gnit/lucenekmp/util/BytesRef;", "docIDUpTo", "", "<init>", "(Lorg/gnit/lucenekmp/index/Term;Ljava/lang/String;Lorg/gnit/lucenekmp/util/BytesRef;I)V", "(Lorg/gnit/lucenekmp/index/Term;Ljava/lang/String;Lorg/gnit/lucenekmp/util/BytesRef;)V", "prepareForApply", "valueSizeInBytes", "", "valueToString", "getValue", "writeTo", "", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "Companion", "core"})
    @SourceDebugExtension(value={"SMAP\nDocValuesUpdate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocValuesUpdate.kt\norg/gnit/lucenekmp/index/DocValuesUpdate$BinaryDocValuesUpdate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1#2:200\n*E\n"})
    public static final class BinaryDocValuesUpdate
    extends DocValuesUpdate {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final BytesRef value;
        private static final long RAW_VALUE_SIZE_IN_BYTES = 20L;

        private BinaryDocValuesUpdate(Term term, String field, BytesRef value, int docIDUpTo) {
            super(DocValuesType.BINARY, term, field, docIDUpTo, value != null);
            this.value = value;
        }

        public BinaryDocValuesUpdate(@Nullable Term term, @NotNull String field, @NotNull BytesRef value) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this(term, field, value, Integer.MAX_VALUE);
        }

        @NotNull
        public final BinaryDocValuesUpdate prepareForApply(int docIDUpTo) {
            if (docIDUpTo == this.getDocIDUpTo()) {
                return this;
            }
            return new BinaryDocValuesUpdate(this.getTerm(), this.getField(), this.value, docIDUpTo);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long valueSizeInBytes() {
            BytesRef bytesRef = this.value;
            Object object = bytesRef;
            if (bytesRef == null) return 20L;
            byte[] byArray = ((BytesRef)object).getBytes();
            object = byArray;
            if (byArray == null) return 20L;
            int n = ((Object)object).length;
            return 20L + (long)n;
        }

        @Override
        @NotNull
        public String valueToString() {
            return String.valueOf(this.value);
        }

        @Nullable
        public final BytesRef getValue() {
            if (!this.getHasValue()) {
                boolean bl = false;
                String string = "getValue should only be called if this update has a value";
                throw new IllegalArgumentException(string.toString());
            }
            return this.value;
        }

        @Override
        public void writeTo(@NotNull DataOutput out) throws IOException {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            if (!this.getHasValue()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            BytesRef bytesRef = this.value;
            Intrinsics.checkNotNull((Object)bytesRef);
            out.writeVInt(bytesRef.getLength());
            out.writeBytes(this.value.getBytes(), this.value.getOffset(), this.value.getLength());
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/index/DocValuesUpdate$BinaryDocValuesUpdate$Companion;", "", "<init>", "()V", "RAW_VALUE_SIZE_IN_BYTES", "", "readFrom", "Lorg/gnit/lucenekmp/util/BytesRef;", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "scratch", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BytesRef readFrom(@NotNull DataInput in, @NotNull BytesRef scratch) throws IOException {
                Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                Intrinsics.checkNotNullParameter((Object)scratch, (String)"scratch");
                scratch.setLength(in.readVInt());
                if (scratch.getBytes().length < scratch.getLength()) {
                    scratch.setBytes(ArrayUtil.Companion.grow(scratch.getBytes(), scratch.getLength()));
                }
                in.readBytes(scratch.getBytes(), 0, scratch.getLength());
                return scratch;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/index/DocValuesUpdate$Companion;", "", "<init>", "()V", "RAW_SIZE_IN_BYTES", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\b\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0007R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/index/DocValuesUpdate$NumericDocValuesUpdate;", "Lorg/gnit/lucenekmp/index/DocValuesUpdate;", "term", "Lorg/gnit/lucenekmp/index/Term;", "field", "", "value", "", "docIDUpTo", "", "hasValue", "", "<init>", "(Lorg/gnit/lucenekmp/index/Term;Ljava/lang/String;Ljava/lang/Long;IZ)V", "Ljava/lang/Long;", "prepareForApply", "valueSizeInBytes", "valueToString", "writeTo", "", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "getValue", "Companion", "core"})
    @SourceDebugExtension(value={"SMAP\nDocValuesUpdate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocValuesUpdate.kt\norg/gnit/lucenekmp/index/DocValuesUpdate$NumericDocValuesUpdate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1#2:200\n*E\n"})
    public static final class NumericDocValuesUpdate
    extends DocValuesUpdate {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Long value;

        public NumericDocValuesUpdate(@Nullable Term term, @NotNull String field, @Nullable Long value, int docIDUpTo, boolean hasValue) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            super(DocValuesType.NUMERIC, term, field, docIDUpTo, hasValue);
            this.value = value;
        }

        public /* synthetic */ NumericDocValuesUpdate(Term term, String string, Long l, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                l = -1L;
            }
            if ((n2 & 8) != 0) {
                n = Integer.MAX_VALUE;
            }
            if ((n2 & 0x10) != 0) {
                bl = true;
            }
            this(term, string, l, n, bl);
        }

        @NotNull
        public final NumericDocValuesUpdate prepareForApply(int docIDUpTo) {
            if (docIDUpTo == this.getDocIDUpTo()) {
                return this;
            }
            return new NumericDocValuesUpdate(this.getTerm(), this.getField(), this.value, docIDUpTo, this.getHasValue());
        }

        @Override
        public long valueSizeInBytes() {
            return 8L;
        }

        @Override
        @NotNull
        public String valueToString() {
            return this.getHasValue() ? String.valueOf(this.value) : "null";
        }

        @Override
        public void writeTo(@NotNull DataOutput out) throws IOException {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            if (!this.getHasValue()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Long l = this.value;
            Intrinsics.checkNotNull((Object)l);
            out.writeZLong(l);
        }

        public final long getValue() {
            if (!this.getHasValue()) {
                boolean bl = false;
                String string = "getValue should only be called if this update has a value";
                throw new IllegalArgumentException(string.toString());
            }
            Long l = this.value;
            Intrinsics.checkNotNull((Object)l);
            return l;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/index/DocValuesUpdate$NumericDocValuesUpdate$Companion;", "", "<init>", "()V", "readFrom", "", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "core"})
        public static final class Companion {
            private Companion() {
            }

            public final long readFrom(@NotNull DataInput in) throws IOException {
                Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                return in.readZLong();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

