/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.concurrent.atomics.AtomicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.BufferedUpdates;
import org.gnit.lucenekmp.index.DocValuesType;
import org.gnit.lucenekmp.index.DocValuesUpdate;
import org.gnit.lucenekmp.index.FrozenBufferedUpdates;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.jdkport.ReentrantLock;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.store.AlreadyClosedException;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.InfoStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0015\u0018\u0000 a2\u00020\u00012\u00060\u0002j\u0002`\u0003:\bZ[\\]^_`aB/\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0004\b\u000b\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\rJ\u001f\u0010&\u001a\u00020\u00072\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0(\"\u00020)\u00a2\u0006\u0002\u0010*J\u001f\u0010&\u001a\u00020\u00072\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020,0(\"\u00020,\u00a2\u0006\u0002\u0010-J\u001f\u0010.\u001a\u00020\u00072\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u0002000(\"\u000200\u00a2\u0006\u0002\u00101J\u001a\u00102\u001a\u00020\u00072\n\u00103\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u00104\u001a\u00020\u0015J\u0012\u00102\u001a\u00020\u00072\n\u00105\u001a\u0006\u0012\u0002\b\u00030\u0011J\u0006\u00106\u001a\u00020\u0013J\u0006\u00107\u001a\u000208J\u0010\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020\u0015J\b\u0010<\u001a\u0004\u0018\u00010:J\u0016\u0010=\u001a\u0004\u0018\u00010:2\n\u0010>\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002J\u0006\u0010?\u001a\u00020\u0015J\u000e\u0010@\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0015J\u000e\u0010A\u001a\u00020\u00132\u0006\u00104\u001a\u00020\u0015J\b\u0010B\u001a\u000208H\u0002J\b\u0010D\u001a\u000208H\u0016J\u0006\u0010E\u001a\u00020FJ\u0006\u0010G\u001a\u000208J\b\u0010K\u001a\u00020\u0007H\u0016J\b\u0010L\u001a\u00020MH\u0016J\u000e\u0010T\u001a\u0002082\u0006\u0010U\u001a\u00020\u0007J\u000e\u0010X\u001a\u00020\u00002\u0006\u0010Y\u001a\u00020FR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010 \u0012\u0004\b\u001e\u0010\u001fR\u001e\u0010\"\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000fR\u001e\u0010$\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010C\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\bC\u0010%R\u0011\u0010H\u001a\u00020F8F\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\u0017\u0010N\u001a\u00020\u00078F\u00a2\u0006\f\u0012\u0004\bO\u0010\u001f\u001a\u0004\bP\u0010\u000fR\u0017\u0010Q\u001a\u00020\u00078F\u00a2\u0006\f\u0012\u0004\bR\u0010\u001f\u001a\u0004\bS\u0010\u000fR\u0011\u0010V\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\bW\u0010\u000f\u00a8\u0006b"}, d2={"Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue;", "Lorg/gnit/lucenekmp/util/Accountable;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "generation", "", "startSeqNo", "previousMaxSeqId", "Lkotlin/Function0;", "<init>", "(Lorg/gnit/lucenekmp/util/InfoStream;JJLkotlin/jvm/functions/Function0;)V", "(Lorg/gnit/lucenekmp/util/InfoStream;)V", "getGeneration", "()J", "tail", "Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$Node;", "closed", "", "globalSlice", "Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$DeleteSlice;", "globalBufferedUpdates", "Lorg/gnit/lucenekmp/index/BufferedUpdates;", "globalBufferLock", "Lorg/gnit/lucenekmp/jdkport/ReentrantLock;", "getGlobalBufferLock", "()Lorg/gnit/lucenekmp/jdkport/ReentrantLock;", "nextSeqNo", "Lkotlin/concurrent/atomics/AtomicLong;", "getNextSeqNo$annotations", "()V", "Ljava/util/concurrent/atomic/AtomicLong;", "value", "maxSeqNo", "getMaxSeqNo", "isAdvanced", "()Z", "addDelete", "queries", "", "Lorg/gnit/lucenekmp/search/Query;", "([Lorg/gnit/lucenekmp/search/Query;)J", "terms", "Lorg/gnit/lucenekmp/index/Term;", "([Lorg/gnit/lucenekmp/index/Term;)J", "addDocValuesUpdates", "updates", "Lorg/gnit/lucenekmp/index/DocValuesUpdate;", "([Lorg/gnit/lucenekmp/index/DocValuesUpdate;)J", "add", "deleteNode", "slice", "newNode", "anyChanges", "tryApplyGlobalSlice", "", "freezeGlobalBuffer", "Lorg/gnit/lucenekmp/index/FrozenBufferedUpdates;", "callerSlice", "maybeFreezeGlobalBuffer", "freezeGlobalBufferInternal", "currentTail", "newSlice", "updateSlice", "updateSliceNoSeqNo", "ensureOpen", "isOpen", "close", "numGlobalTermDeletes", "", "clear", "bufferedUpdatesTermsSize", "getBufferedUpdatesTermsSize", "()I", "ramBytesUsed", "toString", "", "nextSequenceNumber", "getNextSequenceNumber$annotations", "getNextSequenceNumber", "lastSequenceNumber", "getLastSequenceNumber$annotations", "getLastSequenceNumber", "skipSequenceNumbers", "jump", "maxCompletedSeqNo", "getMaxCompletedSeqNo", "advanceQueue", "maxNumPendingOps", "DeleteSlice", "Node", "TermNode", "QueryNode", "QueryArrayNode", "TermArrayNode", "DocValuesUpdatesNode", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDocumentsWriterDeleteQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentsWriterDeleteQueue.kt\norg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,598:1\n8#2,2:599\n8#2,2:601\n8#2,2:603\n3#2,8:605\n8#2,2:615\n8#2,2:617\n8#2,2:619\n10#3:613\n1#4:614\n*S KotlinDebug\n*F\n+ 1 DocumentsWriterDeleteQueue.kt\norg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue\n*L\n100#1:599,2\n141#1:601,2\n228#1:603,2\n237#1:605,8\n306#1:615,2\n519#1:617,2\n544#1:619,2\n237#1:613\n*E\n"})
public final class DocumentsWriterDeleteQueue
implements Accountable,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InfoStream infoStream;
    private final long generation;
    private final long startSeqNo;
    @NotNull
    private final Function0<Long> previousMaxSeqId;
    @NotNull
    private volatile Node<?> tail;
    private volatile boolean closed;
    @NotNull
    private final DeleteSlice globalSlice;
    @NotNull
    private final BufferedUpdates globalBufferedUpdates;
    @NotNull
    private final ReentrantLock globalBufferLock;
    @NotNull
    private final AtomicLong nextSeqNo;
    private volatile long maxSeqNo;
    private boolean isAdvanced;

    private DocumentsWriterDeleteQueue(InfoStream infoStream, long generation, long startSeqNo, Function0<Long> previousMaxSeqId) {
        this.infoStream = infoStream;
        this.generation = generation;
        this.startSeqNo = startSeqNo;
        this.previousMaxSeqId = previousMaxSeqId;
        this.globalBufferedUpdates = new BufferedUpdates("global");
        this.globalBufferLock = new ReentrantLock();
        this.nextSeqNo = new AtomicLong(this.startSeqNo);
        this.maxSeqNo = Long.MAX_VALUE;
        long value = ((Number)this.previousMaxSeqId.invoke()).longValue();
        boolean condition$iv = value <= this.startSeqNo;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "illegal max sequence ID: " + value + " start was: " + this.startSeqNo;
            throw new AssertionError((Object)string);
        }
        this.tail = new Node<Object>(new Object());
        this.globalSlice = new DeleteSlice(this.tail);
    }

    public final long getGeneration() {
        return this.generation;
    }

    @NotNull
    public final ReentrantLock getGlobalBufferLock() {
        return this.globalBufferLock;
    }

    private static /* synthetic */ void getNextSeqNo$annotations() {
    }

    public final long getMaxSeqNo() {
        return this.maxSeqNo;
    }

    public final boolean isAdvanced() {
        return this.isAdvanced;
    }

    public DocumentsWriterDeleteQueue(@NotNull InfoStream infoStream) {
        Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
        this(infoStream, 0L, 1L, (Function0<Long>)((Function0)DocumentsWriterDeleteQueue::_init_$lambda$0));
    }

    public final long addDelete(Query ... queries2) {
        Intrinsics.checkNotNullParameter((Object)queries2, (String)"queries");
        long seqNo2 = this.add(new QueryArrayNode(queries2));
        this.tryApplyGlobalSlice();
        return seqNo2;
    }

    public final long addDelete(Term ... terms) {
        Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
        long seqNo2 = this.add(new TermArrayNode(terms));
        this.tryApplyGlobalSlice();
        return seqNo2;
    }

    public final long addDocValuesUpdates(DocValuesUpdate ... updates) {
        Intrinsics.checkNotNullParameter((Object)updates, (String)"updates");
        long seqNo2 = this.add(new DocValuesUpdatesNode(Arrays.copyOf(updates, updates.length)));
        this.tryApplyGlobalSlice();
        return seqNo2;
    }

    public final long add(@NotNull Node<?> deleteNode, @NotNull DeleteSlice slice) {
        Intrinsics.checkNotNullParameter(deleteNode, (String)"deleteNode");
        Intrinsics.checkNotNullParameter((Object)slice, (String)"slice");
        long seqNo2 = this.add(deleteNode);
        slice.setSliceTail(deleteNode);
        boolean condition$iv = slice.getSliceHead() != slice.getSliceTail();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "slice head and tail must differ after add";
            throw new AssertionError((Object)string);
        }
        this.tryApplyGlobalSlice();
        return seqNo2;
    }

    public final long add(@NotNull Node<?> newNode) {
        Intrinsics.checkNotNullParameter(newNode, (String)"newNode");
        this.ensureOpen();
        this.tail.setNext(newNode);
        this.tail = newNode;
        return this.getNextSequenceNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean anyChanges() {
        this.globalBufferLock.lock();
        try {
            boolean bl = this.globalBufferedUpdates.any() || !this.globalSlice.isEmpty() || this.globalSlice.getSliceTail() != this.tail || this.tail.getNext() != null;
            return bl;
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tryApplyGlobalSlice() {
        if (this.globalBufferLock.tryLock()) {
            this.ensureOpen();
            try {
                if (this.updateSliceNoSeqNo(this.globalSlice)) {
                    this.globalSlice.apply(this.globalBufferedUpdates, Integer.MAX_VALUE);
                }
            }
            finally {
                this.globalBufferLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final FrozenBufferedUpdates freezeGlobalBuffer(@NotNull DeleteSlice callerSlice) {
        Intrinsics.checkNotNullParameter((Object)callerSlice, (String)"callerSlice");
        this.globalBufferLock.lock();
        try {
            this.ensureOpen();
            Node<?> currentTail = this.tail;
            callerSlice.setSliceTail(currentTail);
            FrozenBufferedUpdates frozenBufferedUpdates = this.freezeGlobalBufferInternal(currentTail);
            return frozenBufferedUpdates;
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final FrozenBufferedUpdates maybeFreezeGlobalBuffer() {
        this.globalBufferLock.lock();
        try {
            if (!this.closed) {
                FrozenBufferedUpdates frozenBufferedUpdates = this.freezeGlobalBufferInternal(this.tail);
                return frozenBufferedUpdates;
            }
            boolean condition$iv = !this.anyChanges();
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "we are closed but have changes";
                throw new AssertionError((Object)string);
            }
            FrozenBufferedUpdates frozenBufferedUpdates = null;
            return frozenBufferedUpdates;
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    private final FrozenBufferedUpdates freezeGlobalBufferInternal(Node<?> currentTail) {
        boolean condition$iv = this.globalBufferLock.isHeldByCurrentThread();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        if (this.globalSlice.getSliceTail() != currentTail) {
            this.globalSlice.setSliceTail(currentTail);
            this.globalSlice.apply(this.globalBufferedUpdates, Integer.MAX_VALUE);
        }
        if (this.globalBufferedUpdates.any()) {
            FrozenBufferedUpdates packet = new FrozenBufferedUpdates(this.infoStream, this.globalBufferedUpdates, null);
            this.globalBufferedUpdates.clear();
            return packet;
        }
        return null;
    }

    @NotNull
    public final DeleteSlice newSlice() {
        return new DeleteSlice(this.tail);
    }

    public final long updateSlice(@NotNull DeleteSlice slice) {
        Intrinsics.checkNotNullParameter((Object)slice, (String)"slice");
        this.ensureOpen();
        long seqNo2 = this.getNextSequenceNumber();
        if (slice.getSliceTail() != this.tail) {
            slice.setSliceTail(this.tail);
            seqNo2 = -seqNo2;
        }
        return seqNo2;
    }

    public final boolean updateSliceNoSeqNo(@NotNull DeleteSlice slice) {
        Intrinsics.checkNotNullParameter((Object)slice, (String)"slice");
        if (slice.getSliceTail() != this.tail) {
            slice.setSliceTail(this.tail);
            return true;
        }
        return false;
    }

    private final void ensureOpen() {
        if (this.closed) {
            throw new AlreadyClosedException("This " + Reflection.getOrCreateKotlinClass(DocumentsWriterDeleteQueue.class).getSimpleName() + " is already closed");
        }
    }

    public final boolean isOpen() {
        return !this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void close() {
        this.globalBufferLock.lock();
        try {
            void condition$iv;
            boolean hasChanges = this.globalBufferedUpdates.any() || !this.globalSlice.isEmpty() || this.globalSlice.getSliceTail() != this.tail || this.tail.getNext() != null;
            if (!(!hasChanges)) {
                boolean bl = false;
                String string = "Can't close queue unless all changes are applied";
                throw new IllegalStateException(string.toString());
            }
            this.closed = true;
            long seqNo2 = this.nextSeqNo.get();
            boolean bl = seqNo2 <= this.maxSeqNo;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && condition$iv == false) {
                boolean bl2 = false;
                String string = "maxSeqNo must be greater or equal to " + seqNo2 + " but was " + this.maxSeqNo;
                throw new AssertionError((Object)string);
            }
            this.nextSeqNo.set(this.maxSeqNo + 1L);
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    public final int numGlobalTermDeletes() {
        return this.globalBufferedUpdates.getDeleteTerms().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        this.globalBufferLock.lock();
        try {
            Node<?> currentTail = this.tail;
            this.globalSlice.setSliceTail(currentTail);
            this.globalSlice.setSliceHead(this.globalSlice.getSliceTail());
            this.globalBufferedUpdates.clear();
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getBufferedUpdatesTermsSize() {
        ReentrantLock lock2 = this.globalBufferLock;
        lock2.lock();
        try {
            Node<?> currentTail = this.tail;
            if (this.globalSlice.getSliceTail() != currentTail) {
                this.globalSlice.setSliceTail(currentTail);
                this.globalSlice.apply(this.globalBufferedUpdates, Integer.MAX_VALUE);
            }
            int n = this.globalBufferedUpdates.getDeleteTerms().size();
            return n;
        }
        finally {
            lock2.unlock();
        }
    }

    @Override
    public long ramBytesUsed() {
        return this.globalBufferedUpdates.ramBytesUsed();
    }

    @NotNull
    public String toString() {
        return "DWDQ: [ generation: " + this.generation + " ]";
    }

    public final long getNextSequenceNumber() {
        long seqNo2 = AtomicsKt.fetchAndIncrement((AtomicLong)this.nextSeqNo);
        boolean condition$iv = seqNo2 <= this.maxSeqNo;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "seqNo=" + seqNo2 + " vs maxSeqNo=" + this.maxSeqNo;
            throw new AssertionError((Object)string);
        }
        return seqNo2;
    }

    public static /* synthetic */ void getNextSequenceNumber$annotations() {
    }

    public final long getLastSequenceNumber() {
        return this.nextSeqNo.get() - 1L;
    }

    public static /* synthetic */ void getLastSequenceNumber$annotations() {
    }

    public final void skipSequenceNumbers(long jump) {
        this.nextSeqNo.addAndGet(jump);
    }

    public final long getMaxCompletedSeqNo() {
        if (this.startSeqNo < this.nextSeqNo.get()) {
            return this.getLastSequenceNumber();
        }
        long value = ((Number)this.previousMaxSeqId.invoke()).longValue();
        boolean condition$iv = value < this.startSeqNo;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "illegal max sequence ID: " + value + " start was: " + this.startSeqNo;
            throw new AssertionError((Object)string);
        }
        return value;
    }

    @NotNull
    public final DocumentsWriterDeleteQueue advanceQueue(int maxNumPendingOps) {
        long seqNo2;
        if (!(!this.isAdvanced)) {
            boolean bl = false;
            String string = "queue was already advanced";
            throw new IllegalStateException(string.toString());
        }
        this.isAdvanced = true;
        this.maxSeqNo = seqNo2 = this.getLastSequenceNumber() + (long)maxNumPendingOps + 1L;
        return new DocumentsWriterDeleteQueue(this.infoStream, this.generation + 1L, seqNo2 + 1L, (Function0<Long>)DocumentsWriterDeleteQueue.Companion.getPrevMaxSeqIdSupplier(this.nextSeqNo));
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    private static final long _init_$lambda$0() {
        return 0L;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\bJ-\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\u00052\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$Companion;", "", "<init>", "()V", "newNode", "Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$Node;", "Lorg/gnit/lucenekmp/index/Term;", "term", "Lorg/gnit/lucenekmp/search/Query;", "query", "", "Lorg/gnit/lucenekmp/index/DocValuesUpdate;", "updates", "([Lorg/gnit/lucenekmp/index/DocValuesUpdate;)Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$Node;", "getPrevMaxSeqIdSupplier", "Lkotlin/Function0;", "", "nextSeqNo", "Lkotlin/concurrent/atomics/AtomicLong;", "(Ljava/util/concurrent/atomic/AtomicLong;)Lkotlin/jvm/functions/Function0;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Node<Term> newNode(@NotNull Term term) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            return new TermNode(term);
        }

        @NotNull
        public final Node<Query> newNode(@NotNull Query query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            return new QueryNode(query);
        }

        @NotNull
        public final Node<DocValuesUpdate[]> newNode(DocValuesUpdate ... updates) {
            Intrinsics.checkNotNullParameter((Object)updates, (String)"updates");
            return new DocValuesUpdatesNode(Arrays.copyOf(updates, updates.length));
        }

        private final Function0<Long> getPrevMaxSeqIdSupplier(AtomicLong nextSeqNo) {
            return () -> Companion.getPrevMaxSeqIdSupplier$lambda$0(nextSeqNo);
        }

        private static final long getPrevMaxSeqIdSupplier$lambda$0(AtomicLong $nextSeqNo) {
            return $nextSeqNo.get() - 1L;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u000eJ\u0012\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0003J\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0001R\u001e\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0005R\u001e\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\u0005R\u0011\u0010\u0019\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$DeleteSlice;", "", "currentTail", "Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$Node;", "<init>", "(Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$Node;)V", "sliceHead", "getSliceHead", "()Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$Node;", "setSliceHead", "sliceTail", "getSliceTail", "setSliceTail", "apply", "", "del", "Lorg/gnit/lucenekmp/index/BufferedUpdates;", "docIDUpto", "", "reset", "isTail", "", "node", "isTailItem", "object", "isEmpty", "()Z", "core"})
    @SourceDebugExtension(value={"SMAP\nDocumentsWriterDeleteQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentsWriterDeleteQueue.kt\norg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$DeleteSlice\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,598:1\n1#2:599\n*E\n"})
    public static final class DeleteSlice {
        @NotNull
        private Node<?> sliceHead;
        @NotNull
        private Node<?> sliceTail;

        public DeleteSlice(@NotNull Node<?> currentTail) {
            Intrinsics.checkNotNullParameter(currentTail, (String)"currentTail");
            this.sliceTail = currentTail;
            this.sliceHead = this.sliceTail;
        }

        @NotNull
        public final Node<?> getSliceHead() {
            return this.sliceHead;
        }

        public final void setSliceHead(@NotNull Node<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"<set-?>");
            this.sliceHead = node;
        }

        @NotNull
        public final Node<?> getSliceTail() {
            return this.sliceTail;
        }

        public final void setSliceTail(@NotNull Node<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"<set-?>");
            this.sliceTail = node;
        }

        public final void apply(@NotNull BufferedUpdates del, int docIDUpto) {
            Intrinsics.checkNotNullParameter((Object)del, (String)"del");
            if (this.sliceHead == this.sliceTail) {
                return;
            }
            Node<?> current = this.sliceHead;
            do {
                Node<?> node = current;
                Intrinsics.checkNotNull(node);
                current = node.getNext();
                if (current == null) {
                    boolean bl = false;
                    String string = "slice property violated between the head on the tail must not be a null node";
                    throw new IllegalStateException(string.toString());
                }
                current.apply(del, docIDUpto);
            } while (current != this.sliceTail);
            this.reset();
        }

        public final void reset() {
            this.sliceHead = this.sliceTail;
        }

        public final boolean isTail(@NotNull Node<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            return this.sliceTail == node;
        }

        public final boolean isTailItem(@NotNull Object object) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"object");
            return this.sliceTail.getItem() == object;
        }

        public final boolean isEmpty() {
            return this.sliceHead == this.sliceTail;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00020\u0001B\u001b\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002\"\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$DocValuesUpdatesNode;", "Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$Node;", "", "Lorg/gnit/lucenekmp/index/DocValuesUpdate;", "updates", "<init>", "([Lorg/gnit/lucenekmp/index/DocValuesUpdate;)V", "apply", "", "bufferedUpdates", "Lorg/gnit/lucenekmp/index/BufferedUpdates;", "docIDUpto", "", "toString", "", "core"})
    private static final class DocValuesUpdatesNode
    extends Node<DocValuesUpdate[]> {
        public DocValuesUpdatesNode(DocValuesUpdate ... updates) {
            Intrinsics.checkNotNullParameter((Object)updates, (String)"updates");
            super(updates);
        }

        @Override
        public void apply(@NotNull BufferedUpdates bufferedUpdates, int docIDUpto) {
            Intrinsics.checkNotNullParameter((Object)bufferedUpdates, (String)"bufferedUpdates");
            block5: for (DocValuesUpdate update : (DocValuesUpdate[])this.getItem()) {
                switch (WhenMappings.$EnumSwitchMapping$0[update.getType().ordinal()]) {
                    case 1: {
                        Intrinsics.checkNotNull((Object)update, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.DocValuesUpdate.NumericDocValuesUpdate");
                        bufferedUpdates.addNumericUpdate((DocValuesUpdate.NumericDocValuesUpdate)update, docIDUpto);
                        continue block5;
                    }
                    case 2: {
                        Intrinsics.checkNotNull((Object)update, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.DocValuesUpdate.BinaryDocValuesUpdate");
                        bufferedUpdates.addBinaryUpdate((DocValuesUpdate.BinaryDocValuesUpdate)update, docIDUpto);
                        continue block5;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        throw new IllegalArgumentException(update.getType() + " DocValues updates not supported yet!");
                    }
                    default: {
                        throw new IllegalArgumentException(update.getType() + " DocValues updates not supported yet!");
                    }
                }
            }
        }

        @NotNull
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("docValuesUpdates: ");
            if (!(((Object[])this.getItem()).length == 0)) {
                sb.append("term=").append(((DocValuesUpdate[])this.getItem())[0].getTerm()).append("; updates: [");
                for (DocValuesUpdate update : (DocValuesUpdate[])this.getItem()) {
                    sb.append(update.getField()).append(':').append(update.valueToString()).append(',');
                }
                sb.setCharAt(sb.length() - 1, ']');
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DocValuesType.values().length];
                try {
                    nArray[DocValuesType.NUMERIC.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DocValuesType.BINARY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DocValuesType.NONE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DocValuesType.SORTED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DocValuesType.SORTED_SET.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DocValuesType.SORTED_NUMERIC.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R \u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$Node;", "T", "", "item", "<init>", "(Ljava/lang/Object;)V", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "next", "getNext", "()Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$Node;", "setNext", "(Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$Node;)V", "apply", "", "bufferedDeletes", "Lorg/gnit/lucenekmp/index/BufferedUpdates;", "docIDUpto", "", "isDelete", "", "()Z", "core"})
    public static class Node<T> {
        private final T item;
        @Nullable
        private volatile Node<?> next;

        public Node(T item) {
            this.item = item;
        }

        public final T getItem() {
            return this.item;
        }

        @Nullable
        public final Node<?> getNext() {
            return this.next;
        }

        public final void setNext(@Nullable Node<?> node) {
            this.next = node;
        }

        public void apply(@NotNull BufferedUpdates bufferedDeletes, int docIDUpto) {
            Intrinsics.checkNotNullParameter((Object)bufferedDeletes, (String)"bufferedDeletes");
            throw new IllegalStateException("sentinel item must never be applied");
        }

        public final boolean isDelete() {
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00020\u0001B\u0017\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$QueryArrayNode;", "Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$Node;", "", "Lorg/gnit/lucenekmp/search/Query;", "query", "<init>", "([Lorg/gnit/lucenekmp/search/Query;)V", "apply", "", "bufferedUpdates", "Lorg/gnit/lucenekmp/index/BufferedUpdates;", "docIDUpto", "", "core"})
    private static final class QueryArrayNode
    extends Node<Query[]> {
        public QueryArrayNode(@NotNull Query[] query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            super(query);
        }

        @Override
        public void apply(@NotNull BufferedUpdates bufferedUpdates, int docIDUpto) {
            Intrinsics.checkNotNullParameter((Object)bufferedUpdates, (String)"bufferedUpdates");
            for (Query query : (Query[])this.getItem()) {
                bufferedUpdates.addQuery(query, docIDUpto);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$QueryNode;", "Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$Node;", "Lorg/gnit/lucenekmp/search/Query;", "query", "<init>", "(Lorg/gnit/lucenekmp/search/Query;)V", "apply", "", "bufferedDeletes", "Lorg/gnit/lucenekmp/index/BufferedUpdates;", "docIDUpto", "", "toString", "", "core"})
    private static final class QueryNode
    extends Node<Query> {
        public QueryNode(@NotNull Query query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            super(query);
        }

        @Override
        public void apply(@NotNull BufferedUpdates bufferedDeletes, int docIDUpto) {
            Intrinsics.checkNotNullParameter((Object)bufferedDeletes, (String)"bufferedDeletes");
            bufferedDeletes.addQuery((Query)this.getItem(), docIDUpto);
        }

        @NotNull
        public String toString() {
            return "del=" + this.getItem();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00020\u0001B\u0017\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$TermArrayNode;", "Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$Node;", "", "Lorg/gnit/lucenekmp/index/Term;", "term", "<init>", "([Lorg/gnit/lucenekmp/index/Term;)V", "apply", "", "bufferedUpdates", "Lorg/gnit/lucenekmp/index/BufferedUpdates;", "docIDUpto", "", "toString", "", "core"})
    private static final class TermArrayNode
    extends Node<Term[]> {
        public TermArrayNode(@NotNull Term[] term) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            super(term);
        }

        @Override
        public void apply(@NotNull BufferedUpdates bufferedUpdates, int docIDUpto) {
            Intrinsics.checkNotNullParameter((Object)bufferedUpdates, (String)"bufferedUpdates");
            for (Term term : (Term[])this.getItem()) {
                bufferedUpdates.addTerm(term, docIDUpto);
            }
        }

        @NotNull
        public String toString() {
            String string = Arrays.toString((Object[])this.getItem());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return "dels=" + string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$TermNode;", "Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$Node;", "Lorg/gnit/lucenekmp/index/Term;", "term", "<init>", "(Lorg/gnit/lucenekmp/index/Term;)V", "apply", "", "bufferedDeletes", "Lorg/gnit/lucenekmp/index/BufferedUpdates;", "docIDUpto", "", "toString", "", "core"})
    private static final class TermNode
    extends Node<Term> {
        public TermNode(@NotNull Term term) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            super(term);
        }

        @Override
        public void apply(@NotNull BufferedUpdates bufferedDeletes, int docIDUpto) {
            Intrinsics.checkNotNullParameter((Object)bufferedDeletes, (String)"bufferedDeletes");
            bufferedDeletes.addTerm((Term)this.getItem(), docIDUpto);
        }

        @NotNull
        public String toString() {
            return "del=" + this.getItem();
        }
    }
}

