/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.gnit.lucenekmp.index.DocValuesSkipIndexType;
import org.gnit.lucenekmp.index.DocValuesType;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.IndexReader;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.VectorEncoding;
import org.gnit.lucenekmp.index.VectorSimilarityFunction;
import org.gnit.lucenekmp.internal.hppc.IntObjectHashMap;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.util.CollectionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010%\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010)\n\u0002\b\u000b\b\u0016\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0007%&'()*+B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\u0006\u0010\u0011\u001a\u00020\bJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!H\u0096\u0002J\u0014\u0010\"\u001a\u0004\u0018\u00010\u00022\b\u0010#\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00022\u0006\u0010$\u001a\u00020\u001fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/gnit/lucenekmp/index/FieldInfos;", "", "Lorg/gnit/lucenekmp/index/FieldInfo;", "infos", "", "<init>", "([Lorg/gnit/lucenekmp/index/FieldInfo;)V", "hasFreq", "", "hasPostings", "hasProx", "hasPayloads", "hasOffsets", "hasTermVectors", "hasNorms", "hasDocValues", "hasPointValues", "hasVectorValues", "softDeletesField", "", "getSoftDeletesField", "()Ljava/lang/String;", "parentField", "getParentField", "byNumber", "[Lorg/gnit/lucenekmp/index/FieldInfo;", "byName", "", "values", "", "size", "", "iterator", "", "fieldInfo", "fieldName", "fieldNumber", "FieldDimensions", "FieldVectorProperties", "IndexOptionsProperties", "FieldProperties", "FieldNumbers", "Builder", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nFieldInfos.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldInfos.kt\norg/gnit/lucenekmp/index/FieldInfos\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,799:1\n1#2:800\n*E\n"})
public class FieldInfos
implements Iterable<FieldInfo>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasFreq;
    private final boolean hasPostings;
    private final boolean hasProx;
    private final boolean hasPayloads;
    private final boolean hasOffsets;
    private final boolean hasTermVectors;
    private final boolean hasNorms;
    private final boolean hasDocValues;
    private final boolean hasPointValues;
    private final boolean hasVectorValues;
    @Nullable
    private final String softDeletesField;
    @Nullable
    private final String parentField;
    @NotNull
    private final FieldInfo[] byNumber;
    @NotNull
    private final Map<String, FieldInfo> byName;
    @NotNull
    private Collection<FieldInfo> values;
    @NotNull
    private static final FieldInfos EMPTY = new FieldInfos(new FieldInfo[0]);

    public FieldInfos(@NotNull FieldInfo[] infos) {
        int n;
        Intrinsics.checkNotNullParameter((Object)infos, (String)"infos");
        this.values = new ArrayList();
        boolean hasTermVectors = false;
        boolean hasPostings = false;
        boolean hasProx = false;
        boolean hasPayloads = false;
        boolean hasOffsets = false;
        boolean hasFreq = false;
        boolean hasNorms = false;
        boolean hasDocValues = false;
        boolean hasPointValues = false;
        boolean hasVectorValues = false;
        String softDeletesField = null;
        String parentField = null;
        this.byName = CollectionUtil.INSTANCE.newHashMap(infos.length);
        int maxFieldNumber = -1;
        boolean fieldNumberStrictlyAscending = true;
        int n2 = infos.length;
        for (n = 0; n < n2; ++n) {
            FieldInfo info = infos[n];
            int fieldNumber = info.getNumber();
            if (!(fieldNumber >= 0)) {
                boolean $i$a$-require-FieldInfos$62 = false;
                String $i$a$-require-FieldInfos$62 = "illegal field number: " + info.getNumber() + " for field " + info.getName();
                throw new IllegalArgumentException($i$a$-require-FieldInfos$62.toString());
            }
            if (maxFieldNumber < fieldNumber) {
                maxFieldNumber = fieldNumber;
            } else {
                fieldNumberStrictlyAscending = false;
            }
            FieldInfo previous = this.byName.put(info.getName(), info);
            if (!(previous == null)) {
                boolean $i$a$-require-FieldInfos$72 = false;
                FieldInfo fieldInfo = previous;
                Intrinsics.checkNotNull((Object)fieldInfo);
                String $i$a$-require-FieldInfos$72 = "duplicate field names: " + fieldInfo.getNumber() + " and " + info.getNumber() + " have: " + info.getName();
                throw new IllegalArgumentException($i$a$-require-FieldInfos$72.toString());
            }
            hasTermVectors |= info.hasTermVectors();
            hasPostings |= info.getIndexOptions() != IndexOptions.NONE;
            hasProx |= info.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            hasFreq |= info.getIndexOptions() != IndexOptions.DOCS;
            hasOffsets |= info.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            hasNorms |= info.hasNorms();
            hasDocValues |= info.getDocValuesType() != DocValuesType.NONE;
            hasPayloads |= info.hasPayloads();
            hasPointValues |= info.getPointDimensionCount() != 0;
            hasVectorValues |= info.getVectorDimension() != 0;
            if (info.isSoftDeletesField()) {
                if (!(softDeletesField == null || Intrinsics.areEqual(softDeletesField, (Object)info.getName()))) {
                    boolean $i$a$-require-FieldInfos$82 = false;
                    String $i$a$-require-FieldInfos$82 = "multiple soft-deletes fields [" + info.getName() + ", " + softDeletesField + "]";
                    throw new IllegalArgumentException($i$a$-require-FieldInfos$82.toString());
                }
                softDeletesField = info.getName();
            }
            if (!info.isParentField()) continue;
            if (!(parentField == null || Intrinsics.areEqual(parentField, (Object)info.getName()))) {
                boolean bl = false;
                String string = "multiple parent fields [" + info.getName() + ", " + parentField + "]";
                throw new IllegalArgumentException(string.toString());
            }
            parentField = info.getName();
        }
        this.hasTermVectors = hasTermVectors;
        this.hasPostings = hasPostings;
        this.hasProx = hasProx;
        this.hasPayloads = hasPayloads;
        this.hasOffsets = hasOffsets;
        this.hasFreq = hasFreq;
        this.hasNorms = hasNorms;
        this.hasDocValues = hasDocValues;
        this.hasPointValues = hasPointValues;
        this.hasVectorValues = hasVectorValues;
        this.softDeletesField = softDeletesField;
        this.parentField = parentField;
        if (fieldNumberStrictlyAscending && maxFieldNumber == infos.length - 1) {
            FieldInfo[] fieldInfoArray = this.byNumber = infos;
            this.values = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(fieldInfoArray, fieldInfoArray.length));
        } else {
            this.byNumber = new FieldInfo[maxFieldNumber + 1];
            n2 = infos.length;
            for (n = 0; n < n2; ++n) {
                FieldInfo fieldInfo = infos[n];
                FieldInfo existing = this.byNumber[fieldInfo.getNumber()];
                if (!(existing == null)) {
                    boolean bl = false;
                    String string = "duplicate field numbers: " + existing.getName() + " and " + fieldInfo.getName() + " have: " + fieldInfo.getNumber();
                    throw new IllegalArgumentException(string.toString());
                }
                this.byNumber[fieldInfo.getNumber()] = fieldInfo;
            }
            if (maxFieldNumber == infos.length - 1) {
                FieldInfo[] fieldInfoArray = this.byNumber;
                this.values = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(fieldInfoArray, fieldInfoArray.length));
            } else {
                if (!fieldNumberStrictlyAscending) {
                    org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.sort(infos, FieldInfos::_init_$lambda$5);
                }
                this.values = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(infos, infos.length));
            }
        }
    }

    @Nullable
    public final String getSoftDeletesField() {
        return this.softDeletesField;
    }

    @Nullable
    public final String getParentField() {
        return this.parentField;
    }

    public boolean hasFreq() {
        return this.hasFreq;
    }

    public boolean hasPostings() {
        return this.hasPostings;
    }

    public boolean hasProx() {
        return this.hasProx;
    }

    public boolean hasPayloads() {
        return this.hasPayloads;
    }

    public boolean hasOffsets() {
        return this.hasOffsets;
    }

    public boolean hasTermVectors() {
        return this.hasTermVectors;
    }

    public boolean hasNorms() {
        return this.hasNorms;
    }

    public boolean hasDocValues() {
        return this.hasDocValues;
    }

    public boolean hasPointValues() {
        return this.hasPointValues;
    }

    public final boolean hasVectorValues() {
        return this.hasVectorValues;
    }

    public int size() {
        return this.byName.size();
    }

    @Override
    @NotNull
    public Iterator<FieldInfo> iterator() {
        return this.values.iterator();
    }

    @Nullable
    public FieldInfo fieldInfo(@Nullable String fieldName) {
        return this.byName.get(fieldName);
    }

    @Nullable
    public FieldInfo fieldInfo(int fieldNumber) {
        if (!(fieldNumber >= 0)) {
            boolean bl = false;
            String string = "Illegal field number: " + fieldNumber;
            throw new IllegalArgumentException(string.toString());
        }
        return fieldNumber >= this.byNumber.length ? null : this.byNumber[fieldNumber];
    }

    private static final int _init_$lambda$5(FieldInfo fi1, FieldInfo fi2) {
        Intrinsics.checkNotNullParameter((Object)fi1, (String)"fi1");
        Intrinsics.checkNotNullParameter((Object)fi2, (String)"fi2");
        return IntExtKt.compare(IntCompanionObject.INSTANCE, fi1.getNumber(), fi2.getNumber());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tJ\u0016\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\bJ\b\u0010\u0019\u001a\u00020\rH\u0002J\u0006\u0010\u001a\u001a\u00020\u001bR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/index/FieldInfos$Builder;", "", "globalFieldNumbers", "Lorg/gnit/lucenekmp/index/FieldInfos$FieldNumbers;", "<init>", "(Lorg/gnit/lucenekmp/index/FieldInfos$FieldNumbers;)V", "byName", "", "", "Lorg/gnit/lucenekmp/index/FieldInfo;", "getGlobalFieldNumbers", "()Lorg/gnit/lucenekmp/index/FieldInfos$FieldNumbers;", "finished", "", "softDeletesFieldName", "getSoftDeletesFieldName", "()Ljava/lang/String;", "parentFieldName", "getParentFieldName", "add", "fi", "dvGen", "", "fieldInfo", "fieldName", "assertNotFinished", "finish", "Lorg/gnit/lucenekmp/index/FieldInfos;", "core"})
    @SourceDebugExtension(value={"SMAP\nFieldInfos.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldInfos.kt\norg/gnit/lucenekmp/index/FieldInfos$Builder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,799:1\n216#2,2:800\n1#3:802\n37#4:803\n36#4,3:804\n*S KotlinDebug\n*F\n+ 1 FieldInfos.kt\norg/gnit/lucenekmp/index/FieldInfos$Builder\n*L\n670#1:800,2\n724#1:803\n724#1:804,3\n*E\n"})
    public static final class Builder {
        @NotNull
        private final Map<String, FieldInfo> byName;
        @NotNull
        private final FieldNumbers globalFieldNumbers;
        private boolean finished;

        public Builder(@NotNull FieldNumbers globalFieldNumbers) {
            Intrinsics.checkNotNullParameter((Object)globalFieldNumbers, (String)"globalFieldNumbers");
            this.byName = new LinkedHashMap();
            this.globalFieldNumbers = globalFieldNumbers;
        }

        @NotNull
        public final FieldNumbers getGlobalFieldNumbers() {
            return this.globalFieldNumbers;
        }

        @Nullable
        public final String getSoftDeletesFieldName() {
            return this.globalFieldNumbers.getSoftDeletesFieldName$core();
        }

        @Nullable
        public final String getParentFieldName() {
            return this.globalFieldNumbers.getParentFieldName$core();
        }

        @NotNull
        public final FieldInfo add(@NotNull FieldInfo fi) {
            Intrinsics.checkNotNullParameter((Object)fi, (String)"fi");
            return this.add(fi, -1L);
        }

        @NotNull
        public final FieldInfo add(@NotNull FieldInfo fi, long dvGen) {
            Intrinsics.checkNotNullParameter((Object)fi, (String)"fi");
            FieldInfo curFi = this.fieldInfo(fi.getName());
            Map<String, String> attributes = fi.attributes();
            if (curFi != null) {
                curFi.verifySameSchema(fi);
                if (attributes != null) {
                    Map<String, String> $this$forEach$iv = attributes;
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<String, String> element$iv;
                        Map.Entry<String, String> entry = element$iv = iterator2.next();
                        boolean bl = false;
                        String key = entry.getKey();
                        String value = entry.getValue();
                        curFi.putAttribute(key, value);
                    }
                }
                if (fi.hasPayloads()) {
                    curFi.setStorePayloads();
                }
                return curFi;
            }
            if (!this.assertNotFinished()) {
                String $i$f$forEach = "Failed requirement.";
                throw new IllegalArgumentException($i$f$forEach.toString());
            }
            int fieldNumber = this.globalFieldNumbers.addOrGet(fi);
            FieldInfo fiNew = new FieldInfo(fi.getName(), fieldNumber, fi.hasTermVectors(), fi.omitsNorms(), fi.hasPayloads(), fi.getIndexOptions(), fi.getDocValuesType(), fi.docValuesSkipIndexType(), dvGen, attributes, fi.getPointDimensionCount(), fi.getPointIndexDimensionCount(), fi.getPointNumBytes(), fi.getVectorDimension(), fi.getVectorEncoding(), fi.getVectorSimilarityFunction(), fi.isSoftDeletesField(), fi.isParentField());
            this.byName.put(fiNew.getName(), fiNew);
            return fiNew;
        }

        @Nullable
        public final FieldInfo fieldInfo(@NotNull String fieldName) {
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            return this.byName.get(fieldName);
        }

        private final boolean assertNotFinished() {
            if (!(!this.finished)) {
                boolean bl = false;
                String string = "FieldInfos.Builder was already finished; cannot add new fields";
                throw new IllegalStateException(string.toString());
            }
            return true;
        }

        @NotNull
        public final FieldInfos finish() {
            this.finished = true;
            Collection<FieldInfo> $this$toTypedArray$iv = this.byName.values();
            boolean $i$f$toTypedArray = false;
            Collection<FieldInfo> thisCollection$iv = $this$toTypedArray$iv;
            return new FieldInfos(thisCollection$iv.toArray(new FieldInfo[0]));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/index/FieldInfos$Companion;", "", "<init>", "()V", "EMPTY", "Lorg/gnit/lucenekmp/index/FieldInfos;", "getEMPTY", "()Lorg/gnit/lucenekmp/index/FieldInfos;", "getMergedFieldInfos", "reader", "Lorg/gnit/lucenekmp/index/IndexReader;", "getAndValidateParentField", "", "leaves", "", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "getIndexedFields", "", "core"})
    @SourceDebugExtension(value={"SMAP\nFieldInfos.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldInfos.kt\norg/gnit/lucenekmp/index/FieldInfos$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,799:1\n1#2:800\n1374#3:801\n1460#3,2:802\n774#3:804\n865#3,2:805\n1462#3,3:807\n1563#3:810\n1634#3,3:811\n*S KotlinDebug\n*F\n+ 1 FieldInfos.kt\norg/gnit/lucenekmp/index/FieldInfos$Companion\n*L\n790#1:801\n790#1:802,2\n792#1:804\n792#1:805,2\n790#1:807,3\n794#1:810\n794#1:811,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FieldInfos getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final FieldInfos getMergedFieldInfos(@NotNull IndexReader reader2) {
            String string;
            List<LeafReaderContext> leaves;
            block5: {
                Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
                leaves = reader2.leaves();
                if (leaves.isEmpty()) {
                    return this.getEMPTY();
                }
                if (leaves.size() == 1) {
                    return leaves.get(0).reader().getFieldInfos();
                }
                for (LeafReaderContext l : (Iterable)leaves) {
                    boolean bl = false;
                    String string2 = l.reader().getFieldInfos().getSoftDeletesField();
                    if (string2 == null) continue;
                    string = string2;
                    break block5;
                }
                string = null;
            }
            String softDeletesField = string;
            String parentField = this.getAndValidateParentField(leaves);
            Builder builder = new Builder(new FieldNumbers(softDeletesField, parentField));
            for (LeafReaderContext ctx : leaves) {
                for (FieldInfo fieldInfo : ctx.reader().getFieldInfos()) {
                    builder.add(fieldInfo);
                }
            }
            return builder.finish();
        }

        private final String getAndValidateParentField(List<LeafReaderContext> leaves) {
            boolean set = false;
            String theField = null;
            for (LeafReaderContext ctx : leaves) {
                String field = ctx.reader().getFieldInfos().getParentField();
                if (!(!set || Intrinsics.areEqual((Object)field, theField))) {
                    boolean bl = false;
                    String string = "expected parent doc field to be \"" + theField + " \" across all segments but found a segment with different field \"" + field + "\"";
                    throw new IllegalStateException(string.toString());
                }
                theField = field;
                set = true;
            }
            return theField;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<String> getIndexedFields(@NotNull IndexReader reader2) {
            void $this$mapTo$iv$iv;
            Object list$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            Iterable $this$flatMap$iv = reader2.leaves();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                LeafReaderContext leaf = (LeafReaderContext)element$iv$iv;
                boolean bl = false;
                Iterable iterable2 = leaf.reader().getFieldInfos();
                boolean $i$f$filter = false;
                void var13_13 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    FieldInfo fi = (FieldInfo)element$iv$iv2;
                    boolean bl2 = false;
                    if (!(fi.getIndexOptions() != IndexOptions.NONE)) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void fi;
                list$iv$iv = (FieldInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(fi.getName());
            }
            return CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/index/FieldInfos$FieldDimensions;", "", "dimensionCount", "", "indexDimensionCount", "dimensionNumBytes", "<init>", "(III)V", "getDimensionCount", "()I", "getIndexDimensionCount", "getDimensionNumBytes", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "core"})
    private static final class FieldDimensions {
        private final int dimensionCount;
        private final int indexDimensionCount;
        private final int dimensionNumBytes;

        public FieldDimensions(int dimensionCount, int indexDimensionCount, int dimensionNumBytes) {
            this.dimensionCount = dimensionCount;
            this.indexDimensionCount = indexDimensionCount;
            this.dimensionNumBytes = dimensionNumBytes;
        }

        public final int getDimensionCount() {
            return this.dimensionCount;
        }

        public final int getIndexDimensionCount() {
            return this.indexDimensionCount;
        }

        public final int getDimensionNumBytes() {
            return this.dimensionNumBytes;
        }

        public final int component1() {
            return this.dimensionCount;
        }

        public final int component2() {
            return this.indexDimensionCount;
        }

        public final int component3() {
            return this.dimensionNumBytes;
        }

        @NotNull
        public final FieldDimensions copy(int dimensionCount, int indexDimensionCount, int dimensionNumBytes) {
            return new FieldDimensions(dimensionCount, indexDimensionCount, dimensionNumBytes);
        }

        public static /* synthetic */ FieldDimensions copy$default(FieldDimensions fieldDimensions, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = fieldDimensions.dimensionCount;
            }
            if ((n4 & 2) != 0) {
                n2 = fieldDimensions.indexDimensionCount;
            }
            if ((n4 & 4) != 0) {
                n3 = fieldDimensions.dimensionNumBytes;
            }
            return fieldDimensions.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "FieldDimensions(dimensionCount=" + this.dimensionCount + ", indexDimensionCount=" + this.indexDimensionCount + ", dimensionNumBytes=" + this.dimensionNumBytes + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.dimensionCount);
            result = result * 31 + Integer.hashCode(this.indexDimensionCount);
            result = result * 31 + Integer.hashCode(this.dimensionNumBytes);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FieldDimensions)) {
                return false;
            }
            FieldDimensions fieldDimensions = (FieldDimensions)other;
            if (this.dimensionCount != fieldDimensions.dimensionCount) {
                return false;
            }
            if (this.indexDimensionCount != fieldDimensions.indexDimensionCount) {
                return false;
            }
            return this.dimensionNumBytes == fieldDimensions.dimensionNumBytes;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019J \u0010!\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\rJ\u0006\u0010'\u001a\u00020\u0012R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lorg/gnit/lucenekmp/index/FieldInfos$FieldNumbers;", "", "softDeletesFieldName", "", "parentFieldName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "numberToName", "Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;", "fieldProperties", "", "Lorg/gnit/lucenekmp/index/FieldInfos$FieldProperties;", "lowestUnassignedFieldNumber", "", "getSoftDeletesFieldName$core", "()Ljava/lang/String;", "getParentFieldName$core", "verifyFieldInfo", "", "fi", "Lorg/gnit/lucenekmp/index/FieldInfo;", "addOrGet", "verifySoftDeletedFieldName", "fieldName", "isSoftDeletesField", "", "verifyParentFieldName", "isParentField", "verifySameSchema", "verifyOrCreateDvOnlyField", "dvType", "Lorg/gnit/lucenekmp/index/DocValuesType;", "fieldMustExist", "constructFieldInfo", "newFieldNumber", "fieldNames", "", "getFieldNames", "()Ljava/util/Set;", "clear", "core"})
    public static final class FieldNumbers {
        @NotNull
        private final IntObjectHashMap<String> numberToName = new IntObjectHashMap();
        @NotNull
        private final Map<String, FieldProperties> fieldProperties = new LinkedHashMap();
        private int lowestUnassignedFieldNumber = -1;
        @Nullable
        private final String softDeletesFieldName;
        @Nullable
        private final String parentFieldName;

        public FieldNumbers(@Nullable String softDeletesFieldName, @Nullable String parentFieldName) {
            this.softDeletesFieldName = softDeletesFieldName;
            this.parentFieldName = parentFieldName;
            if (!(softDeletesFieldName == null || parentFieldName == null || !Intrinsics.areEqual((Object)parentFieldName, (Object)softDeletesFieldName))) {
                boolean bl = false;
                String string = "parent document and soft-deletes field can't be the same field \"" + parentFieldName + "\"";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @Nullable
        public final String getSoftDeletesFieldName$core() {
            return this.softDeletesFieldName;
        }

        @Nullable
        public final String getParentFieldName$core() {
            return this.parentFieldName;
        }

        public final void verifyFieldInfo(@NotNull FieldInfo fi) {
            Intrinsics.checkNotNullParameter((Object)fi, (String)"fi");
            String fieldName = fi.getName();
            this.verifySoftDeletedFieldName(fieldName, fi.isSoftDeletesField());
            this.verifyParentFieldName(fieldName, fi.isParentField());
            if (this.fieldProperties.containsKey(fieldName)) {
                this.verifySameSchema(fi);
            }
        }

        public final int addOrGet(@NotNull FieldInfo fi) {
            Intrinsics.checkNotNullParameter((Object)fi, (String)"fi");
            String fieldName = fi.getName();
            this.verifySoftDeletedFieldName(fieldName, fi.isSoftDeletesField());
            this.verifyParentFieldName(fieldName, fi.isParentField());
            FieldProperties fieldProperties = this.fieldProperties.get(fieldName);
            if (fieldProperties != null) {
                this.verifySameSchema(fi);
            } else {
                int fieldNumber = 0;
                if (fi.getNumber() != -1 && !this.numberToName.containsKey(fi.getNumber())) {
                    fieldNumber = fi.getNumber();
                } else {
                    do {
                        ++this.lowestUnassignedFieldNumber;
                    } while (this.numberToName.containsKey(this.lowestUnassignedFieldNumber));
                    fieldNumber = this.lowestUnassignedFieldNumber;
                }
                if (!(fieldNumber >= 0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                this.numberToName.put(fieldNumber, fieldName);
                fieldProperties = new FieldProperties(fieldNumber, fi.getIndexOptions(), fi.getIndexOptions() != IndexOptions.NONE ? new IndexOptionsProperties(fi.hasTermVectors(), fi.omitsNorms()) : null, fi.getDocValuesType(), fi.docValuesSkipIndexType(), new FieldDimensions(fi.getPointDimensionCount(), fi.getPointIndexDimensionCount(), fi.getPointNumBytes()), new FieldVectorProperties(fi.getVectorDimension(), fi.getVectorEncoding(), fi.getVectorSimilarityFunction()));
                this.fieldProperties.put(fieldName, fieldProperties);
            }
            return fieldProperties.getNumber();
        }

        private final void verifySoftDeletedFieldName(String fieldName, boolean isSoftDeletesField) {
            if (isSoftDeletesField) {
                if (!(this.softDeletesFieldName != null)) {
                    boolean $i$a$-require-FieldInfos$FieldNumbers$verifySoftDeletedFieldName$42 = false;
                    String $i$a$-require-FieldInfos$FieldNumbers$verifySoftDeletedFieldName$42 = "this index has [" + fieldName + "] as soft-deletes already but soft-deletes field is not configured in IWC";
                    throw new IllegalArgumentException($i$a$-require-FieldInfos$FieldNumbers$verifySoftDeletedFieldName$42.toString());
                }
                if (!Intrinsics.areEqual((Object)fieldName, (Object)this.softDeletesFieldName)) {
                    boolean $i$a$-require-FieldInfos$FieldNumbers$verifySoftDeletedFieldName$52 = false;
                    String $i$a$-require-FieldInfos$FieldNumbers$verifySoftDeletedFieldName$52 = "cannot configure [" + this.softDeletesFieldName + "] as soft-deletes; this index uses [" + fieldName + "] as soft-deletes already";
                    throw new IllegalArgumentException($i$a$-require-FieldInfos$FieldNumbers$verifySoftDeletedFieldName$52.toString());
                }
            } else if (!(!Intrinsics.areEqual((Object)fieldName, (Object)this.softDeletesFieldName))) {
                boolean bl = false;
                String string = "cannot configure [" + this.softDeletesFieldName + "] as soft-deletes; this index uses [" + fieldName + "] as non-soft-deletes already";
                throw new IllegalArgumentException(string.toString());
            }
        }

        private final void verifyParentFieldName(String fieldName, boolean isParentField) {
            if (isParentField) {
                if (this.parentFieldName != null) {
                    // empty if block
                }
                if (!Intrinsics.areEqual((Object)fieldName, (Object)this.parentFieldName)) {
                    boolean $i$a$-require-FieldInfos$FieldNumbers$verifyParentFieldName$42 = false;
                    String $i$a$-require-FieldInfos$FieldNumbers$verifyParentFieldName$42 = "can't add field [" + fieldName + "] as parent document field; this IndexWriter is configured with [" + this.parentFieldName + "] as parent document field";
                    throw new IllegalArgumentException($i$a$-require-FieldInfos$FieldNumbers$verifyParentFieldName$42.toString());
                }
            } else if (!(!Intrinsics.areEqual((Object)fieldName, (Object)this.parentFieldName))) {
                boolean bl = false;
                String string = "can't add [" + fieldName + "] as non parent document field; this IndexWriter is configured with [" + this.parentFieldName + "] as parent document field";
                throw new IllegalArgumentException(string.toString());
            }
        }

        private final void verifySameSchema(FieldInfo fi) {
            String fieldName = fi.getName();
            FieldProperties fieldProperties = this.fieldProperties.get(fieldName);
            Intrinsics.checkNotNull((Object)fieldProperties);
            FieldProperties fieldProperties2 = fieldProperties;
            IndexOptions currentOpts = fieldProperties2.getIndexOptions();
            FieldInfo.Companion.verifySameIndexOptions(fieldName, currentOpts, fi.getIndexOptions());
            if (currentOpts != IndexOptions.NONE) {
                IndexOptionsProperties indexOptionsProperties = fieldProperties2.getIndexOptionsProperties();
                Intrinsics.checkNotNull((Object)indexOptionsProperties);
                boolean curStoreTermVector = indexOptionsProperties.getStoreTermVectors();
                FieldInfo.Companion.verifySameStoreTermVectors(fieldName, curStoreTermVector, fi.hasTermVectors());
                boolean curOmitNorms = fieldProperties2.getIndexOptionsProperties().getOmitNorms();
                FieldInfo.Companion.verifySameOmitNorms(fieldName, curOmitNorms, fi.omitsNorms());
            }
            DocValuesType currentDVType = fieldProperties2.getDocValuesType();
            FieldInfo.Companion.verifySameDocValuesType(fieldName, currentDVType, fi.getDocValuesType());
            DocValuesSkipIndexType currentDocValuesSkipIndex = fieldProperties2.getDocValuesSkipIndex();
            FieldInfo.Companion.verifySameDocValuesSkipIndex(fieldName, currentDocValuesSkipIndex, fi.docValuesSkipIndexType());
            FieldDimensions dims = fieldProperties2.getFieldDimensions();
            FieldInfo.Companion.verifySamePointsOptions(fieldName, dims.getDimensionCount(), dims.getIndexDimensionCount(), dims.getDimensionNumBytes(), fi.getPointDimensionCount(), fi.getPointIndexDimensionCount(), fi.getPointNumBytes());
            FieldVectorProperties props = fieldProperties2.getFieldVectorProperties();
            FieldInfo.Companion.verifySameVectorOptions(fieldName, props.getNumDimensions(), props.getVectorEncoding(), props.getSimilarityFunction(), fi.getVectorDimension(), fi.getVectorEncoding(), fi.getVectorSimilarityFunction());
        }

        public final void verifyOrCreateDvOnlyField(@NotNull String fieldName, @NotNull DocValuesType dvType, boolean fieldMustExist) {
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            Intrinsics.checkNotNullParameter((Object)((Object)dvType), (String)"dvType");
            if (!this.fieldProperties.containsKey(fieldName)) {
                if (!(!fieldMustExist)) {
                    boolean $i$a$-require-FieldInfos$FieldNumbers$verifyOrCreateDvOnlyField$72 = false;
                    String $i$a$-require-FieldInfos$FieldNumbers$verifyOrCreateDvOnlyField$72 = "Can't update [" + dvType + "] doc values; the field [" + fieldName + "] doesn't exist.";
                    throw new IllegalArgumentException($i$a$-require-FieldInfos$FieldNumbers$verifyOrCreateDvOnlyField$72.toString());
                }
                FieldInfo fi = new FieldInfo(fieldName, -1, false, false, false, IndexOptions.NONE, dvType, DocValuesSkipIndexType.NONE, -1L, new LinkedHashMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, this.softDeletesFieldName != null && Intrinsics.areEqual((Object)this.softDeletesFieldName, (Object)fieldName), this.parentFieldName != null && Intrinsics.areEqual((Object)this.parentFieldName, (Object)fieldName));
                this.addOrGet(fi);
            } else {
                FieldProperties fieldProperties = this.fieldProperties.get(fieldName);
                Intrinsics.checkNotNull((Object)fieldProperties);
                FieldProperties fieldProperties2 = fieldProperties;
                DocValuesType fieldDvType = fieldProperties2.getDocValuesType();
                if (!(dvType == fieldDvType)) {
                    boolean $i$a$-require-FieldInfos$FieldNumbers$verifyOrCreateDvOnlyField$82 = false;
                    String $i$a$-require-FieldInfos$FieldNumbers$verifyOrCreateDvOnlyField$82 = "Can't update [" + dvType + "] doc values; the field [" + fieldName + "] has inconsistent doc values' type of [" + fieldDvType + "].";
                    throw new IllegalArgumentException($i$a$-require-FieldInfos$FieldNumbers$verifyOrCreateDvOnlyField$82.toString());
                }
                DocValuesSkipIndexType hasDocValuesSkipIndex = fieldProperties2.getDocValuesSkipIndex();
                if (!(hasDocValuesSkipIndex == DocValuesSkipIndexType.NONE)) {
                    boolean $i$a$-require-FieldInfos$FieldNumbers$verifyOrCreateDvOnlyField$92 = false;
                    String $i$a$-require-FieldInfos$FieldNumbers$verifyOrCreateDvOnlyField$92 = "Can't update [" + dvType + "] doc values; the field [" + fieldName + "] must be doc values only field, bit it has doc values skip index";
                    throw new IllegalArgumentException($i$a$-require-FieldInfos$FieldNumbers$verifyOrCreateDvOnlyField$92.toString());
                }
                FieldDimensions fdimensions = fieldProperties2.getFieldDimensions();
                if (!(fdimensions == null || fdimensions.getDimensionCount() == 0)) {
                    boolean $i$a$-require-FieldInfos$FieldNumbers$verifyOrCreateDvOnlyField$102 = false;
                    String $i$a$-require-FieldInfos$FieldNumbers$verifyOrCreateDvOnlyField$102 = "Can't update [" + dvType + "] doc values; the field [" + fieldName + "] must be doc values only field, but is also indexed with points.";
                    throw new IllegalArgumentException($i$a$-require-FieldInfos$FieldNumbers$verifyOrCreateDvOnlyField$102.toString());
                }
                IndexOptions ioptions = fieldProperties2.getIndexOptions();
                if (!(ioptions == null || ioptions == IndexOptions.NONE)) {
                    boolean bl = false;
                    String string = "Can't update [" + dvType + "] doc values; the field [" + fieldName + "] must be doc values only field, but is also indexed with postings.";
                    throw new IllegalArgumentException(string.toString());
                }
                FieldVectorProperties fvp = fieldProperties2.getFieldVectorProperties();
                if (!(fvp == null || fvp.getNumDimensions() == 0)) {
                    boolean bl = false;
                    String string = "Can't update [" + dvType + "] doc values; the field [" + fieldName + "] must be doc values only field, but is also indexed with vectors.";
                    throw new IllegalArgumentException(string.toString());
                }
            }
        }

        @Nullable
        public final FieldInfo constructFieldInfo(@NotNull String fieldName, @NotNull DocValuesType dvType, int newFieldNumber) {
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            Intrinsics.checkNotNullParameter((Object)((Object)dvType), (String)"dvType");
            FieldProperties fieldProperties = this.fieldProperties.get(fieldName);
            if (fieldProperties == null) {
                return null;
            }
            DocValuesType dvType0 = fieldProperties.getDocValuesType();
            if (dvType != dvType0) {
                return null;
            }
            boolean isSoftDeletesField = Intrinsics.areEqual((Object)fieldName, (Object)this.softDeletesFieldName);
            boolean isParentField = Intrinsics.areEqual((Object)fieldName, (Object)this.parentFieldName);
            return new FieldInfo(fieldName, newFieldNumber, false, false, false, IndexOptions.NONE, dvType, DocValuesSkipIndexType.NONE, -1L, new LinkedHashMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, isSoftDeletesField, isParentField);
        }

        @NotNull
        public final Set<String> getFieldNames() {
            return this.fieldProperties.keySet();
        }

        public final void clear() {
            this.numberToName.clear();
            this.fieldProperties.clear();
            this.lowestUnassignedFieldNumber = -1;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\tH\u00c6\u0003J\t\u0010$\u001a\u00020\u000bH\u00c6\u0003J\t\u0010%\u001a\u00020\rH\u00c6\u0003J\t\u0010&\u001a\u00020\u000fH\u00c6\u0003JQ\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020\u0003H\u00d6\u0001J\t\u0010,\u001a\u00020-H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006."}, d2={"Lorg/gnit/lucenekmp/index/FieldInfos$FieldProperties;", "", "number", "", "indexOptions", "Lorg/gnit/lucenekmp/index/IndexOptions;", "indexOptionsProperties", "Lorg/gnit/lucenekmp/index/FieldInfos$IndexOptionsProperties;", "docValuesType", "Lorg/gnit/lucenekmp/index/DocValuesType;", "docValuesSkipIndex", "Lorg/gnit/lucenekmp/index/DocValuesSkipIndexType;", "fieldDimensions", "Lorg/gnit/lucenekmp/index/FieldInfos$FieldDimensions;", "fieldVectorProperties", "Lorg/gnit/lucenekmp/index/FieldInfos$FieldVectorProperties;", "<init>", "(ILorg/gnit/lucenekmp/index/IndexOptions;Lorg/gnit/lucenekmp/index/FieldInfos$IndexOptionsProperties;Lorg/gnit/lucenekmp/index/DocValuesType;Lorg/gnit/lucenekmp/index/DocValuesSkipIndexType;Lorg/gnit/lucenekmp/index/FieldInfos$FieldDimensions;Lorg/gnit/lucenekmp/index/FieldInfos$FieldVectorProperties;)V", "getNumber", "()I", "getIndexOptions", "()Lorg/gnit/lucenekmp/index/IndexOptions;", "getIndexOptionsProperties", "()Lorg/gnit/lucenekmp/index/FieldInfos$IndexOptionsProperties;", "getDocValuesType", "()Lorg/gnit/lucenekmp/index/DocValuesType;", "getDocValuesSkipIndex", "()Lorg/gnit/lucenekmp/index/DocValuesSkipIndexType;", "getFieldDimensions", "()Lorg/gnit/lucenekmp/index/FieldInfos$FieldDimensions;", "getFieldVectorProperties", "()Lorg/gnit/lucenekmp/index/FieldInfos$FieldVectorProperties;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "toString", "", "core"})
    private static final class FieldProperties {
        private final int number;
        @NotNull
        private final IndexOptions indexOptions;
        @Nullable
        private final IndexOptionsProperties indexOptionsProperties;
        @NotNull
        private final DocValuesType docValuesType;
        @NotNull
        private final DocValuesSkipIndexType docValuesSkipIndex;
        @NotNull
        private final FieldDimensions fieldDimensions;
        @NotNull
        private final FieldVectorProperties fieldVectorProperties;

        public FieldProperties(int number, @NotNull IndexOptions indexOptions, @Nullable IndexOptionsProperties indexOptionsProperties, @NotNull DocValuesType docValuesType, @NotNull DocValuesSkipIndexType docValuesSkipIndex, @NotNull FieldDimensions fieldDimensions, @NotNull FieldVectorProperties fieldVectorProperties) {
            Intrinsics.checkNotNullParameter((Object)((Object)indexOptions), (String)"indexOptions");
            Intrinsics.checkNotNullParameter((Object)((Object)docValuesType), (String)"docValuesType");
            Intrinsics.checkNotNullParameter((Object)((Object)docValuesSkipIndex), (String)"docValuesSkipIndex");
            Intrinsics.checkNotNullParameter((Object)fieldDimensions, (String)"fieldDimensions");
            Intrinsics.checkNotNullParameter((Object)fieldVectorProperties, (String)"fieldVectorProperties");
            this.number = number;
            this.indexOptions = indexOptions;
            this.indexOptionsProperties = indexOptionsProperties;
            this.docValuesType = docValuesType;
            this.docValuesSkipIndex = docValuesSkipIndex;
            this.fieldDimensions = fieldDimensions;
            this.fieldVectorProperties = fieldVectorProperties;
        }

        public final int getNumber() {
            return this.number;
        }

        @NotNull
        public final IndexOptions getIndexOptions() {
            return this.indexOptions;
        }

        @Nullable
        public final IndexOptionsProperties getIndexOptionsProperties() {
            return this.indexOptionsProperties;
        }

        @NotNull
        public final DocValuesType getDocValuesType() {
            return this.docValuesType;
        }

        @NotNull
        public final DocValuesSkipIndexType getDocValuesSkipIndex() {
            return this.docValuesSkipIndex;
        }

        @NotNull
        public final FieldDimensions getFieldDimensions() {
            return this.fieldDimensions;
        }

        @NotNull
        public final FieldVectorProperties getFieldVectorProperties() {
            return this.fieldVectorProperties;
        }

        public final int component1() {
            return this.number;
        }

        @NotNull
        public final IndexOptions component2() {
            return this.indexOptions;
        }

        @Nullable
        public final IndexOptionsProperties component3() {
            return this.indexOptionsProperties;
        }

        @NotNull
        public final DocValuesType component4() {
            return this.docValuesType;
        }

        @NotNull
        public final DocValuesSkipIndexType component5() {
            return this.docValuesSkipIndex;
        }

        @NotNull
        public final FieldDimensions component6() {
            return this.fieldDimensions;
        }

        @NotNull
        public final FieldVectorProperties component7() {
            return this.fieldVectorProperties;
        }

        @NotNull
        public final FieldProperties copy(int number, @NotNull IndexOptions indexOptions, @Nullable IndexOptionsProperties indexOptionsProperties, @NotNull DocValuesType docValuesType, @NotNull DocValuesSkipIndexType docValuesSkipIndex, @NotNull FieldDimensions fieldDimensions, @NotNull FieldVectorProperties fieldVectorProperties) {
            Intrinsics.checkNotNullParameter((Object)((Object)indexOptions), (String)"indexOptions");
            Intrinsics.checkNotNullParameter((Object)((Object)docValuesType), (String)"docValuesType");
            Intrinsics.checkNotNullParameter((Object)((Object)docValuesSkipIndex), (String)"docValuesSkipIndex");
            Intrinsics.checkNotNullParameter((Object)fieldDimensions, (String)"fieldDimensions");
            Intrinsics.checkNotNullParameter((Object)fieldVectorProperties, (String)"fieldVectorProperties");
            return new FieldProperties(number, indexOptions, indexOptionsProperties, docValuesType, docValuesSkipIndex, fieldDimensions, fieldVectorProperties);
        }

        public static /* synthetic */ FieldProperties copy$default(FieldProperties fieldProperties, int n, IndexOptions indexOptions, IndexOptionsProperties indexOptionsProperties, DocValuesType docValuesType, DocValuesSkipIndexType docValuesSkipIndexType, FieldDimensions fieldDimensions, FieldVectorProperties fieldVectorProperties, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = fieldProperties.number;
            }
            if ((n2 & 2) != 0) {
                indexOptions = fieldProperties.indexOptions;
            }
            if ((n2 & 4) != 0) {
                indexOptionsProperties = fieldProperties.indexOptionsProperties;
            }
            if ((n2 & 8) != 0) {
                docValuesType = fieldProperties.docValuesType;
            }
            if ((n2 & 0x10) != 0) {
                docValuesSkipIndexType = fieldProperties.docValuesSkipIndex;
            }
            if ((n2 & 0x20) != 0) {
                fieldDimensions = fieldProperties.fieldDimensions;
            }
            if ((n2 & 0x40) != 0) {
                fieldVectorProperties = fieldProperties.fieldVectorProperties;
            }
            return fieldProperties.copy(n, indexOptions, indexOptionsProperties, docValuesType, docValuesSkipIndexType, fieldDimensions, fieldVectorProperties);
        }

        @NotNull
        public String toString() {
            return "FieldProperties(number=" + this.number + ", indexOptions=" + this.indexOptions + ", indexOptionsProperties=" + this.indexOptionsProperties + ", docValuesType=" + this.docValuesType + ", docValuesSkipIndex=" + this.docValuesSkipIndex + ", fieldDimensions=" + this.fieldDimensions + ", fieldVectorProperties=" + this.fieldVectorProperties + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.number);
            result = result * 31 + this.indexOptions.hashCode();
            result = result * 31 + (this.indexOptionsProperties == null ? 0 : this.indexOptionsProperties.hashCode());
            result = result * 31 + this.docValuesType.hashCode();
            result = result * 31 + this.docValuesSkipIndex.hashCode();
            result = result * 31 + this.fieldDimensions.hashCode();
            result = result * 31 + this.fieldVectorProperties.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FieldProperties)) {
                return false;
            }
            FieldProperties fieldProperties = (FieldProperties)other;
            if (this.number != fieldProperties.number) {
                return false;
            }
            if (this.indexOptions != fieldProperties.indexOptions) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.indexOptionsProperties, (Object)fieldProperties.indexOptionsProperties)) {
                return false;
            }
            if (this.docValuesType != fieldProperties.docValuesType) {
                return false;
            }
            if (this.docValuesSkipIndex != fieldProperties.docValuesSkipIndex) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fieldDimensions, (Object)fieldProperties.fieldDimensions)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.fieldVectorProperties, (Object)fieldProperties.fieldVectorProperties);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/index/FieldInfos$FieldVectorProperties;", "", "numDimensions", "", "vectorEncoding", "Lorg/gnit/lucenekmp/index/VectorEncoding;", "similarityFunction", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "<init>", "(ILorg/gnit/lucenekmp/index/VectorEncoding;Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;)V", "getNumDimensions", "()I", "getVectorEncoding", "()Lorg/gnit/lucenekmp/index/VectorEncoding;", "getSimilarityFunction", "()Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "core"})
    private static final class FieldVectorProperties {
        private final int numDimensions;
        @NotNull
        private final VectorEncoding vectorEncoding;
        @NotNull
        private final VectorSimilarityFunction similarityFunction;

        public FieldVectorProperties(int numDimensions, @NotNull VectorEncoding vectorEncoding, @NotNull VectorSimilarityFunction similarityFunction) {
            Intrinsics.checkNotNullParameter((Object)((Object)vectorEncoding), (String)"vectorEncoding");
            Intrinsics.checkNotNullParameter((Object)((Object)similarityFunction), (String)"similarityFunction");
            this.numDimensions = numDimensions;
            this.vectorEncoding = vectorEncoding;
            this.similarityFunction = similarityFunction;
        }

        public final int getNumDimensions() {
            return this.numDimensions;
        }

        @NotNull
        public final VectorEncoding getVectorEncoding() {
            return this.vectorEncoding;
        }

        @NotNull
        public final VectorSimilarityFunction getSimilarityFunction() {
            return this.similarityFunction;
        }

        public final int component1() {
            return this.numDimensions;
        }

        @NotNull
        public final VectorEncoding component2() {
            return this.vectorEncoding;
        }

        @NotNull
        public final VectorSimilarityFunction component3() {
            return this.similarityFunction;
        }

        @NotNull
        public final FieldVectorProperties copy(int numDimensions, @NotNull VectorEncoding vectorEncoding, @NotNull VectorSimilarityFunction similarityFunction) {
            Intrinsics.checkNotNullParameter((Object)((Object)vectorEncoding), (String)"vectorEncoding");
            Intrinsics.checkNotNullParameter((Object)((Object)similarityFunction), (String)"similarityFunction");
            return new FieldVectorProperties(numDimensions, vectorEncoding, similarityFunction);
        }

        public static /* synthetic */ FieldVectorProperties copy$default(FieldVectorProperties fieldVectorProperties, int n, VectorEncoding vectorEncoding, VectorSimilarityFunction vectorSimilarityFunction, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = fieldVectorProperties.numDimensions;
            }
            if ((n2 & 2) != 0) {
                vectorEncoding = fieldVectorProperties.vectorEncoding;
            }
            if ((n2 & 4) != 0) {
                vectorSimilarityFunction = fieldVectorProperties.similarityFunction;
            }
            return fieldVectorProperties.copy(n, vectorEncoding, vectorSimilarityFunction);
        }

        @NotNull
        public String toString() {
            return "FieldVectorProperties(numDimensions=" + this.numDimensions + ", vectorEncoding=" + this.vectorEncoding + ", similarityFunction=" + this.similarityFunction + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.numDimensions);
            result = result * 31 + this.vectorEncoding.hashCode();
            result = result * 31 + this.similarityFunction.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FieldVectorProperties)) {
                return false;
            }
            FieldVectorProperties fieldVectorProperties = (FieldVectorProperties)other;
            if (this.numDimensions != fieldVectorProperties.numDimensions) {
                return false;
            }
            if (this.vectorEncoding != fieldVectorProperties.vectorEncoding) {
                return false;
            }
            return this.similarityFunction == fieldVectorProperties.similarityFunction;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/index/FieldInfos$IndexOptionsProperties;", "", "storeTermVectors", "", "omitNorms", "<init>", "(ZZ)V", "getStoreTermVectors", "()Z", "getOmitNorms", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "core"})
    private static final class IndexOptionsProperties {
        private final boolean storeTermVectors;
        private final boolean omitNorms;

        public IndexOptionsProperties(boolean storeTermVectors, boolean omitNorms) {
            this.storeTermVectors = storeTermVectors;
            this.omitNorms = omitNorms;
        }

        public final boolean getStoreTermVectors() {
            return this.storeTermVectors;
        }

        public final boolean getOmitNorms() {
            return this.omitNorms;
        }

        public final boolean component1() {
            return this.storeTermVectors;
        }

        public final boolean component2() {
            return this.omitNorms;
        }

        @NotNull
        public final IndexOptionsProperties copy(boolean storeTermVectors, boolean omitNorms) {
            return new IndexOptionsProperties(storeTermVectors, omitNorms);
        }

        public static /* synthetic */ IndexOptionsProperties copy$default(IndexOptionsProperties indexOptionsProperties, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = indexOptionsProperties.storeTermVectors;
            }
            if ((n & 2) != 0) {
                bl2 = indexOptionsProperties.omitNorms;
            }
            return indexOptionsProperties.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "IndexOptionsProperties(storeTermVectors=" + this.storeTermVectors + ", omitNorms=" + this.omitNorms + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.storeTermVectors);
            result = result * 31 + Boolean.hashCode(this.omitNorms);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IndexOptionsProperties)) {
                return false;
            }
            IndexOptionsProperties indexOptionsProperties = (IndexOptionsProperties)other;
            if (this.storeTermVectors != indexOptionsProperties.storeTermVectors) {
                return false;
            }
            return this.omitNorms == indexOptionsProperties.omitNorms;
        }
    }
}

