/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.DocumentsWriterFlushControl;
import org.gnit.lucenekmp.index.DocumentsWriterPerThread;
import org.gnit.lucenekmp.index.FlushPolicy;
import org.gnit.lucenekmp.index.LiveIndexWriterConfig;
import org.gnit.lucenekmp.util.InfoStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0004J\b\u0010\r\u001a\u00020\u000eH\u0004J\b\u0010\u000f\u001a\u00020\u000eH\u0004\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/index/FlushByRamOrCountsPolicy;", "Lorg/gnit/lucenekmp/index/FlushPolicy;", "<init>", "()V", "onChange", "", "control", "Lorg/gnit/lucenekmp/index/DocumentsWriterFlushControl;", "perThread", "Lorg/gnit/lucenekmp/index/DocumentsWriterPerThread;", "flushDeletes", "flushActiveBytes", "markLargestWriterPending", "flushOnDocCount", "", "flushOnRAM", "core"})
public class FlushByRamOrCountsPolicy
extends FlushPolicy {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onChange(@NotNull DocumentsWriterFlushControl control, @Nullable DocumentsWriterPerThread perThread) {
        Intrinsics.checkNotNullParameter((Object)control, (String)"control");
        if (perThread != null && this.flushOnDocCount()) {
            int n = perThread.getNumDocsInRAM();
            LiveIndexWriterConfig liveIndexWriterConfig = this.getIndexWriterConfig();
            Intrinsics.checkNotNull((Object)liveIndexWriterConfig);
            if (n >= liveIndexWriterConfig.getMaxBufferedDocs()) {
                control.setFlushPending(perThread);
                return;
            }
        }
        if (!this.flushOnRAM()) return;
        LiveIndexWriterConfig liveIndexWriterConfig = this.getIndexWriterConfig();
        Intrinsics.checkNotNull((Object)liveIndexWriterConfig);
        long limit = (long)(liveIndexWriterConfig.getRAMBufferSizeMB() * 1024.0 * 1024.0);
        long activeRam = control.activeBytes();
        long deletesRam = control.getDeleteBytesUsed();
        if (deletesRam >= limit && activeRam >= limit && perThread != null) {
            this.flushDeletes(control);
            this.flushActiveBytes(control, perThread);
            return;
        }
        if (deletesRam >= limit) {
            this.flushDeletes(control);
            return;
        }
        if (activeRam + deletesRam < limit) return;
        if (perThread == null) return;
        this.flushActiveBytes(control, perThread);
    }

    private final void flushDeletes(DocumentsWriterFlushControl control) {
        control.setApplyAllDeletes();
        InfoStream infoStream = this.getInfoStream();
        Intrinsics.checkNotNull((Object)infoStream);
        if (infoStream.isEnabled("FP")) {
            InfoStream infoStream2 = this.getInfoStream();
            Intrinsics.checkNotNull((Object)infoStream2);
            long l = control.getDeleteBytesUsed();
            LiveIndexWriterConfig liveIndexWriterConfig = this.getIndexWriterConfig();
            Intrinsics.checkNotNull((Object)liveIndexWriterConfig);
            infoStream2.message("FP", "force apply deletes bytesUsed=" + l + " vs ramBufferMB=" + liveIndexWriterConfig.getRAMBufferSizeMB());
        }
    }

    private final void flushActiveBytes(DocumentsWriterFlushControl control, DocumentsWriterPerThread perThread) {
        InfoStream infoStream = this.getInfoStream();
        Intrinsics.checkNotNull((Object)infoStream);
        if (infoStream.isEnabled("FP")) {
            InfoStream infoStream2 = this.getInfoStream();
            Intrinsics.checkNotNull((Object)infoStream2);
            long l = control.activeBytes();
            long l2 = control.getDeleteBytesUsed();
            LiveIndexWriterConfig liveIndexWriterConfig = this.getIndexWriterConfig();
            Intrinsics.checkNotNull((Object)liveIndexWriterConfig);
            infoStream2.message("FP", "trigger flush: activeBytes=" + l + " deleteBytes=" + l2 + " vs ramBufferMB=" + liveIndexWriterConfig.getRAMBufferSizeMB());
        }
        this.markLargestWriterPending(control, perThread);
    }

    protected final void markLargestWriterPending(@NotNull DocumentsWriterFlushControl control, @NotNull DocumentsWriterPerThread perThread) {
        Intrinsics.checkNotNullParameter((Object)control, (String)"control");
        Intrinsics.checkNotNullParameter((Object)perThread, (String)"perThread");
        DocumentsWriterPerThread largestNonPendingWriter = this.findLargestNonPendingWriter(control, perThread);
        if (largestNonPendingWriter != null) {
            control.setFlushPending(largestNonPendingWriter);
        }
    }

    protected final boolean flushOnDocCount() {
        LiveIndexWriterConfig liveIndexWriterConfig = this.getIndexWriterConfig();
        Intrinsics.checkNotNull((Object)liveIndexWriterConfig);
        return liveIndexWriterConfig.getMaxBufferedDocs() != -1;
    }

    protected final boolean flushOnRAM() {
        LiveIndexWriterConfig liveIndexWriterConfig = this.getIndexWriterConfig();
        Intrinsics.checkNotNull((Object)liveIndexWriterConfig);
        return !(liveIndexWriterConfig.getRAMBufferSizeMB() == -1.0);
    }
}

