/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.BaseTermsEnum;
import org.gnit.lucenekmp.index.ByteSliceReader;
import org.gnit.lucenekmp.index.Fields;
import org.gnit.lucenekmp.index.FreqProxTermsWriterPerField;
import org.gnit.lucenekmp.index.ImpactsEnum;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.ParallelPostingsArray;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.TermState;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBlockPool;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0096\u0002J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/index/FreqProxFields;", "Lorg/gnit/lucenekmp/index/Fields;", "fieldList", "", "Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField;", "<init>", "(Ljava/util/List;)V", "fields", "", "", "getFields", "()Ljava/util/Map;", "iterator", "", "terms", "Lorg/gnit/lucenekmp/index/Terms;", "field", "size", "", "FreqProxTerms", "FreqProxTermsEnum", "FreqProxDocsEnum", "FreqProxPostingsEnum", "core"})
public final class FreqProxFields
extends Fields {
    @NotNull
    private final Map<String, FreqProxTermsWriterPerField> fields;

    public FreqProxFields(@NotNull List<FreqProxTermsWriterPerField> fieldList) {
        Intrinsics.checkNotNullParameter(fieldList, (String)"fieldList");
        this.fields = new LinkedHashMap();
        for (FreqProxTermsWriterPerField field : fieldList) {
            this.fields.put(field.getFieldName(), field);
        }
    }

    @NotNull
    public final Map<String, FreqProxTermsWriterPerField> getFields() {
        return this.fields;
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return this.fields.keySet().iterator();
    }

    @Override
    @Nullable
    public Terms terms(@Nullable String field) throws IOException {
        FreqProxTermsWriterPerField perField = this.fields.get(field);
        return perField == null ? null : (Terms)new FreqProxTerms(perField);
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020\u0015J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\b\u0010&\u001a\u00020\u0015H\u0016J\b\u0010'\u001a\u00020\u0015H\u0016J\b\u0010(\u001a\u00020\u0015H\u0016J\b\u0010-\u001a\u00020\u0015H\u0016J\u0010\u0010.\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\u0015H\u0016J\b\u00100\u001a\u000201H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0013\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0017\"\u0004\b#\u0010\u0019R\u0016\u0010)\u001a\u0004\u0018\u00010*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u00062"}, d2={"Lorg/gnit/lucenekmp/index/FreqProxFields$FreqProxDocsEnum;", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "terms", "Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField;", "postingsArray", "Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField$FreqProxPostingsArray;", "<init>", "(Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField;Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField$FreqProxPostingsArray;)V", "getTerms", "()Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField;", "getPostingsArray", "()Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField$FreqProxPostingsArray;", "reader", "Lorg/gnit/lucenekmp/index/ByteSliceReader;", "getReader", "()Lorg/gnit/lucenekmp/index/ByteSliceReader;", "readTermFreq", "", "getReadTermFreq", "()Z", "docID", "", "getDocID", "()I", "setDocID", "(I)V", "freq", "getFreq", "setFreq", "ended", "getEnded", "setEnded", "(Z)V", "termID", "getTermID", "setTermID", "reset", "", "nextPosition", "startOffset", "endOffset", "payload", "Lorg/gnit/lucenekmp/util/BytesRef;", "getPayload", "()Lorg/gnit/lucenekmp/util/BytesRef;", "nextDoc", "advance", "target", "cost", "", "core"})
    @SourceDebugExtension(value={"SMAP\nFreqProxFields.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FreqProxFields.kt\norg/gnit/lucenekmp/index/FreqProxFields$FreqProxDocsEnum\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,471:1\n1#2:472\n3#3,8:473\n10#4:481\n*S KotlinDebug\n*F\n+ 1 FreqProxFields.kt\norg/gnit/lucenekmp/index/FreqProxFields$FreqProxDocsEnum\n*L\n331#1:473,8\n331#1:481\n*E\n"})
    private static final class FreqProxDocsEnum
    extends PostingsEnum {
        @NotNull
        private final FreqProxTermsWriterPerField terms;
        @NotNull
        private final FreqProxTermsWriterPerField.FreqProxPostingsArray postingsArray;
        @NotNull
        private final ByteSliceReader reader;
        private final boolean readTermFreq;
        private int docID;
        private int freq;
        private boolean ended;
        private int termID;

        public FreqProxDocsEnum(@NotNull FreqProxTermsWriterPerField terms, @NotNull FreqProxTermsWriterPerField.FreqProxPostingsArray postingsArray) {
            Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
            Intrinsics.checkNotNullParameter((Object)postingsArray, (String)"postingsArray");
            this.terms = terms;
            this.postingsArray = postingsArray;
            this.reader = new ByteSliceReader();
            this.readTermFreq = this.terms.getHasFreq();
            this.docID = -1;
        }

        @NotNull
        public final FreqProxTermsWriterPerField getTerms() {
            return this.terms;
        }

        @NotNull
        public final FreqProxTermsWriterPerField.FreqProxPostingsArray getPostingsArray() {
            return this.postingsArray;
        }

        @NotNull
        public final ByteSliceReader getReader() {
            return this.reader;
        }

        public final boolean getReadTermFreq() {
            return this.readTermFreq;
        }

        public final int getDocID() {
            return this.docID;
        }

        public final void setDocID(int n) {
            this.docID = n;
        }

        public final int getFreq() {
            return this.freq;
        }

        public final void setFreq(int n) {
            this.freq = n;
        }

        public final boolean getEnded() {
            return this.ended;
        }

        public final void setEnded(boolean bl) {
            this.ended = bl;
        }

        public final int getTermID() {
            return this.termID;
        }

        public final void setTermID(int n) {
            this.termID = n;
        }

        public final void reset(int termID) {
            this.termID = termID;
            this.terms.initReader(this.reader, termID, 0);
            this.ended = false;
            this.docID = -1;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int freq() {
            if (!this.readTermFreq) {
                boolean bl = false;
                String string = "freq was not indexed";
                throw new IllegalStateException(string.toString());
            }
            return this.freq;
        }

        @Override
        public int nextPosition() throws IOException {
            return -1;
        }

        @Override
        public int startOffset() throws IOException {
            return -1;
        }

        @Override
        public int endOffset() throws IOException {
            return -1;
        }

        @Override
        @Nullable
        public BytesRef getPayload() {
            return null;
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.docID == -1) {
                this.docID = 0;
            }
            if (this.reader.eof()) {
                if (this.ended) {
                    return Integer.MAX_VALUE;
                }
                this.ended = true;
                this.docID = this.postingsArray.getLastDocIDs()[this.termID];
                if (this.readTermFreq) {
                    int[] nArray = this.postingsArray.getTermFreqs();
                    Intrinsics.checkNotNull((Object)nArray);
                    this.freq = nArray[this.termID];
                }
            } else {
                int code = this.reader.readVInt();
                if (!this.readTermFreq) {
                    this.docID += code;
                } else {
                    this.docID += code >>> 1;
                    this.freq = (code & 1) != 0 ? 1 : this.reader.readVInt();
                }
                boolean condition$iv = this.docID != this.postingsArray.getLastDocIDs()[this.termID];
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
            }
            return this.docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            throw new UnsupportedOperationException();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010;\u001a\u00020<2\u0006\u0010+\u001a\u00020\u0017J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\b\u0010=\u001a\u00020\u0017H\u0016J\u0010\u0010>\u001a\u00020\u00172\u0006\u0010?\u001a\u00020\u0017H\u0016J\b\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020\u0017H\u0016J\b\u0010\"\u001a\u00020\u0017H\u0016J\b\u0010%\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u001a\u0010\u001f\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0019\"\u0004\b!\u0010\u001bR\u001a\u0010\"\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0019\"\u0004\b$\u0010\u001bR\u001a\u0010%\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0019\"\u0004\b'\u0010\u001bR\u001a\u0010(\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0019\"\u0004\b*\u0010\u001bR\u001a\u0010+\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0019\"\u0004\b-\u0010\u001bR\u001a\u0010.\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0015\"\u0004\b0\u00101R\u001a\u00102\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0015\"\u0004\b4\u00101R\u001a\u00105\u001a\u000206X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u0016\u0010C\u001a\u0004\u0018\u00010D8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010F\u00a8\u0006G"}, d2={"Lorg/gnit/lucenekmp/index/FreqProxFields$FreqProxPostingsEnum;", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "terms", "Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField;", "postingsArray", "Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField$FreqProxPostingsArray;", "<init>", "(Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField;Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField$FreqProxPostingsArray;)V", "getTerms", "()Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField;", "getPostingsArray", "()Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField$FreqProxPostingsArray;", "reader", "Lorg/gnit/lucenekmp/index/ByteSliceReader;", "getReader", "()Lorg/gnit/lucenekmp/index/ByteSliceReader;", "posReader", "getPosReader", "readOffsets", "", "getReadOffsets", "()Z", "docID", "", "getDocID", "()I", "setDocID", "(I)V", "freq", "getFreq", "setFreq", "pos", "getPos", "setPos", "startOffset", "getStartOffset", "setStartOffset", "endOffset", "getEndOffset", "setEndOffset", "posLeft", "getPosLeft", "setPosLeft", "termID", "getTermID", "setTermID", "ended", "getEnded", "setEnded", "(Z)V", "hasPayload", "getHasPayload", "setHasPayload", "payloadBuilder", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "getPayloadBuilder", "()Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "setPayloadBuilder", "(Lorg/gnit/lucenekmp/util/BytesRefBuilder;)V", "reset", "", "nextDoc", "advance", "target", "cost", "", "nextPosition", "payload", "Lorg/gnit/lucenekmp/util/BytesRef;", "getPayload", "()Lorg/gnit/lucenekmp/util/BytesRef;", "core"})
    @SourceDebugExtension(value={"SMAP\nFreqProxFields.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FreqProxFields.kt\norg/gnit/lucenekmp/index/FreqProxFields$FreqProxPostingsEnum\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,471:1\n3#2,8:472\n3#2,8:481\n3#2,8:490\n3#2,8:499\n10#3:480\n10#3:489\n10#3:498\n10#3:507\n1#4:508\n*S KotlinDebug\n*F\n+ 1 FreqProxFields.kt\norg/gnit/lucenekmp/index/FreqProxFields$FreqProxPostingsEnum\n*L\n363#1:472,8\n364#1:481,8\n410#1:490,8\n429#1:499,8\n363#1:480\n364#1:489\n410#1:498\n429#1:507\n*E\n"})
    private static final class FreqProxPostingsEnum
    extends PostingsEnum {
        @NotNull
        private final FreqProxTermsWriterPerField terms;
        @NotNull
        private final FreqProxTermsWriterPerField.FreqProxPostingsArray postingsArray;
        @NotNull
        private final ByteSliceReader reader;
        @NotNull
        private final ByteSliceReader posReader;
        private final boolean readOffsets;
        private int docID;
        private int freq;
        private int pos;
        private int startOffset;
        private int endOffset;
        private int posLeft;
        private int termID;
        private boolean ended;
        private boolean hasPayload;
        @NotNull
        private BytesRefBuilder payloadBuilder;

        public FreqProxPostingsEnum(@NotNull FreqProxTermsWriterPerField terms, @NotNull FreqProxTermsWriterPerField.FreqProxPostingsArray postingsArray) {
            Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
            Intrinsics.checkNotNullParameter((Object)postingsArray, (String)"postingsArray");
            this.terms = terms;
            this.postingsArray = postingsArray;
            this.reader = new ByteSliceReader();
            this.posReader = new ByteSliceReader();
            this.readOffsets = this.terms.getHasOffsets();
            this.docID = -1;
            this.payloadBuilder = new BytesRefBuilder();
            boolean condition$iv = this.terms.getHasProx();
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            condition$iv = this.terms.getHasFreq();
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
        }

        @NotNull
        public final FreqProxTermsWriterPerField getTerms() {
            return this.terms;
        }

        @NotNull
        public final FreqProxTermsWriterPerField.FreqProxPostingsArray getPostingsArray() {
            return this.postingsArray;
        }

        @NotNull
        public final ByteSliceReader getReader() {
            return this.reader;
        }

        @NotNull
        public final ByteSliceReader getPosReader() {
            return this.posReader;
        }

        public final boolean getReadOffsets() {
            return this.readOffsets;
        }

        public final int getDocID() {
            return this.docID;
        }

        public final void setDocID(int n) {
            this.docID = n;
        }

        public final int getFreq() {
            return this.freq;
        }

        public final void setFreq(int n) {
            this.freq = n;
        }

        public final int getPos() {
            return this.pos;
        }

        public final void setPos(int n) {
            this.pos = n;
        }

        public final int getStartOffset() {
            return this.startOffset;
        }

        public final void setStartOffset(int n) {
            this.startOffset = n;
        }

        public final int getEndOffset() {
            return this.endOffset;
        }

        public final void setEndOffset(int n) {
            this.endOffset = n;
        }

        public final int getPosLeft() {
            return this.posLeft;
        }

        public final void setPosLeft(int n) {
            this.posLeft = n;
        }

        public final int getTermID() {
            return this.termID;
        }

        public final void setTermID(int n) {
            this.termID = n;
        }

        public final boolean getEnded() {
            return this.ended;
        }

        public final void setEnded(boolean bl) {
            this.ended = bl;
        }

        public final boolean getHasPayload() {
            return this.hasPayload;
        }

        public final void setHasPayload(boolean bl) {
            this.hasPayload = bl;
        }

        @NotNull
        public final BytesRefBuilder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public final void setPayloadBuilder(@NotNull BytesRefBuilder bytesRefBuilder) {
            Intrinsics.checkNotNullParameter((Object)bytesRefBuilder, (String)"<set-?>");
            this.payloadBuilder = bytesRefBuilder;
        }

        public final void reset(int termID) {
            this.termID = termID;
            this.terms.initReader(this.reader, termID, 0);
            this.terms.initReader(this.posReader, termID, 1);
            this.ended = false;
            this.docID = -1;
            this.posLeft = 0;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int freq() {
            return this.freq;
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.docID == -1) {
                this.docID = 0;
            }
            while (this.posLeft != 0) {
                this.nextPosition();
            }
            if (this.reader.eof()) {
                if (this.ended) {
                    return Integer.MAX_VALUE;
                }
                this.ended = true;
                this.docID = this.postingsArray.getLastDocIDs()[this.termID];
                int[] nArray = this.postingsArray.getTermFreqs();
                Intrinsics.checkNotNull((Object)nArray);
                this.freq = nArray[this.termID];
            } else {
                int code = this.reader.readVInt();
                this.docID += code >>> 1;
                this.freq = (code & 1) != 0 ? 1 : this.reader.readVInt();
                boolean condition$iv = this.docID != this.postingsArray.getLastDocIDs()[this.termID];
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
            }
            this.posLeft = this.freq;
            this.pos = 0;
            this.startOffset = 0;
            return this.docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int nextPosition() throws IOException {
            int condition$iv = this.posLeft > 0 ? 1 : 0;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && condition$iv == 0) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            condition$iv = this.posLeft;
            this.posLeft = condition$iv + -1;
            int code = this.posReader.readVInt();
            this.pos += code >>> 1;
            if ((code & 1) != 0) {
                this.hasPayload = true;
                this.payloadBuilder.setLength(this.posReader.readVInt());
                this.payloadBuilder.growNoCopy(this.payloadBuilder.length());
                this.posReader.readBytes(this.payloadBuilder.bytes(), 0, this.payloadBuilder.length());
            } else {
                this.hasPayload = false;
            }
            if (this.readOffsets) {
                this.startOffset += this.posReader.readVInt();
                this.endOffset = this.startOffset + this.posReader.readVInt();
            }
            return this.pos;
        }

        @Override
        public int startOffset() {
            if (!this.readOffsets) {
                boolean bl = false;
                String string = "offsets were not indexed";
                throw new IllegalStateException(string.toString());
            }
            return this.startOffset;
        }

        @Override
        public int endOffset() {
            if (!this.readOffsets) {
                boolean bl = false;
                String string = "offsets were not indexed";
                throw new IllegalStateException(string.toString());
            }
            return this.endOffset;
        }

        @Override
        @Nullable
        public BytesRef getPayload() {
            return this.hasPayload ? this.payloadBuilder.get() : null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\f\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/index/FreqProxFields$FreqProxTerms;", "Lorg/gnit/lucenekmp/index/Terms;", "terms", "Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField;", "<init>", "(Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField;)V", "getTerms", "()Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField;", "iterator", "Lorg/gnit/lucenekmp/index/TermsEnum;", "size", "", "sumTotalTermFreq", "getSumTotalTermFreq", "()J", "sumDocFreq", "getSumDocFreq", "docCount", "", "getDocCount", "()I", "hasFreqs", "", "hasOffsets", "hasPositions", "hasPayloads", "core"})
    private static final class FreqProxTerms
    extends Terms {
        @NotNull
        private final FreqProxTermsWriterPerField terms;

        public FreqProxTerms(@NotNull FreqProxTermsWriterPerField terms) {
            Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
            this.terms = terms;
        }

        @NotNull
        public final FreqProxTermsWriterPerField getTerms() {
            return this.terms;
        }

        @Override
        @NotNull
        public TermsEnum iterator() {
            FreqProxTermsEnum termsEnum = new FreqProxTermsEnum(this.terms);
            termsEnum.reset();
            return termsEnum;
        }

        @Override
        public long size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSumTotalTermFreq() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSumDocFreq() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDocCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasFreqs() {
            return this.terms.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0;
        }

        @Override
        public boolean hasOffsets() {
            return this.terms.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        }

        @Override
        public boolean hasPositions() {
            return this.terms.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        }

        @Override
        public boolean hasPayloads() {
            return this.terms.getSawPayloads();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0015H\u0016J\u0010\u0010%\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020&H\u0016J\n\u0010'\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010(\u001a\u00020\u0015H\u0016J\b\u0010\u001c\u001a\u00020&H\u0016J\b\u0010)\u001a\u00020\u0019H\u0016J\b\u0010*\u001a\u00020&H\u0016J\u001a\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010,2\u0006\u0010.\u001a\u00020\u0019H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u0010.\u001a\u00020\u0019H\u0016J\b\u00101\u001a\u000202H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001b\"\u0004\b\u001e\u0010\u001f\u00a8\u00063"}, d2={"Lorg/gnit/lucenekmp/index/FreqProxFields$FreqProxTermsEnum;", "Lorg/gnit/lucenekmp/index/BaseTermsEnum;", "terms", "Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField;", "<init>", "(Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField;)V", "getTerms", "()Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField;", "termsPool", "Lorg/gnit/lucenekmp/util/BytesRefBlockPool;", "getTermsPool", "()Lorg/gnit/lucenekmp/util/BytesRefBlockPool;", "sortedTermIDs", "", "getSortedTermIDs", "()[I", "postingsArray", "Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField$FreqProxPostingsArray;", "getPostingsArray", "()Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField$FreqProxPostingsArray;", "scratch", "Lorg/gnit/lucenekmp/util/BytesRef;", "getScratch", "()Lorg/gnit/lucenekmp/util/BytesRef;", "numTerms", "", "getNumTerms", "()I", "ord", "getOrd", "setOrd", "(I)V", "reset", "", "seekCeil", "Lorg/gnit/lucenekmp/index/TermsEnum$SeekStatus;", "text", "seekExact", "", "next", "term", "docFreq", "totalTermFreq", "postings", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "reuse", "flags", "impacts", "Lorg/gnit/lucenekmp/index/ImpactsEnum;", "termState", "Lorg/gnit/lucenekmp/index/TermState;", "core"})
    @SourceDebugExtension(value={"SMAP\nFreqProxFields.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FreqProxFields.kt\norg/gnit/lucenekmp/index/FreqProxFields$FreqProxTermsEnum\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,471:1\n3#2,8:472\n3#2,8:481\n10#3:480\n10#3:489\n1#4:490\n*S KotlinDebug\n*F\n+ 1 FreqProxFields.kt\norg/gnit/lucenekmp/index/FreqProxFields$FreqProxTermsEnum\n*L\n122#1:472,8\n134#1:481,8\n122#1:480\n134#1:489\n*E\n"})
    private static final class FreqProxTermsEnum
    extends BaseTermsEnum {
        @NotNull
        private final FreqProxTermsWriterPerField terms;
        @NotNull
        private final BytesRefBlockPool termsPool;
        @NotNull
        private final int[] sortedTermIDs;
        @NotNull
        private final FreqProxTermsWriterPerField.FreqProxPostingsArray postingsArray;
        @NotNull
        private final BytesRef scratch;
        private final int numTerms;
        private int ord;

        public FreqProxTermsEnum(@NotNull FreqProxTermsWriterPerField terms) {
            Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
            this.terms = terms;
            this.termsPool = new BytesRefBlockPool(this.terms.getBytePool());
            this.sortedTermIDs = this.terms.getSortedTermIDs();
            ParallelPostingsArray parallelPostingsArray = this.terms.getPostingsArray();
            Intrinsics.checkNotNull((Object)parallelPostingsArray, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.FreqProxTermsWriterPerField.FreqProxPostingsArray");
            this.postingsArray = (FreqProxTermsWriterPerField.FreqProxPostingsArray)parallelPostingsArray;
            this.scratch = new BytesRef();
            this.numTerms = this.terms.getNumTerms();
        }

        @NotNull
        public final FreqProxTermsWriterPerField getTerms() {
            return this.terms;
        }

        @NotNull
        public final BytesRefBlockPool getTermsPool() {
            return this.termsPool;
        }

        @NotNull
        public final int[] getSortedTermIDs() {
            return this.sortedTermIDs;
        }

        @NotNull
        public final FreqProxTermsWriterPerField.FreqProxPostingsArray getPostingsArray() {
            return this.postingsArray;
        }

        @NotNull
        public final BytesRef getScratch() {
            return this.scratch;
        }

        public final int getNumTerms() {
            return this.numTerms;
        }

        public final int getOrd() {
            return this.ord;
        }

        public final void setOrd(int n) {
            this.ord = n;
        }

        public final void reset() {
            this.ord = -1;
        }

        @Override
        @NotNull
        public TermsEnum.SeekStatus seekCeil(@NotNull BytesRef text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int lo = 0;
            int hi = this.numTerms - 1;
            while (hi >= lo) {
                int mid = lo + hi >>> 1;
                int textStart = this.postingsArray.getTextStarts()[this.sortedTermIDs[mid]];
                this.termsPool.fillBytesRef(this.scratch, textStart);
                int cmp = this.scratch.compareTo(text);
                if (cmp < 0) {
                    lo = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    hi = mid - 1;
                    continue;
                }
                this.ord = mid;
                boolean condition$iv = this.term().compareTo(text) == 0;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
                return TermsEnum.SeekStatus.FOUND;
            }
            this.ord = lo;
            if (this.ord >= this.numTerms) {
                return TermsEnum.SeekStatus.END;
            }
            int textStart = this.postingsArray.getTextStarts()[this.sortedTermIDs[this.ord]];
            this.termsPool.fillBytesRef(this.scratch, textStart);
            boolean condition$iv = this.term().compareTo(text) > 0;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            return TermsEnum.SeekStatus.NOT_FOUND;
        }

        @Override
        public void seekExact(long ord) {
            this.ord = (int)ord;
            int textStart = this.postingsArray.getTextStarts()[this.sortedTermIDs[this.ord]];
            this.termsPool.fillBytesRef(this.scratch, textStart);
        }

        @Override
        @Nullable
        public BytesRef next() {
            int n = this.ord;
            this.ord = n + 1;
            if (this.ord >= this.numTerms) {
                return null;
            }
            int textStart = this.postingsArray.getTextStarts()[this.sortedTermIDs[this.ord]];
            this.termsPool.fillBytesRef(this.scratch, textStart);
            return this.scratch;
        }

        @Override
        @NotNull
        public BytesRef term() {
            return this.scratch;
        }

        @Override
        public long ord() {
            return this.ord;
        }

        @Override
        public int docFreq() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long totalTermFreq() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public PostingsEnum postings(@Nullable PostingsEnum reuse, int flags) {
            if (PostingsEnum.Companion.featureRequested(flags, PostingsEnum.Companion.getPOSITIONS())) {
                FreqProxPostingsEnum posEnum = null;
                if (!this.terms.getHasProx()) {
                    boolean $i$a$-require-FreqProxFields$FreqProxTermsEnum$postings$42 = false;
                    String $i$a$-require-FreqProxFields$FreqProxTermsEnum$postings$42 = "did not index positions";
                    throw new IllegalArgumentException($i$a$-require-FreqProxFields$FreqProxTermsEnum$postings$42.toString());
                }
                if (!(this.terms.getHasOffsets() || !PostingsEnum.Companion.featureRequested(flags, PostingsEnum.Companion.getOFFSETS()))) {
                    boolean $i$a$-require-FreqProxFields$FreqProxTermsEnum$postings$52 = false;
                    String $i$a$-require-FreqProxFields$FreqProxTermsEnum$postings$52 = "did not index offsets";
                    throw new IllegalArgumentException($i$a$-require-FreqProxFields$FreqProxTermsEnum$postings$52.toString());
                }
                if (reuse instanceof FreqProxPostingsEnum) {
                    posEnum = (FreqProxPostingsEnum)reuse;
                    if (!Intrinsics.areEqual((Object)posEnum.getPostingsArray(), (Object)this.postingsArray)) {
                        posEnum = new FreqProxPostingsEnum(this.terms, this.postingsArray);
                    }
                } else {
                    posEnum = new FreqProxPostingsEnum(this.terms, this.postingsArray);
                }
                posEnum.reset(this.sortedTermIDs[this.ord]);
                return posEnum;
            }
            FreqProxDocsEnum docsEnum = null;
            if (!(this.terms.getHasFreq() || !PostingsEnum.Companion.featureRequested(flags, PostingsEnum.Companion.getFREQS()))) {
                boolean bl = false;
                String string = "did not index freq";
                throw new IllegalArgumentException(string.toString());
            }
            if (reuse instanceof FreqProxDocsEnum) {
                docsEnum = (FreqProxDocsEnum)reuse;
                if (!Intrinsics.areEqual((Object)docsEnum.getPostingsArray(), (Object)this.postingsArray)) {
                    docsEnum = new FreqProxDocsEnum(this.terms, this.postingsArray);
                }
            } else {
                docsEnum = new FreqProxDocsEnum(this.terms, this.postingsArray);
            }
            docsEnum.reset(this.sortedTermIDs[this.ord]);
            return docsEnum;
        }

        @Override
        @NotNull
        public ImpactsEnum impacts(int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public TermState termState() throws IOException {
            return new TermState(){

                public void copyFrom(TermState other) {
                    Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

