/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.OrdinalMap;
import org.gnit.lucenekmp.index.SortedDocValues;
import org.gnit.lucenekmp.jdkport.DoubleExtKt;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.search.SortField;
import org.gnit.lucenekmp.util.LongValues;
import org.gnit.lucenekmp.util.NumericUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\bf\u0018\u00002\u00020\u0001:\t\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001aJ#\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006H&\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH&R\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/index/IndexSorter;", "", "getComparableProviders", "", "Lorg/gnit/lucenekmp/index/IndexSorter$ComparableProvider;", "readers", "", "Lorg/gnit/lucenekmp/index/LeafReader;", "(Ljava/util/List;)[Lorg/gnit/lucenekmp/index/IndexSorter$ComparableProvider;", "getDocComparator", "Lorg/gnit/lucenekmp/index/IndexSorter$DocComparator;", "reader", "maxDoc", "", "providerName", "", "getProviderName", "()Ljava/lang/String;", "ComparableProvider", "DocComparator", "NumericDocValuesProvider", "SortedDocValuesProvider", "IntSorter", "LongSorter", "FloatSorter", "DoubleSorter", "StringSorter", "core"})
public interface IndexSorter {
    @NotNull
    public ComparableProvider[] getComparableProviders(@NotNull List<? extends LeafReader> var1) throws IOException;

    @NotNull
    public DocComparator getDocComparator(@NotNull LeafReader var1, int var2) throws IOException;

    @NotNull
    public String getProviderName();

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/index/IndexSorter$ComparableProvider;", "", "getAsComparableLong", "", "docID", "", "core"})
    public static interface ComparableProvider {
        public long getAsComparableLong(int var1) throws IOException;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/index/IndexSorter$DocComparator;", "", "compare", "", "docID1", "docID2", "core"})
    public static interface DocComparator {
        public int compare(int var1, int var2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ#\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/index/IndexSorter$DoubleSorter;", "Lorg/gnit/lucenekmp/index/IndexSorter;", "providerName", "", "missingValue", "", "reverse", "", "valuesProvider", "Lorg/gnit/lucenekmp/index/IndexSorter$NumericDocValuesProvider;", "<init>", "(Ljava/lang/String;Ljava/lang/Double;ZLorg/gnit/lucenekmp/index/IndexSorter$NumericDocValuesProvider;)V", "getProviderName", "()Ljava/lang/String;", "Ljava/lang/Double;", "reverseMul", "", "getComparableProviders", "", "Lorg/gnit/lucenekmp/index/IndexSorter$ComparableProvider;", "readers", "", "Lorg/gnit/lucenekmp/index/LeafReader;", "(Ljava/util/List;)[Lorg/gnit/lucenekmp/index/IndexSorter$ComparableProvider;", "getDocComparator", "Lorg/gnit/lucenekmp/index/IndexSorter$DocComparator;", "reader", "maxDoc", "core"})
    public static final class DoubleSorter
    implements IndexSorter {
        @NotNull
        private final String providerName;
        @Nullable
        private final Double missingValue;
        @NotNull
        private final NumericDocValuesProvider valuesProvider;
        private final int reverseMul;

        public DoubleSorter(@NotNull String providerName, @Nullable Double missingValue, boolean reverse, @NotNull NumericDocValuesProvider valuesProvider) {
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            Intrinsics.checkNotNullParameter((Object)valuesProvider, (String)"valuesProvider");
            this.providerName = providerName;
            this.missingValue = missingValue;
            this.valuesProvider = valuesProvider;
            this.reverseMul = reverse ? -1 : 1;
        }

        @Override
        @NotNull
        public String getProviderName() {
            return this.providerName;
        }

        @Override
        @NotNull
        public ComparableProvider[] getComparableProviders(@NotNull List<? extends LeafReader> readers) throws IOException {
            Intrinsics.checkNotNullParameter(readers, (String)"readers");
            ComparableProvider[] providers = new ComparableProvider[readers.size()];
            Double d = this.missingValue;
            long missingValueBits = DoubleExtKt.doubleToLongBits(DoubleCompanionObject.INSTANCE, d != null ? d : 0.0);
            int n = ((Collection)readers).size();
            for (int readerIndex = 0; readerIndex < n; ++readerIndex) {
                NumericDocValues values2 = this.valuesProvider.get(readers.get(readerIndex));
                providers[readerIndex] = new ComparableProvider(values2, missingValueBits){
                    final /* synthetic */ NumericDocValues $values;
                    final /* synthetic */ long $missingValueBits;
                    {
                        this.$values = $values;
                        this.$missingValueBits = $missingValueBits;
                    }

                    public long getAsComparableLong(int docID) throws IOException {
                        long valueBits = this.$values.advanceExact(docID) ? this.$values.longValue() : this.$missingValueBits;
                        return NumericUtils.INSTANCE.sortableDoubleBits(valueBits);
                    }
                };
            }
            return providers;
        }

        @Override
        @NotNull
        public DocComparator getDocComparator(@NotNull LeafReader reader2, int maxDoc) throws IOException {
            int docID;
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            NumericDocValues dvs = this.valuesProvider.get(reader2);
            double[] values2 = new double[maxDoc];
            if (this.missingValue != null) {
                ArraysKt.fill$default((double[])values2, (double)this.missingValue, (int)0, (int)0, (int)6, null);
            }
            while ((docID = dvs.nextDoc()) != Integer.MAX_VALUE) {
                values2[docID] = DoubleExtKt.longBitsToDouble(DoubleCompanionObject.INSTANCE, dvs.longValue());
            }
            return new DocComparator(this, values2){
                final /* synthetic */ DoubleSorter this$0;
                final /* synthetic */ double[] $values;
                {
                    this.this$0 = $receiver;
                    this.$values = $values;
                }

                public int compare(int docID1, int docID2) {
                    return DoubleSorter.access$getReverseMul$p(this.this$0) * DoubleExtKt.compare(DoubleCompanionObject.INSTANCE, this.$values[docID1], this.$values[docID2]);
                }
            };
        }

        public static final /* synthetic */ int access$getReverseMul$p(DoubleSorter $this) {
            return $this.reverseMul;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ#\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/index/IndexSorter$FloatSorter;", "Lorg/gnit/lucenekmp/index/IndexSorter;", "providerName", "", "missingValue", "", "reverse", "", "valuesProvider", "Lorg/gnit/lucenekmp/index/IndexSorter$NumericDocValuesProvider;", "<init>", "(Ljava/lang/String;Ljava/lang/Float;ZLorg/gnit/lucenekmp/index/IndexSorter$NumericDocValuesProvider;)V", "getProviderName", "()Ljava/lang/String;", "Ljava/lang/Float;", "reverseMul", "", "getComparableProviders", "", "Lorg/gnit/lucenekmp/index/IndexSorter$ComparableProvider;", "readers", "", "Lorg/gnit/lucenekmp/index/LeafReader;", "(Ljava/util/List;)[Lorg/gnit/lucenekmp/index/IndexSorter$ComparableProvider;", "getDocComparator", "Lorg/gnit/lucenekmp/index/IndexSorter$DocComparator;", "reader", "maxDoc", "core"})
    public static final class FloatSorter
    implements IndexSorter {
        @NotNull
        private final String providerName;
        @Nullable
        private final Float missingValue;
        @NotNull
        private final NumericDocValuesProvider valuesProvider;
        private final int reverseMul;

        public FloatSorter(@NotNull String providerName, @Nullable Float missingValue, boolean reverse, @NotNull NumericDocValuesProvider valuesProvider) {
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            Intrinsics.checkNotNullParameter((Object)valuesProvider, (String)"valuesProvider");
            this.providerName = providerName;
            this.missingValue = missingValue;
            this.valuesProvider = valuesProvider;
            this.reverseMul = reverse ? -1 : 1;
        }

        @Override
        @NotNull
        public String getProviderName() {
            return this.providerName;
        }

        @Override
        @NotNull
        public ComparableProvider[] getComparableProviders(@NotNull List<? extends LeafReader> readers) throws IOException {
            Intrinsics.checkNotNullParameter(readers, (String)"readers");
            ComparableProvider[] providers = new ComparableProvider[readers.size()];
            Float f = this.missingValue;
            int missValueBits = FloatExtKt.floatToIntBits(FloatCompanionObject.INSTANCE, f != null ? f.floatValue() : 0.0f);
            int n = ((Collection)readers).size();
            for (int readerIndex = 0; readerIndex < n; ++readerIndex) {
                NumericDocValues values2 = this.valuesProvider.get(readers.get(readerIndex));
                providers[readerIndex] = new ComparableProvider(values2, missValueBits){
                    final /* synthetic */ NumericDocValues $values;
                    final /* synthetic */ int $missValueBits;
                    {
                        this.$values = $values;
                        this.$missValueBits = $missValueBits;
                    }

                    public long getAsComparableLong(int docID) throws IOException {
                        int valueBits = this.$values.advanceExact(docID) ? (int)this.$values.longValue() : this.$missValueBits;
                        return NumericUtils.INSTANCE.sortableFloatBits(valueBits);
                    }
                };
            }
            return providers;
        }

        @Override
        @NotNull
        public DocComparator getDocComparator(@NotNull LeafReader reader2, int maxDoc) throws IOException {
            int docID;
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            NumericDocValues dvs = this.valuesProvider.get(reader2);
            float[] values2 = new float[maxDoc];
            if (this.missingValue != null) {
                ArraysKt.fill$default((float[])values2, (float)this.missingValue.floatValue(), (int)0, (int)0, (int)6, null);
            }
            while ((docID = dvs.nextDoc()) != Integer.MAX_VALUE) {
                values2[docID] = FloatExtKt.intBitsToFloat(FloatCompanionObject.INSTANCE, (int)dvs.longValue());
            }
            return new DocComparator(this, values2){
                final /* synthetic */ FloatSorter this$0;
                final /* synthetic */ float[] $values;
                {
                    this.this$0 = $receiver;
                    this.$values = $values;
                }

                public int compare(int docID1, int docID2) {
                    return FloatSorter.access$getReverseMul$p(this.this$0) * FloatExtKt.compare(FloatCompanionObject.INSTANCE, this.$values[docID1], this.$values[docID2]);
                }
            };
        }

        public static final /* synthetic */ int access$getReverseMul$p(FloatSorter $this) {
            return $this.reverseMul;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ#\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0005H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/index/IndexSorter$IntSorter;", "Lorg/gnit/lucenekmp/index/IndexSorter;", "providerName", "", "missingValue", "", "reverse", "", "valuesProvider", "Lorg/gnit/lucenekmp/index/IndexSorter$NumericDocValuesProvider;", "<init>", "(Ljava/lang/String;Ljava/lang/Integer;ZLorg/gnit/lucenekmp/index/IndexSorter$NumericDocValuesProvider;)V", "getProviderName", "()Ljava/lang/String;", "Ljava/lang/Integer;", "reverseMul", "getComparableProviders", "", "Lorg/gnit/lucenekmp/index/IndexSorter$ComparableProvider;", "readers", "", "Lorg/gnit/lucenekmp/index/LeafReader;", "(Ljava/util/List;)[Lorg/gnit/lucenekmp/index/IndexSorter$ComparableProvider;", "getDocComparator", "Lorg/gnit/lucenekmp/index/IndexSorter$DocComparator;", "reader", "maxDoc", "core"})
    public static final class IntSorter
    implements IndexSorter {
        @NotNull
        private final String providerName;
        @Nullable
        private final Integer missingValue;
        @NotNull
        private final NumericDocValuesProvider valuesProvider;
        private final int reverseMul;

        public IntSorter(@NotNull String providerName, @Nullable Integer missingValue, boolean reverse, @NotNull NumericDocValuesProvider valuesProvider) {
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            Intrinsics.checkNotNullParameter((Object)valuesProvider, (String)"valuesProvider");
            this.providerName = providerName;
            this.missingValue = missingValue;
            this.valuesProvider = valuesProvider;
            this.reverseMul = reverse ? -1 : 1;
        }

        @Override
        @NotNull
        public String getProviderName() {
            return this.providerName;
        }

        @Override
        @NotNull
        public ComparableProvider[] getComparableProviders(@NotNull List<? extends LeafReader> readers) throws IOException {
            Intrinsics.checkNotNullParameter(readers, (String)"readers");
            ComparableProvider[] providers = new ComparableProvider[readers.size()];
            long missingValue = this.missingValue != null ? (long)this.missingValue.intValue() : 0L;
            int n = ((Collection)readers).size();
            for (int readerIndex = 0; readerIndex < n; ++readerIndex) {
                NumericDocValues values2 = this.valuesProvider.get(readers.get(readerIndex));
                providers[readerIndex] = new ComparableProvider(values2, missingValue){
                    final /* synthetic */ NumericDocValues $values;
                    final /* synthetic */ long $missingValue;
                    {
                        this.$values = $values;
                        this.$missingValue = $missingValue;
                    }

                    public long getAsComparableLong(int docID) {
                        return this.$values.advanceExact(docID) ? this.$values.longValue() : this.$missingValue;
                    }
                };
            }
            return providers;
        }

        @Override
        @NotNull
        public DocComparator getDocComparator(@NotNull LeafReader reader2, int maxDoc) throws IOException {
            int docID;
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            NumericDocValues dvs = this.valuesProvider.get(reader2);
            int[] values2 = new int[maxDoc];
            if (this.missingValue != null) {
                ArraysKt.fill$default((int[])values2, (int)this.missingValue, (int)0, (int)0, (int)6, null);
            }
            while ((docID = dvs.nextDoc()) != Integer.MAX_VALUE) {
                values2[docID] = (int)dvs.longValue();
            }
            return new DocComparator(this, values2){
                final /* synthetic */ IntSorter this$0;
                final /* synthetic */ int[] $values;
                {
                    this.this$0 = $receiver;
                    this.$values = $values;
                }

                public int compare(int docID1, int docID2) {
                    return IntSorter.access$getReverseMul$p(this.this$0) * IntExtKt.compare(IntCompanionObject.INSTANCE, this.$values[docID1], this.$values[docID2]);
                }
            };
        }

        public static final /* synthetic */ int access$getReverseMul$p(IntSorter $this) {
            return $this.reverseMul;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ#\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/index/IndexSorter$LongSorter;", "Lorg/gnit/lucenekmp/index/IndexSorter;", "providerName", "", "missingValue", "", "reverse", "", "valuesProvider", "Lorg/gnit/lucenekmp/index/IndexSorter$NumericDocValuesProvider;", "<init>", "(Ljava/lang/String;Ljava/lang/Long;ZLorg/gnit/lucenekmp/index/IndexSorter$NumericDocValuesProvider;)V", "getProviderName", "()Ljava/lang/String;", "Ljava/lang/Long;", "reverseMul", "", "getComparableProviders", "", "Lorg/gnit/lucenekmp/index/IndexSorter$ComparableProvider;", "readers", "", "Lorg/gnit/lucenekmp/index/LeafReader;", "(Ljava/util/List;)[Lorg/gnit/lucenekmp/index/IndexSorter$ComparableProvider;", "getDocComparator", "Lorg/gnit/lucenekmp/index/IndexSorter$DocComparator;", "reader", "maxDoc", "core"})
    public static final class LongSorter
    implements IndexSorter {
        @NotNull
        private final String providerName;
        @Nullable
        private final Long missingValue;
        @NotNull
        private final NumericDocValuesProvider valuesProvider;
        private final int reverseMul;

        public LongSorter(@NotNull String providerName, @Nullable Long missingValue, boolean reverse, @NotNull NumericDocValuesProvider valuesProvider) {
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            Intrinsics.checkNotNullParameter((Object)valuesProvider, (String)"valuesProvider");
            this.providerName = providerName;
            this.missingValue = missingValue;
            this.valuesProvider = valuesProvider;
            this.reverseMul = reverse ? -1 : 1;
        }

        @Override
        @NotNull
        public String getProviderName() {
            return this.providerName;
        }

        @Override
        @NotNull
        public ComparableProvider[] getComparableProviders(@NotNull List<? extends LeafReader> readers) throws IOException {
            Intrinsics.checkNotNullParameter(readers, (String)"readers");
            ComparableProvider[] providers = new ComparableProvider[readers.size()];
            Long l = this.missingValue;
            long missingValue = l != null ? l : 0L;
            int n = ((Collection)readers).size();
            for (int readerIndex = 0; readerIndex < n; ++readerIndex) {
                NumericDocValues values2 = this.valuesProvider.get(readers.get(readerIndex));
                providers[readerIndex] = new ComparableProvider(values2, missingValue){
                    final /* synthetic */ NumericDocValues $values;
                    final /* synthetic */ long $missingValue;
                    {
                        this.$values = $values;
                        this.$missingValue = $missingValue;
                    }

                    public long getAsComparableLong(int docID) throws IOException {
                        return this.$values.advanceExact(docID) ? this.$values.longValue() : this.$missingValue;
                    }
                };
            }
            return providers;
        }

        @Override
        @NotNull
        public DocComparator getDocComparator(@NotNull LeafReader reader2, int maxDoc) throws IOException {
            int docID;
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            NumericDocValues dvs = this.valuesProvider.get(reader2);
            long[] values2 = new long[maxDoc];
            if (this.missingValue != null) {
                ArraysKt.fill$default((long[])values2, (long)this.missingValue, (int)0, (int)0, (int)6, null);
            }
            while ((docID = dvs.nextDoc()) != Integer.MAX_VALUE) {
                values2[docID] = dvs.longValue();
            }
            return new DocComparator(this, values2){
                final /* synthetic */ LongSorter this$0;
                final /* synthetic */ long[] $values;
                {
                    this.this$0 = $receiver;
                    this.$values = $values;
                }

                public int compare(int docID1, int docID2) {
                    return LongSorter.access$getReverseMul$p(this.this$0) * LongExtKt.compare(LongCompanionObject.INSTANCE, this.$values[docID1], this.$values[docID2]);
                }
            };
        }

        public static final /* synthetic */ int access$getReverseMul$p(LongSorter $this) {
            return $this.reverseMul;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/index/IndexSorter$NumericDocValuesProvider;", "", "get", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "reader", "Lorg/gnit/lucenekmp/index/LeafReader;", "core"})
    public static interface NumericDocValuesProvider {
        @NotNull
        public NumericDocValues get(@NotNull LeafReader var1) throws IOException;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/index/IndexSorter$SortedDocValuesProvider;", "", "get", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "reader", "Lorg/gnit/lucenekmp/index/LeafReader;", "core"})
    public static interface SortedDocValuesProvider {
        @NotNull
        public SortedDocValues get(@NotNull LeafReader var1) throws IOException;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ#\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/index/IndexSorter$StringSorter;", "Lorg/gnit/lucenekmp/index/IndexSorter;", "providerName", "", "missingValue", "", "reverse", "", "valuesProvider", "Lorg/gnit/lucenekmp/index/IndexSorter$SortedDocValuesProvider;", "<init>", "(Ljava/lang/String;Ljava/lang/Object;ZLorg/gnit/lucenekmp/index/IndexSorter$SortedDocValuesProvider;)V", "getProviderName", "()Ljava/lang/String;", "reverseMul", "", "getComparableProviders", "", "Lorg/gnit/lucenekmp/index/IndexSorter$ComparableProvider;", "readers", "", "Lorg/gnit/lucenekmp/index/LeafReader;", "(Ljava/util/List;)[Lorg/gnit/lucenekmp/index/IndexSorter$ComparableProvider;", "getDocComparator", "Lorg/gnit/lucenekmp/index/IndexSorter$DocComparator;", "reader", "maxDoc", "core"})
    @SourceDebugExtension(value={"SMAP\nIndexSorter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexSorter.kt\norg/gnit/lucenekmp/index/IndexSorter$StringSorter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,401:1\n1#2:402\n*E\n"})
    public static class StringSorter
    implements IndexSorter {
        @NotNull
        private final String providerName;
        @NotNull
        private final Object missingValue;
        @NotNull
        private final SortedDocValuesProvider valuesProvider;
        private final int reverseMul;

        public StringSorter(@NotNull String providerName, @NotNull Object missingValue, boolean reverse, @NotNull SortedDocValuesProvider valuesProvider) {
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            Intrinsics.checkNotNullParameter((Object)missingValue, (String)"missingValue");
            Intrinsics.checkNotNullParameter((Object)valuesProvider, (String)"valuesProvider");
            this.providerName = providerName;
            this.missingValue = missingValue;
            this.valuesProvider = valuesProvider;
            this.reverseMul = reverse ? -1 : 1;
        }

        @Override
        @NotNull
        public String getProviderName() {
            return this.providerName;
        }

        @Override
        @NotNull
        public ComparableProvider[] getComparableProviders(@NotNull List<? extends LeafReader> readers) throws IOException {
            Intrinsics.checkNotNullParameter(readers, (String)"readers");
            ComparableProvider[] providers = new ComparableProvider[readers.size()];
            SortedDocValues[] values2 = new SortedDocValues[readers.size()];
            int n = ((Collection)readers).size();
            for (int i = 0; i < n; ++i) {
                SortedDocValues sorted;
                values2[i] = sorted = this.valuesProvider.get(readers.get(i));
            }
            OrdinalMap ordinalMap = OrdinalMap.Companion.build(null, values2, 0.25f);
            int missingOrd = this.missingValue == SortField.Companion.getSTRING_LAST() ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            int n2 = ((Collection)readers).size();
            for (int readerIndex = 0; readerIndex < n2; ++readerIndex) {
                SortedDocValues readerValues = values2[readerIndex];
                LongValues globalOrds = ordinalMap.getGlobalOrds(readerIndex);
                providers[readerIndex] = new ComparableProvider(readerValues, globalOrds, missingOrd){
                    final /* synthetic */ SortedDocValues $readerValues;
                    final /* synthetic */ LongValues $globalOrds;
                    final /* synthetic */ int $missingOrd;
                    {
                        this.$readerValues = $readerValues;
                        this.$globalOrds = $globalOrds;
                        this.$missingOrd = $missingOrd;
                    }

                    public long getAsComparableLong(int docID) throws IOException {
                        return this.$readerValues.advanceExact(docID) ? this.$globalOrds.get(this.$readerValues.ordValue()) : (long)this.$missingOrd;
                    }
                };
            }
            return providers;
        }

        @Override
        @NotNull
        public DocComparator getDocComparator(@NotNull LeafReader reader2, int maxDoc) throws IOException {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            SortedDocValues sorted = this.valuesProvider.get(reader2);
            int missingOrd = this.missingValue == SortField.Companion.getSTRING_LAST() ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            int[] ords = new int[maxDoc];
            ArraysKt.fill$default((int[])ords, (int)missingOrd, (int)0, (int)0, (int)6, null);
            int docID = 0;
            while (true) {
                int n;
                int it = n = sorted.nextDoc();
                boolean bl = false;
                docID = it;
                if (n == Integer.MAX_VALUE) break;
                ords[docID] = sorted.ordValue();
            }
            return new DocComparator(this, ords){
                final /* synthetic */ StringSorter this$0;
                final /* synthetic */ int[] $ords;
                {
                    this.this$0 = $receiver;
                    this.$ords = $ords;
                }

                public int compare(int docID1, int docID2) {
                    return StringSorter.access$getReverseMul$p(this.this$0) * IntExtKt.compare(IntCompanionObject.INSTANCE, this.$ords[docID1], this.$ords[docID2]);
                }
            };
        }

        public static final /* synthetic */ int access$getReverseMul$p(StringSorter $this) {
            return $this.reverseMul;
        }
    }
}

