/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.BinaryDocValues;
import org.gnit.lucenekmp.index.ByteVectorValues;
import org.gnit.lucenekmp.index.DocValuesSkipper;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.FloatVectorValues;
import org.gnit.lucenekmp.index.IndexReader;
import org.gnit.lucenekmp.index.LeafMetaData;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.SortedDocValues;
import org.gnit.lucenekmp.index.SortedNumericDocValues;
import org.gnit.lucenekmp.index.SortedSetDocValues;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.search.KnnCollector;
import org.gnit.lucenekmp.search.TopDocs;
import org.gnit.lucenekmp.search.TopDocsCollector;
import org.gnit.lucenekmp.search.TopKnnCollector;
import org.gnit.lucenekmp.util.Bits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u000eJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0012\u0010'\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u0014\u001a\u00020\u0015H&J.\u0010.\u001a\u00020/2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000eJ.\u0010.\u001a\u00020/2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00100\u001a\u0002062\u0006\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000eJ(\u0010.\u001a\u0002072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00100\u001a\u0002012\u0006\u00108\u001a\u0002092\u0006\u00103\u001a\u000204H&J(\u0010.\u001a\u0002072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00100\u001a\u0002062\u0006\u00108\u001a\u0002092\u0006\u00103\u001a\u000204H&J\u0012\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010\u0014\u001a\u00020\u0015H&J\b\u0010C\u001a\u000207H&R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010:\u001a\u00020;X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0014\u0010>\u001a\u0004\u0018\u000104X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0012\u0010D\u001a\u00020EX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010G\u00a8\u0006H"}, d2={"Lorg/gnit/lucenekmp/index/LeafReader;", "Lorg/gnit/lucenekmp/index/IndexReader;", "<init>", "()V", "readerContext", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "context", "getContext", "()Lorg/gnit/lucenekmp/index/LeafReaderContext;", "coreCacheHelper", "Lorg/gnit/lucenekmp/index/IndexReader$CacheHelper;", "getCoreCacheHelper", "()Lorg/gnit/lucenekmp/index/IndexReader$CacheHelper;", "docFreq", "", "term", "Lorg/gnit/lucenekmp/index/Term;", "totalTermFreq", "", "getSumDocFreq", "field", "", "getDocCount", "getSumTotalTermFreq", "terms", "Lorg/gnit/lucenekmp/index/Terms;", "postings", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "flags", "getNumericDocValues", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "getBinaryDocValues", "Lorg/gnit/lucenekmp/index/BinaryDocValues;", "getSortedDocValues", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "getSortedNumericDocValues", "Lorg/gnit/lucenekmp/index/SortedNumericDocValues;", "getSortedSetDocValues", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "getNormValues", "getDocValuesSkipper", "Lorg/gnit/lucenekmp/index/DocValuesSkipper;", "getFloatVectorValues", "Lorg/gnit/lucenekmp/index/FloatVectorValues;", "getByteVectorValues", "Lorg/gnit/lucenekmp/index/ByteVectorValues;", "searchNearestVectors", "Lorg/gnit/lucenekmp/search/TopDocs;", "target", "", "k", "acceptDocs", "Lorg/gnit/lucenekmp/util/Bits;", "visitedLimit", "", "", "knnCollector", "Lorg/gnit/lucenekmp/search/KnnCollector;", "fieldInfos", "Lorg/gnit/lucenekmp/index/FieldInfos;", "getFieldInfos", "()Lorg/gnit/lucenekmp/index/FieldInfos;", "liveDocs", "getLiveDocs", "()Lorg/gnit/lucenekmp/util/Bits;", "getPointValues", "Lorg/gnit/lucenekmp/index/PointValues;", "checkIntegrity", "metaData", "Lorg/gnit/lucenekmp/index/LeafMetaData;", "getMetaData", "()Lorg/gnit/lucenekmp/index/LeafMetaData;", "core"})
public abstract class LeafReader
extends IndexReader {
    @NotNull
    private final LeafReaderContext readerContext = new LeafReaderContext(this);

    protected LeafReader() {
    }

    @Override
    @NotNull
    public LeafReaderContext getContext() {
        this.ensureOpen();
        return this.readerContext;
    }

    @NotNull
    public abstract IndexReader.CacheHelper getCoreCacheHelper();

    @Override
    public int docFreq(@NotNull Term term) throws IOException {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        Terms terms = Terms.Companion.getTerms(this, term.field());
        TermsEnum termsEnum = terms.iterator();
        return termsEnum.seekExact(term.bytes()) ? termsEnum.docFreq() : 0;
    }

    @Override
    public long totalTermFreq(@NotNull Term term) throws IOException {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        Terms terms = Terms.Companion.getTerms(this, term.field());
        TermsEnum termsEnum = terms.iterator();
        return termsEnum.seekExact(term.bytes()) ? termsEnum.totalTermFreq() : 0L;
    }

    @Override
    public long getSumDocFreq(@NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Terms terms = this.terms(field);
        if (terms == null) {
            return 0L;
        }
        return terms.getSumDocFreq();
    }

    @Override
    public int getDocCount(@NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Terms terms = this.terms(field);
        if (terms == null) {
            return 0;
        }
        return terms.getDocCount();
    }

    @Override
    public long getSumTotalTermFreq(@NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Terms terms = this.terms(field);
        if (terms == null) {
            return 0L;
        }
        return terms.getSumTotalTermFreq();
    }

    @Nullable
    public abstract Terms terms(@NotNull String var1) throws IOException;

    @Nullable
    public final PostingsEnum postings(@NotNull Term term, int flags) throws IOException {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        if (term.field() == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        if (term.bytes() == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Terms terms = Terms.Companion.getTerms(this, term.field());
        TermsEnum termsEnum = terms.iterator();
        if (termsEnum.seekExact(term.bytes())) {
            return termsEnum.postings(null, flags);
        }
        return null;
    }

    @Nullable
    public final PostingsEnum postings(@NotNull Term term) throws IOException {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        return this.postings(term, PostingsEnum.Companion.getFREQS());
    }

    @Nullable
    public abstract NumericDocValues getNumericDocValues(@NotNull String var1) throws IOException;

    @Nullable
    public abstract BinaryDocValues getBinaryDocValues(@NotNull String var1) throws IOException;

    @Nullable
    public abstract SortedDocValues getSortedDocValues(@NotNull String var1) throws IOException;

    @Nullable
    public abstract SortedNumericDocValues getSortedNumericDocValues(@NotNull String var1) throws IOException;

    @Nullable
    public abstract SortedSetDocValues getSortedSetDocValues(@NotNull String var1) throws IOException;

    @Nullable
    public abstract NumericDocValues getNormValues(@NotNull String var1) throws IOException;

    @Nullable
    public abstract DocValuesSkipper getDocValuesSkipper(@NotNull String var1) throws IOException;

    @Nullable
    public abstract FloatVectorValues getFloatVectorValues(@NotNull String var1) throws IOException;

    @Nullable
    public abstract ByteVectorValues getByteVectorValues(@NotNull String var1) throws IOException;

    @NotNull
    public final TopDocs searchNearestVectors(@NotNull String field, @NotNull float[] target, int k, @NotNull Bits acceptDocs, int visitedLimit) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)acceptDocs, (String)"acceptDocs");
        int k2 = k;
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getVectorDimension() == 0) {
            return TopDocsCollector.Companion.getEMPTY_TOPDOCS();
        }
        FloatVectorValues floatVectorValues = this.getFloatVectorValues(fi.getName());
        if (floatVectorValues == null) {
            return TopDocsCollector.Companion.getEMPTY_TOPDOCS();
        }
        if ((k2 = Math.min(k2, floatVectorValues.size())) == 0) {
            return TopDocsCollector.Companion.getEMPTY_TOPDOCS();
        }
        KnnCollector collector2 = new TopKnnCollector(k2, visitedLimit, null, 4, null);
        this.searchNearestVectors(field, target, collector2, acceptDocs);
        TopDocs topDocs = collector2.topDocs();
        Intrinsics.checkNotNull((Object)topDocs);
        return topDocs;
    }

    @NotNull
    public final TopDocs searchNearestVectors(@NotNull String field, @NotNull byte[] target, int k, @NotNull Bits acceptDocs, int visitedLimit) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)acceptDocs, (String)"acceptDocs");
        int k2 = k;
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getVectorDimension() == 0) {
            return TopDocsCollector.Companion.getEMPTY_TOPDOCS();
        }
        ByteVectorValues byteVectorValues = this.getByteVectorValues(fi.getName());
        if (byteVectorValues == null) {
            return TopDocsCollector.Companion.getEMPTY_TOPDOCS();
        }
        if ((k2 = Math.min(k2, byteVectorValues.size())) == 0) {
            return TopDocsCollector.Companion.getEMPTY_TOPDOCS();
        }
        KnnCollector collector2 = new TopKnnCollector(k2, visitedLimit, null, 4, null);
        this.searchNearestVectors(field, target, collector2, acceptDocs);
        TopDocs topDocs = collector2.topDocs();
        Intrinsics.checkNotNull((Object)topDocs);
        return topDocs;
    }

    public abstract void searchNearestVectors(@NotNull String var1, @NotNull float[] var2, @NotNull KnnCollector var3, @NotNull Bits var4) throws IOException;

    public abstract void searchNearestVectors(@NotNull String var1, @NotNull byte[] var2, @NotNull KnnCollector var3, @NotNull Bits var4) throws IOException;

    @NotNull
    public abstract FieldInfos getFieldInfos();

    @Nullable
    public abstract Bits getLiveDocs();

    @Nullable
    public abstract PointValues getPointValues(@NotNull String var1) throws IOException;

    public abstract void checkIntegrity() throws IOException;

    @NotNull
    public abstract LeafMetaData getMetaData();
}

