/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.analysis.Analyzer;
import org.gnit.lucenekmp.codecs.Codec;
import org.gnit.lucenekmp.index.ConcurrentMergeScheduler;
import org.gnit.lucenekmp.index.FlushByRamOrCountsPolicy;
import org.gnit.lucenekmp.index.FlushPolicy;
import org.gnit.lucenekmp.index.IndexCommit;
import org.gnit.lucenekmp.index.IndexDeletionPolicy;
import org.gnit.lucenekmp.index.IndexWriter;
import org.gnit.lucenekmp.index.IndexWriterConfig;
import org.gnit.lucenekmp.index.IndexWriterEventListener;
import org.gnit.lucenekmp.index.KeepOnlyLastCommitDeletionPolicy;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.MergePolicy;
import org.gnit.lucenekmp.index.MergeScheduler;
import org.gnit.lucenekmp.index.TieredMergePolicy;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.Sort;
import org.gnit.lucenekmp.search.similarities.Similarity;
import org.gnit.lucenekmp.util.InfoStream;
import org.gnit.lucenekmp.util.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0015J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0015H\u0016J\u0011\u0010\u0012\u001a\u00020\u00002\u0007\u0010\u0091\u0001\u001a\u00020\u000fH\u0016J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010N\u001a\u00020\u00002\u0006\u0010J\u001a\u00020KH\u0016J\u0010\u0010a\u001a\u00020\u00002\u0006\u0010_\u001a\u00020PH\u0016J\u0011\u0010\u0096\u0001\u001a\u00020\u00002\u0006\u0010\u007f\u001a\u00020PH\u0016J\t\u0010\u0099\u0001\u001a\u00020tH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001c\u001a\u00020\u001dX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020)X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R$\u0010/\u001a\u00020\t2\u0006\u0010.\u001a\u00020\t@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u000b\"\u0004\b1\u0010\rR\u001a\u00102\u001a\u000203X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u000209X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001a\u0010>\u001a\u00020?X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u001a\u0010D\u001a\u00020EX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u001a\u0010J\u001a\u00020KX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR$\u0010Q\u001a\u00020P2\u0006\u0010.\u001a\u00020P@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR\u001a\u0010V\u001a\u00020WX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010Y\"\u0004\bZ\u0010[R$\u0010\\\u001a\u00020\t2\u0006\u0010.\u001a\u00020\t@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010\u000b\"\u0004\b^\u0010\rR$\u0010_\u001a\u00020P2\u0006\u0010.\u001a\u00020P@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010S\"\u0004\ba\u0010UR$\u0010b\u001a\u00020P2\u0006\u0010.\u001a\u00020P@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u0010S\"\u0004\bd\u0010UR\u001c\u0010e\u001a\u0004\u0018\u00010fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bg\u0010h\"\u0004\bi\u0010jR0\u0010k\u001a\u0016\u0012\u0004\u0012\u00020m\u0018\u00010lj\n\u0012\u0004\u0012\u00020m\u0018\u0001`n8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bo\u0010p\"\u0004\bq\u0010rR4\u0010u\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010t0s2\u000e\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010t0s@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bv\u0010w\"\u0004\bx\u0010yR(\u0010z\u001a\u0004\u0018\u00010t2\b\u0010.\u001a\u0004\u0018\u00010t@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b{\u0010|\"\u0004\b}\u0010~R&\u0010\u007f\u001a\u00020P2\u0006\u0010.\u001a\u00020P@DX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0080\u0001\u0010S\"\u0005\b\u0081\u0001\u0010UR+\u0010\u0082\u0001\u001a\u0004\u0018\u00010t2\b\u0010.\u001a\u0004\u0018\u00010t@DX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0083\u0001\u0010|\"\u0005\b\u0084\u0001\u0010~R+\u0010\u0086\u0001\u001a\u00030\u0085\u00012\u0007\u0010.\u001a\u00030\u0085\u0001@DX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0087\u0001\u0010\u0088\u0001\"\u0006\b\u0089\u0001\u0010\u008a\u0001R \u0010\u008b\u0001\u001a\u00030\u008c\u0001X\u0084\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u008d\u0001\u0010\u008e\u0001\"\u0006\b\u008f\u0001\u0010\u0090\u0001R\u0016\u0010\u0092\u0001\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u0093\u0001\u0010\u001fR\u0018\u0010\u0094\u0001\u001a\u0004\u0018\u00010#8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u0095\u0001\u0010%R\u0015\u0010\u0097\u0001\u001a\u00030\u008c\u00018F\u00a2\u0006\b\u001a\u0006\b\u0098\u0001\u0010\u008e\u0001\u00a8\u0006\u009a\u0001"}, d2={"Lorg/gnit/lucenekmp/index/LiveIndexWriterConfig;", "", "analyzer", "Lorg/gnit/lucenekmp/analysis/Analyzer;", "<init>", "(Lorg/gnit/lucenekmp/analysis/Analyzer;)V", "getAnalyzer", "()Lorg/gnit/lucenekmp/analysis/Analyzer;", "maxBufferedDocs", "", "getMaxBufferedDocs", "()I", "setMaxBufferedDocs", "(I)V", "rAMBufferSizeMB", "", "getRAMBufferSizeMB", "()D", "setRAMBufferSizeMB", "(D)V", "mergedSegmentWarmer", "Lorg/gnit/lucenekmp/index/IndexWriter$IndexReaderWarmer;", "getMergedSegmentWarmer", "()Lorg/gnit/lucenekmp/index/IndexWriter$IndexReaderWarmer;", "setMergedSegmentWarmer", "(Lorg/gnit/lucenekmp/index/IndexWriter$IndexReaderWarmer;)V", "get", "mergeSegmentWarmer", "delPolicy", "Lorg/gnit/lucenekmp/index/IndexDeletionPolicy;", "getDelPolicy", "()Lorg/gnit/lucenekmp/index/IndexDeletionPolicy;", "setDelPolicy", "(Lorg/gnit/lucenekmp/index/IndexDeletionPolicy;)V", "commit", "Lorg/gnit/lucenekmp/index/IndexCommit;", "getCommit", "()Lorg/gnit/lucenekmp/index/IndexCommit;", "setCommit", "(Lorg/gnit/lucenekmp/index/IndexCommit;)V", "openMode", "Lorg/gnit/lucenekmp/index/IndexWriterConfig$OpenMode;", "getOpenMode", "()Lorg/gnit/lucenekmp/index/IndexWriterConfig$OpenMode;", "setOpenMode", "(Lorg/gnit/lucenekmp/index/IndexWriterConfig$OpenMode;)V", "value", "createdVersionMajor", "getCreatedVersionMajor", "setCreatedVersionMajor", "similarity", "Lorg/gnit/lucenekmp/search/similarities/Similarity;", "getSimilarity", "()Lorg/gnit/lucenekmp/search/similarities/Similarity;", "setSimilarity", "(Lorg/gnit/lucenekmp/search/similarities/Similarity;)V", "mergeScheduler", "Lorg/gnit/lucenekmp/index/MergeScheduler;", "getMergeScheduler", "()Lorg/gnit/lucenekmp/index/MergeScheduler;", "setMergeScheduler", "(Lorg/gnit/lucenekmp/index/MergeScheduler;)V", "codec", "Lorg/gnit/lucenekmp/codecs/Codec;", "getCodec", "()Lorg/gnit/lucenekmp/codecs/Codec;", "setCodec", "(Lorg/gnit/lucenekmp/codecs/Codec;)V", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "getInfoStream", "()Lorg/gnit/lucenekmp/util/InfoStream;", "setInfoStream", "(Lorg/gnit/lucenekmp/util/InfoStream;)V", "mergePolicy", "Lorg/gnit/lucenekmp/index/MergePolicy;", "getMergePolicy", "()Lorg/gnit/lucenekmp/index/MergePolicy;", "setMergePolicy", "(Lorg/gnit/lucenekmp/index/MergePolicy;)V", "", "readerPooling", "getReaderPooling", "()Z", "setReaderPooling", "(Z)V", "flushPolicy", "Lorg/gnit/lucenekmp/index/FlushPolicy;", "getFlushPolicy", "()Lorg/gnit/lucenekmp/index/FlushPolicy;", "setFlushPolicy", "(Lorg/gnit/lucenekmp/index/FlushPolicy;)V", "rAMPerThreadHardLimitMB", "getRAMPerThreadHardLimitMB", "setRAMPerThreadHardLimitMB", "useCompoundFile", "getUseCompoundFile", "setUseCompoundFile", "commitOnClose", "getCommitOnClose", "setCommitOnClose", "indexSort", "Lorg/gnit/lucenekmp/search/Sort;", "getIndexSort", "()Lorg/gnit/lucenekmp/search/Sort;", "setIndexSort", "(Lorg/gnit/lucenekmp/search/Sort;)V", "leafSorter", "Ljava/util/Comparator;", "Lorg/gnit/lucenekmp/index/LeafReader;", "Lkotlin/Comparator;", "getLeafSorter", "()Ljava/util/Comparator;", "setLeafSorter", "(Ljava/util/Comparator;)V", "", "", "indexSortFields", "getIndexSortFields", "()Ljava/util/Set;", "setIndexSortFields", "(Ljava/util/Set;)V", "parentField", "getParentField", "()Ljava/lang/String;", "setParentField", "(Ljava/lang/String;)V", "checkPendingFlushOnUpdate", "getCheckPendingFlushOnUpdate", "setCheckPendingFlushOnUpdate", "softDeletesField", "getSoftDeletesField", "setSoftDeletesField", "", "maxFullFlushMergeWaitMillis", "getMaxFullFlushMergeWaitMillis", "()J", "setMaxFullFlushMergeWaitMillis", "(J)V", "eventListener", "Lorg/gnit/lucenekmp/index/IndexWriterEventListener;", "getEventListener", "()Lorg/gnit/lucenekmp/index/IndexWriterEventListener;", "setEventListener", "(Lorg/gnit/lucenekmp/index/IndexWriterEventListener;)V", "ramBufferSizeMB", "indexDeletionPolicy", "getIndexDeletionPolicy", "indexCommit", "getIndexCommit", "setCheckPendingFlushUpdate", "indexWriterEventListener", "getIndexWriterEventListener", "toString", "core"})
@SourceDebugExtension(value={"SMAP\nLiveIndexWriterConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveIndexWriterConfig.kt\norg/gnit/lucenekmp/index/LiveIndexWriterConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,397:1\n1#2:398\n*E\n"})
public class LiveIndexWriterConfig {
    @NotNull
    private final Analyzer analyzer;
    private volatile int maxBufferedDocs;
    private volatile double rAMBufferSizeMB;
    @Nullable
    private volatile IndexWriter.IndexReaderWarmer mergedSegmentWarmer;
    @NotNull
    private volatile IndexDeletionPolicy delPolicy;
    @Nullable
    private volatile IndexCommit commit;
    public volatile IndexWriterConfig.OpenMode openMode;
    private int createdVersionMajor;
    public volatile Similarity similarity;
    public volatile MergeScheduler mergeScheduler;
    public volatile Codec codec;
    public volatile InfoStream infoStream;
    public volatile MergePolicy mergePolicy;
    private volatile boolean readerPooling;
    public volatile FlushPolicy flushPolicy;
    private volatile int rAMPerThreadHardLimitMB;
    private volatile boolean useCompoundFile;
    private boolean commitOnClose;
    @Nullable
    private Sort indexSort;
    @Nullable
    private Comparator<LeafReader> leafSorter;
    @NotNull
    private Set<String> indexSortFields;
    @Nullable
    private String parentField;
    private volatile boolean checkPendingFlushOnUpdate;
    @Nullable
    private String softDeletesField;
    private volatile long maxFullFlushMergeWaitMillis;
    @NotNull
    private IndexWriterEventListener eventListener;

    public LiveIndexWriterConfig(@NotNull Analyzer analyzer) {
        Intrinsics.checkNotNullParameter((Object)analyzer, (String)"analyzer");
        this.analyzer = analyzer;
        this.maxBufferedDocs = -1;
        this.rAMBufferSizeMB = 16.0;
        this.createdVersionMajor = Version.Companion.getLATEST().getMajor();
        this.readerPooling = true;
        this.commitOnClose = true;
        this.indexSortFields = new LinkedHashSet();
        this.checkPendingFlushOnUpdate = true;
        this.setRAMBufferSizeMB(16.0);
        this.setMaxBufferedDocs(-1);
        this.setMergedSegmentWarmer(null);
        this.delPolicy = new KeepOnlyLastCommitDeletionPolicy();
        this.commit = null;
        this.useCompoundFile = true;
        this.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        this.setSimilarity(IndexSearcher.Companion.getDefaultSimilarity());
        this.setMergeScheduler(new ConcurrentMergeScheduler());
        this.setCodec(Codec.Companion.getDefault());
        if (this.getCodec() == null) {
            throw new NullPointerException();
        }
        this.setInfoStream(InfoStream.Companion.getDefault());
        this.setMergePolicy(new TieredMergePolicy());
        this.setFlushPolicy(new FlushByRamOrCountsPolicy());
        this.setReaderPooling(true);
        this.rAMPerThreadHardLimitMB = 1945;
        this.maxFullFlushMergeWaitMillis = 500L;
        this.eventListener = IndexWriterEventListener.Companion.getNO_OP_LISTENER();
    }

    @NotNull
    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public int getMaxBufferedDocs() {
        return this.maxBufferedDocs;
    }

    public void setMaxBufferedDocs(int n) {
        this.maxBufferedDocs = n;
    }

    public double getRAMBufferSizeMB() {
        return this.rAMBufferSizeMB;
    }

    public void setRAMBufferSizeMB(double d) {
        this.rAMBufferSizeMB = d;
    }

    @Nullable
    public IndexWriter.IndexReaderWarmer getMergedSegmentWarmer() {
        return this.mergedSegmentWarmer;
    }

    public void setMergedSegmentWarmer(@Nullable IndexWriter.IndexReaderWarmer indexReaderWarmer) {
        this.mergedSegmentWarmer = indexReaderWarmer;
    }

    @Nullable
    public final IndexWriter.IndexReaderWarmer get() {
        return this.getMergedSegmentWarmer();
    }

    @NotNull
    public LiveIndexWriterConfig setMergedSegmentWarmer(@NotNull IndexWriter.IndexReaderWarmer mergeSegmentWarmer) {
        Intrinsics.checkNotNullParameter((Object)mergeSegmentWarmer, (String)"mergeSegmentWarmer");
        this.setMergedSegmentWarmer(mergeSegmentWarmer);
        return this;
    }

    @NotNull
    protected final IndexDeletionPolicy getDelPolicy() {
        return this.delPolicy;
    }

    protected final void setDelPolicy(@NotNull IndexDeletionPolicy indexDeletionPolicy) {
        Intrinsics.checkNotNullParameter((Object)indexDeletionPolicy, (String)"<set-?>");
        this.delPolicy = indexDeletionPolicy;
    }

    @Nullable
    protected final IndexCommit getCommit() {
        return this.commit;
    }

    protected final void setCommit(@Nullable IndexCommit indexCommit) {
        this.commit = indexCommit;
    }

    @NotNull
    public IndexWriterConfig.OpenMode getOpenMode() {
        IndexWriterConfig.OpenMode openMode = this.openMode;
        if (openMode != null) {
            return openMode;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"openMode");
        return null;
    }

    public void setOpenMode(@NotNull IndexWriterConfig.OpenMode openMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)openMode), (String)"<set-?>");
        this.openMode = openMode;
    }

    public final int getCreatedVersionMajor() {
        return this.createdVersionMajor;
    }

    protected final void setCreatedVersionMajor(int n) {
        this.createdVersionMajor = n;
    }

    @NotNull
    public Similarity getSimilarity() {
        Similarity similarity = this.similarity;
        if (similarity != null) {
            return similarity;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"similarity");
        return null;
    }

    public void setSimilarity(@NotNull Similarity similarity) {
        Intrinsics.checkNotNullParameter((Object)similarity, (String)"<set-?>");
        this.similarity = similarity;
    }

    @NotNull
    public MergeScheduler getMergeScheduler() {
        MergeScheduler mergeScheduler = this.mergeScheduler;
        if (mergeScheduler != null) {
            return mergeScheduler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mergeScheduler");
        return null;
    }

    public void setMergeScheduler(@NotNull MergeScheduler mergeScheduler) {
        Intrinsics.checkNotNullParameter((Object)mergeScheduler, (String)"<set-?>");
        this.mergeScheduler = mergeScheduler;
    }

    @NotNull
    public Codec getCodec() {
        Codec codec = this.codec;
        if (codec != null) {
            return codec;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"codec");
        return null;
    }

    public void setCodec(@NotNull Codec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"<set-?>");
        this.codec = codec;
    }

    @NotNull
    public InfoStream getInfoStream() {
        InfoStream infoStream = this.infoStream;
        if (infoStream != null) {
            return infoStream;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"infoStream");
        return null;
    }

    public void setInfoStream(@NotNull InfoStream infoStream) {
        Intrinsics.checkNotNullParameter((Object)infoStream, (String)"<set-?>");
        this.infoStream = infoStream;
    }

    @NotNull
    public MergePolicy getMergePolicy() {
        MergePolicy mergePolicy = this.mergePolicy;
        if (mergePolicy != null) {
            return mergePolicy;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mergePolicy");
        return null;
    }

    public void setMergePolicy(@NotNull MergePolicy mergePolicy) {
        Intrinsics.checkNotNullParameter((Object)mergePolicy, (String)"<set-?>");
        this.mergePolicy = mergePolicy;
    }

    public boolean getReaderPooling() {
        return this.readerPooling;
    }

    protected void setReaderPooling(boolean bl) {
        this.readerPooling = bl;
    }

    @NotNull
    public FlushPolicy getFlushPolicy() {
        FlushPolicy flushPolicy = this.flushPolicy;
        if (flushPolicy != null) {
            return flushPolicy;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"flushPolicy");
        return null;
    }

    public void setFlushPolicy(@NotNull FlushPolicy flushPolicy) {
        Intrinsics.checkNotNullParameter((Object)flushPolicy, (String)"<set-?>");
        this.flushPolicy = flushPolicy;
    }

    public final int getRAMPerThreadHardLimitMB() {
        return this.rAMPerThreadHardLimitMB;
    }

    protected final void setRAMPerThreadHardLimitMB(int n) {
        this.rAMPerThreadHardLimitMB = n;
    }

    public final boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    protected final void setUseCompoundFile(boolean bl) {
        this.useCompoundFile = bl;
    }

    public final boolean getCommitOnClose() {
        return this.commitOnClose;
    }

    protected final void setCommitOnClose(boolean bl) {
        this.commitOnClose = bl;
    }

    @Nullable
    public final Sort getIndexSort() {
        return this.indexSort;
    }

    public final void setIndexSort(@Nullable Sort sort2) {
        this.indexSort = sort2;
    }

    @Nullable
    public final Comparator<LeafReader> getLeafSorter() {
        return this.getLeafSorter();
    }

    public final void setLeafSorter(@Nullable Comparator<LeafReader> comparator2) {
        this.leafSorter = comparator2;
    }

    @NotNull
    public final Set<String> getIndexSortFields() {
        return this.indexSortFields;
    }

    protected final void setIndexSortFields(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.indexSortFields = set;
    }

    @Nullable
    public final String getParentField() {
        return this.parentField;
    }

    protected final void setParentField(@Nullable String string) {
        this.parentField = string;
    }

    public final boolean getCheckPendingFlushOnUpdate() {
        return this.checkPendingFlushOnUpdate;
    }

    protected final void setCheckPendingFlushOnUpdate(boolean bl) {
        this.checkPendingFlushOnUpdate = bl;
    }

    @Nullable
    public final String getSoftDeletesField() {
        return this.softDeletesField;
    }

    protected final void setSoftDeletesField(@Nullable String string) {
        this.softDeletesField = string;
    }

    public final long getMaxFullFlushMergeWaitMillis() {
        return this.maxFullFlushMergeWaitMillis;
    }

    protected final void setMaxFullFlushMergeWaitMillis(long l) {
        this.maxFullFlushMergeWaitMillis = l;
    }

    @NotNull
    protected final IndexWriterEventListener getEventListener() {
        return this.eventListener;
    }

    protected final void setEventListener(@NotNull IndexWriterEventListener indexWriterEventListener) {
        Intrinsics.checkNotNullParameter((Object)indexWriterEventListener, (String)"<set-?>");
        this.eventListener = indexWriterEventListener;
    }

    @NotNull
    public LiveIndexWriterConfig setRAMBufferSizeMB(double ramBufferSizeMB) {
        if (!(ramBufferSizeMB == -1.0 || !(ramBufferSizeMB <= 0.0))) {
            boolean $i$a$-require-LiveIndexWriterConfig$setRAMBufferSizeMB$32 = false;
            String $i$a$-require-LiveIndexWriterConfig$setRAMBufferSizeMB$32 = "ramBufferSize should be > 0.0 MB when enabled";
            throw new IllegalArgumentException($i$a$-require-LiveIndexWriterConfig$setRAMBufferSizeMB$32.toString());
        }
        if (!(!(ramBufferSizeMB == -1.0) || this.getMaxBufferedDocs() != -1)) {
            boolean bl = false;
            String string = "at least one of ramBufferSize and maxBufferedDocs must be enabled";
            throw new IllegalArgumentException(string.toString());
        }
        this.setRAMBufferSizeMB(ramBufferSizeMB);
        return this;
    }

    @NotNull
    public LiveIndexWriterConfig setMaxBufferedDocs(int maxBufferedDocs) {
        if (!(maxBufferedDocs == -1 || maxBufferedDocs >= 2)) {
            boolean $i$a$-require-LiveIndexWriterConfig$setMaxBufferedDocs$32 = false;
            String $i$a$-require-LiveIndexWriterConfig$setMaxBufferedDocs$32 = "maxBufferedDocs must at least be 2 when enabled";
            throw new IllegalArgumentException($i$a$-require-LiveIndexWriterConfig$setMaxBufferedDocs$32.toString());
        }
        if (!(maxBufferedDocs != -1 || !(this.getRAMBufferSizeMB() == -1.0))) {
            boolean bl = false;
            String string = "at least one of ramBufferSize and maxBufferedDocs must be enabled";
            throw new IllegalArgumentException(string.toString());
        }
        this.setMaxBufferedDocs(maxBufferedDocs);
        return this;
    }

    @NotNull
    public LiveIndexWriterConfig setMergePolicy(@NotNull MergePolicy mergePolicy) {
        Intrinsics.checkNotNullParameter((Object)mergePolicy, (String)"mergePolicy");
        this.setMergePolicy(mergePolicy);
        return this;
    }

    @NotNull
    public IndexDeletionPolicy getIndexDeletionPolicy() {
        return this.delPolicy;
    }

    @Nullable
    public IndexCommit getIndexCommit() {
        return this.commit;
    }

    @NotNull
    public LiveIndexWriterConfig setUseCompoundFile(boolean useCompoundFile) {
        this.useCompoundFile = useCompoundFile;
        return this;
    }

    @NotNull
    public LiveIndexWriterConfig setCheckPendingFlushUpdate(boolean checkPendingFlushOnUpdate) {
        this.checkPendingFlushOnUpdate = checkPendingFlushOnUpdate;
        return this;
    }

    @NotNull
    public final IndexWriterEventListener getIndexWriterEventListener() {
        return this.eventListener;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("analyzer=").append(this.getAnalyzer() == null ? "null" : Reflection.getOrCreateKotlinClass(this.getAnalyzer().getClass()).getQualifiedName()).append("\n");
        sb.append("ramBufferSizeMB=").append(this.getRAMBufferSizeMB()).append("\n");
        sb.append("maxBufferedDocs=").append(this.getMaxBufferedDocs()).append("\n");
        sb.append("mergedSegmentWarmer=").append(this.getMergedSegmentWarmer()).append("\n");
        sb.append("delPolicy=").append(Reflection.getOrCreateKotlinClass(this.getIndexDeletionPolicy().getClass()).getQualifiedName()).append("\n");
        IndexCommit commit2 = this.getIndexCommit();
        IndexCommit indexCommit = commit2;
        sb.append("commit=").append(indexCommit == null ? (Comparable)((Object)"null") : (Comparable)indexCommit).append("\n");
        sb.append("openMode=").append((Object)this.getOpenMode()).append("\n");
        sb.append("similarity=").append(Reflection.getOrCreateKotlinClass(this.getSimilarity().getClass()).getQualifiedName()).append("\n");
        sb.append("mergeScheduler=").append(this.getMergeScheduler()).append("\n");
        sb.append("codec=").append(this.getCodec()).append("\n");
        sb.append("infoStream=").append(Reflection.getOrCreateKotlinClass(this.getInfoStream().getClass()).getQualifiedName()).append("\n");
        sb.append("mergePolicy=").append(this.getMergePolicy()).append("\n");
        sb.append("readerPooling=").append(this.getReaderPooling()).append("\n");
        sb.append("perThreadHardLimitMB=").append(this.rAMPerThreadHardLimitMB).append("\n");
        sb.append("useCompoundFile=").append(this.useCompoundFile).append("\n");
        sb.append("commitOnClose=").append(this.commitOnClose).append("\n");
        sb.append("indexSort=").append(this.indexSort).append("\n");
        sb.append("checkPendingFlushOnUpdate=").append(this.checkPendingFlushOnUpdate).append("\n");
        sb.append("softDeletesField=").append(this.softDeletesField).append("\n");
        sb.append("maxFullFlushMergeWaitMillis=").append(this.maxFullFlushMergeWaitMillis).append("\n");
        sb.append("leafSorter=").append(this.getLeafSorter()).append("\n");
        sb.append("eventListener=").append(this.getIndexWriterEventListener()).append("\n");
        sb.append("parentField=").append(this.parentField).append("\n");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

